/*
 * CLOUD API
 *
 * IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// TargetPortRange struct for TargetPortRange
type TargetPortRange struct {
	// Target port range start associated with the NAT Gateway rule.
	Start *int32 `json:"start,omitempty"`
	// Target port range end associated with the NAT Gateway rule.
	End *int32 `json:"end,omitempty"`
}

// NewTargetPortRange instantiates a new TargetPortRange object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewTargetPortRange() *TargetPortRange {
	this := TargetPortRange{}

	return &this
}

// NewTargetPortRangeWithDefaults instantiates a new TargetPortRange object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewTargetPortRangeWithDefaults() *TargetPortRange {
	this := TargetPortRange{}
	return &this
}

// GetStart returns the Start field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *TargetPortRange) GetStart() *int32 {
	if o == nil {
		return nil
	}

	return o.Start

}

// GetStartOk returns a tuple with the Start field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *TargetPortRange) GetStartOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.Start, true
}

// SetStart sets field value
func (o *TargetPortRange) SetStart(v int32) {

	o.Start = &v

}

// HasStart returns a boolean if a field has been set.
func (o *TargetPortRange) HasStart() bool {
	if o != nil && o.Start != nil {
		return true
	}

	return false
}

// GetEnd returns the End field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *TargetPortRange) GetEnd() *int32 {
	if o == nil {
		return nil
	}

	return o.End

}

// GetEndOk returns a tuple with the End field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *TargetPortRange) GetEndOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.End, true
}

// SetEnd sets field value
func (o *TargetPortRange) SetEnd(v int32) {

	o.End = &v

}

// HasEnd returns a boolean if a field has been set.
func (o *TargetPortRange) HasEnd() bool {
	if o != nil && o.End != nil {
		return true
	}

	return false
}

func (o TargetPortRange) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Start != nil {
		toSerialize["start"] = o.Start
	}
	if o.End != nil {
		toSerialize["end"] = o.End
	}
	return json.Marshal(toSerialize)
}

type NullableTargetPortRange struct {
	value *TargetPortRange
	isSet bool
}

func (v NullableTargetPortRange) Get() *TargetPortRange {
	return v.value
}

func (v *NullableTargetPortRange) Set(val *TargetPortRange) {
	v.value = val
	v.isSet = true
}

func (v NullableTargetPortRange) IsSet() bool {
	return v.isSet
}

func (v *NullableTargetPortRange) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableTargetPortRange(val *TargetPortRange) *NullableTargetPortRange {
	return &NullableTargetPortRange{value: val, isSet: true}
}

func (v NullableTargetPortRange) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableTargetPortRange) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
