// Code generated by smithy-go-codegen DO NOT EDIT.

package auditmanager

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a presigned Amazon S3 URL that can be used to upload a file as manual
// evidence. For instructions on how to use this operation, see [Upload a file from your browser]in the Audit
// Manager User Guide.
//
// The following restrictions apply to this operation:
//
//   - Maximum size of an individual evidence file: 100 MB
//
//   - Number of daily manual evidence uploads per control: 100
//
//   - Supported file formats: See [Supported file types for manual evidence]in the Audit Manager User Guide
//
// For more information about Audit Manager service restrictions, see [Quotas and restrictions for Audit Manager].
//
// [Supported file types for manual evidence]: https://docs.aws.amazon.com/audit-manager/latest/userguide/upload-evidence.html#supported-manual-evidence-files
// [Upload a file from your browser]: https://docs.aws.amazon.com/audit-manager/latest/userguide/upload-evidence.html#how-to-upload-manual-evidence-files
// [Quotas and restrictions for Audit Manager]: https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html
func (c *Client) GetEvidenceFileUploadUrl(ctx context.Context, params *GetEvidenceFileUploadUrlInput, optFns ...func(*Options)) (*GetEvidenceFileUploadUrlOutput, error) {
	if params == nil {
		params = &GetEvidenceFileUploadUrlInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetEvidenceFileUploadUrl", params, optFns, c.addOperationGetEvidenceFileUploadUrlMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetEvidenceFileUploadUrlOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetEvidenceFileUploadUrlInput struct {

	// The file that you want to upload. For a list of supported file formats, see [Supported file types for manual evidence] in
	// the Audit Manager User Guide.
	//
	// [Supported file types for manual evidence]: https://docs.aws.amazon.com/audit-manager/latest/userguide/upload-evidence.html#supported-manual-evidence-files
	//
	// This member is required.
	FileName *string

	noSmithyDocumentSerde
}

type GetEvidenceFileUploadUrlOutput struct {

	// The name of the uploaded manual evidence file that the presigned URL was
	// generated for.
	EvidenceFileName *string

	// The presigned URL that was generated.
	UploadUrl *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetEvidenceFileUploadUrlMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetEvidenceFileUploadUrl{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetEvidenceFileUploadUrl{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetEvidenceFileUploadUrl"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetEvidenceFileUploadUrlValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetEvidenceFileUploadUrl(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetEvidenceFileUploadUrl(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetEvidenceFileUploadUrl",
	}
}
