// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package f3

type User struct {
	Common
	Name     string `json:"name"`
	Email    string `json:"email"`
	UserName string `json:"username"`
	Password string `json:"password"`
	IsAdmin  bool   `json:"admin"`
}

func (o User) Equal(other User) bool {
	return o.Common.Equal(other.Common) &&
		o.Name == other.Name &&
		o.Email == other.Email &&
		o.UserName == other.UserName &&
		o.IsAdmin == other.IsAdmin
}

func (o *User) GetName() string {
	return o.UserName
}

func (o *User) Clone() Interface {
	clone := &User{}
	*clone = *o
	return clone
}
