=begin
#OpenBao API

#HTTP API that gives you full access to OpenBao. All API routes are prefixed with `/v1/`.

The version of the OpenAPI document: 2.0.0

Generated by: https://openapi-generator.tech
Generator version: 7.7.0

=end

require 'cgi'

module OpenbaoClient
  class AuthApi
    attr_accessor :api_client

    def initialize(api_client = ApiClient.default)
      @api_client = api_client
    end
    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_delete_bind_secret_id(role_name, approle_mount_path, opts = {})
      app_role_delete_bind_secret_id_with_http_info(role_name, approle_mount_path, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_delete_bind_secret_id_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_delete_bind_secret_id ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_delete_bind_secret_id"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_delete_bind_secret_id"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/bind-secret-id'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_delete_bind_secret_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_delete_bind_secret_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_delete_bound_cidr_list(role_name, approle_mount_path, opts = {})
      app_role_delete_bound_cidr_list_with_http_info(role_name, approle_mount_path, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_delete_bound_cidr_list_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_delete_bound_cidr_list ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_delete_bound_cidr_list"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_delete_bound_cidr_list"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/bound-cidr-list'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_delete_bound_cidr_list",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_delete_bound_cidr_list\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_delete_period(role_name, approle_mount_path, opts = {})
      app_role_delete_period_with_http_info(role_name, approle_mount_path, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_delete_period_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_delete_period ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_delete_period"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_delete_period"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/period'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_delete_period",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_delete_period\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_delete_policies(role_name, approle_mount_path, opts = {})
      app_role_delete_policies_with_http_info(role_name, approle_mount_path, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_delete_policies_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_delete_policies ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_delete_policies"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_delete_policies"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/policies'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_delete_policies",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_delete_policies\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_delete_role(role_name, approle_mount_path, opts = {})
      app_role_delete_role_with_http_info(role_name, approle_mount_path, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_delete_role_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_delete_role ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_delete_role"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_delete_role"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_delete_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_delete_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_delete_secret_id_bound_cidrs(role_name, approle_mount_path, opts = {})
      app_role_delete_secret_id_bound_cidrs_with_http_info(role_name, approle_mount_path, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_delete_secret_id_bound_cidrs_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_delete_secret_id_bound_cidrs ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_delete_secret_id_bound_cidrs"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_delete_secret_id_bound_cidrs"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/secret-id-bound-cidrs'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_delete_secret_id_bound_cidrs",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_delete_secret_id_bound_cidrs\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_delete_secret_id_num_uses(role_name, approle_mount_path, opts = {})
      app_role_delete_secret_id_num_uses_with_http_info(role_name, approle_mount_path, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_delete_secret_id_num_uses_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_delete_secret_id_num_uses ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_delete_secret_id_num_uses"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_delete_secret_id_num_uses"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/secret-id-num-uses'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_delete_secret_id_num_uses",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_delete_secret_id_num_uses\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_delete_secret_id_ttl(role_name, approle_mount_path, opts = {})
      app_role_delete_secret_id_ttl_with_http_info(role_name, approle_mount_path, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_delete_secret_id_ttl_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_delete_secret_id_ttl ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_delete_secret_id_ttl"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_delete_secret_id_ttl"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/secret-id-ttl'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_delete_secret_id_ttl",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_delete_secret_id_ttl\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_delete_token_bound_cidrs(role_name, approle_mount_path, opts = {})
      app_role_delete_token_bound_cidrs_with_http_info(role_name, approle_mount_path, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_delete_token_bound_cidrs_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_delete_token_bound_cidrs ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_delete_token_bound_cidrs"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_delete_token_bound_cidrs"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/token-bound-cidrs'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_delete_token_bound_cidrs",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_delete_token_bound_cidrs\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_delete_token_max_ttl(role_name, approle_mount_path, opts = {})
      app_role_delete_token_max_ttl_with_http_info(role_name, approle_mount_path, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_delete_token_max_ttl_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_delete_token_max_ttl ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_delete_token_max_ttl"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_delete_token_max_ttl"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/token-max-ttl'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_delete_token_max_ttl",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_delete_token_max_ttl\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_delete_token_num_uses(role_name, approle_mount_path, opts = {})
      app_role_delete_token_num_uses_with_http_info(role_name, approle_mount_path, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_delete_token_num_uses_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_delete_token_num_uses ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_delete_token_num_uses"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_delete_token_num_uses"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/token-num-uses'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_delete_token_num_uses",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_delete_token_num_uses\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_delete_token_ttl(role_name, approle_mount_path, opts = {})
      app_role_delete_token_ttl_with_http_info(role_name, approle_mount_path, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_delete_token_ttl_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_delete_token_ttl ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_delete_token_ttl"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_delete_token_ttl"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/token-ttl'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_delete_token_ttl",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_delete_token_ttl\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_destroy_secret_id_request [AppRoleDestroySecretIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_destroy_secret_id(role_name, approle_mount_path, app_role_destroy_secret_id_request, opts = {})
      app_role_destroy_secret_id_with_http_info(role_name, approle_mount_path, app_role_destroy_secret_id_request, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_destroy_secret_id_request [AppRoleDestroySecretIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_destroy_secret_id_with_http_info(role_name, approle_mount_path, app_role_destroy_secret_id_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_destroy_secret_id ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_destroy_secret_id"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_destroy_secret_id"
      end
      # verify the required parameter 'app_role_destroy_secret_id_request' is set
      if @api_client.config.client_side_validation && app_role_destroy_secret_id_request.nil?
        fail ArgumentError, "Missing the required parameter 'app_role_destroy_secret_id_request' when calling AuthApi.app_role_destroy_secret_id"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/secret-id/destroy'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(app_role_destroy_secret_id_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_destroy_secret_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_destroy_secret_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_destroy_secret_id2(role_name, approle_mount_path, opts = {})
      app_role_destroy_secret_id2_with_http_info(role_name, approle_mount_path, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_destroy_secret_id2_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_destroy_secret_id2 ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_destroy_secret_id2"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_destroy_secret_id2"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/secret-id/destroy'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_destroy_secret_id2",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_destroy_secret_id2\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_destroy_secret_id_by_accessor_request [AppRoleDestroySecretIdByAccessorRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_destroy_secret_id_by_accessor(role_name, approle_mount_path, app_role_destroy_secret_id_by_accessor_request, opts = {})
      app_role_destroy_secret_id_by_accessor_with_http_info(role_name, approle_mount_path, app_role_destroy_secret_id_by_accessor_request, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_destroy_secret_id_by_accessor_request [AppRoleDestroySecretIdByAccessorRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_destroy_secret_id_by_accessor_with_http_info(role_name, approle_mount_path, app_role_destroy_secret_id_by_accessor_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_destroy_secret_id_by_accessor ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_destroy_secret_id_by_accessor"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_destroy_secret_id_by_accessor"
      end
      # verify the required parameter 'app_role_destroy_secret_id_by_accessor_request' is set
      if @api_client.config.client_side_validation && app_role_destroy_secret_id_by_accessor_request.nil?
        fail ArgumentError, "Missing the required parameter 'app_role_destroy_secret_id_by_accessor_request' when calling AuthApi.app_role_destroy_secret_id_by_accessor"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/secret-id-accessor/destroy'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(app_role_destroy_secret_id_by_accessor_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_destroy_secret_id_by_accessor",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_destroy_secret_id_by_accessor\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_destroy_secret_id_by_accessor2(role_name, approle_mount_path, opts = {})
      app_role_destroy_secret_id_by_accessor2_with_http_info(role_name, approle_mount_path, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_destroy_secret_id_by_accessor2_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_destroy_secret_id_by_accessor2 ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_destroy_secret_id_by_accessor2"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_destroy_secret_id_by_accessor2"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/secret-id-accessor/destroy'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_destroy_secret_id_by_accessor2",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_destroy_secret_id_by_accessor2\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [AppRoleListRolesResponse]
    def app_role_list_roles(approle_mount_path, list, opts = {})
      data, _status_code, _headers = app_role_list_roles_with_http_info(approle_mount_path, list, opts)
      data
    end

    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(AppRoleListRolesResponse, Integer, Hash)>] AppRoleListRolesResponse data, response status code and response headers
    def app_role_list_roles_with_http_info(approle_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_list_roles ...'
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_list_roles"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling AuthApi.app_role_list_roles"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role'.sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'AppRoleListRolesResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_list_roles",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_list_roles\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [AppRoleListSecretIdsResponse]
    def app_role_list_secret_ids(role_name, approle_mount_path, list, opts = {})
      data, _status_code, _headers = app_role_list_secret_ids_with_http_info(role_name, approle_mount_path, list, opts)
      data
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(AppRoleListSecretIdsResponse, Integer, Hash)>] AppRoleListSecretIdsResponse data, response status code and response headers
    def app_role_list_secret_ids_with_http_info(role_name, approle_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_list_secret_ids ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_list_secret_ids"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_list_secret_ids"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling AuthApi.app_role_list_secret_ids"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/secret-id'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'AppRoleListSecretIdsResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_list_secret_ids",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_list_secret_ids\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_login_request [AppRoleLoginRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_login(approle_mount_path, app_role_login_request, opts = {})
      app_role_login_with_http_info(approle_mount_path, app_role_login_request, opts)
      nil
    end

    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_login_request [AppRoleLoginRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_login_with_http_info(approle_mount_path, app_role_login_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_login ...'
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_login"
      end
      # verify the required parameter 'app_role_login_request' is set
      if @api_client.config.client_side_validation && app_role_login_request.nil?
        fail ArgumentError, "Missing the required parameter 'app_role_login_request' when calling AuthApi.app_role_login"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/login'.sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(app_role_login_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_login",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_login\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_look_up_secret_id_request [AppRoleLookUpSecretIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [AppRoleLookUpSecretIdResponse]
    def app_role_look_up_secret_id(role_name, approle_mount_path, app_role_look_up_secret_id_request, opts = {})
      data, _status_code, _headers = app_role_look_up_secret_id_with_http_info(role_name, approle_mount_path, app_role_look_up_secret_id_request, opts)
      data
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_look_up_secret_id_request [AppRoleLookUpSecretIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(AppRoleLookUpSecretIdResponse, Integer, Hash)>] AppRoleLookUpSecretIdResponse data, response status code and response headers
    def app_role_look_up_secret_id_with_http_info(role_name, approle_mount_path, app_role_look_up_secret_id_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_look_up_secret_id ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_look_up_secret_id"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_look_up_secret_id"
      end
      # verify the required parameter 'app_role_look_up_secret_id_request' is set
      if @api_client.config.client_side_validation && app_role_look_up_secret_id_request.nil?
        fail ArgumentError, "Missing the required parameter 'app_role_look_up_secret_id_request' when calling AuthApi.app_role_look_up_secret_id"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/secret-id/lookup'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(app_role_look_up_secret_id_request)

      # return_type
      return_type = opts[:debug_return_type] || 'AppRoleLookUpSecretIdResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_look_up_secret_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_look_up_secret_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_look_up_secret_id_by_accessor_request [AppRoleLookUpSecretIdByAccessorRequest] 
    # @param [Hash] opts the optional parameters
    # @return [AppRoleLookUpSecretIdByAccessorResponse]
    def app_role_look_up_secret_id_by_accessor(role_name, approle_mount_path, app_role_look_up_secret_id_by_accessor_request, opts = {})
      data, _status_code, _headers = app_role_look_up_secret_id_by_accessor_with_http_info(role_name, approle_mount_path, app_role_look_up_secret_id_by_accessor_request, opts)
      data
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_look_up_secret_id_by_accessor_request [AppRoleLookUpSecretIdByAccessorRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(AppRoleLookUpSecretIdByAccessorResponse, Integer, Hash)>] AppRoleLookUpSecretIdByAccessorResponse data, response status code and response headers
    def app_role_look_up_secret_id_by_accessor_with_http_info(role_name, approle_mount_path, app_role_look_up_secret_id_by_accessor_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_look_up_secret_id_by_accessor ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_look_up_secret_id_by_accessor"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_look_up_secret_id_by_accessor"
      end
      # verify the required parameter 'app_role_look_up_secret_id_by_accessor_request' is set
      if @api_client.config.client_side_validation && app_role_look_up_secret_id_by_accessor_request.nil?
        fail ArgumentError, "Missing the required parameter 'app_role_look_up_secret_id_by_accessor_request' when calling AuthApi.app_role_look_up_secret_id_by_accessor"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/secret-id-accessor/lookup'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(app_role_look_up_secret_id_by_accessor_request)

      # return_type
      return_type = opts[:debug_return_type] || 'AppRoleLookUpSecretIdByAccessorResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_look_up_secret_id_by_accessor",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_look_up_secret_id_by_accessor\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [AppRoleReadBindSecretIdResponse]
    def app_role_read_bind_secret_id(role_name, approle_mount_path, opts = {})
      data, _status_code, _headers = app_role_read_bind_secret_id_with_http_info(role_name, approle_mount_path, opts)
      data
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(AppRoleReadBindSecretIdResponse, Integer, Hash)>] AppRoleReadBindSecretIdResponse data, response status code and response headers
    def app_role_read_bind_secret_id_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_read_bind_secret_id ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_read_bind_secret_id"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_read_bind_secret_id"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/bind-secret-id'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'AppRoleReadBindSecretIdResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_read_bind_secret_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_read_bind_secret_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [AppRoleReadBoundCidrListResponse]
    def app_role_read_bound_cidr_list(role_name, approle_mount_path, opts = {})
      data, _status_code, _headers = app_role_read_bound_cidr_list_with_http_info(role_name, approle_mount_path, opts)
      data
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(AppRoleReadBoundCidrListResponse, Integer, Hash)>] AppRoleReadBoundCidrListResponse data, response status code and response headers
    def app_role_read_bound_cidr_list_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_read_bound_cidr_list ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_read_bound_cidr_list"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_read_bound_cidr_list"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/bound-cidr-list'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'AppRoleReadBoundCidrListResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_read_bound_cidr_list",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_read_bound_cidr_list\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [AppRoleReadLocalSecretIdsResponse]
    def app_role_read_local_secret_ids(role_name, approle_mount_path, opts = {})
      data, _status_code, _headers = app_role_read_local_secret_ids_with_http_info(role_name, approle_mount_path, opts)
      data
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(AppRoleReadLocalSecretIdsResponse, Integer, Hash)>] AppRoleReadLocalSecretIdsResponse data, response status code and response headers
    def app_role_read_local_secret_ids_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_read_local_secret_ids ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_read_local_secret_ids"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_read_local_secret_ids"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/local-secret-ids'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'AppRoleReadLocalSecretIdsResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_read_local_secret_ids",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_read_local_secret_ids\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [AppRoleReadPeriodResponse]
    def app_role_read_period(role_name, approle_mount_path, opts = {})
      data, _status_code, _headers = app_role_read_period_with_http_info(role_name, approle_mount_path, opts)
      data
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(AppRoleReadPeriodResponse, Integer, Hash)>] AppRoleReadPeriodResponse data, response status code and response headers
    def app_role_read_period_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_read_period ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_read_period"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_read_period"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/period'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'AppRoleReadPeriodResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_read_period",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_read_period\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [AppRoleReadPoliciesResponse]
    def app_role_read_policies(role_name, approle_mount_path, opts = {})
      data, _status_code, _headers = app_role_read_policies_with_http_info(role_name, approle_mount_path, opts)
      data
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(AppRoleReadPoliciesResponse, Integer, Hash)>] AppRoleReadPoliciesResponse data, response status code and response headers
    def app_role_read_policies_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_read_policies ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_read_policies"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_read_policies"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/policies'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'AppRoleReadPoliciesResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_read_policies",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_read_policies\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [AppRoleReadRoleResponse]
    def app_role_read_role(role_name, approle_mount_path, opts = {})
      data, _status_code, _headers = app_role_read_role_with_http_info(role_name, approle_mount_path, opts)
      data
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(AppRoleReadRoleResponse, Integer, Hash)>] AppRoleReadRoleResponse data, response status code and response headers
    def app_role_read_role_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_read_role ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_read_role"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_read_role"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'AppRoleReadRoleResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_read_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_read_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [AppRoleReadRoleIdResponse]
    def app_role_read_role_id(role_name, approle_mount_path, opts = {})
      data, _status_code, _headers = app_role_read_role_id_with_http_info(role_name, approle_mount_path, opts)
      data
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(AppRoleReadRoleIdResponse, Integer, Hash)>] AppRoleReadRoleIdResponse data, response status code and response headers
    def app_role_read_role_id_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_read_role_id ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_read_role_id"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_read_role_id"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/role-id'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'AppRoleReadRoleIdResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_read_role_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_read_role_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [AppRoleReadSecretIdBoundCidrsResponse]
    def app_role_read_secret_id_bound_cidrs(role_name, approle_mount_path, opts = {})
      data, _status_code, _headers = app_role_read_secret_id_bound_cidrs_with_http_info(role_name, approle_mount_path, opts)
      data
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(AppRoleReadSecretIdBoundCidrsResponse, Integer, Hash)>] AppRoleReadSecretIdBoundCidrsResponse data, response status code and response headers
    def app_role_read_secret_id_bound_cidrs_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_read_secret_id_bound_cidrs ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_read_secret_id_bound_cidrs"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_read_secret_id_bound_cidrs"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/secret-id-bound-cidrs'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'AppRoleReadSecretIdBoundCidrsResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_read_secret_id_bound_cidrs",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_read_secret_id_bound_cidrs\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [AppRoleReadSecretIdNumUsesResponse]
    def app_role_read_secret_id_num_uses(role_name, approle_mount_path, opts = {})
      data, _status_code, _headers = app_role_read_secret_id_num_uses_with_http_info(role_name, approle_mount_path, opts)
      data
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(AppRoleReadSecretIdNumUsesResponse, Integer, Hash)>] AppRoleReadSecretIdNumUsesResponse data, response status code and response headers
    def app_role_read_secret_id_num_uses_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_read_secret_id_num_uses ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_read_secret_id_num_uses"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_read_secret_id_num_uses"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/secret-id-num-uses'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'AppRoleReadSecretIdNumUsesResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_read_secret_id_num_uses",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_read_secret_id_num_uses\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [AppRoleReadSecretIdTtlResponse]
    def app_role_read_secret_id_ttl(role_name, approle_mount_path, opts = {})
      data, _status_code, _headers = app_role_read_secret_id_ttl_with_http_info(role_name, approle_mount_path, opts)
      data
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(AppRoleReadSecretIdTtlResponse, Integer, Hash)>] AppRoleReadSecretIdTtlResponse data, response status code and response headers
    def app_role_read_secret_id_ttl_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_read_secret_id_ttl ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_read_secret_id_ttl"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_read_secret_id_ttl"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/secret-id-ttl'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'AppRoleReadSecretIdTtlResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_read_secret_id_ttl",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_read_secret_id_ttl\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [AppRoleReadTokenBoundCidrsResponse]
    def app_role_read_token_bound_cidrs(role_name, approle_mount_path, opts = {})
      data, _status_code, _headers = app_role_read_token_bound_cidrs_with_http_info(role_name, approle_mount_path, opts)
      data
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(AppRoleReadTokenBoundCidrsResponse, Integer, Hash)>] AppRoleReadTokenBoundCidrsResponse data, response status code and response headers
    def app_role_read_token_bound_cidrs_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_read_token_bound_cidrs ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_read_token_bound_cidrs"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_read_token_bound_cidrs"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/token-bound-cidrs'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'AppRoleReadTokenBoundCidrsResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_read_token_bound_cidrs",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_read_token_bound_cidrs\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [AppRoleReadTokenMaxTtlResponse]
    def app_role_read_token_max_ttl(role_name, approle_mount_path, opts = {})
      data, _status_code, _headers = app_role_read_token_max_ttl_with_http_info(role_name, approle_mount_path, opts)
      data
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(AppRoleReadTokenMaxTtlResponse, Integer, Hash)>] AppRoleReadTokenMaxTtlResponse data, response status code and response headers
    def app_role_read_token_max_ttl_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_read_token_max_ttl ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_read_token_max_ttl"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_read_token_max_ttl"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/token-max-ttl'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'AppRoleReadTokenMaxTtlResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_read_token_max_ttl",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_read_token_max_ttl\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [AppRoleReadTokenNumUsesResponse]
    def app_role_read_token_num_uses(role_name, approle_mount_path, opts = {})
      data, _status_code, _headers = app_role_read_token_num_uses_with_http_info(role_name, approle_mount_path, opts)
      data
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(AppRoleReadTokenNumUsesResponse, Integer, Hash)>] AppRoleReadTokenNumUsesResponse data, response status code and response headers
    def app_role_read_token_num_uses_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_read_token_num_uses ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_read_token_num_uses"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_read_token_num_uses"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/token-num-uses'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'AppRoleReadTokenNumUsesResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_read_token_num_uses",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_read_token_num_uses\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [AppRoleReadTokenTtlResponse]
    def app_role_read_token_ttl(role_name, approle_mount_path, opts = {})
      data, _status_code, _headers = app_role_read_token_ttl_with_http_info(role_name, approle_mount_path, opts)
      data
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(AppRoleReadTokenTtlResponse, Integer, Hash)>] AppRoleReadTokenTtlResponse data, response status code and response headers
    def app_role_read_token_ttl_with_http_info(role_name, approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_read_token_ttl ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_read_token_ttl"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_read_token_ttl"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/token-ttl'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'AppRoleReadTokenTtlResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_read_token_ttl",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_read_token_ttl\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_tidy_secret_id(approle_mount_path, opts = {})
      app_role_tidy_secret_id_with_http_info(approle_mount_path, opts)
      nil
    end

    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_tidy_secret_id_with_http_info(approle_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_tidy_secret_id ...'
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_tidy_secret_id"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/tidy/secret-id'.sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_tidy_secret_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_tidy_secret_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_bind_secret_id_request [AppRoleWriteBindSecretIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_write_bind_secret_id(role_name, approle_mount_path, app_role_write_bind_secret_id_request, opts = {})
      app_role_write_bind_secret_id_with_http_info(role_name, approle_mount_path, app_role_write_bind_secret_id_request, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_bind_secret_id_request [AppRoleWriteBindSecretIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_write_bind_secret_id_with_http_info(role_name, approle_mount_path, app_role_write_bind_secret_id_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_write_bind_secret_id ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_write_bind_secret_id"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_write_bind_secret_id"
      end
      # verify the required parameter 'app_role_write_bind_secret_id_request' is set
      if @api_client.config.client_side_validation && app_role_write_bind_secret_id_request.nil?
        fail ArgumentError, "Missing the required parameter 'app_role_write_bind_secret_id_request' when calling AuthApi.app_role_write_bind_secret_id"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/bind-secret-id'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(app_role_write_bind_secret_id_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_write_bind_secret_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_write_bind_secret_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_bound_cidr_list_request [AppRoleWriteBoundCidrListRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_write_bound_cidr_list(role_name, approle_mount_path, app_role_write_bound_cidr_list_request, opts = {})
      app_role_write_bound_cidr_list_with_http_info(role_name, approle_mount_path, app_role_write_bound_cidr_list_request, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_bound_cidr_list_request [AppRoleWriteBoundCidrListRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_write_bound_cidr_list_with_http_info(role_name, approle_mount_path, app_role_write_bound_cidr_list_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_write_bound_cidr_list ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_write_bound_cidr_list"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_write_bound_cidr_list"
      end
      # verify the required parameter 'app_role_write_bound_cidr_list_request' is set
      if @api_client.config.client_side_validation && app_role_write_bound_cidr_list_request.nil?
        fail ArgumentError, "Missing the required parameter 'app_role_write_bound_cidr_list_request' when calling AuthApi.app_role_write_bound_cidr_list"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/bound-cidr-list'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(app_role_write_bound_cidr_list_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_write_bound_cidr_list",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_write_bound_cidr_list\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_custom_secret_id_request [AppRoleWriteCustomSecretIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [AppRoleWriteCustomSecretIdResponse]
    def app_role_write_custom_secret_id(role_name, approle_mount_path, app_role_write_custom_secret_id_request, opts = {})
      data, _status_code, _headers = app_role_write_custom_secret_id_with_http_info(role_name, approle_mount_path, app_role_write_custom_secret_id_request, opts)
      data
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_custom_secret_id_request [AppRoleWriteCustomSecretIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(AppRoleWriteCustomSecretIdResponse, Integer, Hash)>] AppRoleWriteCustomSecretIdResponse data, response status code and response headers
    def app_role_write_custom_secret_id_with_http_info(role_name, approle_mount_path, app_role_write_custom_secret_id_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_write_custom_secret_id ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_write_custom_secret_id"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_write_custom_secret_id"
      end
      # verify the required parameter 'app_role_write_custom_secret_id_request' is set
      if @api_client.config.client_side_validation && app_role_write_custom_secret_id_request.nil?
        fail ArgumentError, "Missing the required parameter 'app_role_write_custom_secret_id_request' when calling AuthApi.app_role_write_custom_secret_id"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/custom-secret-id'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(app_role_write_custom_secret_id_request)

      # return_type
      return_type = opts[:debug_return_type] || 'AppRoleWriteCustomSecretIdResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_write_custom_secret_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_write_custom_secret_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_period_request [AppRoleWritePeriodRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_write_period(role_name, approle_mount_path, app_role_write_period_request, opts = {})
      app_role_write_period_with_http_info(role_name, approle_mount_path, app_role_write_period_request, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_period_request [AppRoleWritePeriodRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_write_period_with_http_info(role_name, approle_mount_path, app_role_write_period_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_write_period ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_write_period"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_write_period"
      end
      # verify the required parameter 'app_role_write_period_request' is set
      if @api_client.config.client_side_validation && app_role_write_period_request.nil?
        fail ArgumentError, "Missing the required parameter 'app_role_write_period_request' when calling AuthApi.app_role_write_period"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/period'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(app_role_write_period_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_write_period",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_write_period\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_policies_request [AppRoleWritePoliciesRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_write_policies(role_name, approle_mount_path, app_role_write_policies_request, opts = {})
      app_role_write_policies_with_http_info(role_name, approle_mount_path, app_role_write_policies_request, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_policies_request [AppRoleWritePoliciesRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_write_policies_with_http_info(role_name, approle_mount_path, app_role_write_policies_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_write_policies ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_write_policies"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_write_policies"
      end
      # verify the required parameter 'app_role_write_policies_request' is set
      if @api_client.config.client_side_validation && app_role_write_policies_request.nil?
        fail ArgumentError, "Missing the required parameter 'app_role_write_policies_request' when calling AuthApi.app_role_write_policies"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/policies'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(app_role_write_policies_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_write_policies",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_write_policies\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_role_request [AppRoleWriteRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_write_role(role_name, approle_mount_path, app_role_write_role_request, opts = {})
      app_role_write_role_with_http_info(role_name, approle_mount_path, app_role_write_role_request, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_role_request [AppRoleWriteRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_write_role_with_http_info(role_name, approle_mount_path, app_role_write_role_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_write_role ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_write_role"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_write_role"
      end
      # verify the required parameter 'app_role_write_role_request' is set
      if @api_client.config.client_side_validation && app_role_write_role_request.nil?
        fail ArgumentError, "Missing the required parameter 'app_role_write_role_request' when calling AuthApi.app_role_write_role"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(app_role_write_role_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_write_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_write_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_role_id_request [AppRoleWriteRoleIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_write_role_id(role_name, approle_mount_path, app_role_write_role_id_request, opts = {})
      app_role_write_role_id_with_http_info(role_name, approle_mount_path, app_role_write_role_id_request, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_role_id_request [AppRoleWriteRoleIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_write_role_id_with_http_info(role_name, approle_mount_path, app_role_write_role_id_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_write_role_id ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_write_role_id"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_write_role_id"
      end
      # verify the required parameter 'app_role_write_role_id_request' is set
      if @api_client.config.client_side_validation && app_role_write_role_id_request.nil?
        fail ArgumentError, "Missing the required parameter 'app_role_write_role_id_request' when calling AuthApi.app_role_write_role_id"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/role-id'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(app_role_write_role_id_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_write_role_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_write_role_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_secret_id_request [AppRoleWriteSecretIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [AppRoleWriteSecretIdResponse]
    def app_role_write_secret_id(role_name, approle_mount_path, app_role_write_secret_id_request, opts = {})
      data, _status_code, _headers = app_role_write_secret_id_with_http_info(role_name, approle_mount_path, app_role_write_secret_id_request, opts)
      data
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_secret_id_request [AppRoleWriteSecretIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(AppRoleWriteSecretIdResponse, Integer, Hash)>] AppRoleWriteSecretIdResponse data, response status code and response headers
    def app_role_write_secret_id_with_http_info(role_name, approle_mount_path, app_role_write_secret_id_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_write_secret_id ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_write_secret_id"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_write_secret_id"
      end
      # verify the required parameter 'app_role_write_secret_id_request' is set
      if @api_client.config.client_side_validation && app_role_write_secret_id_request.nil?
        fail ArgumentError, "Missing the required parameter 'app_role_write_secret_id_request' when calling AuthApi.app_role_write_secret_id"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/secret-id'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(app_role_write_secret_id_request)

      # return_type
      return_type = opts[:debug_return_type] || 'AppRoleWriteSecretIdResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_write_secret_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_write_secret_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_secret_id_bound_cidrs_request [AppRoleWriteSecretIdBoundCidrsRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_write_secret_id_bound_cidrs(role_name, approle_mount_path, app_role_write_secret_id_bound_cidrs_request, opts = {})
      app_role_write_secret_id_bound_cidrs_with_http_info(role_name, approle_mount_path, app_role_write_secret_id_bound_cidrs_request, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_secret_id_bound_cidrs_request [AppRoleWriteSecretIdBoundCidrsRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_write_secret_id_bound_cidrs_with_http_info(role_name, approle_mount_path, app_role_write_secret_id_bound_cidrs_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_write_secret_id_bound_cidrs ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_write_secret_id_bound_cidrs"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_write_secret_id_bound_cidrs"
      end
      # verify the required parameter 'app_role_write_secret_id_bound_cidrs_request' is set
      if @api_client.config.client_side_validation && app_role_write_secret_id_bound_cidrs_request.nil?
        fail ArgumentError, "Missing the required parameter 'app_role_write_secret_id_bound_cidrs_request' when calling AuthApi.app_role_write_secret_id_bound_cidrs"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/secret-id-bound-cidrs'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(app_role_write_secret_id_bound_cidrs_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_write_secret_id_bound_cidrs",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_write_secret_id_bound_cidrs\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_secret_id_num_uses_request [AppRoleWriteSecretIdNumUsesRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_write_secret_id_num_uses(role_name, approle_mount_path, app_role_write_secret_id_num_uses_request, opts = {})
      app_role_write_secret_id_num_uses_with_http_info(role_name, approle_mount_path, app_role_write_secret_id_num_uses_request, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_secret_id_num_uses_request [AppRoleWriteSecretIdNumUsesRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_write_secret_id_num_uses_with_http_info(role_name, approle_mount_path, app_role_write_secret_id_num_uses_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_write_secret_id_num_uses ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_write_secret_id_num_uses"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_write_secret_id_num_uses"
      end
      # verify the required parameter 'app_role_write_secret_id_num_uses_request' is set
      if @api_client.config.client_side_validation && app_role_write_secret_id_num_uses_request.nil?
        fail ArgumentError, "Missing the required parameter 'app_role_write_secret_id_num_uses_request' when calling AuthApi.app_role_write_secret_id_num_uses"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/secret-id-num-uses'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(app_role_write_secret_id_num_uses_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_write_secret_id_num_uses",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_write_secret_id_num_uses\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_secret_id_ttl_request [AppRoleWriteSecretIdTtlRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_write_secret_id_ttl(role_name, approle_mount_path, app_role_write_secret_id_ttl_request, opts = {})
      app_role_write_secret_id_ttl_with_http_info(role_name, approle_mount_path, app_role_write_secret_id_ttl_request, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_secret_id_ttl_request [AppRoleWriteSecretIdTtlRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_write_secret_id_ttl_with_http_info(role_name, approle_mount_path, app_role_write_secret_id_ttl_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_write_secret_id_ttl ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_write_secret_id_ttl"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_write_secret_id_ttl"
      end
      # verify the required parameter 'app_role_write_secret_id_ttl_request' is set
      if @api_client.config.client_side_validation && app_role_write_secret_id_ttl_request.nil?
        fail ArgumentError, "Missing the required parameter 'app_role_write_secret_id_ttl_request' when calling AuthApi.app_role_write_secret_id_ttl"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/secret-id-ttl'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(app_role_write_secret_id_ttl_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_write_secret_id_ttl",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_write_secret_id_ttl\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_token_bound_cidrs_request [AppRoleWriteTokenBoundCidrsRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_write_token_bound_cidrs(role_name, approle_mount_path, app_role_write_token_bound_cidrs_request, opts = {})
      app_role_write_token_bound_cidrs_with_http_info(role_name, approle_mount_path, app_role_write_token_bound_cidrs_request, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_token_bound_cidrs_request [AppRoleWriteTokenBoundCidrsRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_write_token_bound_cidrs_with_http_info(role_name, approle_mount_path, app_role_write_token_bound_cidrs_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_write_token_bound_cidrs ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_write_token_bound_cidrs"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_write_token_bound_cidrs"
      end
      # verify the required parameter 'app_role_write_token_bound_cidrs_request' is set
      if @api_client.config.client_side_validation && app_role_write_token_bound_cidrs_request.nil?
        fail ArgumentError, "Missing the required parameter 'app_role_write_token_bound_cidrs_request' when calling AuthApi.app_role_write_token_bound_cidrs"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/token-bound-cidrs'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(app_role_write_token_bound_cidrs_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_write_token_bound_cidrs",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_write_token_bound_cidrs\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_token_max_ttl_request [AppRoleWriteTokenMaxTtlRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_write_token_max_ttl(role_name, approle_mount_path, app_role_write_token_max_ttl_request, opts = {})
      app_role_write_token_max_ttl_with_http_info(role_name, approle_mount_path, app_role_write_token_max_ttl_request, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_token_max_ttl_request [AppRoleWriteTokenMaxTtlRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_write_token_max_ttl_with_http_info(role_name, approle_mount_path, app_role_write_token_max_ttl_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_write_token_max_ttl ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_write_token_max_ttl"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_write_token_max_ttl"
      end
      # verify the required parameter 'app_role_write_token_max_ttl_request' is set
      if @api_client.config.client_side_validation && app_role_write_token_max_ttl_request.nil?
        fail ArgumentError, "Missing the required parameter 'app_role_write_token_max_ttl_request' when calling AuthApi.app_role_write_token_max_ttl"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/token-max-ttl'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(app_role_write_token_max_ttl_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_write_token_max_ttl",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_write_token_max_ttl\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_token_num_uses_request [AppRoleWriteTokenNumUsesRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_write_token_num_uses(role_name, approle_mount_path, app_role_write_token_num_uses_request, opts = {})
      app_role_write_token_num_uses_with_http_info(role_name, approle_mount_path, app_role_write_token_num_uses_request, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_token_num_uses_request [AppRoleWriteTokenNumUsesRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_write_token_num_uses_with_http_info(role_name, approle_mount_path, app_role_write_token_num_uses_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_write_token_num_uses ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_write_token_num_uses"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_write_token_num_uses"
      end
      # verify the required parameter 'app_role_write_token_num_uses_request' is set
      if @api_client.config.client_side_validation && app_role_write_token_num_uses_request.nil?
        fail ArgumentError, "Missing the required parameter 'app_role_write_token_num_uses_request' when calling AuthApi.app_role_write_token_num_uses"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/token-num-uses'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(app_role_write_token_num_uses_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_write_token_num_uses",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_write_token_num_uses\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_token_ttl_request [AppRoleWriteTokenTtlRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def app_role_write_token_ttl(role_name, approle_mount_path, app_role_write_token_ttl_request, opts = {})
      app_role_write_token_ttl_with_http_info(role_name, approle_mount_path, app_role_write_token_ttl_request, opts)
      nil
    end

    # @param role_name [String] Name of the role. Must be less than 4096 bytes.
    # @param approle_mount_path [String] Path that the backend was mounted at
    # @param app_role_write_token_ttl_request [AppRoleWriteTokenTtlRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def app_role_write_token_ttl_with_http_info(role_name, approle_mount_path, app_role_write_token_ttl_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.app_role_write_token_ttl ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.app_role_write_token_ttl"
      end
      # verify the required parameter 'approle_mount_path' is set
      if @api_client.config.client_side_validation && approle_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'approle_mount_path' when calling AuthApi.app_role_write_token_ttl"
      end
      # verify the required parameter 'app_role_write_token_ttl_request' is set
      if @api_client.config.client_side_validation && app_role_write_token_ttl_request.nil?
        fail ArgumentError, "Missing the required parameter 'app_role_write_token_ttl_request' when calling AuthApi.app_role_write_token_ttl"
      end
      # resource path
      local_var_path = '/auth/{approle_mount_path}/role/{role_name}/token-ttl'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s)).sub('{' + 'approle_mount_path' + '}', CGI.escape(approle_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(app_role_write_token_ttl_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.app_role_write_token_ttl",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#app_role_write_token_ttl\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param cert_mount_path [String] Path that the backend was mounted at
    # @param cert_configure_request [CertConfigureRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def cert_configure(cert_mount_path, cert_configure_request, opts = {})
      cert_configure_with_http_info(cert_mount_path, cert_configure_request, opts)
      nil
    end

    # @param cert_mount_path [String] Path that the backend was mounted at
    # @param cert_configure_request [CertConfigureRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def cert_configure_with_http_info(cert_mount_path, cert_configure_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.cert_configure ...'
      end
      # verify the required parameter 'cert_mount_path' is set
      if @api_client.config.client_side_validation && cert_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'cert_mount_path' when calling AuthApi.cert_configure"
      end
      # verify the required parameter 'cert_configure_request' is set
      if @api_client.config.client_side_validation && cert_configure_request.nil?
        fail ArgumentError, "Missing the required parameter 'cert_configure_request' when calling AuthApi.cert_configure"
      end
      # resource path
      local_var_path = '/auth/{cert_mount_path}/config'.sub('{' + 'cert_mount_path' + '}', CGI.escape(cert_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(cert_configure_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.cert_configure",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#cert_configure\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage trusted certificates used for authentication.
    # @param name [String] The name of the certificate
    # @param cert_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def cert_delete_certificate(name, cert_mount_path, opts = {})
      cert_delete_certificate_with_http_info(name, cert_mount_path, opts)
      nil
    end

    # Manage trusted certificates used for authentication.
    # @param name [String] The name of the certificate
    # @param cert_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def cert_delete_certificate_with_http_info(name, cert_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.cert_delete_certificate ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling AuthApi.cert_delete_certificate"
      end
      # verify the required parameter 'cert_mount_path' is set
      if @api_client.config.client_side_validation && cert_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'cert_mount_path' when calling AuthApi.cert_delete_certificate"
      end
      # resource path
      local_var_path = '/auth/{cert_mount_path}/certs/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'cert_mount_path' + '}', CGI.escape(cert_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.cert_delete_certificate",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#cert_delete_certificate\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage Certificate Revocation Lists checked during authentication.
    # @param name [String] The name of the certificate
    # @param cert_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def cert_delete_crl(name, cert_mount_path, opts = {})
      cert_delete_crl_with_http_info(name, cert_mount_path, opts)
      nil
    end

    # Manage Certificate Revocation Lists checked during authentication.
    # @param name [String] The name of the certificate
    # @param cert_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def cert_delete_crl_with_http_info(name, cert_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.cert_delete_crl ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling AuthApi.cert_delete_crl"
      end
      # verify the required parameter 'cert_mount_path' is set
      if @api_client.config.client_side_validation && cert_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'cert_mount_path' when calling AuthApi.cert_delete_crl"
      end
      # resource path
      local_var_path = '/auth/{cert_mount_path}/crls/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'cert_mount_path' + '}', CGI.escape(cert_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.cert_delete_crl",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#cert_delete_crl\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage trusted certificates used for authentication.
    # @param cert_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def cert_list_certificates(cert_mount_path, list, opts = {})
      cert_list_certificates_with_http_info(cert_mount_path, list, opts)
      nil
    end

    # Manage trusted certificates used for authentication.
    # @param cert_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def cert_list_certificates_with_http_info(cert_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.cert_list_certificates ...'
      end
      # verify the required parameter 'cert_mount_path' is set
      if @api_client.config.client_side_validation && cert_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'cert_mount_path' when calling AuthApi.cert_list_certificates"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling AuthApi.cert_list_certificates"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/auth/{cert_mount_path}/certs'.sub('{' + 'cert_mount_path' + '}', CGI.escape(cert_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.cert_list_certificates",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#cert_list_certificates\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param cert_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def cert_list_crls(cert_mount_path, list, opts = {})
      cert_list_crls_with_http_info(cert_mount_path, list, opts)
      nil
    end

    # @param cert_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def cert_list_crls_with_http_info(cert_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.cert_list_crls ...'
      end
      # verify the required parameter 'cert_mount_path' is set
      if @api_client.config.client_side_validation && cert_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'cert_mount_path' when calling AuthApi.cert_list_crls"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling AuthApi.cert_list_crls"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/auth/{cert_mount_path}/crls'.sub('{' + 'cert_mount_path' + '}', CGI.escape(cert_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.cert_list_crls",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#cert_list_crls\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param cert_mount_path [String] Path that the backend was mounted at
    # @param cert_login_request [CertLoginRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def cert_login(cert_mount_path, cert_login_request, opts = {})
      cert_login_with_http_info(cert_mount_path, cert_login_request, opts)
      nil
    end

    # @param cert_mount_path [String] Path that the backend was mounted at
    # @param cert_login_request [CertLoginRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def cert_login_with_http_info(cert_mount_path, cert_login_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.cert_login ...'
      end
      # verify the required parameter 'cert_mount_path' is set
      if @api_client.config.client_side_validation && cert_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'cert_mount_path' when calling AuthApi.cert_login"
      end
      # verify the required parameter 'cert_login_request' is set
      if @api_client.config.client_side_validation && cert_login_request.nil?
        fail ArgumentError, "Missing the required parameter 'cert_login_request' when calling AuthApi.cert_login"
      end
      # resource path
      local_var_path = '/auth/{cert_mount_path}/login'.sub('{' + 'cert_mount_path' + '}', CGI.escape(cert_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(cert_login_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.cert_login",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#cert_login\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage trusted certificates used for authentication.
    # @param name [String] The name of the certificate
    # @param cert_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def cert_read_certificate(name, cert_mount_path, opts = {})
      cert_read_certificate_with_http_info(name, cert_mount_path, opts)
      nil
    end

    # Manage trusted certificates used for authentication.
    # @param name [String] The name of the certificate
    # @param cert_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def cert_read_certificate_with_http_info(name, cert_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.cert_read_certificate ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling AuthApi.cert_read_certificate"
      end
      # verify the required parameter 'cert_mount_path' is set
      if @api_client.config.client_side_validation && cert_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'cert_mount_path' when calling AuthApi.cert_read_certificate"
      end
      # resource path
      local_var_path = '/auth/{cert_mount_path}/certs/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'cert_mount_path' + '}', CGI.escape(cert_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.cert_read_certificate",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#cert_read_certificate\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param cert_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def cert_read_configuration(cert_mount_path, opts = {})
      cert_read_configuration_with_http_info(cert_mount_path, opts)
      nil
    end

    # @param cert_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def cert_read_configuration_with_http_info(cert_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.cert_read_configuration ...'
      end
      # verify the required parameter 'cert_mount_path' is set
      if @api_client.config.client_side_validation && cert_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'cert_mount_path' when calling AuthApi.cert_read_configuration"
      end
      # resource path
      local_var_path = '/auth/{cert_mount_path}/config'.sub('{' + 'cert_mount_path' + '}', CGI.escape(cert_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.cert_read_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#cert_read_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage Certificate Revocation Lists checked during authentication.
    # @param name [String] The name of the certificate
    # @param cert_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def cert_read_crl(name, cert_mount_path, opts = {})
      cert_read_crl_with_http_info(name, cert_mount_path, opts)
      nil
    end

    # Manage Certificate Revocation Lists checked during authentication.
    # @param name [String] The name of the certificate
    # @param cert_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def cert_read_crl_with_http_info(name, cert_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.cert_read_crl ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling AuthApi.cert_read_crl"
      end
      # verify the required parameter 'cert_mount_path' is set
      if @api_client.config.client_side_validation && cert_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'cert_mount_path' when calling AuthApi.cert_read_crl"
      end
      # resource path
      local_var_path = '/auth/{cert_mount_path}/crls/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'cert_mount_path' + '}', CGI.escape(cert_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.cert_read_crl",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#cert_read_crl\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage trusted certificates used for authentication.
    # @param name [String] The name of the certificate
    # @param cert_mount_path [String] Path that the backend was mounted at
    # @param cert_write_certificate_request [CertWriteCertificateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def cert_write_certificate(name, cert_mount_path, cert_write_certificate_request, opts = {})
      cert_write_certificate_with_http_info(name, cert_mount_path, cert_write_certificate_request, opts)
      nil
    end

    # Manage trusted certificates used for authentication.
    # @param name [String] The name of the certificate
    # @param cert_mount_path [String] Path that the backend was mounted at
    # @param cert_write_certificate_request [CertWriteCertificateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def cert_write_certificate_with_http_info(name, cert_mount_path, cert_write_certificate_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.cert_write_certificate ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling AuthApi.cert_write_certificate"
      end
      # verify the required parameter 'cert_mount_path' is set
      if @api_client.config.client_side_validation && cert_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'cert_mount_path' when calling AuthApi.cert_write_certificate"
      end
      # verify the required parameter 'cert_write_certificate_request' is set
      if @api_client.config.client_side_validation && cert_write_certificate_request.nil?
        fail ArgumentError, "Missing the required parameter 'cert_write_certificate_request' when calling AuthApi.cert_write_certificate"
      end
      # resource path
      local_var_path = '/auth/{cert_mount_path}/certs/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'cert_mount_path' + '}', CGI.escape(cert_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(cert_write_certificate_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.cert_write_certificate",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#cert_write_certificate\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage Certificate Revocation Lists checked during authentication.
    # @param name [String] The name of the certificate
    # @param cert_mount_path [String] Path that the backend was mounted at
    # @param cert_write_crl_request [CertWriteCrlRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def cert_write_crl(name, cert_mount_path, cert_write_crl_request, opts = {})
      cert_write_crl_with_http_info(name, cert_mount_path, cert_write_crl_request, opts)
      nil
    end

    # Manage Certificate Revocation Lists checked during authentication.
    # @param name [String] The name of the certificate
    # @param cert_mount_path [String] Path that the backend was mounted at
    # @param cert_write_crl_request [CertWriteCrlRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def cert_write_crl_with_http_info(name, cert_mount_path, cert_write_crl_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.cert_write_crl ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling AuthApi.cert_write_crl"
      end
      # verify the required parameter 'cert_mount_path' is set
      if @api_client.config.client_side_validation && cert_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'cert_mount_path' when calling AuthApi.cert_write_crl"
      end
      # verify the required parameter 'cert_write_crl_request' is set
      if @api_client.config.client_side_validation && cert_write_crl_request.nil?
        fail ArgumentError, "Missing the required parameter 'cert_write_crl_request' when calling AuthApi.cert_write_crl"
      end
      # resource path
      local_var_path = '/auth/{cert_mount_path}/crls/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'cert_mount_path' + '}', CGI.escape(cert_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(cert_write_crl_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.cert_write_crl",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#cert_write_crl\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Configure the JWT authentication backend.
    # The JWT authentication backend validates JWTs (or OIDC) using the configured credentials. If using OIDC Discovery, the URL must be provided, along with (optionally) the CA cert to use for the connection. If performing JWT validation locally, a set of public keys must be provided.
    # @param jwt_mount_path [String] Path that the backend was mounted at
    # @param jwt_configure_request [JwtConfigureRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def jwt_configure(jwt_mount_path, jwt_configure_request, opts = {})
      jwt_configure_with_http_info(jwt_mount_path, jwt_configure_request, opts)
      nil
    end

    # Configure the JWT authentication backend.
    # The JWT authentication backend validates JWTs (or OIDC) using the configured credentials. If using OIDC Discovery, the URL must be provided, along with (optionally) the CA cert to use for the connection. If performing JWT validation locally, a set of public keys must be provided.
    # @param jwt_mount_path [String] Path that the backend was mounted at
    # @param jwt_configure_request [JwtConfigureRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def jwt_configure_with_http_info(jwt_mount_path, jwt_configure_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.jwt_configure ...'
      end
      # verify the required parameter 'jwt_mount_path' is set
      if @api_client.config.client_side_validation && jwt_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'jwt_mount_path' when calling AuthApi.jwt_configure"
      end
      # verify the required parameter 'jwt_configure_request' is set
      if @api_client.config.client_side_validation && jwt_configure_request.nil?
        fail ArgumentError, "Missing the required parameter 'jwt_configure_request' when calling AuthApi.jwt_configure"
      end
      # resource path
      local_var_path = '/auth/{jwt_mount_path}/config'.sub('{' + 'jwt_mount_path' + '}', CGI.escape(jwt_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(jwt_configure_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.jwt_configure",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#jwt_configure\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Delete an existing role.
    # @param name [String] Name of the role.
    # @param jwt_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def jwt_delete_role(name, jwt_mount_path, opts = {})
      jwt_delete_role_with_http_info(name, jwt_mount_path, opts)
      nil
    end

    # Delete an existing role.
    # @param name [String] Name of the role.
    # @param jwt_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def jwt_delete_role_with_http_info(name, jwt_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.jwt_delete_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling AuthApi.jwt_delete_role"
      end
      # verify the required parameter 'jwt_mount_path' is set
      if @api_client.config.client_side_validation && jwt_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'jwt_mount_path' when calling AuthApi.jwt_delete_role"
      end
      # resource path
      local_var_path = '/auth/{jwt_mount_path}/role/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'jwt_mount_path' + '}', CGI.escape(jwt_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.jwt_delete_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#jwt_delete_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Lists all the roles registered with the backend.
    # The list will contain the names of the roles.
    # @param jwt_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def jwt_list_roles(jwt_mount_path, list, opts = {})
      jwt_list_roles_with_http_info(jwt_mount_path, list, opts)
      nil
    end

    # Lists all the roles registered with the backend.
    # The list will contain the names of the roles.
    # @param jwt_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def jwt_list_roles_with_http_info(jwt_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.jwt_list_roles ...'
      end
      # verify the required parameter 'jwt_mount_path' is set
      if @api_client.config.client_side_validation && jwt_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'jwt_mount_path' when calling AuthApi.jwt_list_roles"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling AuthApi.jwt_list_roles"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/auth/{jwt_mount_path}/role'.sub('{' + 'jwt_mount_path' + '}', CGI.escape(jwt_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.jwt_list_roles",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#jwt_list_roles\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Authenticates to OpenBao using a JWT (or OIDC) token.
    # @param jwt_mount_path [String] Path that the backend was mounted at
    # @param jwt_login_request [JwtLoginRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def jwt_login(jwt_mount_path, jwt_login_request, opts = {})
      jwt_login_with_http_info(jwt_mount_path, jwt_login_request, opts)
      nil
    end

    # Authenticates to OpenBao using a JWT (or OIDC) token.
    # @param jwt_mount_path [String] Path that the backend was mounted at
    # @param jwt_login_request [JwtLoginRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def jwt_login_with_http_info(jwt_mount_path, jwt_login_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.jwt_login ...'
      end
      # verify the required parameter 'jwt_mount_path' is set
      if @api_client.config.client_side_validation && jwt_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'jwt_mount_path' when calling AuthApi.jwt_login"
      end
      # verify the required parameter 'jwt_login_request' is set
      if @api_client.config.client_side_validation && jwt_login_request.nil?
        fail ArgumentError, "Missing the required parameter 'jwt_login_request' when calling AuthApi.jwt_login"
      end
      # resource path
      local_var_path = '/auth/{jwt_mount_path}/login'.sub('{' + 'jwt_mount_path' + '}', CGI.escape(jwt_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(jwt_login_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.jwt_login",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#jwt_login\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Callback endpoint to complete an OIDC login.
    # @param jwt_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @option opts [String] :client_nonce 
    # @option opts [String] :code 
    # @option opts [String] :state 
    # @return [nil]
    def jwt_oidc_callback(jwt_mount_path, opts = {})
      jwt_oidc_callback_with_http_info(jwt_mount_path, opts)
      nil
    end

    # Callback endpoint to complete an OIDC login.
    # @param jwt_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @option opts [String] :client_nonce 
    # @option opts [String] :code 
    # @option opts [String] :state 
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def jwt_oidc_callback_with_http_info(jwt_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.jwt_oidc_callback ...'
      end
      # verify the required parameter 'jwt_mount_path' is set
      if @api_client.config.client_side_validation && jwt_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'jwt_mount_path' when calling AuthApi.jwt_oidc_callback"
      end
      # resource path
      local_var_path = '/auth/{jwt_mount_path}/oidc/callback'.sub('{' + 'jwt_mount_path' + '}', CGI.escape(jwt_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'client_nonce'] = opts[:'client_nonce'] if !opts[:'client_nonce'].nil?
      query_params[:'code'] = opts[:'code'] if !opts[:'code'].nil?
      query_params[:'state'] = opts[:'state'] if !opts[:'state'].nil?

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.jwt_oidc_callback",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#jwt_oidc_callback\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Callback endpoint to handle form_posts.
    # @param jwt_mount_path [String] Path that the backend was mounted at
    # @param jwt_oidc_callback_form_post_request [JwtOidcCallbackFormPostRequest] 
    # @param [Hash] opts the optional parameters
    # @option opts [String] :client_nonce 
    # @option opts [String] :code 
    # @option opts [String] :state 
    # @return [nil]
    def jwt_oidc_callback_form_post(jwt_mount_path, jwt_oidc_callback_form_post_request, opts = {})
      jwt_oidc_callback_form_post_with_http_info(jwt_mount_path, jwt_oidc_callback_form_post_request, opts)
      nil
    end

    # Callback endpoint to handle form_posts.
    # @param jwt_mount_path [String] Path that the backend was mounted at
    # @param jwt_oidc_callback_form_post_request [JwtOidcCallbackFormPostRequest] 
    # @param [Hash] opts the optional parameters
    # @option opts [String] :client_nonce 
    # @option opts [String] :code 
    # @option opts [String] :state 
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def jwt_oidc_callback_form_post_with_http_info(jwt_mount_path, jwt_oidc_callback_form_post_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.jwt_oidc_callback_form_post ...'
      end
      # verify the required parameter 'jwt_mount_path' is set
      if @api_client.config.client_side_validation && jwt_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'jwt_mount_path' when calling AuthApi.jwt_oidc_callback_form_post"
      end
      # verify the required parameter 'jwt_oidc_callback_form_post_request' is set
      if @api_client.config.client_side_validation && jwt_oidc_callback_form_post_request.nil?
        fail ArgumentError, "Missing the required parameter 'jwt_oidc_callback_form_post_request' when calling AuthApi.jwt_oidc_callback_form_post"
      end
      # resource path
      local_var_path = '/auth/{jwt_mount_path}/oidc/callback'.sub('{' + 'jwt_mount_path' + '}', CGI.escape(jwt_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'client_nonce'] = opts[:'client_nonce'] if !opts[:'client_nonce'].nil?
      query_params[:'code'] = opts[:'code'] if !opts[:'code'].nil?
      query_params[:'state'] = opts[:'state'] if !opts[:'state'].nil?

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(jwt_oidc_callback_form_post_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.jwt_oidc_callback_form_post",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#jwt_oidc_callback_form_post\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Request an authorization URL to start an OIDC login flow.
    # @param jwt_mount_path [String] Path that the backend was mounted at
    # @param jwt_oidc_request_authorization_url_request [JwtOidcRequestAuthorizationUrlRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def jwt_oidc_request_authorization_url(jwt_mount_path, jwt_oidc_request_authorization_url_request, opts = {})
      jwt_oidc_request_authorization_url_with_http_info(jwt_mount_path, jwt_oidc_request_authorization_url_request, opts)
      nil
    end

    # Request an authorization URL to start an OIDC login flow.
    # @param jwt_mount_path [String] Path that the backend was mounted at
    # @param jwt_oidc_request_authorization_url_request [JwtOidcRequestAuthorizationUrlRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def jwt_oidc_request_authorization_url_with_http_info(jwt_mount_path, jwt_oidc_request_authorization_url_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.jwt_oidc_request_authorization_url ...'
      end
      # verify the required parameter 'jwt_mount_path' is set
      if @api_client.config.client_side_validation && jwt_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'jwt_mount_path' when calling AuthApi.jwt_oidc_request_authorization_url"
      end
      # verify the required parameter 'jwt_oidc_request_authorization_url_request' is set
      if @api_client.config.client_side_validation && jwt_oidc_request_authorization_url_request.nil?
        fail ArgumentError, "Missing the required parameter 'jwt_oidc_request_authorization_url_request' when calling AuthApi.jwt_oidc_request_authorization_url"
      end
      # resource path
      local_var_path = '/auth/{jwt_mount_path}/oidc/auth_url'.sub('{' + 'jwt_mount_path' + '}', CGI.escape(jwt_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(jwt_oidc_request_authorization_url_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.jwt_oidc_request_authorization_url",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#jwt_oidc_request_authorization_url\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Read the current JWT authentication backend configuration.
    # @param jwt_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def jwt_read_configuration(jwt_mount_path, opts = {})
      jwt_read_configuration_with_http_info(jwt_mount_path, opts)
      nil
    end

    # Read the current JWT authentication backend configuration.
    # @param jwt_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def jwt_read_configuration_with_http_info(jwt_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.jwt_read_configuration ...'
      end
      # verify the required parameter 'jwt_mount_path' is set
      if @api_client.config.client_side_validation && jwt_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'jwt_mount_path' when calling AuthApi.jwt_read_configuration"
      end
      # resource path
      local_var_path = '/auth/{jwt_mount_path}/config'.sub('{' + 'jwt_mount_path' + '}', CGI.escape(jwt_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.jwt_read_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#jwt_read_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Read an existing role.
    # @param name [String] Name of the role.
    # @param jwt_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def jwt_read_role(name, jwt_mount_path, opts = {})
      jwt_read_role_with_http_info(name, jwt_mount_path, opts)
      nil
    end

    # Read an existing role.
    # @param name [String] Name of the role.
    # @param jwt_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def jwt_read_role_with_http_info(name, jwt_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.jwt_read_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling AuthApi.jwt_read_role"
      end
      # verify the required parameter 'jwt_mount_path' is set
      if @api_client.config.client_side_validation && jwt_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'jwt_mount_path' when calling AuthApi.jwt_read_role"
      end
      # resource path
      local_var_path = '/auth/{jwt_mount_path}/role/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'jwt_mount_path' + '}', CGI.escape(jwt_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.jwt_read_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#jwt_read_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Register an role with the backend.
    # A role is required to authenticate with this backend. The role binds   JWT token information with token policies and settings.   The bindings, token polices and token settings can all be configured   using this endpoint
    # @param name [String] Name of the role.
    # @param jwt_mount_path [String] Path that the backend was mounted at
    # @param jwt_write_role_request [JwtWriteRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def jwt_write_role(name, jwt_mount_path, jwt_write_role_request, opts = {})
      jwt_write_role_with_http_info(name, jwt_mount_path, jwt_write_role_request, opts)
      nil
    end

    # Register an role with the backend.
    # A role is required to authenticate with this backend. The role binds   JWT token information with token policies and settings.   The bindings, token polices and token settings can all be configured   using this endpoint
    # @param name [String] Name of the role.
    # @param jwt_mount_path [String] Path that the backend was mounted at
    # @param jwt_write_role_request [JwtWriteRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def jwt_write_role_with_http_info(name, jwt_mount_path, jwt_write_role_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.jwt_write_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling AuthApi.jwt_write_role"
      end
      # verify the required parameter 'jwt_mount_path' is set
      if @api_client.config.client_side_validation && jwt_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'jwt_mount_path' when calling AuthApi.jwt_write_role"
      end
      # verify the required parameter 'jwt_write_role_request' is set
      if @api_client.config.client_side_validation && jwt_write_role_request.nil?
        fail ArgumentError, "Missing the required parameter 'jwt_write_role_request' when calling AuthApi.jwt_write_role"
      end
      # resource path
      local_var_path = '/auth/{jwt_mount_path}/role/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'jwt_mount_path' + '}', CGI.escape(jwt_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(jwt_write_role_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.jwt_write_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#jwt_write_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param kerberos_mount_path [String] Path that the backend was mounted at
    # @param kerberos_configure_request [KerberosConfigureRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kerberos_configure(kerberos_mount_path, kerberos_configure_request, opts = {})
      kerberos_configure_with_http_info(kerberos_mount_path, kerberos_configure_request, opts)
      nil
    end

    # @param kerberos_mount_path [String] Path that the backend was mounted at
    # @param kerberos_configure_request [KerberosConfigureRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kerberos_configure_with_http_info(kerberos_mount_path, kerberos_configure_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.kerberos_configure ...'
      end
      # verify the required parameter 'kerberos_mount_path' is set
      if @api_client.config.client_side_validation && kerberos_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kerberos_mount_path' when calling AuthApi.kerberos_configure"
      end
      # verify the required parameter 'kerberos_configure_request' is set
      if @api_client.config.client_side_validation && kerberos_configure_request.nil?
        fail ArgumentError, "Missing the required parameter 'kerberos_configure_request' when calling AuthApi.kerberos_configure"
      end
      # resource path
      local_var_path = '/auth/{kerberos_mount_path}/config'.sub('{' + 'kerberos_mount_path' + '}', CGI.escape(kerberos_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(kerberos_configure_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.kerberos_configure",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#kerberos_configure\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param kerberos_mount_path [String] Path that the backend was mounted at
    # @param kerberos_configure_ldap_request [KerberosConfigureLdapRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kerberos_configure_ldap(kerberos_mount_path, kerberos_configure_ldap_request, opts = {})
      kerberos_configure_ldap_with_http_info(kerberos_mount_path, kerberos_configure_ldap_request, opts)
      nil
    end

    # @param kerberos_mount_path [String] Path that the backend was mounted at
    # @param kerberos_configure_ldap_request [KerberosConfigureLdapRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kerberos_configure_ldap_with_http_info(kerberos_mount_path, kerberos_configure_ldap_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.kerberos_configure_ldap ...'
      end
      # verify the required parameter 'kerberos_mount_path' is set
      if @api_client.config.client_side_validation && kerberos_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kerberos_mount_path' when calling AuthApi.kerberos_configure_ldap"
      end
      # verify the required parameter 'kerberos_configure_ldap_request' is set
      if @api_client.config.client_side_validation && kerberos_configure_ldap_request.nil?
        fail ArgumentError, "Missing the required parameter 'kerberos_configure_ldap_request' when calling AuthApi.kerberos_configure_ldap"
      end
      # resource path
      local_var_path = '/auth/{kerberos_mount_path}/config/ldap'.sub('{' + 'kerberos_mount_path' + '}', CGI.escape(kerberos_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(kerberos_configure_ldap_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.kerberos_configure_ldap",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#kerberos_configure_ldap\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the LDAP group.
    # @param kerberos_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kerberos_delete_group(name, kerberos_mount_path, opts = {})
      kerberos_delete_group_with_http_info(name, kerberos_mount_path, opts)
      nil
    end

    # @param name [String] Name of the LDAP group.
    # @param kerberos_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kerberos_delete_group_with_http_info(name, kerberos_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.kerberos_delete_group ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling AuthApi.kerberos_delete_group"
      end
      # verify the required parameter 'kerberos_mount_path' is set
      if @api_client.config.client_side_validation && kerberos_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kerberos_mount_path' when calling AuthApi.kerberos_delete_group"
      end
      # resource path
      local_var_path = '/auth/{kerberos_mount_path}/groups/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'kerberos_mount_path' + '}', CGI.escape(kerberos_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.kerberos_delete_group",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#kerberos_delete_group\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param kerberos_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kerberos_list_groups(kerberos_mount_path, list, opts = {})
      kerberos_list_groups_with_http_info(kerberos_mount_path, list, opts)
      nil
    end

    # @param kerberos_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kerberos_list_groups_with_http_info(kerberos_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.kerberos_list_groups ...'
      end
      # verify the required parameter 'kerberos_mount_path' is set
      if @api_client.config.client_side_validation && kerberos_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kerberos_mount_path' when calling AuthApi.kerberos_list_groups"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling AuthApi.kerberos_list_groups"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/auth/{kerberos_mount_path}/groups'.sub('{' + 'kerberos_mount_path' + '}', CGI.escape(kerberos_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.kerberos_list_groups",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#kerberos_list_groups\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param kerberos_mount_path [String] Path that the backend was mounted at
    # @param kerberos_login_request [KerberosLoginRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kerberos_login(kerberos_mount_path, kerberos_login_request, opts = {})
      kerberos_login_with_http_info(kerberos_mount_path, kerberos_login_request, opts)
      nil
    end

    # @param kerberos_mount_path [String] Path that the backend was mounted at
    # @param kerberos_login_request [KerberosLoginRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kerberos_login_with_http_info(kerberos_mount_path, kerberos_login_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.kerberos_login ...'
      end
      # verify the required parameter 'kerberos_mount_path' is set
      if @api_client.config.client_side_validation && kerberos_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kerberos_mount_path' when calling AuthApi.kerberos_login"
      end
      # verify the required parameter 'kerberos_login_request' is set
      if @api_client.config.client_side_validation && kerberos_login_request.nil?
        fail ArgumentError, "Missing the required parameter 'kerberos_login_request' when calling AuthApi.kerberos_login"
      end
      # resource path
      local_var_path = '/auth/{kerberos_mount_path}/login'.sub('{' + 'kerberos_mount_path' + '}', CGI.escape(kerberos_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(kerberos_login_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.kerberos_login",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#kerberos_login\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param kerberos_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kerberos_login2(kerberos_mount_path, opts = {})
      kerberos_login2_with_http_info(kerberos_mount_path, opts)
      nil
    end

    # @param kerberos_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kerberos_login2_with_http_info(kerberos_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.kerberos_login2 ...'
      end
      # verify the required parameter 'kerberos_mount_path' is set
      if @api_client.config.client_side_validation && kerberos_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kerberos_mount_path' when calling AuthApi.kerberos_login2"
      end
      # resource path
      local_var_path = '/auth/{kerberos_mount_path}/login'.sub('{' + 'kerberos_mount_path' + '}', CGI.escape(kerberos_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.kerberos_login2",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#kerberos_login2\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param kerberos_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kerberos_read_configuration(kerberos_mount_path, opts = {})
      kerberos_read_configuration_with_http_info(kerberos_mount_path, opts)
      nil
    end

    # @param kerberos_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kerberos_read_configuration_with_http_info(kerberos_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.kerberos_read_configuration ...'
      end
      # verify the required parameter 'kerberos_mount_path' is set
      if @api_client.config.client_side_validation && kerberos_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kerberos_mount_path' when calling AuthApi.kerberos_read_configuration"
      end
      # resource path
      local_var_path = '/auth/{kerberos_mount_path}/config'.sub('{' + 'kerberos_mount_path' + '}', CGI.escape(kerberos_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.kerberos_read_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#kerberos_read_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the LDAP group.
    # @param kerberos_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kerberos_read_group(name, kerberos_mount_path, opts = {})
      kerberos_read_group_with_http_info(name, kerberos_mount_path, opts)
      nil
    end

    # @param name [String] Name of the LDAP group.
    # @param kerberos_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kerberos_read_group_with_http_info(name, kerberos_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.kerberos_read_group ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling AuthApi.kerberos_read_group"
      end
      # verify the required parameter 'kerberos_mount_path' is set
      if @api_client.config.client_side_validation && kerberos_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kerberos_mount_path' when calling AuthApi.kerberos_read_group"
      end
      # resource path
      local_var_path = '/auth/{kerberos_mount_path}/groups/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'kerberos_mount_path' + '}', CGI.escape(kerberos_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.kerberos_read_group",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#kerberos_read_group\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param kerberos_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kerberos_read_ldap_configuration(kerberos_mount_path, opts = {})
      kerberos_read_ldap_configuration_with_http_info(kerberos_mount_path, opts)
      nil
    end

    # @param kerberos_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kerberos_read_ldap_configuration_with_http_info(kerberos_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.kerberos_read_ldap_configuration ...'
      end
      # verify the required parameter 'kerberos_mount_path' is set
      if @api_client.config.client_side_validation && kerberos_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kerberos_mount_path' when calling AuthApi.kerberos_read_ldap_configuration"
      end
      # resource path
      local_var_path = '/auth/{kerberos_mount_path}/config/ldap'.sub('{' + 'kerberos_mount_path' + '}', CGI.escape(kerberos_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.kerberos_read_ldap_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#kerberos_read_ldap_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the LDAP group.
    # @param kerberos_mount_path [String] Path that the backend was mounted at
    # @param kerberos_write_group_request [KerberosWriteGroupRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kerberos_write_group(name, kerberos_mount_path, kerberos_write_group_request, opts = {})
      kerberos_write_group_with_http_info(name, kerberos_mount_path, kerberos_write_group_request, opts)
      nil
    end

    # @param name [String] Name of the LDAP group.
    # @param kerberos_mount_path [String] Path that the backend was mounted at
    # @param kerberos_write_group_request [KerberosWriteGroupRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kerberos_write_group_with_http_info(name, kerberos_mount_path, kerberos_write_group_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.kerberos_write_group ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling AuthApi.kerberos_write_group"
      end
      # verify the required parameter 'kerberos_mount_path' is set
      if @api_client.config.client_side_validation && kerberos_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kerberos_mount_path' when calling AuthApi.kerberos_write_group"
      end
      # verify the required parameter 'kerberos_write_group_request' is set
      if @api_client.config.client_side_validation && kerberos_write_group_request.nil?
        fail ArgumentError, "Missing the required parameter 'kerberos_write_group_request' when calling AuthApi.kerberos_write_group"
      end
      # resource path
      local_var_path = '/auth/{kerberos_mount_path}/groups/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'kerberos_mount_path' + '}', CGI.escape(kerberos_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(kerberos_write_group_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.kerberos_write_group",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#kerberos_write_group\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param kubernetes_configure_auth_request [KubernetesConfigureAuthRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kubernetes_configure_auth(kubernetes_mount_path, kubernetes_configure_auth_request, opts = {})
      kubernetes_configure_auth_with_http_info(kubernetes_mount_path, kubernetes_configure_auth_request, opts)
      nil
    end

    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param kubernetes_configure_auth_request [KubernetesConfigureAuthRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kubernetes_configure_auth_with_http_info(kubernetes_mount_path, kubernetes_configure_auth_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.kubernetes_configure_auth ...'
      end
      # verify the required parameter 'kubernetes_mount_path' is set
      if @api_client.config.client_side_validation && kubernetes_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kubernetes_mount_path' when calling AuthApi.kubernetes_configure_auth"
      end
      # verify the required parameter 'kubernetes_configure_auth_request' is set
      if @api_client.config.client_side_validation && kubernetes_configure_auth_request.nil?
        fail ArgumentError, "Missing the required parameter 'kubernetes_configure_auth_request' when calling AuthApi.kubernetes_configure_auth"
      end
      # resource path
      local_var_path = '/auth/{kubernetes_mount_path}/config'.sub('{' + 'kubernetes_mount_path' + '}', CGI.escape(kubernetes_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(kubernetes_configure_auth_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.kubernetes_configure_auth",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#kubernetes_configure_auth\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Register an role with the backend.
    # @param name [String] Name of the role.
    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kubernetes_delete_auth_role(name, kubernetes_mount_path, opts = {})
      kubernetes_delete_auth_role_with_http_info(name, kubernetes_mount_path, opts)
      nil
    end

    # Register an role with the backend.
    # @param name [String] Name of the role.
    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kubernetes_delete_auth_role_with_http_info(name, kubernetes_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.kubernetes_delete_auth_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling AuthApi.kubernetes_delete_auth_role"
      end
      # verify the required parameter 'kubernetes_mount_path' is set
      if @api_client.config.client_side_validation && kubernetes_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kubernetes_mount_path' when calling AuthApi.kubernetes_delete_auth_role"
      end
      # resource path
      local_var_path = '/auth/{kubernetes_mount_path}/role/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'kubernetes_mount_path' + '}', CGI.escape(kubernetes_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.kubernetes_delete_auth_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#kubernetes_delete_auth_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Lists all the roles registered with the backend.
    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kubernetes_list_auth_roles(kubernetes_mount_path, list, opts = {})
      kubernetes_list_auth_roles_with_http_info(kubernetes_mount_path, list, opts)
      nil
    end

    # Lists all the roles registered with the backend.
    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kubernetes_list_auth_roles_with_http_info(kubernetes_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.kubernetes_list_auth_roles ...'
      end
      # verify the required parameter 'kubernetes_mount_path' is set
      if @api_client.config.client_side_validation && kubernetes_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kubernetes_mount_path' when calling AuthApi.kubernetes_list_auth_roles"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling AuthApi.kubernetes_list_auth_roles"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/auth/{kubernetes_mount_path}/role'.sub('{' + 'kubernetes_mount_path' + '}', CGI.escape(kubernetes_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.kubernetes_list_auth_roles",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#kubernetes_list_auth_roles\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Authenticates Kubernetes service accounts with OpenBao.
    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param kubernetes_login_request [KubernetesLoginRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kubernetes_login(kubernetes_mount_path, kubernetes_login_request, opts = {})
      kubernetes_login_with_http_info(kubernetes_mount_path, kubernetes_login_request, opts)
      nil
    end

    # Authenticates Kubernetes service accounts with OpenBao.
    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param kubernetes_login_request [KubernetesLoginRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kubernetes_login_with_http_info(kubernetes_mount_path, kubernetes_login_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.kubernetes_login ...'
      end
      # verify the required parameter 'kubernetes_mount_path' is set
      if @api_client.config.client_side_validation && kubernetes_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kubernetes_mount_path' when calling AuthApi.kubernetes_login"
      end
      # verify the required parameter 'kubernetes_login_request' is set
      if @api_client.config.client_side_validation && kubernetes_login_request.nil?
        fail ArgumentError, "Missing the required parameter 'kubernetes_login_request' when calling AuthApi.kubernetes_login"
      end
      # resource path
      local_var_path = '/auth/{kubernetes_mount_path}/login'.sub('{' + 'kubernetes_mount_path' + '}', CGI.escape(kubernetes_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(kubernetes_login_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.kubernetes_login",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#kubernetes_login\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kubernetes_read_auth_configuration(kubernetes_mount_path, opts = {})
      kubernetes_read_auth_configuration_with_http_info(kubernetes_mount_path, opts)
      nil
    end

    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kubernetes_read_auth_configuration_with_http_info(kubernetes_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.kubernetes_read_auth_configuration ...'
      end
      # verify the required parameter 'kubernetes_mount_path' is set
      if @api_client.config.client_side_validation && kubernetes_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kubernetes_mount_path' when calling AuthApi.kubernetes_read_auth_configuration"
      end
      # resource path
      local_var_path = '/auth/{kubernetes_mount_path}/config'.sub('{' + 'kubernetes_mount_path' + '}', CGI.escape(kubernetes_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.kubernetes_read_auth_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#kubernetes_read_auth_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Register an role with the backend.
    # @param name [String] Name of the role.
    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kubernetes_read_auth_role(name, kubernetes_mount_path, opts = {})
      kubernetes_read_auth_role_with_http_info(name, kubernetes_mount_path, opts)
      nil
    end

    # Register an role with the backend.
    # @param name [String] Name of the role.
    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kubernetes_read_auth_role_with_http_info(name, kubernetes_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.kubernetes_read_auth_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling AuthApi.kubernetes_read_auth_role"
      end
      # verify the required parameter 'kubernetes_mount_path' is set
      if @api_client.config.client_side_validation && kubernetes_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kubernetes_mount_path' when calling AuthApi.kubernetes_read_auth_role"
      end
      # resource path
      local_var_path = '/auth/{kubernetes_mount_path}/role/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'kubernetes_mount_path' + '}', CGI.escape(kubernetes_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.kubernetes_read_auth_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#kubernetes_read_auth_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Register an role with the backend.
    # @param name [String] Name of the role.
    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param kubernetes_write_auth_role_request [KubernetesWriteAuthRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kubernetes_write_auth_role(name, kubernetes_mount_path, kubernetes_write_auth_role_request, opts = {})
      kubernetes_write_auth_role_with_http_info(name, kubernetes_mount_path, kubernetes_write_auth_role_request, opts)
      nil
    end

    # Register an role with the backend.
    # @param name [String] Name of the role.
    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param kubernetes_write_auth_role_request [KubernetesWriteAuthRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kubernetes_write_auth_role_with_http_info(name, kubernetes_mount_path, kubernetes_write_auth_role_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.kubernetes_write_auth_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling AuthApi.kubernetes_write_auth_role"
      end
      # verify the required parameter 'kubernetes_mount_path' is set
      if @api_client.config.client_side_validation && kubernetes_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kubernetes_mount_path' when calling AuthApi.kubernetes_write_auth_role"
      end
      # verify the required parameter 'kubernetes_write_auth_role_request' is set
      if @api_client.config.client_side_validation && kubernetes_write_auth_role_request.nil?
        fail ArgumentError, "Missing the required parameter 'kubernetes_write_auth_role_request' when calling AuthApi.kubernetes_write_auth_role"
      end
      # resource path
      local_var_path = '/auth/{kubernetes_mount_path}/role/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'kubernetes_mount_path' + '}', CGI.escape(kubernetes_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(kubernetes_write_auth_role_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.kubernetes_write_auth_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#kubernetes_write_auth_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param ldap_configure_auth_request [LdapConfigureAuthRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_configure_auth(ldap_mount_path, ldap_configure_auth_request, opts = {})
      ldap_configure_auth_with_http_info(ldap_mount_path, ldap_configure_auth_request, opts)
      nil
    end

    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param ldap_configure_auth_request [LdapConfigureAuthRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_configure_auth_with_http_info(ldap_mount_path, ldap_configure_auth_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.ldap_configure_auth ...'
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling AuthApi.ldap_configure_auth"
      end
      # verify the required parameter 'ldap_configure_auth_request' is set
      if @api_client.config.client_side_validation && ldap_configure_auth_request.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_configure_auth_request' when calling AuthApi.ldap_configure_auth"
      end
      # resource path
      local_var_path = '/auth/{ldap_mount_path}/config'.sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(ldap_configure_auth_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.ldap_configure_auth",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#ldap_configure_auth\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage additional groups for users allowed to authenticate.
    # @param name [String] Name of the LDAP group.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_delete_group(name, ldap_mount_path, opts = {})
      ldap_delete_group_with_http_info(name, ldap_mount_path, opts)
      nil
    end

    # Manage additional groups for users allowed to authenticate.
    # @param name [String] Name of the LDAP group.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_delete_group_with_http_info(name, ldap_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.ldap_delete_group ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling AuthApi.ldap_delete_group"
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling AuthApi.ldap_delete_group"
      end
      # resource path
      local_var_path = '/auth/{ldap_mount_path}/groups/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.ldap_delete_group",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#ldap_delete_group\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage users allowed to authenticate.
    # @param name [String] Name of the LDAP user.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_delete_user(name, ldap_mount_path, opts = {})
      ldap_delete_user_with_http_info(name, ldap_mount_path, opts)
      nil
    end

    # Manage users allowed to authenticate.
    # @param name [String] Name of the LDAP user.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_delete_user_with_http_info(name, ldap_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.ldap_delete_user ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling AuthApi.ldap_delete_user"
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling AuthApi.ldap_delete_user"
      end
      # resource path
      local_var_path = '/auth/{ldap_mount_path}/users/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.ldap_delete_user",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#ldap_delete_user\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage additional groups for users allowed to authenticate.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_list_groups(ldap_mount_path, list, opts = {})
      ldap_list_groups_with_http_info(ldap_mount_path, list, opts)
      nil
    end

    # Manage additional groups for users allowed to authenticate.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_list_groups_with_http_info(ldap_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.ldap_list_groups ...'
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling AuthApi.ldap_list_groups"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling AuthApi.ldap_list_groups"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/auth/{ldap_mount_path}/groups'.sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.ldap_list_groups",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#ldap_list_groups\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage users allowed to authenticate.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_list_users(ldap_mount_path, list, opts = {})
      ldap_list_users_with_http_info(ldap_mount_path, list, opts)
      nil
    end

    # Manage users allowed to authenticate.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_list_users_with_http_info(ldap_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.ldap_list_users ...'
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling AuthApi.ldap_list_users"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling AuthApi.ldap_list_users"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/auth/{ldap_mount_path}/users'.sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.ldap_list_users",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#ldap_list_users\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Log in with a username and password.
    # @param username [String] DN (distinguished name) to be used for login.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param ldap_login_request [LdapLoginRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_login(username, ldap_mount_path, ldap_login_request, opts = {})
      ldap_login_with_http_info(username, ldap_mount_path, ldap_login_request, opts)
      nil
    end

    # Log in with a username and password.
    # @param username [String] DN (distinguished name) to be used for login.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param ldap_login_request [LdapLoginRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_login_with_http_info(username, ldap_mount_path, ldap_login_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.ldap_login ...'
      end
      # verify the required parameter 'username' is set
      if @api_client.config.client_side_validation && username.nil?
        fail ArgumentError, "Missing the required parameter 'username' when calling AuthApi.ldap_login"
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling AuthApi.ldap_login"
      end
      # verify the required parameter 'ldap_login_request' is set
      if @api_client.config.client_side_validation && ldap_login_request.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_login_request' when calling AuthApi.ldap_login"
      end
      # resource path
      local_var_path = '/auth/{ldap_mount_path}/login/{username}'.sub('{' + 'username' + '}', CGI.escape(username.to_s)).sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(ldap_login_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.ldap_login",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#ldap_login\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_read_auth_configuration(ldap_mount_path, opts = {})
      ldap_read_auth_configuration_with_http_info(ldap_mount_path, opts)
      nil
    end

    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_read_auth_configuration_with_http_info(ldap_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.ldap_read_auth_configuration ...'
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling AuthApi.ldap_read_auth_configuration"
      end
      # resource path
      local_var_path = '/auth/{ldap_mount_path}/config'.sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.ldap_read_auth_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#ldap_read_auth_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage additional groups for users allowed to authenticate.
    # @param name [String] Name of the LDAP group.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_read_group(name, ldap_mount_path, opts = {})
      ldap_read_group_with_http_info(name, ldap_mount_path, opts)
      nil
    end

    # Manage additional groups for users allowed to authenticate.
    # @param name [String] Name of the LDAP group.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_read_group_with_http_info(name, ldap_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.ldap_read_group ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling AuthApi.ldap_read_group"
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling AuthApi.ldap_read_group"
      end
      # resource path
      local_var_path = '/auth/{ldap_mount_path}/groups/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.ldap_read_group",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#ldap_read_group\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage users allowed to authenticate.
    # @param name [String] Name of the LDAP user.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_read_user(name, ldap_mount_path, opts = {})
      ldap_read_user_with_http_info(name, ldap_mount_path, opts)
      nil
    end

    # Manage users allowed to authenticate.
    # @param name [String] Name of the LDAP user.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_read_user_with_http_info(name, ldap_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.ldap_read_user ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling AuthApi.ldap_read_user"
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling AuthApi.ldap_read_user"
      end
      # resource path
      local_var_path = '/auth/{ldap_mount_path}/users/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.ldap_read_user",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#ldap_read_user\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage additional groups for users allowed to authenticate.
    # @param name [String] Name of the LDAP group.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param ldap_write_group_request [LdapWriteGroupRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_write_group(name, ldap_mount_path, ldap_write_group_request, opts = {})
      ldap_write_group_with_http_info(name, ldap_mount_path, ldap_write_group_request, opts)
      nil
    end

    # Manage additional groups for users allowed to authenticate.
    # @param name [String] Name of the LDAP group.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param ldap_write_group_request [LdapWriteGroupRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_write_group_with_http_info(name, ldap_mount_path, ldap_write_group_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.ldap_write_group ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling AuthApi.ldap_write_group"
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling AuthApi.ldap_write_group"
      end
      # verify the required parameter 'ldap_write_group_request' is set
      if @api_client.config.client_side_validation && ldap_write_group_request.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_write_group_request' when calling AuthApi.ldap_write_group"
      end
      # resource path
      local_var_path = '/auth/{ldap_mount_path}/groups/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(ldap_write_group_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.ldap_write_group",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#ldap_write_group\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage users allowed to authenticate.
    # @param name [String] Name of the LDAP user.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param ldap_write_user_request [LdapWriteUserRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_write_user(name, ldap_mount_path, ldap_write_user_request, opts = {})
      ldap_write_user_with_http_info(name, ldap_mount_path, ldap_write_user_request, opts)
      nil
    end

    # Manage users allowed to authenticate.
    # @param name [String] Name of the LDAP user.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param ldap_write_user_request [LdapWriteUserRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_write_user_with_http_info(name, ldap_mount_path, ldap_write_user_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.ldap_write_user ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling AuthApi.ldap_write_user"
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling AuthApi.ldap_write_user"
      end
      # verify the required parameter 'ldap_write_user_request' is set
      if @api_client.config.client_side_validation && ldap_write_user_request.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_write_user_request' when calling AuthApi.ldap_write_user"
      end
      # resource path
      local_var_path = '/auth/{ldap_mount_path}/users/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(ldap_write_user_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.ldap_write_user",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#ldap_write_user\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param radius_mount_path [String] Path that the backend was mounted at
    # @param radius_configure_request [RadiusConfigureRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def radius_configure(radius_mount_path, radius_configure_request, opts = {})
      radius_configure_with_http_info(radius_mount_path, radius_configure_request, opts)
      nil
    end

    # @param radius_mount_path [String] Path that the backend was mounted at
    # @param radius_configure_request [RadiusConfigureRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def radius_configure_with_http_info(radius_mount_path, radius_configure_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.radius_configure ...'
      end
      # verify the required parameter 'radius_mount_path' is set
      if @api_client.config.client_side_validation && radius_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'radius_mount_path' when calling AuthApi.radius_configure"
      end
      # verify the required parameter 'radius_configure_request' is set
      if @api_client.config.client_side_validation && radius_configure_request.nil?
        fail ArgumentError, "Missing the required parameter 'radius_configure_request' when calling AuthApi.radius_configure"
      end
      # resource path
      local_var_path = '/auth/{radius_mount_path}/config'.sub('{' + 'radius_mount_path' + '}', CGI.escape(radius_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(radius_configure_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.radius_configure",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#radius_configure\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage users allowed to authenticate.
    # @param name [String] Name of the RADIUS user.
    # @param radius_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def radius_delete_user(name, radius_mount_path, opts = {})
      radius_delete_user_with_http_info(name, radius_mount_path, opts)
      nil
    end

    # Manage users allowed to authenticate.
    # @param name [String] Name of the RADIUS user.
    # @param radius_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def radius_delete_user_with_http_info(name, radius_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.radius_delete_user ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling AuthApi.radius_delete_user"
      end
      # verify the required parameter 'radius_mount_path' is set
      if @api_client.config.client_side_validation && radius_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'radius_mount_path' when calling AuthApi.radius_delete_user"
      end
      # resource path
      local_var_path = '/auth/{radius_mount_path}/users/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'radius_mount_path' + '}', CGI.escape(radius_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.radius_delete_user",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#radius_delete_user\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage users allowed to authenticate.
    # @param radius_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def radius_list_users(radius_mount_path, list, opts = {})
      radius_list_users_with_http_info(radius_mount_path, list, opts)
      nil
    end

    # Manage users allowed to authenticate.
    # @param radius_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def radius_list_users_with_http_info(radius_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.radius_list_users ...'
      end
      # verify the required parameter 'radius_mount_path' is set
      if @api_client.config.client_side_validation && radius_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'radius_mount_path' when calling AuthApi.radius_list_users"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling AuthApi.radius_list_users"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/auth/{radius_mount_path}/users'.sub('{' + 'radius_mount_path' + '}', CGI.escape(radius_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.radius_list_users",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#radius_list_users\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Log in with a username and password.
    # @param radius_mount_path [String] Path that the backend was mounted at
    # @param radius_login_request [RadiusLoginRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def radius_login(radius_mount_path, radius_login_request, opts = {})
      radius_login_with_http_info(radius_mount_path, radius_login_request, opts)
      nil
    end

    # Log in with a username and password.
    # @param radius_mount_path [String] Path that the backend was mounted at
    # @param radius_login_request [RadiusLoginRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def radius_login_with_http_info(radius_mount_path, radius_login_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.radius_login ...'
      end
      # verify the required parameter 'radius_mount_path' is set
      if @api_client.config.client_side_validation && radius_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'radius_mount_path' when calling AuthApi.radius_login"
      end
      # verify the required parameter 'radius_login_request' is set
      if @api_client.config.client_side_validation && radius_login_request.nil?
        fail ArgumentError, "Missing the required parameter 'radius_login_request' when calling AuthApi.radius_login"
      end
      # resource path
      local_var_path = '/auth/{radius_mount_path}/login'.sub('{' + 'radius_mount_path' + '}', CGI.escape(radius_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(radius_login_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.radius_login",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#radius_login\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Log in with a username and password.
    # @param urlusername [String] Username to be used for login. (URL parameter)
    # @param radius_mount_path [String] Path that the backend was mounted at
    # @param radius_login_with_username_request [RadiusLoginWithUsernameRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def radius_login_with_username(urlusername, radius_mount_path, radius_login_with_username_request, opts = {})
      radius_login_with_username_with_http_info(urlusername, radius_mount_path, radius_login_with_username_request, opts)
      nil
    end

    # Log in with a username and password.
    # @param urlusername [String] Username to be used for login. (URL parameter)
    # @param radius_mount_path [String] Path that the backend was mounted at
    # @param radius_login_with_username_request [RadiusLoginWithUsernameRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def radius_login_with_username_with_http_info(urlusername, radius_mount_path, radius_login_with_username_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.radius_login_with_username ...'
      end
      # verify the required parameter 'urlusername' is set
      if @api_client.config.client_side_validation && urlusername.nil?
        fail ArgumentError, "Missing the required parameter 'urlusername' when calling AuthApi.radius_login_with_username"
      end
      # verify the required parameter 'radius_mount_path' is set
      if @api_client.config.client_side_validation && radius_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'radius_mount_path' when calling AuthApi.radius_login_with_username"
      end
      # verify the required parameter 'radius_login_with_username_request' is set
      if @api_client.config.client_side_validation && radius_login_with_username_request.nil?
        fail ArgumentError, "Missing the required parameter 'radius_login_with_username_request' when calling AuthApi.radius_login_with_username"
      end
      # resource path
      local_var_path = '/auth/{radius_mount_path}/login/{urlusername}'.sub('{' + 'urlusername' + '}', CGI.escape(urlusername.to_s)).sub('{' + 'radius_mount_path' + '}', CGI.escape(radius_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(radius_login_with_username_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.radius_login_with_username",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#radius_login_with_username\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param radius_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def radius_read_configuration(radius_mount_path, opts = {})
      radius_read_configuration_with_http_info(radius_mount_path, opts)
      nil
    end

    # @param radius_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def radius_read_configuration_with_http_info(radius_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.radius_read_configuration ...'
      end
      # verify the required parameter 'radius_mount_path' is set
      if @api_client.config.client_side_validation && radius_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'radius_mount_path' when calling AuthApi.radius_read_configuration"
      end
      # resource path
      local_var_path = '/auth/{radius_mount_path}/config'.sub('{' + 'radius_mount_path' + '}', CGI.escape(radius_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.radius_read_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#radius_read_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage users allowed to authenticate.
    # @param name [String] Name of the RADIUS user.
    # @param radius_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def radius_read_user(name, radius_mount_path, opts = {})
      radius_read_user_with_http_info(name, radius_mount_path, opts)
      nil
    end

    # Manage users allowed to authenticate.
    # @param name [String] Name of the RADIUS user.
    # @param radius_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def radius_read_user_with_http_info(name, radius_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.radius_read_user ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling AuthApi.radius_read_user"
      end
      # verify the required parameter 'radius_mount_path' is set
      if @api_client.config.client_side_validation && radius_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'radius_mount_path' when calling AuthApi.radius_read_user"
      end
      # resource path
      local_var_path = '/auth/{radius_mount_path}/users/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'radius_mount_path' + '}', CGI.escape(radius_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.radius_read_user",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#radius_read_user\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage users allowed to authenticate.
    # @param name [String] Name of the RADIUS user.
    # @param radius_mount_path [String] Path that the backend was mounted at
    # @param radius_write_user_request [RadiusWriteUserRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def radius_write_user(name, radius_mount_path, radius_write_user_request, opts = {})
      radius_write_user_with_http_info(name, radius_mount_path, radius_write_user_request, opts)
      nil
    end

    # Manage users allowed to authenticate.
    # @param name [String] Name of the RADIUS user.
    # @param radius_mount_path [String] Path that the backend was mounted at
    # @param radius_write_user_request [RadiusWriteUserRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def radius_write_user_with_http_info(name, radius_mount_path, radius_write_user_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.radius_write_user ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling AuthApi.radius_write_user"
      end
      # verify the required parameter 'radius_mount_path' is set
      if @api_client.config.client_side_validation && radius_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'radius_mount_path' when calling AuthApi.radius_write_user"
      end
      # verify the required parameter 'radius_write_user_request' is set
      if @api_client.config.client_side_validation && radius_write_user_request.nil?
        fail ArgumentError, "Missing the required parameter 'radius_write_user_request' when calling AuthApi.radius_write_user"
      end
      # resource path
      local_var_path = '/auth/{radius_mount_path}/users/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'radius_mount_path' + '}', CGI.escape(radius_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(radius_write_user_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.radius_write_user",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#radius_write_user\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # The token create path is used to create new tokens.
    # @param token_create_request [TokenCreateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def token_create(token_create_request, opts = {})
      token_create_with_http_info(token_create_request, opts)
      nil
    end

    # The token create path is used to create new tokens.
    # @param token_create_request [TokenCreateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def token_create_with_http_info(token_create_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.token_create ...'
      end
      # verify the required parameter 'token_create_request' is set
      if @api_client.config.client_side_validation && token_create_request.nil?
        fail ArgumentError, "Missing the required parameter 'token_create_request' when calling AuthApi.token_create"
      end
      # resource path
      local_var_path = '/auth/token/create'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(token_create_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.token_create",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#token_create\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # This token create path is used to create new tokens adhering to the given role.
    # @param role_name [String] Name of the role
    # @param token_create_against_role_request [TokenCreateAgainstRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def token_create_against_role(role_name, token_create_against_role_request, opts = {})
      token_create_against_role_with_http_info(role_name, token_create_against_role_request, opts)
      nil
    end

    # This token create path is used to create new tokens adhering to the given role.
    # @param role_name [String] Name of the role
    # @param token_create_against_role_request [TokenCreateAgainstRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def token_create_against_role_with_http_info(role_name, token_create_against_role_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.token_create_against_role ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.token_create_against_role"
      end
      # verify the required parameter 'token_create_against_role_request' is set
      if @api_client.config.client_side_validation && token_create_against_role_request.nil?
        fail ArgumentError, "Missing the required parameter 'token_create_against_role_request' when calling AuthApi.token_create_against_role"
      end
      # resource path
      local_var_path = '/auth/token/create/{role_name}'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(token_create_against_role_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.token_create_against_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#token_create_against_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # The token create path is used to create new orphan tokens.
    # @param token_create_orphan_request [TokenCreateOrphanRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def token_create_orphan(token_create_orphan_request, opts = {})
      token_create_orphan_with_http_info(token_create_orphan_request, opts)
      nil
    end

    # The token create path is used to create new orphan tokens.
    # @param token_create_orphan_request [TokenCreateOrphanRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def token_create_orphan_with_http_info(token_create_orphan_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.token_create_orphan ...'
      end
      # verify the required parameter 'token_create_orphan_request' is set
      if @api_client.config.client_side_validation && token_create_orphan_request.nil?
        fail ArgumentError, "Missing the required parameter 'token_create_orphan_request' when calling AuthApi.token_create_orphan"
      end
      # resource path
      local_var_path = '/auth/token/create-orphan'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(token_create_orphan_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.token_create_orphan",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#token_create_orphan\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def token_delete_role(role_name, opts = {})
      token_delete_role_with_http_info(role_name, opts)
      nil
    end

    # @param role_name [String] Name of the role
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def token_delete_role_with_http_info(role_name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.token_delete_role ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.token_delete_role"
      end
      # resource path
      local_var_path = '/auth/token/roles/{role_name}'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.token_delete_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#token_delete_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # List token accessors, which can then be be used to iterate and discover their properties or revoke them. Because this can be used to cause a denial of service, this endpoint requires 'sudo' capability in addition to 'list'.
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def token_list_accessors(list, opts = {})
      token_list_accessors_with_http_info(list, opts)
      nil
    end

    # List token accessors, which can then be be used to iterate and discover their properties or revoke them. Because this can be used to cause a denial of service, this endpoint requires &#39;sudo&#39; capability in addition to &#39;list&#39;.
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def token_list_accessors_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.token_list_accessors ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling AuthApi.token_list_accessors"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/auth/token/accessors'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.token_list_accessors",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#token_list_accessors\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # This endpoint lists configured roles.
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def token_list_roles(list, opts = {})
      token_list_roles_with_http_info(list, opts)
      nil
    end

    # This endpoint lists configured roles.
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def token_list_roles_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.token_list_roles ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling AuthApi.token_list_roles"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/auth/token/roles'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.token_list_roles",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#token_list_roles\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param token_look_up_request [TokenLookUpRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def token_look_up(token_look_up_request, opts = {})
      token_look_up_with_http_info(token_look_up_request, opts)
      nil
    end

    # @param token_look_up_request [TokenLookUpRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def token_look_up_with_http_info(token_look_up_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.token_look_up ...'
      end
      # verify the required parameter 'token_look_up_request' is set
      if @api_client.config.client_side_validation && token_look_up_request.nil?
        fail ArgumentError, "Missing the required parameter 'token_look_up_request' when calling AuthApi.token_look_up"
      end
      # resource path
      local_var_path = '/auth/token/lookup'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(token_look_up_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.token_look_up",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#token_look_up\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param [Hash] opts the optional parameters
    # @return [nil]
    def token_look_up2(opts = {})
      token_look_up2_with_http_info(opts)
      nil
    end

    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def token_look_up2_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.token_look_up2 ...'
      end
      # resource path
      local_var_path = '/auth/token/lookup'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.token_look_up2",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#token_look_up2\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # This endpoint will lookup a token associated with the given accessor and its properties. Response will not contain the token ID.
    # @param token_look_up_accessor_request [TokenLookUpAccessorRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def token_look_up_accessor(token_look_up_accessor_request, opts = {})
      token_look_up_accessor_with_http_info(token_look_up_accessor_request, opts)
      nil
    end

    # This endpoint will lookup a token associated with the given accessor and its properties. Response will not contain the token ID.
    # @param token_look_up_accessor_request [TokenLookUpAccessorRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def token_look_up_accessor_with_http_info(token_look_up_accessor_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.token_look_up_accessor ...'
      end
      # verify the required parameter 'token_look_up_accessor_request' is set
      if @api_client.config.client_side_validation && token_look_up_accessor_request.nil?
        fail ArgumentError, "Missing the required parameter 'token_look_up_accessor_request' when calling AuthApi.token_look_up_accessor"
      end
      # resource path
      local_var_path = '/auth/token/lookup-accessor'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(token_look_up_accessor_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.token_look_up_accessor",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#token_look_up_accessor\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param [Hash] opts the optional parameters
    # @return [nil]
    def token_look_up_self(opts = {})
      token_look_up_self_with_http_info(opts)
      nil
    end

    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def token_look_up_self_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.token_look_up_self ...'
      end
      # resource path
      local_var_path = '/auth/token/lookup-self'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.token_look_up_self",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#token_look_up_self\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param token_look_up_self2_request [TokenLookUpSelf2Request] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def token_look_up_self2(token_look_up_self2_request, opts = {})
      token_look_up_self2_with_http_info(token_look_up_self2_request, opts)
      nil
    end

    # @param token_look_up_self2_request [TokenLookUpSelf2Request] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def token_look_up_self2_with_http_info(token_look_up_self2_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.token_look_up_self2 ...'
      end
      # verify the required parameter 'token_look_up_self2_request' is set
      if @api_client.config.client_side_validation && token_look_up_self2_request.nil?
        fail ArgumentError, "Missing the required parameter 'token_look_up_self2_request' when calling AuthApi.token_look_up_self2"
      end
      # resource path
      local_var_path = '/auth/token/lookup-self'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(token_look_up_self2_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.token_look_up_self2",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#token_look_up_self2\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def token_read_role(role_name, opts = {})
      token_read_role_with_http_info(role_name, opts)
      nil
    end

    # @param role_name [String] Name of the role
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def token_read_role_with_http_info(role_name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.token_read_role ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.token_read_role"
      end
      # resource path
      local_var_path = '/auth/token/roles/{role_name}'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.token_read_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#token_read_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # This endpoint will renew the given token and prevent expiration.
    # @param token_renew_request [TokenRenewRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def token_renew(token_renew_request, opts = {})
      token_renew_with_http_info(token_renew_request, opts)
      nil
    end

    # This endpoint will renew the given token and prevent expiration.
    # @param token_renew_request [TokenRenewRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def token_renew_with_http_info(token_renew_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.token_renew ...'
      end
      # verify the required parameter 'token_renew_request' is set
      if @api_client.config.client_side_validation && token_renew_request.nil?
        fail ArgumentError, "Missing the required parameter 'token_renew_request' when calling AuthApi.token_renew"
      end
      # resource path
      local_var_path = '/auth/token/renew'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(token_renew_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.token_renew",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#token_renew\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # This endpoint will renew a token associated with the given accessor and its properties. Response will not contain the token ID.
    # @param token_renew_accessor_request [TokenRenewAccessorRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def token_renew_accessor(token_renew_accessor_request, opts = {})
      token_renew_accessor_with_http_info(token_renew_accessor_request, opts)
      nil
    end

    # This endpoint will renew a token associated with the given accessor and its properties. Response will not contain the token ID.
    # @param token_renew_accessor_request [TokenRenewAccessorRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def token_renew_accessor_with_http_info(token_renew_accessor_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.token_renew_accessor ...'
      end
      # verify the required parameter 'token_renew_accessor_request' is set
      if @api_client.config.client_side_validation && token_renew_accessor_request.nil?
        fail ArgumentError, "Missing the required parameter 'token_renew_accessor_request' when calling AuthApi.token_renew_accessor"
      end
      # resource path
      local_var_path = '/auth/token/renew-accessor'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(token_renew_accessor_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.token_renew_accessor",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#token_renew_accessor\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # This endpoint will renew the token used to call it and prevent expiration.
    # @param token_renew_self_request [TokenRenewSelfRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def token_renew_self(token_renew_self_request, opts = {})
      token_renew_self_with_http_info(token_renew_self_request, opts)
      nil
    end

    # This endpoint will renew the token used to call it and prevent expiration.
    # @param token_renew_self_request [TokenRenewSelfRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def token_renew_self_with_http_info(token_renew_self_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.token_renew_self ...'
      end
      # verify the required parameter 'token_renew_self_request' is set
      if @api_client.config.client_side_validation && token_renew_self_request.nil?
        fail ArgumentError, "Missing the required parameter 'token_renew_self_request' when calling AuthApi.token_renew_self"
      end
      # resource path
      local_var_path = '/auth/token/renew-self'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(token_renew_self_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.token_renew_self",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#token_renew_self\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # This endpoint will delete the given token and all of its child tokens.
    # @param token_revoke_request [TokenRevokeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def token_revoke(token_revoke_request, opts = {})
      token_revoke_with_http_info(token_revoke_request, opts)
      nil
    end

    # This endpoint will delete the given token and all of its child tokens.
    # @param token_revoke_request [TokenRevokeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def token_revoke_with_http_info(token_revoke_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.token_revoke ...'
      end
      # verify the required parameter 'token_revoke_request' is set
      if @api_client.config.client_side_validation && token_revoke_request.nil?
        fail ArgumentError, "Missing the required parameter 'token_revoke_request' when calling AuthApi.token_revoke"
      end
      # resource path
      local_var_path = '/auth/token/revoke'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(token_revoke_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.token_revoke",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#token_revoke\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # This endpoint will delete the token associated with the accessor and all of its child tokens.
    # @param token_revoke_accessor_request [TokenRevokeAccessorRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def token_revoke_accessor(token_revoke_accessor_request, opts = {})
      token_revoke_accessor_with_http_info(token_revoke_accessor_request, opts)
      nil
    end

    # This endpoint will delete the token associated with the accessor and all of its child tokens.
    # @param token_revoke_accessor_request [TokenRevokeAccessorRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def token_revoke_accessor_with_http_info(token_revoke_accessor_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.token_revoke_accessor ...'
      end
      # verify the required parameter 'token_revoke_accessor_request' is set
      if @api_client.config.client_side_validation && token_revoke_accessor_request.nil?
        fail ArgumentError, "Missing the required parameter 'token_revoke_accessor_request' when calling AuthApi.token_revoke_accessor"
      end
      # resource path
      local_var_path = '/auth/token/revoke-accessor'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(token_revoke_accessor_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.token_revoke_accessor",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#token_revoke_accessor\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # This endpoint will delete the token and orphan its child tokens.
    # @param token_revoke_orphan_request [TokenRevokeOrphanRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def token_revoke_orphan(token_revoke_orphan_request, opts = {})
      token_revoke_orphan_with_http_info(token_revoke_orphan_request, opts)
      nil
    end

    # This endpoint will delete the token and orphan its child tokens.
    # @param token_revoke_orphan_request [TokenRevokeOrphanRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def token_revoke_orphan_with_http_info(token_revoke_orphan_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.token_revoke_orphan ...'
      end
      # verify the required parameter 'token_revoke_orphan_request' is set
      if @api_client.config.client_side_validation && token_revoke_orphan_request.nil?
        fail ArgumentError, "Missing the required parameter 'token_revoke_orphan_request' when calling AuthApi.token_revoke_orphan"
      end
      # resource path
      local_var_path = '/auth/token/revoke-orphan'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(token_revoke_orphan_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.token_revoke_orphan",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#token_revoke_orphan\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # This endpoint will delete the token used to call it and all of its child tokens.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def token_revoke_self(opts = {})
      token_revoke_self_with_http_info(opts)
      nil
    end

    # This endpoint will delete the token used to call it and all of its child tokens.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def token_revoke_self_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.token_revoke_self ...'
      end
      # resource path
      local_var_path = '/auth/token/revoke-self'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.token_revoke_self",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#token_revoke_self\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # This endpoint performs cleanup tasks that can be run if certain error conditions have occurred.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def token_tidy(opts = {})
      token_tidy_with_http_info(opts)
      nil
    end

    # This endpoint performs cleanup tasks that can be run if certain error conditions have occurred.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def token_tidy_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.token_tidy ...'
      end
      # resource path
      local_var_path = '/auth/token/tidy'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.token_tidy",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#token_tidy\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role_name [String] Name of the role
    # @param token_write_role_request [TokenWriteRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def token_write_role(role_name, token_write_role_request, opts = {})
      token_write_role_with_http_info(role_name, token_write_role_request, opts)
      nil
    end

    # @param role_name [String] Name of the role
    # @param token_write_role_request [TokenWriteRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def token_write_role_with_http_info(role_name, token_write_role_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.token_write_role ...'
      end
      # verify the required parameter 'role_name' is set
      if @api_client.config.client_side_validation && role_name.nil?
        fail ArgumentError, "Missing the required parameter 'role_name' when calling AuthApi.token_write_role"
      end
      # verify the required parameter 'token_write_role_request' is set
      if @api_client.config.client_side_validation && token_write_role_request.nil?
        fail ArgumentError, "Missing the required parameter 'token_write_role_request' when calling AuthApi.token_write_role"
      end
      # resource path
      local_var_path = '/auth/token/roles/{role_name}'.sub('{' + 'role_name' + '}', CGI.escape(role_name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(token_write_role_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.token_write_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#token_write_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage users allowed to authenticate.
    # @param username [String] Username for this user.
    # @param userpass_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def userpass_delete_user(username, userpass_mount_path, opts = {})
      userpass_delete_user_with_http_info(username, userpass_mount_path, opts)
      nil
    end

    # Manage users allowed to authenticate.
    # @param username [String] Username for this user.
    # @param userpass_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def userpass_delete_user_with_http_info(username, userpass_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.userpass_delete_user ...'
      end
      # verify the required parameter 'username' is set
      if @api_client.config.client_side_validation && username.nil?
        fail ArgumentError, "Missing the required parameter 'username' when calling AuthApi.userpass_delete_user"
      end
      # verify the required parameter 'userpass_mount_path' is set
      if @api_client.config.client_side_validation && userpass_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'userpass_mount_path' when calling AuthApi.userpass_delete_user"
      end
      # resource path
      local_var_path = '/auth/{userpass_mount_path}/users/{username}'.sub('{' + 'username' + '}', CGI.escape(username.to_s)).sub('{' + 'userpass_mount_path' + '}', CGI.escape(userpass_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.userpass_delete_user",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#userpass_delete_user\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage users allowed to authenticate.
    # @param userpass_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def userpass_list_users(userpass_mount_path, list, opts = {})
      userpass_list_users_with_http_info(userpass_mount_path, list, opts)
      nil
    end

    # Manage users allowed to authenticate.
    # @param userpass_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def userpass_list_users_with_http_info(userpass_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.userpass_list_users ...'
      end
      # verify the required parameter 'userpass_mount_path' is set
      if @api_client.config.client_side_validation && userpass_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'userpass_mount_path' when calling AuthApi.userpass_list_users"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling AuthApi.userpass_list_users"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/auth/{userpass_mount_path}/users'.sub('{' + 'userpass_mount_path' + '}', CGI.escape(userpass_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.userpass_list_users",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#userpass_list_users\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Log in with a username and password.
    # @param username [String] Username of the user.
    # @param userpass_mount_path [String] Path that the backend was mounted at
    # @param userpass_login_request [UserpassLoginRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def userpass_login(username, userpass_mount_path, userpass_login_request, opts = {})
      userpass_login_with_http_info(username, userpass_mount_path, userpass_login_request, opts)
      nil
    end

    # Log in with a username and password.
    # @param username [String] Username of the user.
    # @param userpass_mount_path [String] Path that the backend was mounted at
    # @param userpass_login_request [UserpassLoginRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def userpass_login_with_http_info(username, userpass_mount_path, userpass_login_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.userpass_login ...'
      end
      # verify the required parameter 'username' is set
      if @api_client.config.client_side_validation && username.nil?
        fail ArgumentError, "Missing the required parameter 'username' when calling AuthApi.userpass_login"
      end
      # verify the required parameter 'userpass_mount_path' is set
      if @api_client.config.client_side_validation && userpass_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'userpass_mount_path' when calling AuthApi.userpass_login"
      end
      # verify the required parameter 'userpass_login_request' is set
      if @api_client.config.client_side_validation && userpass_login_request.nil?
        fail ArgumentError, "Missing the required parameter 'userpass_login_request' when calling AuthApi.userpass_login"
      end
      # resource path
      local_var_path = '/auth/{userpass_mount_path}/login/{username}'.sub('{' + 'username' + '}', CGI.escape(username.to_s)).sub('{' + 'userpass_mount_path' + '}', CGI.escape(userpass_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(userpass_login_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.userpass_login",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#userpass_login\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage users allowed to authenticate.
    # @param username [String] Username for this user.
    # @param userpass_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def userpass_read_user(username, userpass_mount_path, opts = {})
      userpass_read_user_with_http_info(username, userpass_mount_path, opts)
      nil
    end

    # Manage users allowed to authenticate.
    # @param username [String] Username for this user.
    # @param userpass_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def userpass_read_user_with_http_info(username, userpass_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.userpass_read_user ...'
      end
      # verify the required parameter 'username' is set
      if @api_client.config.client_side_validation && username.nil?
        fail ArgumentError, "Missing the required parameter 'username' when calling AuthApi.userpass_read_user"
      end
      # verify the required parameter 'userpass_mount_path' is set
      if @api_client.config.client_side_validation && userpass_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'userpass_mount_path' when calling AuthApi.userpass_read_user"
      end
      # resource path
      local_var_path = '/auth/{userpass_mount_path}/users/{username}'.sub('{' + 'username' + '}', CGI.escape(username.to_s)).sub('{' + 'userpass_mount_path' + '}', CGI.escape(userpass_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.userpass_read_user",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#userpass_read_user\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Reset user's password.
    # @param username [String] Username for this user.
    # @param userpass_mount_path [String] Path that the backend was mounted at
    # @param userpass_reset_password_request [UserpassResetPasswordRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def userpass_reset_password(username, userpass_mount_path, userpass_reset_password_request, opts = {})
      userpass_reset_password_with_http_info(username, userpass_mount_path, userpass_reset_password_request, opts)
      nil
    end

    # Reset user&#39;s password.
    # @param username [String] Username for this user.
    # @param userpass_mount_path [String] Path that the backend was mounted at
    # @param userpass_reset_password_request [UserpassResetPasswordRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def userpass_reset_password_with_http_info(username, userpass_mount_path, userpass_reset_password_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.userpass_reset_password ...'
      end
      # verify the required parameter 'username' is set
      if @api_client.config.client_side_validation && username.nil?
        fail ArgumentError, "Missing the required parameter 'username' when calling AuthApi.userpass_reset_password"
      end
      # verify the required parameter 'userpass_mount_path' is set
      if @api_client.config.client_side_validation && userpass_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'userpass_mount_path' when calling AuthApi.userpass_reset_password"
      end
      # verify the required parameter 'userpass_reset_password_request' is set
      if @api_client.config.client_side_validation && userpass_reset_password_request.nil?
        fail ArgumentError, "Missing the required parameter 'userpass_reset_password_request' when calling AuthApi.userpass_reset_password"
      end
      # resource path
      local_var_path = '/auth/{userpass_mount_path}/users/{username}/password'.sub('{' + 'username' + '}', CGI.escape(username.to_s)).sub('{' + 'userpass_mount_path' + '}', CGI.escape(userpass_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(userpass_reset_password_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.userpass_reset_password",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#userpass_reset_password\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Update the policies associated with the username.
    # @param username [String] Username for this user.
    # @param userpass_mount_path [String] Path that the backend was mounted at
    # @param userpass_update_policies_request [UserpassUpdatePoliciesRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def userpass_update_policies(username, userpass_mount_path, userpass_update_policies_request, opts = {})
      userpass_update_policies_with_http_info(username, userpass_mount_path, userpass_update_policies_request, opts)
      nil
    end

    # Update the policies associated with the username.
    # @param username [String] Username for this user.
    # @param userpass_mount_path [String] Path that the backend was mounted at
    # @param userpass_update_policies_request [UserpassUpdatePoliciesRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def userpass_update_policies_with_http_info(username, userpass_mount_path, userpass_update_policies_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.userpass_update_policies ...'
      end
      # verify the required parameter 'username' is set
      if @api_client.config.client_side_validation && username.nil?
        fail ArgumentError, "Missing the required parameter 'username' when calling AuthApi.userpass_update_policies"
      end
      # verify the required parameter 'userpass_mount_path' is set
      if @api_client.config.client_side_validation && userpass_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'userpass_mount_path' when calling AuthApi.userpass_update_policies"
      end
      # verify the required parameter 'userpass_update_policies_request' is set
      if @api_client.config.client_side_validation && userpass_update_policies_request.nil?
        fail ArgumentError, "Missing the required parameter 'userpass_update_policies_request' when calling AuthApi.userpass_update_policies"
      end
      # resource path
      local_var_path = '/auth/{userpass_mount_path}/users/{username}/policies'.sub('{' + 'username' + '}', CGI.escape(username.to_s)).sub('{' + 'userpass_mount_path' + '}', CGI.escape(userpass_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(userpass_update_policies_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.userpass_update_policies",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#userpass_update_policies\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage users allowed to authenticate.
    # @param username [String] Username for this user.
    # @param userpass_mount_path [String] Path that the backend was mounted at
    # @param userpass_write_user_request [UserpassWriteUserRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def userpass_write_user(username, userpass_mount_path, userpass_write_user_request, opts = {})
      userpass_write_user_with_http_info(username, userpass_mount_path, userpass_write_user_request, opts)
      nil
    end

    # Manage users allowed to authenticate.
    # @param username [String] Username for this user.
    # @param userpass_mount_path [String] Path that the backend was mounted at
    # @param userpass_write_user_request [UserpassWriteUserRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def userpass_write_user_with_http_info(username, userpass_mount_path, userpass_write_user_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: AuthApi.userpass_write_user ...'
      end
      # verify the required parameter 'username' is set
      if @api_client.config.client_side_validation && username.nil?
        fail ArgumentError, "Missing the required parameter 'username' when calling AuthApi.userpass_write_user"
      end
      # verify the required parameter 'userpass_mount_path' is set
      if @api_client.config.client_side_validation && userpass_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'userpass_mount_path' when calling AuthApi.userpass_write_user"
      end
      # verify the required parameter 'userpass_write_user_request' is set
      if @api_client.config.client_side_validation && userpass_write_user_request.nil?
        fail ArgumentError, "Missing the required parameter 'userpass_write_user_request' when calling AuthApi.userpass_write_user"
      end
      # resource path
      local_var_path = '/auth/{userpass_mount_path}/users/{username}'.sub('{' + 'username' + '}', CGI.escape(username.to_s)).sub('{' + 'userpass_mount_path' + '}', CGI.escape(userpass_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(userpass_write_user_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"AuthApi.userpass_write_user",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: AuthApi#userpass_write_user\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end
  end
end
