// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes the specified EC2 Mac Dedicated Host or all of your EC2 Mac Dedicated
// Hosts.
func (c *Client) DescribeMacHosts(ctx context.Context, params *DescribeMacHostsInput, optFns ...func(*Options)) (*DescribeMacHostsOutput, error) {
	if params == nil {
		params = &DescribeMacHostsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeMacHosts", params, optFns, c.addOperationDescribeMacHostsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeMacHostsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeMacHostsInput struct {

	// The filters.
	//
	//   - availability-zone - The Availability Zone of the EC2 Mac Dedicated Host.
	//
	//   - instance-type - The instance type size that the EC2 Mac Dedicated Host is
	//   configured to support.
	Filters []types.Filter

	//  The IDs of the EC2 Mac Dedicated Hosts.
	HostIds []string

	// The maximum number of results to return for the request in a single page. The
	// remaining results can be seen by sending another request with the returned
	// nextToken value. This value can be between 5 and 500. If maxResults is given a
	// larger value than 500, you receive an error.
	MaxResults *int32

	// The token to use to retrieve the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeMacHostsOutput struct {

	//  Information about the EC2 Mac Dedicated Hosts.
	MacHosts []types.MacHost

	// The token to use to retrieve the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeMacHostsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeMacHosts{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeMacHosts{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeMacHosts"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeMacHosts(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeMacHostsAPIClient is a client that implements the DescribeMacHosts
// operation.
type DescribeMacHostsAPIClient interface {
	DescribeMacHosts(context.Context, *DescribeMacHostsInput, ...func(*Options)) (*DescribeMacHostsOutput, error)
}

var _ DescribeMacHostsAPIClient = (*Client)(nil)

// DescribeMacHostsPaginatorOptions is the paginator options for DescribeMacHosts
type DescribeMacHostsPaginatorOptions struct {
	// The maximum number of results to return for the request in a single page. The
	// remaining results can be seen by sending another request with the returned
	// nextToken value. This value can be between 5 and 500. If maxResults is given a
	// larger value than 500, you receive an error.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeMacHostsPaginator is a paginator for DescribeMacHosts
type DescribeMacHostsPaginator struct {
	options   DescribeMacHostsPaginatorOptions
	client    DescribeMacHostsAPIClient
	params    *DescribeMacHostsInput
	nextToken *string
	firstPage bool
}

// NewDescribeMacHostsPaginator returns a new DescribeMacHostsPaginator
func NewDescribeMacHostsPaginator(client DescribeMacHostsAPIClient, params *DescribeMacHostsInput, optFns ...func(*DescribeMacHostsPaginatorOptions)) *DescribeMacHostsPaginator {
	if params == nil {
		params = &DescribeMacHostsInput{}
	}

	options := DescribeMacHostsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeMacHostsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeMacHostsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeMacHosts page.
func (p *DescribeMacHostsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeMacHostsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.DescribeMacHosts(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeMacHosts(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeMacHosts",
	}
}
