// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Searches for types in Amazon DataZone.
func (c *Client) SearchTypes(ctx context.Context, params *SearchTypesInput, optFns ...func(*Options)) (*SearchTypesOutput, error) {
	if params == nil {
		params = &SearchTypesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SearchTypes", params, optFns, c.addOperationSearchTypesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SearchTypesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SearchTypesInput struct {

	// The identifier of the Amazon DataZone domain in which to invoke the SearchTypes
	// action.
	//
	// This member is required.
	DomainIdentifier *string

	// Specifies whether the search is managed.
	//
	// This member is required.
	Managed *bool

	// Specifies the scope of the search for types.
	//
	// This member is required.
	SearchScope types.TypesSearchScope

	// The filters for the SearchTypes action.
	Filters types.FilterClause

	// The maximum number of results to return in a single call to SearchTypes . When
	// the number of results to be listed is greater than the value of MaxResults , the
	// response contains a NextToken value that you can use in a subsequent call to
	// SearchTypes to list the next set of results.
	MaxResults *int32

	// When the number of results is greater than the default value for the MaxResults
	// parameter, or if you explicitly specify a value for MaxResults that is less
	// than the number of results, the response includes a pagination token named
	// NextToken . You can specify this NextToken value in a subsequent call to
	// SearchTypes to list the next set of results.
	NextToken *string

	// The details of the search.
	SearchIn []types.SearchInItem

	// Specifies the text for which to search.
	SearchText *string

	// The specifies the way to sort the SearchTypes results.
	Sort *types.SearchSort

	noSmithyDocumentSerde
}

type SearchTypesOutput struct {

	// The results of the SearchTypes action.
	Items []types.SearchTypesResultItem

	// When the number of results is greater than the default value for the MaxResults
	// parameter, or if you explicitly specify a value for MaxResults that is less
	// than the number of results, the response includes a pagination token named
	// NextToken . You can specify this NextToken value in a subsequent call to
	// SearchTypes to list the next set of results.
	NextToken *string

	// Total number of search results.
	TotalMatchCount *int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSearchTypesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpSearchTypes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpSearchTypes{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SearchTypes"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpSearchTypesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSearchTypes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// SearchTypesAPIClient is a client that implements the SearchTypes operation.
type SearchTypesAPIClient interface {
	SearchTypes(context.Context, *SearchTypesInput, ...func(*Options)) (*SearchTypesOutput, error)
}

var _ SearchTypesAPIClient = (*Client)(nil)

// SearchTypesPaginatorOptions is the paginator options for SearchTypes
type SearchTypesPaginatorOptions struct {
	// The maximum number of results to return in a single call to SearchTypes . When
	// the number of results to be listed is greater than the value of MaxResults , the
	// response contains a NextToken value that you can use in a subsequent call to
	// SearchTypes to list the next set of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// SearchTypesPaginator is a paginator for SearchTypes
type SearchTypesPaginator struct {
	options   SearchTypesPaginatorOptions
	client    SearchTypesAPIClient
	params    *SearchTypesInput
	nextToken *string
	firstPage bool
}

// NewSearchTypesPaginator returns a new SearchTypesPaginator
func NewSearchTypesPaginator(client SearchTypesAPIClient, params *SearchTypesInput, optFns ...func(*SearchTypesPaginatorOptions)) *SearchTypesPaginator {
	if params == nil {
		params = &SearchTypesInput{}
	}

	options := SearchTypesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &SearchTypesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *SearchTypesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next SearchTypes page.
func (p *SearchTypesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*SearchTypesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.SearchTypes(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opSearchTypes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SearchTypes",
	}
}
