// Code generated by smithy-go-codegen DO NOT EDIT.

package arczonalshift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/arczonalshift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Update a practice run configuration to change one or more of the following:
// add, change, or remove the blocking alarm; change the outcome alarm; or add,
// change, or remove blocking dates or time windows.
func (c *Client) UpdatePracticeRunConfiguration(ctx context.Context, params *UpdatePracticeRunConfigurationInput, optFns ...func(*Options)) (*UpdatePracticeRunConfigurationOutput, error) {
	if params == nil {
		params = &UpdatePracticeRunConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdatePracticeRunConfiguration", params, optFns, c.addOperationUpdatePracticeRunConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdatePracticeRunConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdatePracticeRunConfigurationInput struct {

	// The identifier for the resource that you want to update the practice run
	// configuration for. The identifier is the Amazon Resource Name (ARN) for the
	// resource.
	//
	// This member is required.
	ResourceIdentifier *string

	// Add, change, or remove blocked dates for a practice run in zonal autoshift.
	//
	// Optionally, you can block practice runs for specific calendar dates. The format
	// for blocked dates is: YYYY-MM-DD. Keep in mind, when you specify dates, that
	// dates and times for practice runs are in UTC. Separate multiple blocked dates
	// with spaces.
	//
	// For example, if you have an application update scheduled to launch on May 1,
	// 2024, and you don't want practice runs to shift traffic away at that time, you
	// could set a blocked date for 2024-05-01 .
	BlockedDates []string

	// Add, change, or remove windows of days and times for when you can, optionally,
	// block Route 53 ARC from starting a practice run for a resource.
	//
	// The format for blocked windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you
	// specify dates, that dates and times for practice runs are in UTC. Also, be aware
	// of potential time adjustments that might be required for daylight saving time
	// differences. Separate multiple blocked windows with spaces.
	//
	// For example, say you run business report summaries three days a week. For this
	// scenario, you might set the following recurring days and times as blocked
	// windows, for example: MON-20:30-21:30 WED-20:30-21:30 FRI-20:30-21:30 .
	BlockedWindows []string

	// Add, change, or remove the Amazon CloudWatch alarm that you optionally specify
	// as the blocking alarm for practice runs.
	BlockingAlarms []types.ControlCondition

	// Specify a new the Amazon CloudWatch alarm as the outcome alarm for practice
	// runs.
	OutcomeAlarms []types.ControlCondition

	noSmithyDocumentSerde
}

type UpdatePracticeRunConfigurationOutput struct {

	// The Amazon Resource Name (ARN) of the resource that you updated the practice
	// run for.
	//
	// This member is required.
	Arn *string

	// The name of the resource that you updated the practice run for.
	//
	// This member is required.
	Name *string

	// The practice run configuration that was updated.
	//
	// This member is required.
	PracticeRunConfiguration *types.PracticeRunConfiguration

	// The zonal autoshift status for the resource that you updated the practice run
	// for.
	//
	// This member is required.
	ZonalAutoshiftStatus types.ZonalAutoshiftStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdatePracticeRunConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdatePracticeRunConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdatePracticeRunConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdatePracticeRunConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdatePracticeRunConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdatePracticeRunConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdatePracticeRunConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdatePracticeRunConfiguration",
	}
}
