//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhybridnetwork

import "time"

// AzureStackEdgeFormat - The reference to the Azure stack edge device.
type AzureStackEdgeFormat struct {
	// REQUIRED; The reference to the Azure stack edge device.
	AzureStackEdge *SubResource `json:"azureStackEdge,omitempty"`

	// REQUIRED; The type of the device.
	DeviceType *DeviceType `json:"deviceType,omitempty"`

	// READ-ONLY; The list of network functions deployed on the device.
	NetworkFunctions []*SubResource `json:"networkFunctions,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the device resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The current device status.
	Status *Status `json:"status,omitempty" azure:"ro"`
}

// GetDevicePropertiesFormat implements the DevicePropertiesFormatClassification interface for type AzureStackEdgeFormat.
func (a *AzureStackEdgeFormat) GetDevicePropertiesFormat() *DevicePropertiesFormat {
	return &DevicePropertiesFormat{
		Status:            a.Status,
		ProvisioningState: a.ProvisioningState,
		DeviceType:        a.DeviceType,
		NetworkFunctions:  a.NetworkFunctions,
	}
}

// CustomProfile - Specifies the custom settings for the virtual machine.
type CustomProfile struct {
	// Path for metadata configuration.
	MetadataConfigurationPath *string `json:"metadataConfigurationPath,omitempty"`
}

// DataDisk - Specifies information about the operating system disk used by the virtual machine.
// For more information about disks, see About disks and VHDs for Azure virtual machines
// [https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json].
type DataDisk struct {
	// Specifies how the virtual machine should be created.
	CreateOption *DiskCreateOptionTypes `json:"createOption,omitempty"`

	// Specifies the size of an empty disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual
	// machine image.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`

	// The name of data disk.
	Name *string `json:"name,omitempty"`
}

// Device resource.
type Device struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Device properties.
	Properties DevicePropertiesFormatClassification `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DeviceListResult - Response for devices API service call.
type DeviceListResult struct {
	// A list of devices.
	Value []*Device `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// DevicePropertiesFormatClassification provides polymorphic access to related types.
// Call the interface's GetDevicePropertiesFormat() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureStackEdgeFormat, *DevicePropertiesFormat
type DevicePropertiesFormatClassification interface {
	// GetDevicePropertiesFormat returns the DevicePropertiesFormat content of the underlying type.
	GetDevicePropertiesFormat() *DevicePropertiesFormat
}

// DevicePropertiesFormat - Device properties.
type DevicePropertiesFormat struct {
	// REQUIRED; The type of the device.
	DeviceType *DeviceType `json:"deviceType,omitempty"`

	// READ-ONLY; The list of network functions deployed on the device.
	NetworkFunctions []*SubResource `json:"networkFunctions,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the device resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The current device status.
	Status *Status `json:"status,omitempty" azure:"ro"`
}

// GetDevicePropertiesFormat implements the DevicePropertiesFormatClassification interface for type DevicePropertiesFormat.
func (d *DevicePropertiesFormat) GetDevicePropertiesFormat() *DevicePropertiesFormat { return d }

// DeviceRegistrationKey - The device registration key.
type DeviceRegistrationKey struct {
	// READ-ONLY; The registration key for the device.
	RegistrationKey *string `json:"registrationKey,omitempty" azure:"ro"`
}

// DevicesClientBeginCreateOrUpdateOptions contains the optional parameters for the DevicesClient.BeginCreateOrUpdate method.
type DevicesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientBeginDeleteOptions contains the optional parameters for the DevicesClient.BeginDelete method.
type DevicesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DevicesClientGetOptions contains the optional parameters for the DevicesClient.Get method.
type DevicesClientGetOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientListByResourceGroupOptions contains the optional parameters for the DevicesClient.ListByResourceGroup method.
type DevicesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientListBySubscriptionOptions contains the optional parameters for the DevicesClient.ListBySubscription method.
type DevicesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientListRegistrationKeyOptions contains the optional parameters for the DevicesClient.ListRegistrationKey method.
type DevicesClientListRegistrationKeyOptions struct {
	// placeholder for future optional parameters
}

// DevicesClientUpdateTagsOptions contains the optional parameters for the DevicesClient.UpdateTags method.
type DevicesClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// ExecuteRequestParameters - Payload for execute request post call.
type ExecuteRequestParameters struct {
	// REQUIRED; The request metadata.
	RequestMetadata *RequestMetadata `json:"requestMetadata,omitempty"`

	// REQUIRED; The endpoint of service to call.
	ServiceEndpoint *string `json:"serviceEndpoint,omitempty"`
}

// ImageReference - The image reference properties.
type ImageReference struct {
	// Specifies in decimal numbers, the exact version of image used to create the virtual machine.
	ExactVersion *string `json:"exactVersion,omitempty"`

	// Specifies the offer of the image used to create the virtual machine.
	Offer *string `json:"offer,omitempty"`

	// The image publisher.
	Publisher *string `json:"publisher,omitempty"`

	// The image SKU.
	SKU *string `json:"sku,omitempty"`

	// Specifies the version of the image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'.
	// Major, Minor, and Build are decimal numbers. Specify 'latest' to use the
	// latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update
	// after deploy time even if a new version becomes available.
	Version *string `json:"version,omitempty"`
}

// LinuxConfiguration - Specifies the Linux operating system settings on the virtual machine.
type LinuxConfiguration struct {
	// Specifies the ssh key configuration for a Linux OS.
	SSH *SSHConfiguration `json:"ssh,omitempty"`
}

// NetworkFunction - Network function resource response.
type NetworkFunction struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Network function properties.
	Properties *NetworkFunctionPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NetworkFunctionListResult - Response for network function API service call.
type NetworkFunctionListResult struct {
	// A list of network function resources in a subscription or resource group.
	Value []*NetworkFunction `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// NetworkFunctionPropertiesFormat - Network function properties.
type NetworkFunctionPropertiesFormat struct {
	// The reference to the device resource. Once set, it cannot be updated.
	Device *SubResource `json:"device,omitempty"`

	// The parameters for the managed application.
	ManagedApplicationParameters interface{} `json:"managedApplicationParameters,omitempty"`

	// The network function container configurations from the user.
	NetworkFunctionContainerConfigurations interface{} `json:"networkFunctionContainerConfigurations,omitempty"`

	// The network function configurations from the user.
	NetworkFunctionUserConfigurations []*NetworkFunctionUserConfiguration `json:"networkFunctionUserConfigurations,omitempty"`

	// The sku name for the network function. Once set, it cannot be updated.
	SKUName *string `json:"skuName,omitempty"`

	// The vendor name for the network function. Once set, it cannot be updated.
	VendorName *string `json:"vendorName,omitempty"`

	// READ-ONLY; The resource URI of the managed application.
	ManagedApplication *SubResource `json:"managedApplication,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the network function resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The sku type for the network function.
	SKUType *SKUType `json:"skuType,omitempty" azure:"ro"`

	// READ-ONLY; The service key for the network function resource.
	ServiceKey *string `json:"serviceKey,omitempty" azure:"ro"`

	// READ-ONLY; The vendor provisioning state for the network function resource.
	VendorProvisioningState *VendorProvisioningState `json:"vendorProvisioningState,omitempty" azure:"ro"`
}

// NetworkFunctionRoleConfiguration - Network function role configuration.
type NetworkFunctionRoleConfiguration struct {
	// Specifies the custom settings for the virtual machine.
	CustomProfile *CustomProfile `json:"customProfile,omitempty"`

	// The network interface configurations.
	NetworkInterfaces []*NetworkInterface `json:"networkInterfaces,omitempty"`

	// Specifies the operating system settings for the role instance. This value can be updated during the deployment of network
	// function.
	OSProfile *OsProfile `json:"osProfile,omitempty"`

	// The name of the network function role.
	RoleName *string `json:"roleName,omitempty"`

	// Role type.
	RoleType *NetworkFunctionRoleConfigurationType `json:"roleType,omitempty"`

	// Specifies the storage settings for the virtual machine disks.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`

	// The user parameters for customers. The format of user data parameters has to be matched with the provided user data template.
	UserDataParameters interface{} `json:"userDataParameters,omitempty"`

	// The user data template for customers. This is a json schema template describing the format and data type of user data parameters.
	UserDataTemplate interface{} `json:"userDataTemplate,omitempty"`

	// The size of the virtual machine.
	VirtualMachineSize *VirtualMachineSizeTypes `json:"virtualMachineSize,omitempty"`
}

// NetworkFunctionRoleInstanceListResult - List of role instances of vendor network function.
type NetworkFunctionRoleInstanceListResult struct {
	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; A list of role instances.
	Value []*RoleInstance `json:"value,omitempty" azure:"ro"`
}

// NetworkFunctionSKUDetails - The network function sku details.
type NetworkFunctionSKUDetails struct {
	// The network function sku type.
	SKUType *SKUType `json:"skuType,omitempty"`

	// The network function sku role details.
	Value []*NetworkFunctionSKURoleDetails `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// NetworkFunctionSKUListResult - A list of available network function skus.
type NetworkFunctionSKUListResult struct {
	// The network function vendor sku overview properties.
	Value []*SKUOverview `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// NetworkFunctionSKURoleDetails - The network function user configuration.
type NetworkFunctionSKURoleDetails struct {
	// The network interface configuration.
	NetworkInterfaces []*NetworkInterface `json:"networkInterfaces,omitempty"`

	// The name of the network function role.
	RoleName *string `json:"roleName,omitempty"`

	// The user parameters for customers.
	UserDataParameters interface{} `json:"userDataParameters,omitempty"`

	// The user data template for customers.
	UserDataTemplate interface{} `json:"userDataTemplate,omitempty"`
}

// NetworkFunctionTemplate - The network function template.
type NetworkFunctionTemplate struct {
	// An array of network function role definitions.
	NetworkFunctionRoleConfigurations []*NetworkFunctionRoleConfiguration `json:"networkFunctionRoleConfigurations,omitempty"`
}

// NetworkFunctionUserConfiguration - The network function user configuration.
type NetworkFunctionUserConfiguration struct {
	// The network interface configuration.
	NetworkInterfaces []*NetworkInterface `json:"networkInterfaces,omitempty"`

	// Specifies the operating system settings for the role instance.
	OSProfile *NetworkFunctionUserConfigurationOsProfile `json:"osProfile,omitempty"`

	// The name of the network function role.
	RoleName *string `json:"roleName,omitempty"`

	// The user data parameters from the customer.
	UserDataParameters interface{} `json:"userDataParameters,omitempty"`
}

// NetworkFunctionUserConfigurationOsProfile - Specifies the operating system settings for the role instance.
type NetworkFunctionUserConfigurationOsProfile struct {
	// Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved
	// as a file on the virtual machine. The maximum length of the binary array is
	// 65535 bytes.
	// Note: Do not pass any secrets or passwords in customData property
	// This property cannot be updated after the VM is created.
	// customData is passed to the VM to be saved as a file. For more information see Custom Data on Azure VMs [https://azure.microsoft.com/en-us/blog/custom-data-and-cloud-init-on-windows-azure/]
	// For using cloud-init for your Linux VM, see Using cloud-init to customize a Linux VM during creation
	// [https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json]
	CustomData *string `json:"customData,omitempty"`
}

// NetworkFunctionVendor - The network function vendor.
type NetworkFunctionVendor struct {
	// Vendors of Hybrid Network service provider.
	Properties *VendorDetails `json:"properties,omitempty"`
}

// NetworkFunctionVendorConfiguration - Network function vendor configuration.
type NetworkFunctionVendorConfiguration struct {
	// The network interface configurations.
	NetworkInterfaces []*NetworkInterface `json:"networkInterfaces,omitempty"`

	// Specifies the operating system settings for the role instance.
	OSProfile *OsProfile `json:"osProfile,omitempty"`

	// The name of the vendor network function role.
	RoleName *string `json:"roleName,omitempty"`

	// READ-ONLY; The user parameters from the customer.
	UserDataParameters interface{} `json:"userDataParameters,omitempty" azure:"ro"`
}

// NetworkFunctionVendorListResult - The network function vendor list result.
type NetworkFunctionVendorListResult struct {
	// A list of available network function vendors and skus.
	Value []*NetworkFunctionVendor `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// NetworkFunctionVendorSKUsClientListBySKUOptions contains the optional parameters for the NetworkFunctionVendorSKUsClient.ListBySKU
// method.
type NetworkFunctionVendorSKUsClientListBySKUOptions struct {
	// placeholder for future optional parameters
}

// NetworkFunctionVendorSKUsClientListByVendorOptions contains the optional parameters for the NetworkFunctionVendorSKUsClient.ListByVendor
// method.
type NetworkFunctionVendorSKUsClientListByVendorOptions struct {
	// placeholder for future optional parameters
}

// NetworkFunctionVendorsClientListOptions contains the optional parameters for the NetworkFunctionVendorsClient.List method.
type NetworkFunctionVendorsClientListOptions struct {
	// placeholder for future optional parameters
}

// NetworkFunctionsClientBeginCreateOrUpdateOptions contains the optional parameters for the NetworkFunctionsClient.BeginCreateOrUpdate
// method.
type NetworkFunctionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NetworkFunctionsClientBeginDeleteOptions contains the optional parameters for the NetworkFunctionsClient.BeginDelete method.
type NetworkFunctionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NetworkFunctionsClientBeginExecuteRequestOptions contains the optional parameters for the NetworkFunctionsClient.BeginExecuteRequest
// method.
type NetworkFunctionsClientBeginExecuteRequestOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NetworkFunctionsClientGetOptions contains the optional parameters for the NetworkFunctionsClient.Get method.
type NetworkFunctionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// NetworkFunctionsClientListByResourceGroupOptions contains the optional parameters for the NetworkFunctionsClient.ListByResourceGroup
// method.
type NetworkFunctionsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// NetworkFunctionsClientListBySubscriptionOptions contains the optional parameters for the NetworkFunctionsClient.ListBySubscription
// method.
type NetworkFunctionsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// NetworkFunctionsClientUpdateTagsOptions contains the optional parameters for the NetworkFunctionsClient.UpdateTags method.
type NetworkFunctionsClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// NetworkInterface - Network interface properties.
type NetworkInterface struct {
	// A list of IP configurations of the network interface.
	IPConfigurations []*NetworkInterfaceIPConfiguration `json:"ipConfigurations,omitempty"`

	// The MAC address of the network interface.
	MacAddress *string `json:"macAddress,omitempty"`

	// The name of the network interface.
	NetworkInterfaceName *string `json:"networkInterfaceName,omitempty"`

	// The type of the VM switch.
	VMSwitchType *VMSwitchType `json:"vmSwitchType,omitempty"`
}

// NetworkInterfaceIPConfiguration - Network interface IP configuration properties.
type NetworkInterfaceIPConfiguration struct {
	// The list of DNS servers IP addresses.
	DNSServers []*string `json:"dnsServers,omitempty"`

	// The value of the gateway.
	Gateway *string `json:"gateway,omitempty"`

	// The value of the IP address.
	IPAddress *string `json:"ipAddress,omitempty"`

	// IP address allocation method.
	IPAllocationMethod *IPAllocationMethod `json:"ipAllocationMethod,omitempty"`

	// IP address version.
	IPVersion *IPVersion `json:"ipVersion,omitempty"`

	// The value of the subnet.
	Subnet *string `json:"subnet,omitempty"`
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType `json:"actionType,omitempty" azure:"ro"`

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool `json:"isDataAction,omitempty" azure:"ro"`

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin `json:"origin,omitempty" azure:"ro"`
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OsDisk - Specifies information about the operating system disk used by the virtual machine.
// For more information about disks, see About disks and VHDs for Azure virtual machines
// [https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json].
type OsDisk struct {
	// Specifies the size of os disk in gigabytes. This is the fully expanded disk size needed of the VHD image on the ASE. This
	// disk size should be greater than the size of the VHD provided in vhdUri.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`

	// The VHD name.
	Name *string `json:"name,omitempty"`

	// The OS type.
	OSType *OperatingSystemTypes `json:"osType,omitempty"`

	// The virtual hard disk.
	Vhd *VirtualHardDisk `json:"vhd,omitempty"`
}

// OsProfile - Specifies the operating system settings for the role instance.
type OsProfile struct {
	// Specifies the name of the administrator account.
	// Windows-only restriction: Cannot end in "."
	// Disallowed values: "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123",
	// "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest",
	// "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
	// Minimum-length (Linux): 1 character
	// Max-length (Linux): 64 characters
	// Max-length (Windows): 20 characters
	// For root access to the Linux VM, see Using root privileges on Linux virtual machines in Azure
	// [https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json]
	// For a list of built-in system users on Linux that should not be used in this field, see Selecting User Names for Linux
	// on Azure
	// [https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json].
	AdminUsername *string `json:"adminUsername,omitempty"`

	// Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved
	// as a file on the virtual machine. The maximum length of the binary array is
	// 65535 bytes.
	// Note: Do not pass any secrets or passwords in customData property
	// This property cannot be updated after the VM is created.
	// customData is passed to the VM to be saved as a file. For more information see Custom Data on Azure VMs [https://azure.microsoft.com/en-us/blog/custom-data-and-cloud-init-on-windows-azure/]
	// For using cloud-init for your Linux VM, see Using cloud-init to customize a Linux VM during creation
	// [https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json]
	CustomData *string `json:"customData,omitempty"`

	// Indicates if custom data is required to deploy this role.
	CustomDataRequired *bool `json:"customDataRequired,omitempty"`

	// Specifies the Linux operating system settings on the virtual machine.
	// For a list of supported Linux distributions, see Linux on Azure-Endorsed Distributions
	// [https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json]
	// For running non-endorsed distributions, see Information for Non-Endorsed Distributions
	// [https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json].
	LinuxConfiguration *LinuxConfiguration `json:"linuxConfiguration,omitempty"`
}

// PreviewSubscription - Customer subscription which can use a sku.
type PreviewSubscription struct {
	// The Preview Subscription properties.
	Properties *PreviewSubscriptionProperties `json:"properties,omitempty"`

	// READ-ONLY; The ARM ID of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The preview subscription ID.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PreviewSubscriptionProperties - PreviewSubscription properties
type PreviewSubscriptionProperties struct {
	// READ-ONLY; The provisioning state of the PreviewSubscription resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PreviewSubscriptionsList - A list of customer subscriptions which can use a sku.
type PreviewSubscriptionsList struct {
	// A list of preview subscriptions.
	Value []*PreviewSubscription `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RequestMetadata - Request metadata of execute request post call payload.
type RequestMetadata struct {
	// REQUIRED; The http method of the request.
	HTTPMethod *HTTPMethod `json:"httpMethod,omitempty"`

	// REQUIRED; The relative path of the request.
	RelativePath *string `json:"relativePath,omitempty"`

	// REQUIRED; The serialized body of the request.
	SerializedBody *string `json:"serializedBody,omitempty"`

	// The api version of the request.
	APIVersion *string `json:"apiVersion,omitempty"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RoleInstance - The role instance sub resource.
type RoleInstance struct {
	// The ARM ID of the resource.
	ID *string `json:"id,omitempty"`

	// The role instance name.
	Name *string `json:"name,omitempty"`

	// The role instance properties.
	Properties *RoleInstanceProperties `json:"properties,omitempty"`

	// The type of the resource.
	Type *string `json:"type,omitempty"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`
}

// RoleInstanceProperties - The role instance properties of the network function.
type RoleInstanceProperties struct {
	// The operational state of the role instance.
	OperationalState *OperationalState `json:"operationalState,omitempty"`

	// READ-ONLY; The provisioning state of the RoleInstance resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// RoleInstancesClientBeginRestartOptions contains the optional parameters for the RoleInstancesClient.BeginRestart method.
type RoleInstancesClientBeginRestartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RoleInstancesClientBeginStartOptions contains the optional parameters for the RoleInstancesClient.BeginStart method.
type RoleInstancesClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RoleInstancesClientBeginStopOptions contains the optional parameters for the RoleInstancesClient.BeginStop method.
type RoleInstancesClientBeginStopOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RoleInstancesClientGetOptions contains the optional parameters for the RoleInstancesClient.Get method.
type RoleInstancesClientGetOptions struct {
	// placeholder for future optional parameters
}

// RoleInstancesClientListOptions contains the optional parameters for the RoleInstancesClient.List method.
type RoleInstancesClientListOptions struct {
	// placeholder for future optional parameters
}

// SKUCredential - The Sku credential definition.
type SKUCredential struct {
	// The Acr server url
	AcrServerURL *string `json:"acrServerUrl,omitempty"`

	// The credential value.
	AcrToken *string `json:"acrToken,omitempty"`

	// The UTC time when credential will expire.
	Expiry *time.Time `json:"expiry,omitempty"`

	// The repositories that could be accessed using the current credential.
	Repositories []*string `json:"repositories,omitempty"`

	// The username of the sku credential.
	Username *string `json:"username,omitempty"`
}

// SKUOverview - The network function sku overview.
type SKUOverview struct {
	// The vendor sku name.
	SKUName *string `json:"skuName,omitempty"`

	// The vendor sku type.
	SKUType *SKUType `json:"skuType,omitempty"`
}

// SSHConfiguration - SSH configuration for Linux based VMs running on Azure
type SSHConfiguration struct {
	// The list of SSH public keys used to authenticate with linux based VMs.
	PublicKeys []*SSHPublicKey `json:"publicKeys,omitempty"`
}

// SSHPublicKey - Contains information about SSH certificate public key and the path on the Linux VM where the public key
// is placed.
type SSHPublicKey struct {
	// SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa
	// format.
	// For creating ssh keys, see Create SSH keys on Linux and Mac for Linux VMs in Azure
	// [https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json].
	KeyData *string `json:"keyData,omitempty"`

	// Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key
	// is appended to the file. Example: /home/user/.ssh/authorized_keys
	Path *string `json:"path,omitempty"`
}

// StorageProfile - Specifies the storage settings for the virtual machine disks.
type StorageProfile struct {
	// Specifies the parameters that are used to add a data disk to a virtual machine.
	DataDisks []*DataDisk `json:"dataDisks,omitempty"`

	// The image reference properties.
	ImageReference *ImageReference `json:"imageReference,omitempty"`

	// Specifies information about the operating system disk used by the virtual machine.
	OSDisk *OsDisk `json:"osDisk,omitempty"`
}

// SubResource - Reference to another sub resource.
type SubResource struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TagsObject - Tags object for patch operations.
type TagsObject struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Vendor resource.
type Vendor struct {
	// Vendor properties.
	Properties *VendorPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VendorDetails - The network function vendor details.
type VendorDetails struct {
	// The network function sku list.
	SKUList []*SKUOverview `json:"skuList,omitempty"`

	// The network function vendor name.
	VendorName *string `json:"vendorName,omitempty"`
}

// VendorListResult - Response for vendors API service call.
type VendorListResult struct {
	// A list of vendors.
	Value []*Vendor `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// VendorNetworkFunction - Vendor network function sub resource.
type VendorNetworkFunction struct {
	// Network function details.
	Properties *VendorNetworkFunctionPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VendorNetworkFunctionListResult - Response for vendors API service call.
type VendorNetworkFunctionListResult struct {
	// A list of vendor network functions.
	Value []*VendorNetworkFunction `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// VendorNetworkFunctionPropertiesFormat - Vendor network function properties.
type VendorNetworkFunctionPropertiesFormat struct {
	// An array of network function vendor configurations.
	NetworkFunctionVendorConfigurations []*NetworkFunctionVendorConfiguration `json:"networkFunctionVendorConfigurations,omitempty"`

	// The vendor controlled provisioning state of the vendor network function.
	VendorProvisioningState *VendorProvisioningState `json:"vendorProvisioningState,omitempty"`

	// READ-ONLY; The provisioning state of the vendor network function sub resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The name of the sku. Once set, it cannot be updated.
	SKUName *string `json:"skuName,omitempty" azure:"ro"`

	// READ-ONLY; The sku type.
	SKUType *SKUType `json:"skuType,omitempty" azure:"ro"`
}

// VendorNetworkFunctionsClientBeginCreateOrUpdateOptions contains the optional parameters for the VendorNetworkFunctionsClient.BeginCreateOrUpdate
// method.
type VendorNetworkFunctionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VendorNetworkFunctionsClientGetOptions contains the optional parameters for the VendorNetworkFunctionsClient.Get method.
type VendorNetworkFunctionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// VendorNetworkFunctionsClientListOptions contains the optional parameters for the VendorNetworkFunctionsClient.List method.
type VendorNetworkFunctionsClientListOptions struct {
	// The filter to apply on the operation. The properties you can use for eq (equals) are: skuType, skuName and vendorProvisioningState.
	Filter *string
}

// VendorPropertiesFormat - Vendor properties.
type VendorPropertiesFormat struct {
	// READ-ONLY; The provisioning state of the vendor resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; A list of IDs of the vendor skus offered by the vendor.
	SKUs []*SubResource `json:"skus,omitempty" azure:"ro"`
}

// VendorSKU - Sku sub resource.
type VendorSKU struct {
	// Vendor sku details.
	Properties *VendorSKUPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VendorSKUListResult - Response for list vendor sku API service call.
type VendorSKUListResult struct {
	// A list of vendor skus offered by the vendor.
	Value []*VendorSKU `json:"value,omitempty"`

	// READ-ONLY; The URI to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// VendorSKUPreviewClientBeginCreateOrUpdateOptions contains the optional parameters for the VendorSKUPreviewClient.BeginCreateOrUpdate
// method.
type VendorSKUPreviewClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VendorSKUPreviewClientBeginDeleteOptions contains the optional parameters for the VendorSKUPreviewClient.BeginDelete method.
type VendorSKUPreviewClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VendorSKUPreviewClientGetOptions contains the optional parameters for the VendorSKUPreviewClient.Get method.
type VendorSKUPreviewClientGetOptions struct {
	// placeholder for future optional parameters
}

// VendorSKUPreviewClientListOptions contains the optional parameters for the VendorSKUPreviewClient.List method.
type VendorSKUPreviewClientListOptions struct {
	// placeholder for future optional parameters
}

// VendorSKUPropertiesFormat - Sku properties
type VendorSKUPropertiesFormat struct {
	// The sku deployment mode.
	DeploymentMode *SKUDeploymentMode `json:"deploymentMode,omitempty"`

	// The parameters for the managed application to be supplied by the vendor.
	ManagedApplicationParameters interface{} `json:"managedApplicationParameters,omitempty"`

	// The template for the managed application deployment.
	ManagedApplicationTemplate interface{} `json:"managedApplicationTemplate,omitempty"`

	// The template definition of the network function.
	NetworkFunctionTemplate *NetworkFunctionTemplate `json:"networkFunctionTemplate,omitempty"`

	// The network function type.
	NetworkFunctionType *NetworkFunctionType `json:"networkFunctionType,omitempty"`

	// Indicates if the vendor sku is in preview mode.
	Preview *bool `json:"preview,omitempty"`

	// The sku type.
	SKUType *SKUType `json:"skuType,omitempty"`

	// READ-ONLY; The provisioning state of the vendor sku sub resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// VendorSKUsClientBeginCreateOrUpdateOptions contains the optional parameters for the VendorSKUsClient.BeginCreateOrUpdate
// method.
type VendorSKUsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VendorSKUsClientBeginDeleteOptions contains the optional parameters for the VendorSKUsClient.BeginDelete method.
type VendorSKUsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VendorSKUsClientGetOptions contains the optional parameters for the VendorSKUsClient.Get method.
type VendorSKUsClientGetOptions struct {
	// placeholder for future optional parameters
}

// VendorSKUsClientListCredentialOptions contains the optional parameters for the VendorSKUsClient.ListCredential method.
type VendorSKUsClientListCredentialOptions struct {
	// placeholder for future optional parameters
}

// VendorSKUsClientListOptions contains the optional parameters for the VendorSKUsClient.List method.
type VendorSKUsClientListOptions struct {
	// placeholder for future optional parameters
}

// VendorsClientBeginCreateOrUpdateOptions contains the optional parameters for the VendorsClient.BeginCreateOrUpdate method.
type VendorsClientBeginCreateOrUpdateOptions struct {
	// Parameters supplied to the create vendor operation.
	Parameters *Vendor
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VendorsClientBeginDeleteOptions contains the optional parameters for the VendorsClient.BeginDelete method.
type VendorsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VendorsClientGetOptions contains the optional parameters for the VendorsClient.Get method.
type VendorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// VendorsClientListBySubscriptionOptions contains the optional parameters for the VendorsClient.ListBySubscription method.
type VendorsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// VirtualHardDisk - Describes the uri of a disk.
type VirtualHardDisk struct {
	// Specifies the virtual hard disk's uri.
	URI *string `json:"uri,omitempty"`
}
