// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/baremetalsolution/v2/volume.proto

package baremetalsolutionpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The storage type for a volume.
type Volume_StorageType int32

const (
	// The storage type for this volume is unknown.
	Volume_STORAGE_TYPE_UNSPECIFIED Volume_StorageType = 0
	// The storage type for this volume is SSD.
	Volume_SSD Volume_StorageType = 1
	// This storage type for this volume is HDD.
	Volume_HDD Volume_StorageType = 2
)

// Enum value maps for Volume_StorageType.
var (
	Volume_StorageType_name = map[int32]string{
		0: "STORAGE_TYPE_UNSPECIFIED",
		1: "SSD",
		2: "HDD",
	}
	Volume_StorageType_value = map[string]int32{
		"STORAGE_TYPE_UNSPECIFIED": 0,
		"SSD":                      1,
		"HDD":                      2,
	}
)

func (x Volume_StorageType) Enum() *Volume_StorageType {
	p := new(Volume_StorageType)
	*p = x
	return p
}

func (x Volume_StorageType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Volume_StorageType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_baremetalsolution_v2_volume_proto_enumTypes[0].Descriptor()
}

func (Volume_StorageType) Type() protoreflect.EnumType {
	return &file_google_cloud_baremetalsolution_v2_volume_proto_enumTypes[0]
}

func (x Volume_StorageType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Volume_StorageType.Descriptor instead.
func (Volume_StorageType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_volume_proto_rawDescGZIP(), []int{0, 0}
}

// The possible states for a storage volume.
type Volume_State int32

const (
	// The storage volume is in an unknown state.
	Volume_STATE_UNSPECIFIED Volume_State = 0
	// The storage volume is being created.
	Volume_CREATING Volume_State = 1
	// The storage volume is ready for use.
	Volume_READY Volume_State = 2
	// The storage volume has been requested to be deleted.
	Volume_DELETING Volume_State = 3
	// The storage volume is being updated.
	Volume_UPDATING Volume_State = 4
	// The storage volume is in cool off state. It will be deleted after
	// `expire_time`.
	Volume_COOL_OFF Volume_State = 5
)

// Enum value maps for Volume_State.
var (
	Volume_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "READY",
		3: "DELETING",
		4: "UPDATING",
		5: "COOL_OFF",
	}
	Volume_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"READY":             2,
		"DELETING":          3,
		"UPDATING":          4,
		"COOL_OFF":          5,
	}
)

func (x Volume_State) Enum() *Volume_State {
	p := new(Volume_State)
	*p = x
	return p
}

func (x Volume_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Volume_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_baremetalsolution_v2_volume_proto_enumTypes[1].Descriptor()
}

func (Volume_State) Type() protoreflect.EnumType {
	return &file_google_cloud_baremetalsolution_v2_volume_proto_enumTypes[1]
}

func (x Volume_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Volume_State.Descriptor instead.
func (Volume_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_volume_proto_rawDescGZIP(), []int{0, 1}
}

// The kinds of auto delete behavior to use when snapshot reserved space is
// full.
type Volume_SnapshotAutoDeleteBehavior int32

const (
	// The unspecified behavior.
	Volume_SNAPSHOT_AUTO_DELETE_BEHAVIOR_UNSPECIFIED Volume_SnapshotAutoDeleteBehavior = 0
	// Don't delete any snapshots. This disables new snapshot creation, as
	// long as the snapshot reserved space is full.
	Volume_DISABLED Volume_SnapshotAutoDeleteBehavior = 1
	// Delete the oldest snapshots first.
	Volume_OLDEST_FIRST Volume_SnapshotAutoDeleteBehavior = 2
	// Delete the newest snapshots first.
	Volume_NEWEST_FIRST Volume_SnapshotAutoDeleteBehavior = 3
)

// Enum value maps for Volume_SnapshotAutoDeleteBehavior.
var (
	Volume_SnapshotAutoDeleteBehavior_name = map[int32]string{
		0: "SNAPSHOT_AUTO_DELETE_BEHAVIOR_UNSPECIFIED",
		1: "DISABLED",
		2: "OLDEST_FIRST",
		3: "NEWEST_FIRST",
	}
	Volume_SnapshotAutoDeleteBehavior_value = map[string]int32{
		"SNAPSHOT_AUTO_DELETE_BEHAVIOR_UNSPECIFIED": 0,
		"DISABLED":     1,
		"OLDEST_FIRST": 2,
		"NEWEST_FIRST": 3,
	}
)

func (x Volume_SnapshotAutoDeleteBehavior) Enum() *Volume_SnapshotAutoDeleteBehavior {
	p := new(Volume_SnapshotAutoDeleteBehavior)
	*p = x
	return p
}

func (x Volume_SnapshotAutoDeleteBehavior) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Volume_SnapshotAutoDeleteBehavior) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_baremetalsolution_v2_volume_proto_enumTypes[2].Descriptor()
}

func (Volume_SnapshotAutoDeleteBehavior) Type() protoreflect.EnumType {
	return &file_google_cloud_baremetalsolution_v2_volume_proto_enumTypes[2]
}

func (x Volume_SnapshotAutoDeleteBehavior) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Volume_SnapshotAutoDeleteBehavior.Descriptor instead.
func (Volume_SnapshotAutoDeleteBehavior) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_volume_proto_rawDescGZIP(), []int{0, 2}
}

// Storage protocol.
type Volume_Protocol int32

const (
	// Value is not specified.
	Volume_PROTOCOL_UNSPECIFIED Volume_Protocol = 0
	// Fibre Channel protocol.
	Volume_FIBRE_CHANNEL Volume_Protocol = 1
	// NFS protocol means Volume is a NFS Share volume.
	// Such volumes cannot be manipulated via Volumes API.
	Volume_NFS Volume_Protocol = 2
)

// Enum value maps for Volume_Protocol.
var (
	Volume_Protocol_name = map[int32]string{
		0: "PROTOCOL_UNSPECIFIED",
		1: "FIBRE_CHANNEL",
		2: "NFS",
	}
	Volume_Protocol_value = map[string]int32{
		"PROTOCOL_UNSPECIFIED": 0,
		"FIBRE_CHANNEL":        1,
		"NFS":                  2,
	}
)

func (x Volume_Protocol) Enum() *Volume_Protocol {
	p := new(Volume_Protocol)
	*p = x
	return p
}

func (x Volume_Protocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Volume_Protocol) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_baremetalsolution_v2_volume_proto_enumTypes[3].Descriptor()
}

func (Volume_Protocol) Type() protoreflect.EnumType {
	return &file_google_cloud_baremetalsolution_v2_volume_proto_enumTypes[3]
}

func (x Volume_Protocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Volume_Protocol.Descriptor instead.
func (Volume_Protocol) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_volume_proto_rawDescGZIP(), []int{0, 3}
}

// The possible values for a workload profile.
type Volume_WorkloadProfile int32

const (
	// The workload profile is in an unknown state.
	Volume_WORKLOAD_PROFILE_UNSPECIFIED Volume_WorkloadProfile = 0
	// The workload profile is generic.
	Volume_GENERIC Volume_WorkloadProfile = 1
	// The workload profile is hana.
	Volume_HANA Volume_WorkloadProfile = 2
)

// Enum value maps for Volume_WorkloadProfile.
var (
	Volume_WorkloadProfile_name = map[int32]string{
		0: "WORKLOAD_PROFILE_UNSPECIFIED",
		1: "GENERIC",
		2: "HANA",
	}
	Volume_WorkloadProfile_value = map[string]int32{
		"WORKLOAD_PROFILE_UNSPECIFIED": 0,
		"GENERIC":                      1,
		"HANA":                         2,
	}
)

func (x Volume_WorkloadProfile) Enum() *Volume_WorkloadProfile {
	p := new(Volume_WorkloadProfile)
	*p = x
	return p
}

func (x Volume_WorkloadProfile) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Volume_WorkloadProfile) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_baremetalsolution_v2_volume_proto_enumTypes[4].Descriptor()
}

func (Volume_WorkloadProfile) Type() protoreflect.EnumType {
	return &file_google_cloud_baremetalsolution_v2_volume_proto_enumTypes[4]
}

func (x Volume_WorkloadProfile) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Volume_WorkloadProfile.Descriptor instead.
func (Volume_WorkloadProfile) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_volume_proto_rawDescGZIP(), []int{0, 4}
}

// A storage volume.
type Volume struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this `Volume`.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// Format:
	// `projects/{project}/locations/{location}/volumes/{volume}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// An identifier for the `Volume`, generated by the backend.
	Id string `protobuf:"bytes,11,opt,name=id,proto3" json:"id,omitempty"`
	// The storage type for this volume.
	StorageType Volume_StorageType `protobuf:"varint,2,opt,name=storage_type,json=storageType,proto3,enum=google.cloud.baremetalsolution.v2.Volume_StorageType" json:"storage_type,omitempty"`
	// The state of this storage volume.
	State Volume_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.baremetalsolution.v2.Volume_State" json:"state,omitempty"`
	// The requested size of this storage volume, in GiB.
	RequestedSizeGib int64 `protobuf:"varint,4,opt,name=requested_size_gib,json=requestedSizeGib,proto3" json:"requested_size_gib,omitempty"`
	// Originally requested size, in GiB.
	OriginallyRequestedSizeGib int64 `protobuf:"varint,16,opt,name=originally_requested_size_gib,json=originallyRequestedSizeGib,proto3" json:"originally_requested_size_gib,omitempty"`
	// The current size of this storage volume, in GiB, including space reserved
	// for snapshots. This size might be different than the requested size if the
	// storage volume has been configured with auto grow or auto shrink.
	CurrentSizeGib int64 `protobuf:"varint,5,opt,name=current_size_gib,json=currentSizeGib,proto3" json:"current_size_gib,omitempty"`
	// Additional emergency size that was requested for this Volume, in GiB.
	// current_size_gib includes this value.
	EmergencySizeGib int64 `protobuf:"varint,14,opt,name=emergency_size_gib,json=emergencySizeGib,proto3" json:"emergency_size_gib,omitempty"`
	// Maximum size volume can be expanded to in case of evergency, in GiB.
	MaxSizeGib int64 `protobuf:"varint,17,opt,name=max_size_gib,json=maxSizeGib,proto3" json:"max_size_gib,omitempty"`
	// The size, in GiB, that this storage volume has expanded as a result of an
	// auto grow policy. In the absence of auto-grow, the value is 0.
	AutoGrownSizeGib int64 `protobuf:"varint,6,opt,name=auto_grown_size_gib,json=autoGrownSizeGib,proto3" json:"auto_grown_size_gib,omitempty"`
	// The space remaining in the storage volume for new LUNs, in GiB, excluding
	// space reserved for snapshots.
	RemainingSpaceGib int64 `protobuf:"varint,7,opt,name=remaining_space_gib,json=remainingSpaceGib,proto3" json:"remaining_space_gib,omitempty"`
	// Details about snapshot space reservation and usage on the storage volume.
	SnapshotReservationDetail *Volume_SnapshotReservationDetail `protobuf:"bytes,8,opt,name=snapshot_reservation_detail,json=snapshotReservationDetail,proto3" json:"snapshot_reservation_detail,omitempty"`
	// The behavior to use when snapshot reserved space is full.
	SnapshotAutoDeleteBehavior Volume_SnapshotAutoDeleteBehavior `protobuf:"varint,9,opt,name=snapshot_auto_delete_behavior,json=snapshotAutoDeleteBehavior,proto3,enum=google.cloud.baremetalsolution.v2.Volume_SnapshotAutoDeleteBehavior" json:"snapshot_auto_delete_behavior,omitempty"`
	// Labels as key value pairs.
	Labels map[string]string `protobuf:"bytes,12,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Whether snapshots are enabled.
	SnapshotEnabled bool `protobuf:"varint,13,opt,name=snapshot_enabled,json=snapshotEnabled,proto3" json:"snapshot_enabled,omitempty"`
	// Immutable. Pod name.
	Pod string `protobuf:"bytes,15,opt,name=pod,proto3" json:"pod,omitempty"`
	// Output only. Storage protocol for the Volume.
	Protocol Volume_Protocol `protobuf:"varint,18,opt,name=protocol,proto3,enum=google.cloud.baremetalsolution.v2.Volume_Protocol" json:"protocol,omitempty"`
	// Output only. Whether this volume is a boot volume. A boot volume is one
	// which contains a boot LUN.
	BootVolume bool `protobuf:"varint,19,opt,name=boot_volume,json=bootVolume,proto3" json:"boot_volume,omitempty"`
	// Immutable. Performance tier of the Volume.
	// Default is SHARED.
	PerformanceTier VolumePerformanceTier `protobuf:"varint,20,opt,name=performance_tier,json=performanceTier,proto3,enum=google.cloud.baremetalsolution.v2.VolumePerformanceTier" json:"performance_tier,omitempty"`
	// Input only. User-specified notes for new Volume.
	// Used to provision Volumes that require manual intervention.
	Notes string `protobuf:"bytes,21,opt,name=notes,proto3" json:"notes,omitempty"`
	// The workload profile for the volume.
	WorkloadProfile Volume_WorkloadProfile `protobuf:"varint,22,opt,name=workload_profile,json=workloadProfile,proto3,enum=google.cloud.baremetalsolution.v2.Volume_WorkloadProfile" json:"workload_profile,omitempty"`
	// Output only. Time after which volume will be fully deleted.
	// It is filled only for volumes in COOLOFF state.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,24,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Output only. Instances this Volume is attached to.
	// This field is set only in Get requests.
	Instances []string `protobuf:"bytes,25,rep,name=instances,proto3" json:"instances,omitempty"`
	// Output only. Is the Volume attached at at least one instance.
	// This field is a lightweight counterpart of `instances` field.
	// It is filled in List responses as well.
	Attached bool `protobuf:"varint,26,opt,name=attached,proto3" json:"attached,omitempty"`
}

func (x *Volume) Reset() {
	*x = Volume{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Volume) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Volume) ProtoMessage() {}

func (x *Volume) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Volume.ProtoReflect.Descriptor instead.
func (*Volume) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_volume_proto_rawDescGZIP(), []int{0}
}

func (x *Volume) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Volume) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Volume) GetStorageType() Volume_StorageType {
	if x != nil {
		return x.StorageType
	}
	return Volume_STORAGE_TYPE_UNSPECIFIED
}

func (x *Volume) GetState() Volume_State {
	if x != nil {
		return x.State
	}
	return Volume_STATE_UNSPECIFIED
}

func (x *Volume) GetRequestedSizeGib() int64 {
	if x != nil {
		return x.RequestedSizeGib
	}
	return 0
}

func (x *Volume) GetOriginallyRequestedSizeGib() int64 {
	if x != nil {
		return x.OriginallyRequestedSizeGib
	}
	return 0
}

func (x *Volume) GetCurrentSizeGib() int64 {
	if x != nil {
		return x.CurrentSizeGib
	}
	return 0
}

func (x *Volume) GetEmergencySizeGib() int64 {
	if x != nil {
		return x.EmergencySizeGib
	}
	return 0
}

func (x *Volume) GetMaxSizeGib() int64 {
	if x != nil {
		return x.MaxSizeGib
	}
	return 0
}

func (x *Volume) GetAutoGrownSizeGib() int64 {
	if x != nil {
		return x.AutoGrownSizeGib
	}
	return 0
}

func (x *Volume) GetRemainingSpaceGib() int64 {
	if x != nil {
		return x.RemainingSpaceGib
	}
	return 0
}

func (x *Volume) GetSnapshotReservationDetail() *Volume_SnapshotReservationDetail {
	if x != nil {
		return x.SnapshotReservationDetail
	}
	return nil
}

func (x *Volume) GetSnapshotAutoDeleteBehavior() Volume_SnapshotAutoDeleteBehavior {
	if x != nil {
		return x.SnapshotAutoDeleteBehavior
	}
	return Volume_SNAPSHOT_AUTO_DELETE_BEHAVIOR_UNSPECIFIED
}

func (x *Volume) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Volume) GetSnapshotEnabled() bool {
	if x != nil {
		return x.SnapshotEnabled
	}
	return false
}

func (x *Volume) GetPod() string {
	if x != nil {
		return x.Pod
	}
	return ""
}

func (x *Volume) GetProtocol() Volume_Protocol {
	if x != nil {
		return x.Protocol
	}
	return Volume_PROTOCOL_UNSPECIFIED
}

func (x *Volume) GetBootVolume() bool {
	if x != nil {
		return x.BootVolume
	}
	return false
}

func (x *Volume) GetPerformanceTier() VolumePerformanceTier {
	if x != nil {
		return x.PerformanceTier
	}
	return VolumePerformanceTier_VOLUME_PERFORMANCE_TIER_UNSPECIFIED
}

func (x *Volume) GetNotes() string {
	if x != nil {
		return x.Notes
	}
	return ""
}

func (x *Volume) GetWorkloadProfile() Volume_WorkloadProfile {
	if x != nil {
		return x.WorkloadProfile
	}
	return Volume_WORKLOAD_PROFILE_UNSPECIFIED
}

func (x *Volume) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *Volume) GetInstances() []string {
	if x != nil {
		return x.Instances
	}
	return nil
}

func (x *Volume) GetAttached() bool {
	if x != nil {
		return x.Attached
	}
	return false
}

// Message for requesting storage volume information.
type GetVolumeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetVolumeRequest) Reset() {
	*x = GetVolumeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetVolumeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVolumeRequest) ProtoMessage() {}

func (x *GetVolumeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVolumeRequest.ProtoReflect.Descriptor instead.
func (*GetVolumeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_volume_proto_rawDescGZIP(), []int{1}
}

func (x *GetVolumeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for requesting a list of storage volumes.
type ListVolumesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ListVolumesRequest.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. The server might return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results from the server.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// List filter.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListVolumesRequest) Reset() {
	*x = ListVolumesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListVolumesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVolumesRequest) ProtoMessage() {}

func (x *ListVolumesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVolumesRequest.ProtoReflect.Descriptor instead.
func (*ListVolumesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_volume_proto_rawDescGZIP(), []int{2}
}

func (x *ListVolumesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListVolumesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListVolumesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListVolumesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message containing the list of storage volumes.
type ListVolumesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of storage volumes.
	Volumes []*Volume `protobuf:"bytes,1,rep,name=volumes,proto3" json:"volumes,omitempty"`
	// A token identifying a page of results from the server.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListVolumesResponse) Reset() {
	*x = ListVolumesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListVolumesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVolumesResponse) ProtoMessage() {}

func (x *ListVolumesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVolumesResponse.ProtoReflect.Descriptor instead.
func (*ListVolumesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_volume_proto_rawDescGZIP(), []int{3}
}

func (x *ListVolumesResponse) GetVolumes() []*Volume {
	if x != nil {
		return x.Volumes
	}
	return nil
}

func (x *ListVolumesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListVolumesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for updating a volume.
type UpdateVolumeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The volume to update.
	//
	// The `name` field is used to identify the volume to update.
	// Format: projects/{project}/locations/{location}/volumes/{volume}
	Volume *Volume `protobuf:"bytes,1,opt,name=volume,proto3" json:"volume,omitempty"`
	// The list of fields to update.
	// The only currently supported fields are:
	//
	//	'labels'
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateVolumeRequest) Reset() {
	*x = UpdateVolumeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateVolumeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateVolumeRequest) ProtoMessage() {}

func (x *UpdateVolumeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateVolumeRequest.ProtoReflect.Descriptor instead.
func (*UpdateVolumeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_volume_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateVolumeRequest) GetVolume() *Volume {
	if x != nil {
		return x.Volume
	}
	return nil
}

func (x *UpdateVolumeRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Message requesting rename of a server.
type RenameVolumeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `name` field is used to identify the volume.
	// Format: projects/{project}/locations/{location}/volumes/{volume}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The new `id` of the volume.
	NewVolumeId string `protobuf:"bytes,2,opt,name=new_volume_id,json=newVolumeId,proto3" json:"new_volume_id,omitempty"`
}

func (x *RenameVolumeRequest) Reset() {
	*x = RenameVolumeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RenameVolumeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenameVolumeRequest) ProtoMessage() {}

func (x *RenameVolumeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenameVolumeRequest.ProtoReflect.Descriptor instead.
func (*RenameVolumeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_volume_proto_rawDescGZIP(), []int{5}
}

func (x *RenameVolumeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RenameVolumeRequest) GetNewVolumeId() string {
	if x != nil {
		return x.NewVolumeId
	}
	return ""
}

// Request for skip volume cooloff and delete it.
type EvictVolumeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Volume.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *EvictVolumeRequest) Reset() {
	*x = EvictVolumeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EvictVolumeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EvictVolumeRequest) ProtoMessage() {}

func (x *EvictVolumeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EvictVolumeRequest.ProtoReflect.Descriptor instead.
func (*EvictVolumeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_volume_proto_rawDescGZIP(), []int{6}
}

func (x *EvictVolumeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for emergency resize Volume.
type ResizeVolumeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Volume to resize.
	Volume string `protobuf:"bytes,1,opt,name=volume,proto3" json:"volume,omitempty"`
	// New Volume size, in GiB.
	SizeGib int64 `protobuf:"varint,2,opt,name=size_gib,json=sizeGib,proto3" json:"size_gib,omitempty"`
}

func (x *ResizeVolumeRequest) Reset() {
	*x = ResizeVolumeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResizeVolumeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResizeVolumeRequest) ProtoMessage() {}

func (x *ResizeVolumeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResizeVolumeRequest.ProtoReflect.Descriptor instead.
func (*ResizeVolumeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_volume_proto_rawDescGZIP(), []int{7}
}

func (x *ResizeVolumeRequest) GetVolume() string {
	if x != nil {
		return x.Volume
	}
	return ""
}

func (x *ResizeVolumeRequest) GetSizeGib() int64 {
	if x != nil {
		return x.SizeGib
	}
	return 0
}

// Details about snapshot space reservation and usage on the storage volume.
type Volume_SnapshotReservationDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The space on this storage volume reserved for snapshots, shown in GiB.
	ReservedSpaceGib int64 `protobuf:"varint,1,opt,name=reserved_space_gib,json=reservedSpaceGib,proto3" json:"reserved_space_gib,omitempty"`
	// The percent of snapshot space on this storage volume actually being used
	// by the snapshot copies. This value might be higher than 100% if the
	// snapshot copies have overflowed into the data portion of the storage
	// volume.
	ReservedSpaceUsedPercent int32 `protobuf:"varint,2,opt,name=reserved_space_used_percent,json=reservedSpaceUsedPercent,proto3" json:"reserved_space_used_percent,omitempty"`
	// The amount, in GiB, of available space in this storage volume's reserved
	// snapshot space.
	ReservedSpaceRemainingGib int64 `protobuf:"varint,3,opt,name=reserved_space_remaining_gib,json=reservedSpaceRemainingGib,proto3" json:"reserved_space_remaining_gib,omitempty"`
	// Percent of the total Volume size reserved for snapshot copies.
	// Enabling snapshots requires reserving 20% or more of
	// the storage volume space for snapshots. Maximum reserved space for
	// snapshots is 40%.
	// Setting this field will effectively set snapshot_enabled to true.
	ReservedSpacePercent int32 `protobuf:"varint,4,opt,name=reserved_space_percent,json=reservedSpacePercent,proto3" json:"reserved_space_percent,omitempty"`
}

func (x *Volume_SnapshotReservationDetail) Reset() {
	*x = Volume_SnapshotReservationDetail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Volume_SnapshotReservationDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Volume_SnapshotReservationDetail) ProtoMessage() {}

func (x *Volume_SnapshotReservationDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Volume_SnapshotReservationDetail.ProtoReflect.Descriptor instead.
func (*Volume_SnapshotReservationDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_volume_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Volume_SnapshotReservationDetail) GetReservedSpaceGib() int64 {
	if x != nil {
		return x.ReservedSpaceGib
	}
	return 0
}

func (x *Volume_SnapshotReservationDetail) GetReservedSpaceUsedPercent() int32 {
	if x != nil {
		return x.ReservedSpaceUsedPercent
	}
	return 0
}

func (x *Volume_SnapshotReservationDetail) GetReservedSpaceRemainingGib() int64 {
	if x != nil {
		return x.ReservedSpaceRemainingGib
	}
	return 0
}

func (x *Volume_SnapshotReservationDetail) GetReservedSpacePercent() int32 {
	if x != nil {
		return x.ReservedSpacePercent
	}
	return 0
}

var File_google_cloud_baremetalsolution_v2_volume_proto protoreflect.FileDescriptor

var file_google_cloud_baremetalsolution_v2_volume_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2f, 0x76, 0x32, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x32, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x61,
	0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2f,
	0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xab, 0x12, 0x0a, 0x06, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x58, 0x0a, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65,
	0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x45, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x32, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x69, 0x62, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x10, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x53, 0x69,
	0x7a, 0x65, 0x47, 0x69, 0x62, 0x12, 0x41, 0x0a, 0x1d, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61,
	0x6c, 0x6c, 0x79, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x5f, 0x67, 0x69, 0x62, 0x18, 0x10, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1a, 0x6f, 0x72,
	0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65,
	0x64, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x69, 0x62, 0x12, 0x28, 0x0a, 0x10, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x69, 0x62, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x47,
	0x69, 0x62, 0x12, 0x2c, 0x0a, 0x12, 0x65, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x6e, 0x63, 0x79, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x69, 0x62, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10,
	0x65, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x6e, 0x63, 0x79, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x69, 0x62,
	0x12, 0x20, 0x0a, 0x0c, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x69, 0x62,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x53, 0x69, 0x7a, 0x65, 0x47,
	0x69, 0x62, 0x12, 0x2d, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x67, 0x72, 0x6f, 0x77, 0x6e,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x69, 0x62, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x10, 0x61, 0x75, 0x74, 0x6f, 0x47, 0x72, 0x6f, 0x77, 0x6e, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x69,
	0x62, 0x12, 0x2e, 0x0a, 0x13, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x5f, 0x67, 0x69, 0x62, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11,
	0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x61, 0x63, 0x65, 0x47, 0x69,
	0x62, 0x12, 0x83, 0x01, 0x0a, 0x1b, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c,
	0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x19, 0x73, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x87, 0x01, 0x0a, 0x1d, 0x73, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x32, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x52, 0x1a, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x41,
	0x75, 0x74, 0x6f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x12, 0x4d, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x29, 0x0a, 0x10, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x73, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x15, 0x0a, 0x03, 0x70,
	0x6f, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x03, 0x70,
	0x6f, 0x64, 0x12, 0x53, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x12,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x2e,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x24, 0x0a, 0x0b, 0x62, 0x6f, 0x6f, 0x74, 0x5f,
	0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x62, 0x6f, 0x6f, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x12, 0x68, 0x0a,
	0x10, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x69, 0x65,
	0x72, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c,
	0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x69, 0x65,
	0x72, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0f, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x6e, 0x63, 0x65, 0x54, 0x69, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x05, 0x6e, 0x6f, 0x74, 0x65, 0x73,
	0x18, 0x15, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x05, 0x6e, 0x6f, 0x74,
	0x65, 0x73, 0x12, 0x64, 0x0a, 0x10, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x70,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65,
	0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x0f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69,
	0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x09, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x19, 0x20, 0x03, 0x28, 0x09, 0x42, 0x31, 0xe0,
	0x41, 0x03, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c,
	0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x08, 0x61,
	0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x08, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x1a, 0xff, 0x01, 0x0a,
	0x19, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x5f, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x67, 0x69, 0x62,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64,
	0x53, 0x70, 0x61, 0x63, 0x65, 0x47, 0x69, 0x62, 0x12, 0x3d, 0x0a, 0x1b, 0x72, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x64, 0x5f, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x75, 0x73, 0x65, 0x64, 0x5f,
	0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x18, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x53, 0x70, 0x61, 0x63, 0x65, 0x55, 0x73, 0x65, 0x64,
	0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x1c, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x64, 0x5f, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x5f, 0x67, 0x69, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x19, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x6d, 0x61,
	0x69, 0x6e, 0x69, 0x6e, 0x67, 0x47, 0x69, 0x62, 0x12, 0x34, 0x0a, 0x16, 0x72, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x64, 0x5f, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65,
	0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x14, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x64, 0x53, 0x70, 0x61, 0x63, 0x65, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x1a, 0x39,
	0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x3d, 0x0a, 0x0b, 0x53, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x53, 0x54, 0x4f, 0x52,
	0x41, 0x47, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x53, 0x53, 0x44, 0x10, 0x01, 0x12,
	0x07, 0x0a, 0x03, 0x48, 0x44, 0x44, 0x10, 0x02, 0x22, 0x61, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41,
	0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10,
	0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12,
	0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0c, 0x0a,
	0x08, 0x43, 0x4f, 0x4f, 0x4c, 0x5f, 0x4f, 0x46, 0x46, 0x10, 0x05, 0x22, 0x7d, 0x0a, 0x1a, 0x53,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x12, 0x2d, 0x0a, 0x29, 0x53, 0x4e, 0x41,
	0x50, 0x53, 0x48, 0x4f, 0x54, 0x5f, 0x41, 0x55, 0x54, 0x4f, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54,
	0x45, 0x5f, 0x42, 0x45, 0x48, 0x41, 0x56, 0x49, 0x4f, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41,
	0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x4f, 0x4c, 0x44, 0x45, 0x53, 0x54,
	0x5f, 0x46, 0x49, 0x52, 0x53, 0x54, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x4e, 0x45, 0x57, 0x45,
	0x53, 0x54, 0x5f, 0x46, 0x49, 0x52, 0x53, 0x54, 0x10, 0x03, 0x22, 0x40, 0x0a, 0x08, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x18, 0x0a, 0x14, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43,
	0x4f, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x11, 0x0a, 0x0d, 0x46, 0x49, 0x42, 0x52, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45,
	0x4c, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x4e, 0x46, 0x53, 0x10, 0x02, 0x22, 0x4a, 0x0a, 0x0f,
	0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12,
	0x20, 0x0a, 0x1c, 0x57, 0x4f, 0x52, 0x4b, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x50, 0x52, 0x4f, 0x46,
	0x49, 0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0b, 0x0a, 0x07, 0x47, 0x45, 0x4e, 0x45, 0x52, 0x49, 0x43, 0x10, 0x01, 0x12, 0x08,
	0x0a, 0x04, 0x48, 0x41, 0x4e, 0x41, 0x10, 0x02, 0x3a, 0x66, 0xea, 0x41, 0x63, 0x0a, 0x27, 0x62,
	0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x12, 0x38, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x2f, 0x7b, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x7d,
	0x22, 0x57, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x62, 0x61, 0x72, 0x65,
	0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xab, 0x01, 0x0a, 0x12, 0x4c, 0x69,
	0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xa4, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74,
	0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x43, 0x0a, 0x07, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x07, 0x76, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x9a,
	0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x12, 0x3b,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x83, 0x01, 0x0a, 0x13,
	0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x62, 0x61, 0x72, 0x65, 0x6d,
	0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0d, 0x6e, 0x65, 0x77, 0x5f,
	0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6e, 0x65, 0x77, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x49,
	0x64, 0x22, 0x59, 0x0a, 0x12, 0x45, 0x76, 0x69, 0x63, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x62,
	0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x79, 0x0a, 0x13,
	0x52, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x62, 0x61, 0x72,
	0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x52, 0x06, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x08,
	0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x69, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07,
	0x73, 0x69, 0x7a, 0x65, 0x47, 0x69, 0x62, 0x42, 0xfa, 0x01, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72,
	0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x32, 0x42, 0x0b, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x53, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x62, 0x61,
	0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x70,
	0x62, 0x3b, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x70, 0x62, 0xaa, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x61, 0x72, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x6c, 0x53, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x61, 0x72, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x6c, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5c, 0x56, 0x32, 0xea, 0x02, 0x24,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x42,
	0x61, 0x72, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x6c, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_baremetalsolution_v2_volume_proto_rawDescOnce sync.Once
	file_google_cloud_baremetalsolution_v2_volume_proto_rawDescData = file_google_cloud_baremetalsolution_v2_volume_proto_rawDesc
)

func file_google_cloud_baremetalsolution_v2_volume_proto_rawDescGZIP() []byte {
	file_google_cloud_baremetalsolution_v2_volume_proto_rawDescOnce.Do(func() {
		file_google_cloud_baremetalsolution_v2_volume_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_baremetalsolution_v2_volume_proto_rawDescData)
	})
	return file_google_cloud_baremetalsolution_v2_volume_proto_rawDescData
}

var file_google_cloud_baremetalsolution_v2_volume_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_baremetalsolution_v2_volume_proto_goTypes = []interface{}{
	(Volume_StorageType)(0),                  // 0: google.cloud.baremetalsolution.v2.Volume.StorageType
	(Volume_State)(0),                        // 1: google.cloud.baremetalsolution.v2.Volume.State
	(Volume_SnapshotAutoDeleteBehavior)(0),   // 2: google.cloud.baremetalsolution.v2.Volume.SnapshotAutoDeleteBehavior
	(Volume_Protocol)(0),                     // 3: google.cloud.baremetalsolution.v2.Volume.Protocol
	(Volume_WorkloadProfile)(0),              // 4: google.cloud.baremetalsolution.v2.Volume.WorkloadProfile
	(*Volume)(nil),                           // 5: google.cloud.baremetalsolution.v2.Volume
	(*GetVolumeRequest)(nil),                 // 6: google.cloud.baremetalsolution.v2.GetVolumeRequest
	(*ListVolumesRequest)(nil),               // 7: google.cloud.baremetalsolution.v2.ListVolumesRequest
	(*ListVolumesResponse)(nil),              // 8: google.cloud.baremetalsolution.v2.ListVolumesResponse
	(*UpdateVolumeRequest)(nil),              // 9: google.cloud.baremetalsolution.v2.UpdateVolumeRequest
	(*RenameVolumeRequest)(nil),              // 10: google.cloud.baremetalsolution.v2.RenameVolumeRequest
	(*EvictVolumeRequest)(nil),               // 11: google.cloud.baremetalsolution.v2.EvictVolumeRequest
	(*ResizeVolumeRequest)(nil),              // 12: google.cloud.baremetalsolution.v2.ResizeVolumeRequest
	(*Volume_SnapshotReservationDetail)(nil), // 13: google.cloud.baremetalsolution.v2.Volume.SnapshotReservationDetail
	nil,                                      // 14: google.cloud.baremetalsolution.v2.Volume.LabelsEntry
	(VolumePerformanceTier)(0),               // 15: google.cloud.baremetalsolution.v2.VolumePerformanceTier
	(*timestamppb.Timestamp)(nil),            // 16: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),            // 17: google.protobuf.FieldMask
}
var file_google_cloud_baremetalsolution_v2_volume_proto_depIdxs = []int32{
	0,  // 0: google.cloud.baremetalsolution.v2.Volume.storage_type:type_name -> google.cloud.baremetalsolution.v2.Volume.StorageType
	1,  // 1: google.cloud.baremetalsolution.v2.Volume.state:type_name -> google.cloud.baremetalsolution.v2.Volume.State
	13, // 2: google.cloud.baremetalsolution.v2.Volume.snapshot_reservation_detail:type_name -> google.cloud.baremetalsolution.v2.Volume.SnapshotReservationDetail
	2,  // 3: google.cloud.baremetalsolution.v2.Volume.snapshot_auto_delete_behavior:type_name -> google.cloud.baremetalsolution.v2.Volume.SnapshotAutoDeleteBehavior
	14, // 4: google.cloud.baremetalsolution.v2.Volume.labels:type_name -> google.cloud.baremetalsolution.v2.Volume.LabelsEntry
	3,  // 5: google.cloud.baremetalsolution.v2.Volume.protocol:type_name -> google.cloud.baremetalsolution.v2.Volume.Protocol
	15, // 6: google.cloud.baremetalsolution.v2.Volume.performance_tier:type_name -> google.cloud.baremetalsolution.v2.VolumePerformanceTier
	4,  // 7: google.cloud.baremetalsolution.v2.Volume.workload_profile:type_name -> google.cloud.baremetalsolution.v2.Volume.WorkloadProfile
	16, // 8: google.cloud.baremetalsolution.v2.Volume.expire_time:type_name -> google.protobuf.Timestamp
	5,  // 9: google.cloud.baremetalsolution.v2.ListVolumesResponse.volumes:type_name -> google.cloud.baremetalsolution.v2.Volume
	5,  // 10: google.cloud.baremetalsolution.v2.UpdateVolumeRequest.volume:type_name -> google.cloud.baremetalsolution.v2.Volume
	17, // 11: google.cloud.baremetalsolution.v2.UpdateVolumeRequest.update_mask:type_name -> google.protobuf.FieldMask
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_cloud_baremetalsolution_v2_volume_proto_init() }
func file_google_cloud_baremetalsolution_v2_volume_proto_init() {
	if File_google_cloud_baremetalsolution_v2_volume_proto != nil {
		return
	}
	file_google_cloud_baremetalsolution_v2_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Volume); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetVolumeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListVolumesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListVolumesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateVolumeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RenameVolumeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EvictVolumeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResizeVolumeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Volume_SnapshotReservationDetail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_baremetalsolution_v2_volume_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_baremetalsolution_v2_volume_proto_goTypes,
		DependencyIndexes: file_google_cloud_baremetalsolution_v2_volume_proto_depIdxs,
		EnumInfos:         file_google_cloud_baremetalsolution_v2_volume_proto_enumTypes,
		MessageInfos:      file_google_cloud_baremetalsolution_v2_volume_proto_msgTypes,
	}.Build()
	File_google_cloud_baremetalsolution_v2_volume_proto = out.File
	file_google_cloud_baremetalsolution_v2_volume_proto_rawDesc = nil
	file_google_cloud_baremetalsolution_v2_volume_proto_goTypes = nil
	file_google_cloud_baremetalsolution_v2_volume_proto_depIdxs = nil
}
