// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/securitycenter/v2/securitycenter_service.proto

package securitycenterpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message to create multiple resource value configs
type BatchCreateResourceValueConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the new ResourceValueConfig's parent.
	// The parent field in the CreateResourceValueConfigRequest
	// messages must either be empty or match this field.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The resource value configs to be created.
	Requests []*CreateResourceValueConfigRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchCreateResourceValueConfigsRequest) Reset() {
	*x = BatchCreateResourceValueConfigsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateResourceValueConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateResourceValueConfigsRequest) ProtoMessage() {}

func (x *BatchCreateResourceValueConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateResourceValueConfigsRequest.ProtoReflect.Descriptor instead.
func (*BatchCreateResourceValueConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{0}
}

func (x *BatchCreateResourceValueConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchCreateResourceValueConfigsRequest) GetRequests() []*CreateResourceValueConfigRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Response message for BatchCreateResourceValueConfigs
type BatchCreateResourceValueConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource value configs created
	ResourceValueConfigs []*ResourceValueConfig `protobuf:"bytes,1,rep,name=resource_value_configs,json=resourceValueConfigs,proto3" json:"resource_value_configs,omitempty"`
}

func (x *BatchCreateResourceValueConfigsResponse) Reset() {
	*x = BatchCreateResourceValueConfigsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateResourceValueConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateResourceValueConfigsResponse) ProtoMessage() {}

func (x *BatchCreateResourceValueConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateResourceValueConfigsResponse.ProtoReflect.Descriptor instead.
func (*BatchCreateResourceValueConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{1}
}

func (x *BatchCreateResourceValueConfigsResponse) GetResourceValueConfigs() []*ResourceValueConfig {
	if x != nil {
		return x.ResourceValueConfigs
	}
	return nil
}

// Request message for bulk findings update.
//
// Note:
// 1. If multiple bulk update requests match the same resource, the order in
// which they get executed is not defined.
// 2. Once a bulk operation is started, there is no way to stop it.
type BulkMuteFindingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, at which bulk action needs to be applied. If no
	// location is specified, findings are updated in global. The following list
	// shows some examples:
	//
	// + `organizations/[organization_id]`
	// + `organizations/[organization_id]/locations/[location_id]`
	// + `folders/[folder_id]`
	// + `folders/[folder_id]/locations/[location_id]`
	// + `projects/[project_id]`
	// + `projects/[project_id]/locations/[location_id]`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Expression that identifies findings that should be updated.
	// The expression is a list of zero or more restrictions combined
	// via logical operators `AND` and `OR`. Parentheses are supported, and `OR`
	// has higher precedence than `AND`.
	//
	// Restrictions have the form `<field> <operator> <value>` and may have a
	// `-` character in front of them to indicate negation. The fields map to
	// those defined in the corresponding resource.
	//
	// The supported operators are:
	//
	// * `=` for all value types.
	// * `>`, `<`, `>=`, `<=` for integer values.
	// * `:`, meaning substring matching, for strings.
	//
	// The supported value types are:
	//
	// * string literals in quotes.
	// * integer literals without quotes.
	// * boolean literals `true` and `false` without quotes.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *BulkMuteFindingsRequest) Reset() {
	*x = BulkMuteFindingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BulkMuteFindingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkMuteFindingsRequest) ProtoMessage() {}

func (x *BulkMuteFindingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkMuteFindingsRequest.ProtoReflect.Descriptor instead.
func (*BulkMuteFindingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{2}
}

func (x *BulkMuteFindingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BulkMuteFindingsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// The response to a BulkMute request. Contains the LRO information.
type BulkMuteFindingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BulkMuteFindingsResponse) Reset() {
	*x = BulkMuteFindingsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BulkMuteFindingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkMuteFindingsResponse) ProtoMessage() {}

func (x *BulkMuteFindingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkMuteFindingsResponse.ProtoReflect.Descriptor instead.
func (*BulkMuteFindingsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{3}
}

// Request message for creating a BigQuery export.
type CreateBigQueryExportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the parent resource of the new BigQuery export. Its
	// format is "organizations/[organization_id]/locations/[location_id]",
	// "folders/[folder_id]/locations/[location_id]", or
	// "projects/[project_id]/locations/[location_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The BigQuery export being created.
	BigQueryExport *BigQueryExport `protobuf:"bytes,2,opt,name=big_query_export,json=bigQueryExport,proto3" json:"big_query_export,omitempty"`
	// Required. Unique identifier provided by the client within the parent scope.
	// It must consist of only lowercase letters, numbers, and hyphens, must start
	// with a letter, must end with either a letter or a number, and must be 63
	// characters or less.
	BigQueryExportId string `protobuf:"bytes,3,opt,name=big_query_export_id,json=bigQueryExportId,proto3" json:"big_query_export_id,omitempty"`
}

func (x *CreateBigQueryExportRequest) Reset() {
	*x = CreateBigQueryExportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateBigQueryExportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBigQueryExportRequest) ProtoMessage() {}

func (x *CreateBigQueryExportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBigQueryExportRequest.ProtoReflect.Descriptor instead.
func (*CreateBigQueryExportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{4}
}

func (x *CreateBigQueryExportRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateBigQueryExportRequest) GetBigQueryExport() *BigQueryExport {
	if x != nil {
		return x.BigQueryExport
	}
	return nil
}

func (x *CreateBigQueryExportRequest) GetBigQueryExportId() string {
	if x != nil {
		return x.BigQueryExportId
	}
	return ""
}

// Request message for creating a finding.
type CreateFindingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the new finding's parent. The following list
	// shows some examples of the format:
	// +
	// `organizations/[organization_id]/sources/[source_id]`
	// +
	// `organizations/[organization_id]/sources/[source_id]/locations/[location_id]`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Unique identifier provided by the client within the parent scope.
	// It must be alphanumeric and less than or equal to 32 characters and
	// greater than 0 characters in length.
	FindingId string `protobuf:"bytes,2,opt,name=finding_id,json=findingId,proto3" json:"finding_id,omitempty"`
	// Required. The Finding being created. The name and security_marks will be
	// ignored as they are both output only fields on this resource.
	Finding *Finding `protobuf:"bytes,3,opt,name=finding,proto3" json:"finding,omitempty"`
}

func (x *CreateFindingRequest) Reset() {
	*x = CreateFindingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateFindingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFindingRequest) ProtoMessage() {}

func (x *CreateFindingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFindingRequest.ProtoReflect.Descriptor instead.
func (*CreateFindingRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{5}
}

func (x *CreateFindingRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateFindingRequest) GetFindingId() string {
	if x != nil {
		return x.FindingId
	}
	return ""
}

func (x *CreateFindingRequest) GetFinding() *Finding {
	if x != nil {
		return x.Finding
	}
	return nil
}

// Request message for creating a mute config.
type CreateMuteConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the new mute configs's parent. Its format is
	// "organizations/[organization_id]/locations/[location_id]",
	// "folders/[folder_id]/locations/[location_id]", or
	// "projects/[project_id]/locations/[location_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The mute config being created.
	MuteConfig *MuteConfig `protobuf:"bytes,2,opt,name=mute_config,json=muteConfig,proto3" json:"mute_config,omitempty"`
	// Required. Unique identifier provided by the client within the parent scope.
	// It must consist of only lowercase letters, numbers, and hyphens, must start
	// with a letter, must end with either a letter or a number, and must be 63
	// characters or less.
	MuteConfigId string `protobuf:"bytes,3,opt,name=mute_config_id,json=muteConfigId,proto3" json:"mute_config_id,omitempty"`
}

func (x *CreateMuteConfigRequest) Reset() {
	*x = CreateMuteConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateMuteConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMuteConfigRequest) ProtoMessage() {}

func (x *CreateMuteConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMuteConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateMuteConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{6}
}

func (x *CreateMuteConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMuteConfigRequest) GetMuteConfig() *MuteConfig {
	if x != nil {
		return x.MuteConfig
	}
	return nil
}

func (x *CreateMuteConfigRequest) GetMuteConfigId() string {
	if x != nil {
		return x.MuteConfigId
	}
	return ""
}

// Request message for creating a notification config.
type CreateNotificationConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the new notification config's parent. Its format
	// is "organizations/[organization_id]/locations/[location_id]",
	// "folders/[folder_id]/locations/[location_id]", or
	// "projects/[project_id]/locations/[location_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required.
	// Unique identifier provided by the client within the parent scope.
	// It must be between 1 and 128 characters and contain alphanumeric
	// characters, underscores, or hyphens only.
	ConfigId string `protobuf:"bytes,2,opt,name=config_id,json=configId,proto3" json:"config_id,omitempty"`
	// Required. The notification config being created. The name and the service
	// account will be ignored as they are both output only fields on this
	// resource.
	NotificationConfig *NotificationConfig `protobuf:"bytes,3,opt,name=notification_config,json=notificationConfig,proto3" json:"notification_config,omitempty"`
}

func (x *CreateNotificationConfigRequest) Reset() {
	*x = CreateNotificationConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateNotificationConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateNotificationConfigRequest) ProtoMessage() {}

func (x *CreateNotificationConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateNotificationConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateNotificationConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{7}
}

func (x *CreateNotificationConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateNotificationConfigRequest) GetConfigId() string {
	if x != nil {
		return x.ConfigId
	}
	return ""
}

func (x *CreateNotificationConfigRequest) GetNotificationConfig() *NotificationConfig {
	if x != nil {
		return x.NotificationConfig
	}
	return nil
}

// Request message to create single resource value config
type CreateResourceValueConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the new ResourceValueConfig's parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The resource value config being created.
	ResourceValueConfig *ResourceValueConfig `protobuf:"bytes,2,opt,name=resource_value_config,json=resourceValueConfig,proto3" json:"resource_value_config,omitempty"`
}

func (x *CreateResourceValueConfigRequest) Reset() {
	*x = CreateResourceValueConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateResourceValueConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateResourceValueConfigRequest) ProtoMessage() {}

func (x *CreateResourceValueConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateResourceValueConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateResourceValueConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{8}
}

func (x *CreateResourceValueConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateResourceValueConfigRequest) GetResourceValueConfig() *ResourceValueConfig {
	if x != nil {
		return x.ResourceValueConfig
	}
	return nil
}

// Request message for creating a source.
type CreateSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the new source's parent. Its format should be
	// "organizations/[organization_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Source being created, only the display_name and description
	// will be used. All other fields will be ignored.
	Source *Source `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
}

func (x *CreateSourceRequest) Reset() {
	*x = CreateSourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSourceRequest) ProtoMessage() {}

func (x *CreateSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSourceRequest.ProtoReflect.Descriptor instead.
func (*CreateSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{9}
}

func (x *CreateSourceRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSourceRequest) GetSource() *Source {
	if x != nil {
		return x.Source
	}
	return nil
}

// Request message for deleting a BigQuery export.
type DeleteBigQueryExportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the BigQuery export to delete. The following list
	// shows some examples of the format:
	//
	// +
	// `organizations/{organization}/locations/{location}/bigQueryExports/{export_id}`
	// + `folders/{folder}/locations/{location}/bigQueryExports/{export_id}`
	// + `projects/{project}/locations/{location}/bigQueryExports/{export_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteBigQueryExportRequest) Reset() {
	*x = DeleteBigQueryExportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteBigQueryExportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBigQueryExportRequest) ProtoMessage() {}

func (x *DeleteBigQueryExportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBigQueryExportRequest.ProtoReflect.Descriptor instead.
func (*DeleteBigQueryExportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{10}
}

func (x *DeleteBigQueryExportRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for deleting a mute config. If no location is specified,
// default is global.
type DeleteMuteConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the mute config to delete. The following list shows some
	// examples of the format:
	//
	// + `organizations/{organization}/muteConfigs/{config_id}`
	// +
	// `organizations/{organization}/locations/{location}/muteConfigs/{config_id}`
	// + `folders/{folder}/muteConfigs/{config_id}`
	// + `folders/{folder}/locations/{location}/muteConfigs/{config_id}`
	// + `projects/{project}/muteConfigs/{config_id}`
	// + `projects/{project}/locations/{location}/muteConfigs/{config_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteMuteConfigRequest) Reset() {
	*x = DeleteMuteConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteMuteConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteMuteConfigRequest) ProtoMessage() {}

func (x *DeleteMuteConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteMuteConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteMuteConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{11}
}

func (x *DeleteMuteConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for deleting a notification config.
type DeleteNotificationConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the notification config to delete. The following list
	// shows some examples of the format:
	//
	// +
	// `organizations/[organization_id]/locations/[location_id]/notificationConfigs/[config_id]`
	// +
	// `folders/[folder_id]/locations/[location_id]notificationConfigs/[config_id]`
	// +
	// `projects/[project_id]/locations/[location_id]notificationConfigs/[config_id]`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteNotificationConfigRequest) Reset() {
	*x = DeleteNotificationConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteNotificationConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteNotificationConfigRequest) ProtoMessage() {}

func (x *DeleteNotificationConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteNotificationConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteNotificationConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{12}
}

func (x *DeleteNotificationConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message to delete resource value config
type DeleteResourceValueConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the ResourceValueConfig to delete
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteResourceValueConfigRequest) Reset() {
	*x = DeleteResourceValueConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteResourceValueConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteResourceValueConfigRequest) ProtoMessage() {}

func (x *DeleteResourceValueConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteResourceValueConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteResourceValueConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{13}
}

func (x *DeleteResourceValueConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for retrieving a BigQuery export.
type GetBigQueryExportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the BigQuery export to retrieve. The following list shows
	// some examples of the format:
	//
	// +
	// `organizations/{organization}/locations/{location}/bigQueryExports/{export_id}`
	// + `folders/{folder}/locations/{location}/bigQueryExports/{export_id}`
	// + `projects/{project}locations/{location}//bigQueryExports/{export_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBigQueryExportRequest) Reset() {
	*x = GetBigQueryExportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBigQueryExportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBigQueryExportRequest) ProtoMessage() {}

func (x *GetBigQueryExportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBigQueryExportRequest.ProtoReflect.Descriptor instead.
func (*GetBigQueryExportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{14}
}

func (x *GetBigQueryExportRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for retrieving a mute config. If no location is specified,
// default is global.
type GetMuteConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the mute config to retrieve. The following list shows
	// some examples of the format:
	//
	// + `organizations/{organization}/muteConfigs/{config_id}`
	// +
	// `organizations/{organization}/locations/{location}/muteConfigs/{config_id}`
	// + `folders/{folder}/muteConfigs/{config_id}`
	// + `folders/{folder}/locations/{location}/muteConfigs/{config_id}`
	// + `projects/{project}/muteConfigs/{config_id}`
	// + `projects/{project}/locations/{location}/muteConfigs/{config_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetMuteConfigRequest) Reset() {
	*x = GetMuteConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMuteConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMuteConfigRequest) ProtoMessage() {}

func (x *GetMuteConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMuteConfigRequest.ProtoReflect.Descriptor instead.
func (*GetMuteConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{15}
}

func (x *GetMuteConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for getting a notification config.
type GetNotificationConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the notification config to get. The following list shows
	// some examples of the format:
	//
	// +
	// `organizations/[organization_id]/locations/[location_id]/notificationConfigs/[config_id]`
	// +
	// `folders/[folder_id]/locations/[location_id]/notificationConfigs/[config_id]`
	// +
	// `projects/[project_id]/locations/[location_id]/notificationConfigs/[config_id]`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetNotificationConfigRequest) Reset() {
	*x = GetNotificationConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetNotificationConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNotificationConfigRequest) ProtoMessage() {}

func (x *GetNotificationConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNotificationConfigRequest.ProtoReflect.Descriptor instead.
func (*GetNotificationConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{16}
}

func (x *GetNotificationConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message to get resource value config
type GetResourceValueConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource value config to retrieve. Its format is
	// organizations/{organization}/resourceValueConfigs/{config_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetResourceValueConfigRequest) Reset() {
	*x = GetResourceValueConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetResourceValueConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetResourceValueConfigRequest) ProtoMessage() {}

func (x *GetResourceValueConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetResourceValueConfigRequest.ProtoReflect.Descriptor instead.
func (*GetResourceValueConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{17}
}

func (x *GetResourceValueConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for getting a source.
type GetSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Relative resource name of the source. Its format is
	// "organizations/[organization_id]/source/[source_id]".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSourceRequest) Reset() {
	*x = GetSourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSourceRequest) ProtoMessage() {}

func (x *GetSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSourceRequest.ProtoReflect.Descriptor instead.
func (*GetSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{18}
}

func (x *GetSourceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for grouping by findings.
type GroupFindingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the source to groupBy. If no location is specified,
	// finding is assumed to be in global.
	//
	//	The following list shows some examples:
	//
	// + `organizations/[organization_id]/sources/[source_id]`
	// +
	// `organizations/[organization_id]/sources/[source_id]/locations/[location_id]`
	// + `folders/[folder_id]/sources/[source_id]`
	// + `folders/[folder_id]/sources/[source_id]/locations/[location_id]`
	// + `projects/[project_id]/sources/[source_id]`
	// + `projects/[project_id]/sources/[source_id]/locations/[location_id]`
	//
	// To groupBy across all sources provide a source_id of `-`. The following
	// list shows some examples:
	//
	// + `organizations/{organization_id}/sources/-`
	// + `organizations/{organization_id}/sources/-/locations/[location_id]`
	// + `folders/{folder_id}/sources/-`
	// + `folders/{folder_id}/sources/-/locations/[location_id]`
	// + `projects/{project_id}/sources/-`
	// + `projects/{project_id}/sources/-/locations/[location_id]`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Expression that defines the filter to apply across findings.
	// The expression is a list of one or more restrictions combined via logical
	// operators `AND` and `OR`.
	// Parentheses are supported, and `OR` has higher precedence than `AND`.
	//
	// Restrictions have the form `<field> <operator> <value>` and may have a `-`
	// character in front of them to indicate negation. Examples include:
	//
	//   - name
	//   - security_marks.marks.marka
	//
	// The supported operators are:
	//
	// * `=` for all value types.
	// * `>`, `<`, `>=`, `<=` for integer values.
	// * `:`, meaning substring matching, for strings.
	//
	// The supported value types are:
	//
	// * string literals in quotes.
	// * integer literals without quotes.
	// * boolean literals `true` and `false` without quotes.
	//
	// The following field and operator combinations are supported:
	//
	// * name: `=`
	// * parent: `=`, `:`
	// * resource_name: `=`, `:`
	// * state: `=`, `:`
	// * category: `=`, `:`
	// * external_uri: `=`, `:`
	// * event_time: `=`, `>`, `<`, `>=`, `<=`
	//
	//	Usage: This should be milliseconds since epoch or an RFC3339 string.
	//	Examples:
	//	  `event_time = "2019-06-10T16:07:18-07:00"`
	//	  `event_time = 1560208038000`
	//
	// * severity: `=`, `:`
	// * security_marks.marks: `=`, `:`
	// * resource:
	//   - resource.name: `=`, `:`
	//   - resource.parent_name: `=`, `:`
	//   - resource.parent_display_name: `=`, `:`
	//   - resource.project_name: `=`, `:`
	//   - resource.project_display_name: `=`, `:`
	//   - resource.type: `=`, `:`
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Required. Expression that defines what assets fields to use for grouping.
	// The string value should follow SQL syntax: comma separated list of fields.
	// For example: "parent,resource_name".
	//
	// The following fields are supported:
	//
	// * resource_name
	// * category
	// * state
	// * parent
	// * severity
	GroupBy string `protobuf:"bytes,3,opt,name=group_by,json=groupBy,proto3" json:"group_by,omitempty"`
	// The value returned by the last `GroupFindingsResponse`; indicates
	// that this is a continuation of a prior `GroupFindings` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,7,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,8,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *GroupFindingsRequest) Reset() {
	*x = GroupFindingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GroupFindingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupFindingsRequest) ProtoMessage() {}

func (x *GroupFindingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupFindingsRequest.ProtoReflect.Descriptor instead.
func (*GroupFindingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{19}
}

func (x *GroupFindingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *GroupFindingsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *GroupFindingsRequest) GetGroupBy() string {
	if x != nil {
		return x.GroupBy
	}
	return ""
}

func (x *GroupFindingsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *GroupFindingsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response message for group by findings.
type GroupFindingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Group results. There exists an element for each existing unique
	// combination of property/values. The element contains a count for the number
	// of times those specific property/values appear.
	GroupByResults []*GroupResult `protobuf:"bytes,1,rep,name=group_by_results,json=groupByResults,proto3" json:"group_by_results,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of results matching the query.
	TotalSize int32 `protobuf:"varint,4,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *GroupFindingsResponse) Reset() {
	*x = GroupFindingsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GroupFindingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupFindingsResponse) ProtoMessage() {}

func (x *GroupFindingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupFindingsResponse.ProtoReflect.Descriptor instead.
func (*GroupFindingsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{20}
}

func (x *GroupFindingsResponse) GetGroupByResults() []*GroupResult {
	if x != nil {
		return x.GroupByResults
	}
	return nil
}

func (x *GroupFindingsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *GroupFindingsResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// Result containing the properties and count of a groupBy request.
type GroupResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Properties matching the groupBy fields in the request.
	Properties map[string]*structpb.Value `protobuf:"bytes,1,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Total count of resources for the given properties.
	Count int64 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *GroupResult) Reset() {
	*x = GroupResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GroupResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupResult) ProtoMessage() {}

func (x *GroupResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupResult.ProtoReflect.Descriptor instead.
func (*GroupResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{21}
}

func (x *GroupResult) GetProperties() map[string]*structpb.Value {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *GroupResult) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

// Request message for listing the attack paths for a given simulation or valued
// resource.
type ListAttackPathsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of parent to list attack paths.
	//
	// Valid formats:
	// "organizations/{organization}",
	// "organizations/{organization}/simulations/{simulation}"
	// "organizations/{organization}/simulations/{simulation}/attackExposureResults/{attack_exposure_result_v2}"
	// "organizations/{organization}/simulations/{simulation}/valuedResources/{valued_resource}"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The filter expression that filters the attack path in the response.
	// Supported fields:
	//
	//   - `valued_resources` supports =
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The value returned by the last `ListAttackPathsResponse`; indicates
	// that this is a continuation of a prior `ListAttackPaths` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *ListAttackPathsRequest) Reset() {
	*x = ListAttackPathsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAttackPathsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAttackPathsRequest) ProtoMessage() {}

func (x *ListAttackPathsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAttackPathsRequest.ProtoReflect.Descriptor instead.
func (*ListAttackPathsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{22}
}

func (x *ListAttackPathsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAttackPathsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListAttackPathsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAttackPathsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response message for listing the attack paths for a given simulation or
// valued resource.
type ListAttackPathsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The attack paths that the attack path simulation identified.
	AttackPaths []*AttackPath `protobuf:"bytes,1,rep,name=attack_paths,json=attackPaths,proto3" json:"attack_paths,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAttackPathsResponse) Reset() {
	*x = ListAttackPathsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAttackPathsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAttackPathsResponse) ProtoMessage() {}

func (x *ListAttackPathsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAttackPathsResponse.ProtoReflect.Descriptor instead.
func (*ListAttackPathsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{23}
}

func (x *ListAttackPathsResponse) GetAttackPaths() []*AttackPath {
	if x != nil {
		return x.AttackPaths
	}
	return nil
}

func (x *ListAttackPathsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for getting simulation.
// Simulation name can include "latest" to retrieve the latest simulation
// For example, "organizations/123/simulations/latest"
type GetSimulationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The organization name or simulation name of this simulation
	//
	// Valid format:
	// "organizations/{organization}/simulations/latest"
	// "organizations/{organization}/simulations/{simulation}"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSimulationRequest) Reset() {
	*x = GetSimulationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSimulationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSimulationRequest) ProtoMessage() {}

func (x *GetSimulationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSimulationRequest.ProtoReflect.Descriptor instead.
func (*GetSimulationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{24}
}

func (x *GetSimulationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for getting a valued resource.
type GetValuedResourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of this valued resource
	//
	// Valid format:
	// "organizations/{organization}/simulations/{simulation}/valuedResources/{valued_resource}"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetValuedResourceRequest) Reset() {
	*x = GetValuedResourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetValuedResourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetValuedResourceRequest) ProtoMessage() {}

func (x *GetValuedResourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetValuedResourceRequest.ProtoReflect.Descriptor instead.
func (*GetValuedResourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{25}
}

func (x *GetValuedResourceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for listing BigQuery exports at a given scope e.g.
// organization, folder or project.
type ListBigQueryExportsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns the collection of BigQuery exports. Its
	// format is "organizations/[organization_id]/locations/[location_id]",
	// "folders/[folder_id]/locations/[location_id]", or
	// "projects/[project_id]/locations/[location_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of configs to return. The service may return fewer than
	// this value.
	// If unspecified, at most 10 configs will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListBigQueryExports` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListBigQueryExports`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListBigQueryExportsRequest) Reset() {
	*x = ListBigQueryExportsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBigQueryExportsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBigQueryExportsRequest) ProtoMessage() {}

func (x *ListBigQueryExportsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBigQueryExportsRequest.ProtoReflect.Descriptor instead.
func (*ListBigQueryExportsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{26}
}

func (x *ListBigQueryExportsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBigQueryExportsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBigQueryExportsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for listing BigQuery exports.
type ListBigQueryExportsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The BigQuery exports from the specified parent.
	BigQueryExports []*BigQueryExport `protobuf:"bytes,1,rep,name=big_query_exports,json=bigQueryExports,proto3" json:"big_query_exports,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListBigQueryExportsResponse) Reset() {
	*x = ListBigQueryExportsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBigQueryExportsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBigQueryExportsResponse) ProtoMessage() {}

func (x *ListBigQueryExportsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBigQueryExportsResponse.ProtoReflect.Descriptor instead.
func (*ListBigQueryExportsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{27}
}

func (x *ListBigQueryExportsResponse) GetBigQueryExports() []*BigQueryExport {
	if x != nil {
		return x.BigQueryExports
	}
	return nil
}

func (x *ListBigQueryExportsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for listing findings.
type ListFindingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the source the findings belong to. If no location is
	// specified, the default is global. The following list shows some examples:
	//
	// + `organizations/[organization_id]/sources/[source_id]`
	// +
	// `organizations/[organization_id]/sources/[source_id]/locations/[location_id]`
	// + `folders/[folder_id]/sources/[source_id]`
	// + `folders/[folder_id]/sources/[source_id]/locations/[location_id]`
	// + `projects/[project_id]/sources/[source_id]`
	// + `projects/[project_id]/sources/[source_id]/locations/[location_id]`
	//
	// To list across all sources provide a source_id of `-`. The following
	// list shows some examples:
	//
	// + `organizations/{organization_id}/sources/-`
	// + `organizations/{organization_id}/sources/-/locations/{location_id}`
	// + `folders/{folder_id}/sources/-`
	// + `folders/{folder_id}/sources/-locations/{location_id}`
	// + `projects/{projects_id}/sources/-`
	// + `projects/{projects_id}/sources/-/locations/{location_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Expression that defines the filter to apply across findings.
	// The expression is a list of one or more restrictions combined via logical
	// operators `AND` and `OR`.
	// Parentheses are supported, and `OR` has higher precedence than `AND`.
	//
	// Restrictions have the form `<field> <operator> <value>` and may have a `-`
	// character in front of them to indicate negation. Examples include:
	//
	//   - name
	//   - security_marks.marks.marka
	//
	// The supported operators are:
	//
	// * `=` for all value types.
	// * `>`, `<`, `>=`, `<=` for integer values.
	// * `:`, meaning substring matching, for strings.
	//
	// The supported value types are:
	//
	// * string literals in quotes.
	// * integer literals without quotes.
	// * boolean literals `true` and `false` without quotes.
	//
	// The following field and operator combinations are supported:
	//
	// * name: `=`
	// * parent: `=`, `:`
	// * resource_name: `=`, `:`
	// * state: `=`, `:`
	// * category: `=`, `:`
	// * external_uri: `=`, `:`
	// * event_time: `=`, `>`, `<`, `>=`, `<=`
	//
	//	Usage: This should be milliseconds since epoch or an RFC3339 string.
	//	Examples:
	//	  `event_time = "2019-06-10T16:07:18-07:00"`
	//	  `event_time = 1560208038000`
	//
	// * severity: `=`, `:`
	// * security_marks.marks: `=`, `:`
	// * resource:
	//   - resource.name: `=`, `:`
	//   - resource.parent_name: `=`, `:`
	//   - resource.parent_display_name: `=`, `:`
	//   - resource.project_name: `=`, `:`
	//   - resource.project_display_name: `=`, `:`
	//   - resource.type: `=`, `:`
	//   - resource.folders.resource_folder: `=`, `:`
	//   - resource.display_name: `=`, `:`
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Expression that defines what fields and order to use for sorting. The
	// string value should follow SQL syntax: comma separated list of fields. For
	// example: "name,parent". The default sorting order
	// is ascending. To specify descending order for a field, a suffix " desc"
	// should be appended to the field name. For example: "name
	// desc,parent". Redundant space characters in the
	// syntax are insignificant. "name desc,parent" and "
	// name     desc  ,   parent  " are equivalent.
	//
	// The following fields are supported:
	// name
	// parent
	// state
	// category
	// resource_name
	// event_time
	// security_marks.marks
	OrderBy string `protobuf:"bytes,3,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// A field mask to specify the Finding fields to be listed in the response.
	// An empty field mask will list all fields.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,7,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	// The value returned by the last `ListFindingsResponse`; indicates
	// that this is a continuation of a prior `ListFindings` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,8,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,9,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *ListFindingsRequest) Reset() {
	*x = ListFindingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFindingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFindingsRequest) ProtoMessage() {}

func (x *ListFindingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFindingsRequest.ProtoReflect.Descriptor instead.
func (*ListFindingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{28}
}

func (x *ListFindingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListFindingsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListFindingsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListFindingsRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

func (x *ListFindingsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListFindingsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response message for listing findings.
type ListFindingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Findings matching the list request.
	ListFindingsResults []*ListFindingsResponse_ListFindingsResult `protobuf:"bytes,1,rep,name=list_findings_results,json=listFindingsResults,proto3" json:"list_findings_results,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of findings matching the query.
	TotalSize int32 `protobuf:"varint,4,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *ListFindingsResponse) Reset() {
	*x = ListFindingsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFindingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFindingsResponse) ProtoMessage() {}

func (x *ListFindingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFindingsResponse.ProtoReflect.Descriptor instead.
func (*ListFindingsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{29}
}

func (x *ListFindingsResponse) GetListFindingsResults() []*ListFindingsResponse_ListFindingsResult {
	if x != nil {
		return x.ListFindingsResults
	}
	return nil
}

func (x *ListFindingsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListFindingsResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// Request message for listing  mute configs at a given scope e.g. organization,
// folder or project. If no location is specified, default is
// global.
type ListMuteConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns the collection of mute configs. Its format
	// is "organizations/[organization_id]", "folders/[folder_id]",
	// "projects/[project_id]",
	// "organizations/[organization_id]/locations/[location_id]",
	// "folders/[folder_id]/locations/[location_id]",
	// "projects/[project_id]/locations/[location_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of configs to return. The service may return fewer than
	// this value.
	// If unspecified, at most 10 configs will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListMuteConfigs` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListMuteConfigs` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListMuteConfigsRequest) Reset() {
	*x = ListMuteConfigsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMuteConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMuteConfigsRequest) ProtoMessage() {}

func (x *ListMuteConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMuteConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListMuteConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{30}
}

func (x *ListMuteConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMuteConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMuteConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for listing mute configs.
type ListMuteConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The mute configs from the specified parent.
	MuteConfigs []*MuteConfig `protobuf:"bytes,1,rep,name=mute_configs,json=muteConfigs,proto3" json:"mute_configs,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListMuteConfigsResponse) Reset() {
	*x = ListMuteConfigsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMuteConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMuteConfigsResponse) ProtoMessage() {}

func (x *ListMuteConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMuteConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListMuteConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{31}
}

func (x *ListMuteConfigsResponse) GetMuteConfigs() []*MuteConfig {
	if x != nil {
		return x.MuteConfigs
	}
	return nil
}

func (x *ListMuteConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for listing notification configs.
type ListNotificationConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the parent in which to list the notification
	// configurations. Its format is
	// "organizations/[organization_id]/locations/[location_id]",
	// "folders/[folder_id]/locations/[location_id]", or
	// "projects/[project_id]/locations/[location_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The value returned by the last `ListNotificationConfigsResponse`; indicates
	// that this is a continuation of a prior `ListNotificationConfigs` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *ListNotificationConfigsRequest) Reset() {
	*x = ListNotificationConfigsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNotificationConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNotificationConfigsRequest) ProtoMessage() {}

func (x *ListNotificationConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNotificationConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListNotificationConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{32}
}

func (x *ListNotificationConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListNotificationConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListNotificationConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response message for listing notification configs.
type ListNotificationConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Notification configs belonging to the requested parent.
	NotificationConfigs []*NotificationConfig `protobuf:"bytes,1,rep,name=notification_configs,json=notificationConfigs,proto3" json:"notification_configs,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListNotificationConfigsResponse) Reset() {
	*x = ListNotificationConfigsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNotificationConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNotificationConfigsResponse) ProtoMessage() {}

func (x *ListNotificationConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNotificationConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListNotificationConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{33}
}

func (x *ListNotificationConfigsResponse) GetNotificationConfigs() []*NotificationConfig {
	if x != nil {
		return x.NotificationConfigs
	}
	return nil
}

func (x *ListNotificationConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message to list resource value configs of a parent
type ListResourceValueConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns the collection of resource value configs.
	// Its format is
	// "organizations/[organization_id]"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of configs to return. The service may return fewer than
	// this value.
	// If unspecified, at most 10 configs will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListResourceValueConfigs` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListResourceValueConfigs` must match the call that provided the
	// page token.
	//
	// page_size can be specified, and the new page_size will be used.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListResourceValueConfigsRequest) Reset() {
	*x = ListResourceValueConfigsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListResourceValueConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListResourceValueConfigsRequest) ProtoMessage() {}

func (x *ListResourceValueConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListResourceValueConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListResourceValueConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{34}
}

func (x *ListResourceValueConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListResourceValueConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListResourceValueConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message to list resource value configs
type ListResourceValueConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource value configs from the specified parent.
	ResourceValueConfigs []*ResourceValueConfig `protobuf:"bytes,1,rep,name=resource_value_configs,json=resourceValueConfigs,proto3" json:"resource_value_configs,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is empty, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListResourceValueConfigsResponse) Reset() {
	*x = ListResourceValueConfigsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListResourceValueConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListResourceValueConfigsResponse) ProtoMessage() {}

func (x *ListResourceValueConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListResourceValueConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListResourceValueConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{35}
}

func (x *ListResourceValueConfigsResponse) GetResourceValueConfigs() []*ResourceValueConfig {
	if x != nil {
		return x.ResourceValueConfigs
	}
	return nil
}

func (x *ListResourceValueConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for listing sources.
type ListSourcesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the parent of sources to list. Its format should
	// be "organizations/[organization_id]", "folders/[folder_id]", or
	// "projects/[project_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The value returned by the last `ListSourcesResponse`; indicates
	// that this is a continuation of a prior `ListSources` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,7,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *ListSourcesRequest) Reset() {
	*x = ListSourcesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSourcesRequest) ProtoMessage() {}

func (x *ListSourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSourcesRequest.ProtoReflect.Descriptor instead.
func (*ListSourcesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{36}
}

func (x *ListSourcesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSourcesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSourcesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response message for listing sources.
type ListSourcesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sources belonging to the requested parent.
	Sources []*Source `protobuf:"bytes,1,rep,name=sources,proto3" json:"sources,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSourcesResponse) Reset() {
	*x = ListSourcesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSourcesResponse) ProtoMessage() {}

func (x *ListSourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSourcesResponse.ProtoReflect.Descriptor instead.
func (*ListSourcesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{37}
}

func (x *ListSourcesResponse) GetSources() []*Source {
	if x != nil {
		return x.Sources
	}
	return nil
}

func (x *ListSourcesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for listing the valued resources for a given simulation.
type ListValuedResourcesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of parent to list exposed resources.
	//
	// Valid formats:
	// "organizations/{organization}",
	// "organizations/{organization}/simulations/{simulation}"
	// "organizations/{organization}/simulations/{simulation}/attackExposureResults/{attack_exposure_result_v2}"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The filter expression that filters the valued resources in the response.
	// Supported fields:
	//
	//   - `resource_value` supports =
	//   - `resource_type` supports =
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The value returned by the last `ListValuedResourcesResponse`; indicates
	// that this is a continuation of a prior `ListValuedResources` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The fields by which to order the valued resources response.
	//
	// Supported fields:
	//
	//   - `exposed_score`
	//
	//   - `resource_value`
	//
	//   - `resource_type`
	//
	// Values should be a comma separated list of fields. For example:
	// `exposed_score,resource_value`.
	//
	// The default sorting order is descending. To specify ascending or descending
	// order for a field, append a " ASC" or a " DESC" suffix, respectively; for
	// example: `exposed_score DESC`.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListValuedResourcesRequest) Reset() {
	*x = ListValuedResourcesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListValuedResourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListValuedResourcesRequest) ProtoMessage() {}

func (x *ListValuedResourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListValuedResourcesRequest.ProtoReflect.Descriptor instead.
func (*ListValuedResourcesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{38}
}

func (x *ListValuedResourcesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListValuedResourcesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListValuedResourcesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListValuedResourcesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListValuedResourcesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for listing the valued resources for a given simulation.
type ListValuedResourcesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The valued resources that the attack path simulation identified.
	ValuedResources []*ValuedResource `protobuf:"bytes,1,rep,name=valued_resources,json=valuedResources,proto3" json:"valued_resources,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The estimated total number of results matching the query.
	TotalSize int32 `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *ListValuedResourcesResponse) Reset() {
	*x = ListValuedResourcesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListValuedResourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListValuedResourcesResponse) ProtoMessage() {}

func (x *ListValuedResourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListValuedResourcesResponse.ProtoReflect.Descriptor instead.
func (*ListValuedResourcesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{39}
}

func (x *ListValuedResourcesResponse) GetValuedResources() []*ValuedResource {
	if x != nil {
		return x.ValuedResources
	}
	return nil
}

func (x *ListValuedResourcesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListValuedResourcesResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// Request message for updating a finding's state.
type SetFindingStateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [relative resource
	// name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
	// of the finding. If no location is specified, finding is assumed to be in
	// global. The following list shows some examples:
	//
	// +
	// `organizations/{organization_id}/sources/{source_id}/findings/{finding_id}`
	// +
	// `organizations/{organization_id}/sources/{source_id}/locations/{location_id}/findings/{finding_id}`
	// + `folders/{folder_id}/sources/{source_id}/findings/{finding_id}`
	// +
	// `folders/{folder_id}/sources/{source_id}/locations/{location_id}/findings/{finding_id}`
	// + `projects/{project_id}/sources/{source_id}/findings/{finding_id}`
	// +
	// `projects/{project_id}/sources/{source_id}/locations/{location_id}/findings/{finding_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The desired State of the finding.
	State Finding_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.securitycenter.v2.Finding_State" json:"state,omitempty"`
}

func (x *SetFindingStateRequest) Reset() {
	*x = SetFindingStateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetFindingStateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetFindingStateRequest) ProtoMessage() {}

func (x *SetFindingStateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetFindingStateRequest.ProtoReflect.Descriptor instead.
func (*SetFindingStateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{40}
}

func (x *SetFindingStateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SetFindingStateRequest) GetState() Finding_State {
	if x != nil {
		return x.State
	}
	return Finding_STATE_UNSPECIFIED
}

// Request message for updating a finding's mute status.
type SetMuteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [relative resource
	// name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
	// of the finding. If no location is specified, finding is assumed to be in
	// global. The following list shows some examples:
	//
	// +
	// `organizations/{organization_id}/sources/{source_id}/findings/{finding_id}`
	// +
	// `organizations/{organization_id}/sources/{source_id}/locations/{location_id}/findings/{finding_id}`
	// + `folders/{folder_id}/sources/{source_id}/findings/{finding_id}`
	// +
	// `folders/{folder_id}/sources/{source_id}/locations/{location_id}/findings/{finding_id}`
	// + `projects/{project_id}/sources/{source_id}/findings/{finding_id}`
	// +
	// `projects/{project_id}/sources/{source_id}/locations/{location_id}/findings/{finding_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The desired state of the Mute.
	Mute Finding_Mute `protobuf:"varint,2,opt,name=mute,proto3,enum=google.cloud.securitycenter.v2.Finding_Mute" json:"mute,omitempty"`
}

func (x *SetMuteRequest) Reset() {
	*x = SetMuteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetMuteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetMuteRequest) ProtoMessage() {}

func (x *SetMuteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetMuteRequest.ProtoReflect.Descriptor instead.
func (*SetMuteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{41}
}

func (x *SetMuteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SetMuteRequest) GetMute() Finding_Mute {
	if x != nil {
		return x.Mute
	}
	return Finding_MUTE_UNSPECIFIED
}

// Request message for updating a BigQuery export.
type UpdateBigQueryExportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The BigQuery export being updated.
	BigQueryExport *BigQueryExport `protobuf:"bytes,1,opt,name=big_query_export,json=bigQueryExport,proto3" json:"big_query_export,omitempty"`
	// The list of fields to be updated.
	// If empty all mutable fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateBigQueryExportRequest) Reset() {
	*x = UpdateBigQueryExportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateBigQueryExportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBigQueryExportRequest) ProtoMessage() {}

func (x *UpdateBigQueryExportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBigQueryExportRequest.ProtoReflect.Descriptor instead.
func (*UpdateBigQueryExportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{42}
}

func (x *UpdateBigQueryExportRequest) GetBigQueryExport() *BigQueryExport {
	if x != nil {
		return x.BigQueryExport
	}
	return nil
}

func (x *UpdateBigQueryExportRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for updating a ExternalSystem resource.
type UpdateExternalSystemRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The external system resource to update.
	ExternalSystem *ExternalSystem `protobuf:"bytes,1,opt,name=external_system,json=externalSystem,proto3" json:"external_system,omitempty"`
	// The FieldMask to use when updating the external system resource.
	//
	// If empty all mutable fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateExternalSystemRequest) Reset() {
	*x = UpdateExternalSystemRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateExternalSystemRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateExternalSystemRequest) ProtoMessage() {}

func (x *UpdateExternalSystemRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateExternalSystemRequest.ProtoReflect.Descriptor instead.
func (*UpdateExternalSystemRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{43}
}

func (x *UpdateExternalSystemRequest) GetExternalSystem() *ExternalSystem {
	if x != nil {
		return x.ExternalSystem
	}
	return nil
}

func (x *UpdateExternalSystemRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for updating or creating a finding.
type UpdateFindingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The finding resource to update or create if it does not already
	// exist. parent, security_marks, and update_time will be ignored.
	//
	// In the case of creation, the finding id portion of the name must be
	// alphanumeric and less than or equal to 32 characters and greater than 0
	// characters in length.
	Finding *Finding `protobuf:"bytes,1,opt,name=finding,proto3" json:"finding,omitempty"`
	// The FieldMask to use when updating the finding resource. This field should
	// not be specified when creating a finding.
	//
	// When updating a finding, an empty mask is treated as updating all mutable
	// fields and replacing source_properties.  Individual source_properties can
	// be added/updated by using "source_properties.<property key>" in the field
	// mask.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateFindingRequest) Reset() {
	*x = UpdateFindingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateFindingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFindingRequest) ProtoMessage() {}

func (x *UpdateFindingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFindingRequest.ProtoReflect.Descriptor instead.
func (*UpdateFindingRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{44}
}

func (x *UpdateFindingRequest) GetFinding() *Finding {
	if x != nil {
		return x.Finding
	}
	return nil
}

func (x *UpdateFindingRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for updating a mute config.
type UpdateMuteConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The mute config being updated.
	MuteConfig *MuteConfig `protobuf:"bytes,1,opt,name=mute_config,json=muteConfig,proto3" json:"mute_config,omitempty"`
	// The list of fields to be updated.
	// If empty all mutable fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateMuteConfigRequest) Reset() {
	*x = UpdateMuteConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateMuteConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateMuteConfigRequest) ProtoMessage() {}

func (x *UpdateMuteConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateMuteConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateMuteConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{45}
}

func (x *UpdateMuteConfigRequest) GetMuteConfig() *MuteConfig {
	if x != nil {
		return x.MuteConfig
	}
	return nil
}

func (x *UpdateMuteConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for updating a notification config.
type UpdateNotificationConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The notification config to update.
	NotificationConfig *NotificationConfig `protobuf:"bytes,1,opt,name=notification_config,json=notificationConfig,proto3" json:"notification_config,omitempty"`
	// The FieldMask to use when updating the notification config.
	//
	// If empty all mutable fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateNotificationConfigRequest) Reset() {
	*x = UpdateNotificationConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateNotificationConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateNotificationConfigRequest) ProtoMessage() {}

func (x *UpdateNotificationConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateNotificationConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateNotificationConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{46}
}

func (x *UpdateNotificationConfigRequest) GetNotificationConfig() *NotificationConfig {
	if x != nil {
		return x.NotificationConfig
	}
	return nil
}

func (x *UpdateNotificationConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message to update resource value config
type UpdateResourceValueConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource value config being updated.
	ResourceValueConfig *ResourceValueConfig `protobuf:"bytes,1,opt,name=resource_value_config,json=resourceValueConfig,proto3" json:"resource_value_config,omitempty"`
	// The list of fields to be updated.
	// If empty all mutable fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateResourceValueConfigRequest) Reset() {
	*x = UpdateResourceValueConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateResourceValueConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateResourceValueConfigRequest) ProtoMessage() {}

func (x *UpdateResourceValueConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateResourceValueConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateResourceValueConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{47}
}

func (x *UpdateResourceValueConfigRequest) GetResourceValueConfig() *ResourceValueConfig {
	if x != nil {
		return x.ResourceValueConfig
	}
	return nil
}

func (x *UpdateResourceValueConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for updating a SecurityMarks resource.
type UpdateSecurityMarksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The security marks resource to update.
	SecurityMarks *SecurityMarks `protobuf:"bytes,1,opt,name=security_marks,json=securityMarks,proto3" json:"security_marks,omitempty"`
	// The FieldMask to use when updating the security marks resource.
	//
	// The field mask must not contain duplicate fields.
	// If empty or set to "marks", all marks will be replaced.  Individual
	// marks can be updated using "marks.<mark_key>".
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSecurityMarksRequest) Reset() {
	*x = UpdateSecurityMarksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSecurityMarksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSecurityMarksRequest) ProtoMessage() {}

func (x *UpdateSecurityMarksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSecurityMarksRequest.ProtoReflect.Descriptor instead.
func (*UpdateSecurityMarksRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{48}
}

func (x *UpdateSecurityMarksRequest) GetSecurityMarks() *SecurityMarks {
	if x != nil {
		return x.SecurityMarks
	}
	return nil
}

func (x *UpdateSecurityMarksRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for updating a source.
type UpdateSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The source resource to update.
	Source *Source `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// The FieldMask to use when updating the source resource.
	//
	// If empty all mutable fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSourceRequest) Reset() {
	*x = UpdateSourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSourceRequest) ProtoMessage() {}

func (x *UpdateSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSourceRequest.ProtoReflect.Descriptor instead.
func (*UpdateSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{49}
}

func (x *UpdateSourceRequest) GetSource() *Source {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *UpdateSourceRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Result containing the Finding.
type ListFindingsResponse_ListFindingsResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Finding matching the search request.
	Finding *Finding `protobuf:"bytes,1,opt,name=finding,proto3" json:"finding,omitempty"`
	// Output only. Resource that is associated with this finding.
	Resource *ListFindingsResponse_ListFindingsResult_Resource `protobuf:"bytes,3,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *ListFindingsResponse_ListFindingsResult) Reset() {
	*x = ListFindingsResponse_ListFindingsResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFindingsResponse_ListFindingsResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFindingsResponse_ListFindingsResult) ProtoMessage() {}

func (x *ListFindingsResponse_ListFindingsResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFindingsResponse_ListFindingsResult.ProtoReflect.Descriptor instead.
func (*ListFindingsResponse_ListFindingsResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{29, 0}
}

func (x *ListFindingsResponse_ListFindingsResult) GetFinding() *Finding {
	if x != nil {
		return x.Finding
	}
	return nil
}

func (x *ListFindingsResponse_ListFindingsResult) GetResource() *ListFindingsResponse_ListFindingsResult_Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

// Information related to the Google Cloud resource that is
// associated with this finding.
type ListFindingsResponse_ListFindingsResult_Resource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full resource name of the resource. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The human readable name of the resource.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The full resource type of the resource.
	Type string `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) Reset() {
	*x = ListFindingsResponse_ListFindingsResult_Resource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFindingsResponse_ListFindingsResult_Resource) ProtoMessage() {}

func (x *ListFindingsResponse_ListFindingsResult_Resource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFindingsResponse_ListFindingsResult_Resource.ProtoReflect.Descriptor instead.
func (*ListFindingsResponse_ListFindingsResult_Resource) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP(), []int{29, 0, 0}
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

var File_google_cloud_securitycenter_v2_securitycenter_service_proto protoreflect.FileDescriptor

var file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32,
	0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x6f, 0x75,
	0x74, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x61, 0x74, 0x74, 0x61, 0x63,
	0x6b, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f,
	0x76, 0x32, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f,
	0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2f, 0x76, 0x32, 0x2f, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76,
	0x32, 0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x61, 0x6d, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xde, 0x01, 0x0a, 0x26, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x51, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x12, 0x31, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x61, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0x94, 0x01, 0x0a, 0x27, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x69, 0x0a, 0x16, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x14, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x22, 0x54, 0x0a,
	0x17, 0x42, 0x75, 0x6c, 0x6b, 0x4d, 0x75, 0x74, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x09, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x03,
	0x0a, 0x01, 0x2a, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x22, 0x1a, 0x0a, 0x18, 0x42, 0x75, 0x6c, 0x6b, 0x4d, 0x75, 0x74, 0x65, 0x46,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0xfe, 0x01, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x12, 0x2c, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5d, 0x0a,
	0x10, 0x62, 0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x62, 0x69,
	0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x32, 0x0a, 0x13,
	0x62, 0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10,
	0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x64,
	0x22, 0xc8, 0x01, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x26, 0x0a, 0x24, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x22, 0x0a, 0x0a, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x49, 0x64, 0x12, 0x46, 0x0a, 0x07, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x07, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x22, 0xe0, 0x01, 0x0a, 0x17,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12,
	0x28, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d,
	0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x50, 0x0a, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x29, 0x0a, 0x0e, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0c, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x22, 0xff,
	0x01, 0x0a, 0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x12, 0x30, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x12, 0x68, 0x0a, 0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x6e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0xe3, 0x01, 0x0a, 0x20, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x12, 0x31, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x6c, 0x0a, 0x15, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x13, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xac, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x43, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x32, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x67, 0x0a, 0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42,
	0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x5f,
	0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a,
	0x28, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d,
	0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x6f, 0x0a, 0x1f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x71, 0x0a, 0x20, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x64, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x5c, 0x0a, 0x14, 0x47, 0x65, 0x74,
	0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6c, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x4e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x6f, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6e, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x54, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a,
	0x24, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd0, 0x01, 0x0a, 0x14,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x62, 0x79, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x42, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xb5,
	0x01, 0x0a, 0x15, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x55, 0x0a, 0x10, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x62, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x32, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52,
	0x0e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x74, 0x6f, 0x74,
	0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xd7, 0x01, 0x0a, 0x0b, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x5b, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x55, 0x0a, 0x0f, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2c,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0xb6, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x50,
	0x61, 0x74, 0x68, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2a, 0x12, 0x28, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x41, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x50, 0x61, 0x74, 0x68, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x90, 0x01, 0x0a, 0x17, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x50, 0x61, 0x74, 0x68, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a, 0x0c, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x5f,
	0x70, 0x61, 0x74, 0x68, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x74, 0x74,
	0x61, 0x63, 0x6b, 0x50, 0x61, 0x74, 0x68, 0x52, 0x0b, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x50,
	0x61, 0x74, 0x68, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5c, 0x0a, 0x14,
	0x47, 0x65, 0x74, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x64, 0x0a, 0x18, 0x47, 0x65,
	0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xa6, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x12, 0x2c, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa1, 0x01, 0x0a, 0x1b, 0x4c, 0x69,
	0x73, 0x74, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5a, 0x0a, 0x11, 0x62, 0x69, 0x67,
	0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x52, 0x0f, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x85, 0x02,
	0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x39,
	0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xfe, 0x03, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x7b,
	0x0a, 0x15, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x5f,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x13, 0x6c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69,
	0x7a, 0x65, 0x1a, 0xa1, 0x02, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x41, 0x0a, 0x07, 0x66, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x52, 0x07, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x71, 0x0a, 0x08,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x1a,
	0x55, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x9e, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x4d,
	0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x90, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74,
	0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a, 0x0c, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x75, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xae, 0x01, 0x0a, 0x1e, 0x4c,
	0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x32, 0x12, 0x30, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xb0, 0x01, 0x0a, 0x1f,
	0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x65, 0x0a, 0x14, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb0,
	0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x51, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x12, 0x31, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xb5, 0x01, 0x0a, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x69, 0x0a, 0x16, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x14, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x96, 0x01, 0x0a, 0x12, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x22, 0x7f, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x40, 0x0a, 0x07, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x07, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xde, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x12, 0x2c, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x64,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x42, 0x79, 0x22, 0xbf, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x59, 0x0a, 0x10, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x5f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x74, 0x6f, 0x74,
	0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xa5, 0x01, 0x0a, 0x16, 0x53, 0x65, 0x74, 0x46, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x9a,
	0x01, 0x0a, 0x0e, 0x53, 0x65, 0x74, 0x4d, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x04, 0x6d, 0x75, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x4d, 0x75, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6d, 0x75, 0x74, 0x65, 0x22, 0xb9, 0x01, 0x0a, 0x1b,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5d, 0x0a, 0x10, 0x62,
	0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x62, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xb8, 0x01, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5c, 0x0a, 0x0f, 0x65, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x32, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0x9b, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x07, 0x66,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x66, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x22, 0xa8, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x75, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x0b,
	0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x32, 0x2e, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xc8, 0x01, 0x0a, 0x1f,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x68, 0x0a, 0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xcd, 0x01, 0x0a, 0x20, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6c, 0x0a, 0x15, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xb4, 0x01, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x59, 0x0a, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0d, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73,
	0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x97, 0x01,
	0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x32, 0xc5, 0x7b, 0x0a, 0x0e, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x12, 0x8e, 0x02, 0x0a, 0x1f, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x46,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x5a, 0xda, 0x41, 0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x3a, 0x01, 0x2a, 0x22, 0x3d, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x3a,
	0x62, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x12, 0x9a, 0x04, 0x0a, 0x10,
	0x42, 0x75, 0x6c, 0x6b, 0x4d, 0x75, 0x74, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x32, 0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x4d, 0x75, 0x74, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xad, 0x03, 0xca, 0x41, 0x50, 0x0a, 0x37,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x42,
	0x75, 0x6c, 0x6b, 0x4d, 0x75, 0x74, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xca, 0x02, 0x3a, 0x01,
	0x2a, 0x5a, 0x3f, 0x3a, 0x01, 0x2a, 0x22, 0x3a, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x62, 0x75, 0x6c, 0x6b, 0x4d, 0x75,
	0x74, 0x65, 0x5a, 0x2d, 0x3a, 0x01, 0x2a, 0x22, 0x28, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x62, 0x75, 0x6c, 0x6b, 0x4d, 0x75, 0x74,
	0x65, 0x5a, 0x39, 0x3a, 0x01, 0x2a, 0x22, 0x34, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x73, 0x3a, 0x62, 0x75, 0x6c, 0x6b, 0x4d, 0x75, 0x74, 0x65, 0x5a, 0x2e, 0x3a, 0x01,
	0x2a, 0x22, 0x29, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x73, 0x3a, 0x62, 0x75, 0x6c, 0x6b, 0x4d, 0x75, 0x74, 0x65, 0x5a, 0x3a, 0x3a, 0x01,
	0x2a, 0x22, 0x35, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x3a,
	0x62, 0x75, 0x6c, 0x6b, 0x4d, 0x75, 0x74, 0x65, 0x22, 0x2e, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x3a,
	0x62, 0x75, 0x6c, 0x6b, 0x4d, 0x75, 0x74, 0x65, 0x12, 0x98, 0x03, 0x0a, 0x14, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e,
	0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x22, 0x92,
	0x02, 0xda, 0x41, 0x2b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x62, 0x69, 0x67, 0x5f, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x2c, 0x62, 0x69, 0x67, 0x5f,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0xdd, 0x01, 0x3a, 0x10, 0x62, 0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5a, 0x46, 0x3a, 0x10, 0x62, 0x69, 0x67, 0x5f,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x22, 0x32, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73,
	0x5a, 0x47, 0x3a, 0x10, 0x62, 0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x22, 0x33, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x22, 0x38, 0x2f, 0x76, 0x32, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x73, 0x12, 0x96, 0x02, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x22, 0xa5, 0x01, 0xda, 0x41, 0x19, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2c, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x82, 0x01, 0x3a, 0x07, 0x66, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x5a, 0x3a, 0x3a, 0x07, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x22, 0x2f,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x22,
	0x3b, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x99, 0x05, 0x0a,
	0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x75, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x9f, 0x04, 0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x6d,
	0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0xe2, 0x02, 0x3a, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x5a, 0x3d, 0x3a, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0x2e, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x5a, 0x3e, 0x3a, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22,
	0x2f, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x5a, 0x37, 0x3a, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22,
	0x28, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x75,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x5a, 0x31, 0x3a, 0x0b, 0x6d, 0x75, 0x74,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x22, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x5a, 0x32, 0x3a, 0x0b,
	0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x23, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x22, 0x34, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x8b, 0x01, 0x12, 0x2b, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x21, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x2a, 0x7d, 0x12, 0x30, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x26, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x2a, 0x7d, 0x12, 0x2a, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x2a, 0x7d, 0x12, 0xb2, 0x03, 0x0a, 0x18, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xa0, 0x02, 0xda, 0x41, 0x24,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xf2, 0x01, 0x3a, 0x13, 0x6e, 0x6f, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x5a, 0x4d, 0x3a, 0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x36, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x5a,
	0x4e, 0x3a, 0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x37, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x22,
	0x3c, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0xb1, 0x01,
	0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x44, 0xda, 0x41, 0x0d,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x2e, 0x3a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x24, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x12, 0xa3, 0x02, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22,
	0xb5, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xa7, 0x01,
	0x5a, 0x34, 0x2a, 0x32, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x35, 0x2a, 0x33, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x69, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2a, 0x38, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xbe, 0x04, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0xd8, 0x03,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x94, 0x02, 0x5a, 0x36,
	0x2a, 0x34, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x24, 0x2a, 0x22, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x30, 0x2a, 0x2e,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x25,
	0x2a, 0x23, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x31, 0x2a, 0x2f, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x2a, 0x28, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f,
	0x2a, 0x7d, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0xaf, 0x01, 0x12, 0x37, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x3d, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x2f, 0x2a, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x34, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d,
	0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a,
	0x12, 0x36, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2e, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x12, 0xb7, 0x02, 0x0a, 0x18, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4e, 0x6f, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0xc1,
	0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xb3, 0x01, 0x5a,
	0x38, 0x2a, 0x36, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x39, 0x2a, 0x37, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x2f, 0x2a, 0x7d, 0x2a, 0x3c, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xb7, 0x01, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x40, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x2a, 0x31, 0x2f, 0x76, 0x32, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb5, 0x02, 0x0a,
	0x11, 0x47, 0x65, 0x74, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x69,
	0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x22, 0xb5, 0x01, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xa7, 0x01, 0x5a, 0x34, 0x12,
	0x32, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x5a, 0x35, 0x12, 0x33, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x38, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xaa, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x53, 0x69, 0x6d, 0x75,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x69, 0x6d, 0x75, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x69,
	0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x37, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x12, 0x28, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xc8, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x22, 0x49, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c,
	0x12, 0x3a, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x6d, 0x75,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x64,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x96, 0x01, 0x0a,
	0x0c, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x4b, 0xda, 0x41, 0x08, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x3a, 0x01, 0x2a, 0x22, 0x35,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0xcc, 0x04, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x4d, 0x75, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x75, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4d,
	0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xd8, 0x03, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x94, 0x02, 0x5a, 0x36, 0x12, 0x34, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f,
	0x2a, 0x7d, 0x5a, 0x24, 0x12, 0x22, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x25, 0x12, 0x23, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a,
	0x7d, 0x5a, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x28, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x8a, 0xd3,
	0xe4, 0x93, 0x02, 0xaf, 0x01, 0x12, 0x37, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x2a, 0x7d,
	0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x12, 0x3c,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x34, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x2a, 0x7d, 0x2f, 0x6d,
	0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x12, 0x36, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2e, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x3d, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x2f, 0x2a, 0x12, 0xcd, 0x02, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x4e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e,
	0x47, 0x65, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0xc1, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xb3,
	0x01, 0x5a, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x39, 0x12, 0x37, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x3c, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xce, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32,
	0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x22, 0x40, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x9a, 0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x33, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x26, 0x12, 0x24, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0x8c, 0x04, 0x0a, 0x0d, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x8d, 0x03, 0xda, 0x41, 0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x5f, 0x62, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xf4, 0x02, 0x3a, 0x01, 0x2a,
	0x5a, 0x46, 0x3a, 0x01, 0x2a, 0x22, 0x41, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x3a, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5a, 0x34, 0x3a, 0x01, 0x2a, 0x22, 0x2f, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5a, 0x40,
	0x3a, 0x01, 0x2a, 0x22, 0x3b, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x5a, 0x35, 0x3a, 0x01, 0x2a, 0x22, 0x30, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x3a, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5a, 0x41, 0x3a, 0x01, 0x2a, 0x22, 0x3c, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x3a, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x35, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x12, 0xeb, 0x02, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x6b,
	0x50, 0x61, 0x74, 0x68, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63,
	0x6b, 0x50, 0x61, 0x74, 0x68, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x50, 0x61, 0x74, 0x68, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xe6, 0x01, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xd6, 0x01, 0x5a, 0x4a, 0x12, 0x48, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b,
	0x50, 0x61, 0x74, 0x68, 0x73, 0x5a, 0x50, 0x12, 0x4e, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x45, 0x78, 0x70, 0x6f, 0x73, 0x75, 0x72,
	0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x74, 0x74, 0x61,
	0x63, 0x6b, 0x50, 0x61, 0x74, 0x68, 0x73, 0x12, 0x36, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x50, 0x61, 0x74, 0x68, 0x73, 0x12,
	0xc8, 0x02, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0xb7, 0x01, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0xa7, 0x01, 0x5a, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x5a, 0x35, 0x12, 0x33, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73,
	0x12, 0x38, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x69, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0xca, 0x03, 0x0a, 0x0c, 0x4c,
	0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xce, 0x02, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xbe, 0x02, 0x5a, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x5a, 0x2b, 0x12, 0x29, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x73, 0x5a, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x5a, 0x2c,
	0x12, 0x2a, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x5a, 0x38, 0x12, 0x36,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x2f, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0xdf, 0x04, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74,
	0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xda, 0x03, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x94, 0x02, 0x5a,
	0x36, 0x12, 0x34, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x5a, 0x24, 0x12, 0x22, 0x2f, 0x76, 0x32, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x5a, 0x30, 0x12,
	0x2e, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x5a,
	0x25, 0x12, 0x23, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x5a, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x75,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x28, 0x2f, 0x76, 0x32, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0xaf, 0x01, 0x12, 0x37, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x2d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x12, 0x3c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x32, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x3d, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x12, 0x36, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2c, 0x66, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x2a, 0x7d, 0x2f, 0x6d, 0x75,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0xe0, 0x02, 0x0a, 0x17, 0x4c, 0x69,
	0x73, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xc3, 0x01, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xb3, 0x01, 0x5a, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x5a, 0x39, 0x12, 0x37, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x3c,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0xe1, 0x01, 0x0a,
	0x18, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x12, 0xf2, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x7a, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6b, 0x5a, 0x20, 0x12, 0x1e, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x5a, 0x21, 0x12, 0x1f,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0x24, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0xb3, 0x02, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xa2, 0x01, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x92, 0x01, 0x5a, 0x54, 0x12, 0x52, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x45, 0x78, 0x70,
	0x6f, 0x73, 0x75, 0x72, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0x3a, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x6d,
	0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x8f, 0x04, 0x0a, 0x0f,
	0x53, 0x65, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32,
	0x2e, 0x53, 0x65, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x22, 0x9a, 0x03, 0xda, 0x41, 0x0a, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x86, 0x03, 0x3a, 0x01, 0x2a, 0x5a, 0x49, 0x3a, 0x01, 0x2a, 0x22,
	0x44, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x5a, 0x37, 0x3a, 0x01, 0x2a, 0x22, 0x32, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x5a, 0x43,
	0x3a, 0x01, 0x2a, 0x22, 0x3e, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x5a, 0x38, 0x3a, 0x01, 0x2a, 0x22, 0x33, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x5a, 0x44, 0x3a,
	0x01, 0x2a, 0x22, 0x3f, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x22, 0x38, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x9d, 0x01,
	0x0a, 0x0c, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x52, 0xda, 0x41, 0x0f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3a, 0x3a, 0x01, 0x2a, 0x22, 0x35, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x73, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0xf8, 0x03,
	0x0a, 0x07, 0x53, 0x65, 0x74, 0x4d, 0x75, 0x74, 0x65, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x74, 0x4d, 0x75,
	0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x22, 0x93, 0x03, 0xda, 0x41, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x6d, 0x75, 0x74,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x80, 0x03, 0x3a, 0x01, 0x2a, 0x5a, 0x48, 0x3a, 0x01, 0x2a,
	0x22, 0x43, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65,
	0x74, 0x4d, 0x75, 0x74, 0x65, 0x5a, 0x36, 0x3a, 0x01, 0x2a, 0x22, 0x31, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x4d, 0x75, 0x74, 0x65, 0x5a, 0x42, 0x3a,
	0x01, 0x2a, 0x22, 0x3d, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x4d, 0x75, 0x74,
	0x65, 0x5a, 0x37, 0x3a, 0x01, 0x2a, 0x22, 0x32, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x4d, 0x75, 0x74, 0x65, 0x5a, 0x43, 0x3a, 0x01, 0x2a, 0x22,
	0x3e, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x4d, 0x75, 0x74, 0x65, 0x22,
	0x37, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x73, 0x65, 0x74, 0x4d, 0x75, 0x74, 0x65, 0x12, 0xc8, 0x01, 0x0a, 0x12, 0x54, 0x65, 0x73,
	0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61,
	0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5d, 0xda, 0x41, 0x14, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2c, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x40, 0x3a, 0x01, 0x2a, 0x22, 0x3b, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x74, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0xbc, 0x03, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x69,
	0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x22, 0xb6, 0x02, 0xda, 0x41, 0x1c, 0x62,
	0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x90, 0x02, 0x3a, 0x10, 0x62, 0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x5a, 0x57, 0x3a, 0x10, 0x62, 0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x32, 0x43, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x62,
	0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x69, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x58, 0x3a,
	0x10, 0x62, 0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x32, 0x44, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x62, 0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x32, 0x49, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x62, 0x69,
	0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0x9b, 0x06, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x12, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x22, 0x95, 0x05, 0xda, 0x41, 0x1b, 0x65, 0x78,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xf0, 0x04,
	0x3a, 0x0f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x5a, 0x70, 0x3a, 0x0f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x32, 0x5d, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x65, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a,
	0x2f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73,
	0x2f, 0x2a, 0x7d, 0x5a, 0x5e, 0x3a, 0x0f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x32, 0x4b, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x65, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a,
	0x2f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73,
	0x2f, 0x2a, 0x7d, 0x5a, 0x6a, 0x3a, 0x0f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x32, 0x57, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x65, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x5a,
	0x5f, 0x3a, 0x0f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x32, 0x4c, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x2f, 0x2a, 0x7d,
	0x5a, 0x6b, 0x3a, 0x0f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x32, 0x58, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x32, 0x51, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xb2, 0x04, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x22, 0xc1, 0x03, 0xda, 0x41, 0x13, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xa4,
	0x03, 0x3a, 0x07, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5a, 0x4e, 0x3a, 0x07, 0x66, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x32, 0x43, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x66, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x3c, 0x3a, 0x07, 0x66, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x32, 0x31, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x66, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x48, 0x3a, 0x07, 0x66, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x32, 0x3d, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f,
	0x2a, 0x7d, 0x5a, 0x3d, 0x3a, 0x07, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x32, 0x32, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a,
	0x7d, 0x5a, 0x49, 0x3a, 0x07, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x32, 0x3e, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x32, 0x37, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x9f, 0x06, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22,
	0xa5, 0x05, 0xda, 0x41, 0x17, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0xaa, 0x03, 0x3a, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x5a, 0x4f, 0x3a, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32,
	0x40, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a,
	0x7d, 0x5a, 0x3d, 0x3a, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x32, 0x2e, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d,
	0x5a, 0x49, 0x3a, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32,
	0x3a, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x3e, 0x3a, 0x0b, 0x6d,
	0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0x2f, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x4a, 0x3a, 0x0b, 0x6d,
	0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0x3b, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x32, 0x34, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6d, 0x75,
	0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d,
	0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x8a, 0xd3, 0xe4,
	0x93, 0x02, 0xd3, 0x01, 0x12, 0x43, 0x0a, 0x10, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x12, 0x48, 0x0a, 0x10, 0x6d, 0x75, 0x74,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x34, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x3d, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x2f, 0x2a, 0x12, 0x42, 0x0a, 0x10, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2e, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x12, 0xe9, 0x03, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xd7, 0x02, 0xda, 0x41, 0x1f, 0x6e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0xae, 0x02, 0x3a, 0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5a, 0x61, 0x3a, 0x13, 0x6e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x32, 0x4a, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x62, 0x3a,
	0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x32, 0x4b, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a,
	0x7d, 0x32, 0x50, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0x9f, 0x02, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x8a, 0x01, 0xda, 0x41, 0x21, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x60, 0x3a, 0x15, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0x47, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe4, 0x07, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x12, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x72,
	0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x22, 0xe1, 0x06, 0xda, 0x41, 0x1a, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x2c, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xbd, 0x06, 0x3a,
	0x0e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x5a,
	0x52, 0x3a, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b,
	0x73, 0x32, 0x40, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x72,
	0x6b, 0x73, 0x7d, 0x5a, 0x6a, 0x3a, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f,
	0x6d, 0x61, 0x72, 0x6b, 0x73, 0x32, 0x58, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x7d, 0x5a,
	0x58, 0x3a, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b,
	0x73, 0x32, 0x46, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x7d, 0x5a, 0x4c, 0x3a, 0x0e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x32, 0x3a, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x7d, 0x5a, 0x64, 0x3a, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x32, 0x52, 0x2f, 0x76, 0x32, 0x2f, 0x7b,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x7d, 0x5a, 0x59, 0x3a,
	0x0e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x32,
	0x47, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d,
	0x61, 0x72, 0x6b, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x7d, 0x5a, 0x4d, 0x3a, 0x0e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x32, 0x3b, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x7d, 0x5a, 0x65, 0x3a, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x32, 0x53, 0x2f, 0x76, 0x32, 0x2f, 0x7b,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x7d, 0x32, 0x4c,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61,
	0x72, 0x6b, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x7d, 0x12, 0xbd, 0x01, 0x0a,
	0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x50, 0xda, 0x41, 0x12, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x3a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x32,
	0x2b, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x51, 0xca, 0x41,
	0x1d, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42,
	0xb6, 0x03, 0xea, 0x41, 0x67, 0x0a, 0x32, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0xea, 0x41, 0x55, 0x0a,
	0x2c, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x42, 0x1a, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32,
	0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x62, 0x3b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x62, 0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x56, 0x32, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x5c, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x5c, 0x56, 0x32, 0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescOnce sync.Once
	file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescData = file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDesc
)

func file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescGZIP() []byte {
	file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescData)
	})
	return file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDescData
}

var file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes = make([]protoimpl.MessageInfo, 53)
var file_google_cloud_securitycenter_v2_securitycenter_service_proto_goTypes = []interface{}{
	(*BatchCreateResourceValueConfigsRequest)(nil),           // 0: google.cloud.securitycenter.v2.BatchCreateResourceValueConfigsRequest
	(*BatchCreateResourceValueConfigsResponse)(nil),          // 1: google.cloud.securitycenter.v2.BatchCreateResourceValueConfigsResponse
	(*BulkMuteFindingsRequest)(nil),                          // 2: google.cloud.securitycenter.v2.BulkMuteFindingsRequest
	(*BulkMuteFindingsResponse)(nil),                         // 3: google.cloud.securitycenter.v2.BulkMuteFindingsResponse
	(*CreateBigQueryExportRequest)(nil),                      // 4: google.cloud.securitycenter.v2.CreateBigQueryExportRequest
	(*CreateFindingRequest)(nil),                             // 5: google.cloud.securitycenter.v2.CreateFindingRequest
	(*CreateMuteConfigRequest)(nil),                          // 6: google.cloud.securitycenter.v2.CreateMuteConfigRequest
	(*CreateNotificationConfigRequest)(nil),                  // 7: google.cloud.securitycenter.v2.CreateNotificationConfigRequest
	(*CreateResourceValueConfigRequest)(nil),                 // 8: google.cloud.securitycenter.v2.CreateResourceValueConfigRequest
	(*CreateSourceRequest)(nil),                              // 9: google.cloud.securitycenter.v2.CreateSourceRequest
	(*DeleteBigQueryExportRequest)(nil),                      // 10: google.cloud.securitycenter.v2.DeleteBigQueryExportRequest
	(*DeleteMuteConfigRequest)(nil),                          // 11: google.cloud.securitycenter.v2.DeleteMuteConfigRequest
	(*DeleteNotificationConfigRequest)(nil),                  // 12: google.cloud.securitycenter.v2.DeleteNotificationConfigRequest
	(*DeleteResourceValueConfigRequest)(nil),                 // 13: google.cloud.securitycenter.v2.DeleteResourceValueConfigRequest
	(*GetBigQueryExportRequest)(nil),                         // 14: google.cloud.securitycenter.v2.GetBigQueryExportRequest
	(*GetMuteConfigRequest)(nil),                             // 15: google.cloud.securitycenter.v2.GetMuteConfigRequest
	(*GetNotificationConfigRequest)(nil),                     // 16: google.cloud.securitycenter.v2.GetNotificationConfigRequest
	(*GetResourceValueConfigRequest)(nil),                    // 17: google.cloud.securitycenter.v2.GetResourceValueConfigRequest
	(*GetSourceRequest)(nil),                                 // 18: google.cloud.securitycenter.v2.GetSourceRequest
	(*GroupFindingsRequest)(nil),                             // 19: google.cloud.securitycenter.v2.GroupFindingsRequest
	(*GroupFindingsResponse)(nil),                            // 20: google.cloud.securitycenter.v2.GroupFindingsResponse
	(*GroupResult)(nil),                                      // 21: google.cloud.securitycenter.v2.GroupResult
	(*ListAttackPathsRequest)(nil),                           // 22: google.cloud.securitycenter.v2.ListAttackPathsRequest
	(*ListAttackPathsResponse)(nil),                          // 23: google.cloud.securitycenter.v2.ListAttackPathsResponse
	(*GetSimulationRequest)(nil),                             // 24: google.cloud.securitycenter.v2.GetSimulationRequest
	(*GetValuedResourceRequest)(nil),                         // 25: google.cloud.securitycenter.v2.GetValuedResourceRequest
	(*ListBigQueryExportsRequest)(nil),                       // 26: google.cloud.securitycenter.v2.ListBigQueryExportsRequest
	(*ListBigQueryExportsResponse)(nil),                      // 27: google.cloud.securitycenter.v2.ListBigQueryExportsResponse
	(*ListFindingsRequest)(nil),                              // 28: google.cloud.securitycenter.v2.ListFindingsRequest
	(*ListFindingsResponse)(nil),                             // 29: google.cloud.securitycenter.v2.ListFindingsResponse
	(*ListMuteConfigsRequest)(nil),                           // 30: google.cloud.securitycenter.v2.ListMuteConfigsRequest
	(*ListMuteConfigsResponse)(nil),                          // 31: google.cloud.securitycenter.v2.ListMuteConfigsResponse
	(*ListNotificationConfigsRequest)(nil),                   // 32: google.cloud.securitycenter.v2.ListNotificationConfigsRequest
	(*ListNotificationConfigsResponse)(nil),                  // 33: google.cloud.securitycenter.v2.ListNotificationConfigsResponse
	(*ListResourceValueConfigsRequest)(nil),                  // 34: google.cloud.securitycenter.v2.ListResourceValueConfigsRequest
	(*ListResourceValueConfigsResponse)(nil),                 // 35: google.cloud.securitycenter.v2.ListResourceValueConfigsResponse
	(*ListSourcesRequest)(nil),                               // 36: google.cloud.securitycenter.v2.ListSourcesRequest
	(*ListSourcesResponse)(nil),                              // 37: google.cloud.securitycenter.v2.ListSourcesResponse
	(*ListValuedResourcesRequest)(nil),                       // 38: google.cloud.securitycenter.v2.ListValuedResourcesRequest
	(*ListValuedResourcesResponse)(nil),                      // 39: google.cloud.securitycenter.v2.ListValuedResourcesResponse
	(*SetFindingStateRequest)(nil),                           // 40: google.cloud.securitycenter.v2.SetFindingStateRequest
	(*SetMuteRequest)(nil),                                   // 41: google.cloud.securitycenter.v2.SetMuteRequest
	(*UpdateBigQueryExportRequest)(nil),                      // 42: google.cloud.securitycenter.v2.UpdateBigQueryExportRequest
	(*UpdateExternalSystemRequest)(nil),                      // 43: google.cloud.securitycenter.v2.UpdateExternalSystemRequest
	(*UpdateFindingRequest)(nil),                             // 44: google.cloud.securitycenter.v2.UpdateFindingRequest
	(*UpdateMuteConfigRequest)(nil),                          // 45: google.cloud.securitycenter.v2.UpdateMuteConfigRequest
	(*UpdateNotificationConfigRequest)(nil),                  // 46: google.cloud.securitycenter.v2.UpdateNotificationConfigRequest
	(*UpdateResourceValueConfigRequest)(nil),                 // 47: google.cloud.securitycenter.v2.UpdateResourceValueConfigRequest
	(*UpdateSecurityMarksRequest)(nil),                       // 48: google.cloud.securitycenter.v2.UpdateSecurityMarksRequest
	(*UpdateSourceRequest)(nil),                              // 49: google.cloud.securitycenter.v2.UpdateSourceRequest
	nil,                                                      // 50: google.cloud.securitycenter.v2.GroupResult.PropertiesEntry
	(*ListFindingsResponse_ListFindingsResult)(nil),          // 51: google.cloud.securitycenter.v2.ListFindingsResponse.ListFindingsResult
	(*ListFindingsResponse_ListFindingsResult_Resource)(nil), // 52: google.cloud.securitycenter.v2.ListFindingsResponse.ListFindingsResult.Resource
	(*ResourceValueConfig)(nil),                              // 53: google.cloud.securitycenter.v2.ResourceValueConfig
	(*BigQueryExport)(nil),                                   // 54: google.cloud.securitycenter.v2.BigQueryExport
	(*Finding)(nil),                                          // 55: google.cloud.securitycenter.v2.Finding
	(*MuteConfig)(nil),                                       // 56: google.cloud.securitycenter.v2.MuteConfig
	(*NotificationConfig)(nil),                               // 57: google.cloud.securitycenter.v2.NotificationConfig
	(*Source)(nil),                                           // 58: google.cloud.securitycenter.v2.Source
	(*AttackPath)(nil),                                       // 59: google.cloud.securitycenter.v2.AttackPath
	(*fieldmaskpb.FieldMask)(nil),                            // 60: google.protobuf.FieldMask
	(*ValuedResource)(nil),                                   // 61: google.cloud.securitycenter.v2.ValuedResource
	(Finding_State)(0),                                       // 62: google.cloud.securitycenter.v2.Finding.State
	(Finding_Mute)(0),                                        // 63: google.cloud.securitycenter.v2.Finding.Mute
	(*ExternalSystem)(nil),                                   // 64: google.cloud.securitycenter.v2.ExternalSystem
	(*SecurityMarks)(nil),                                    // 65: google.cloud.securitycenter.v2.SecurityMarks
	(*structpb.Value)(nil),                                   // 66: google.protobuf.Value
	(*iampb.GetIamPolicyRequest)(nil),                        // 67: google.iam.v1.GetIamPolicyRequest
	(*iampb.SetIamPolicyRequest)(nil),                        // 68: google.iam.v1.SetIamPolicyRequest
	(*iampb.TestIamPermissionsRequest)(nil),                  // 69: google.iam.v1.TestIamPermissionsRequest
	(*longrunningpb.Operation)(nil),                          // 70: google.longrunning.Operation
	(*emptypb.Empty)(nil),                                    // 71: google.protobuf.Empty
	(*Simulation)(nil),                                       // 72: google.cloud.securitycenter.v2.Simulation
	(*iampb.Policy)(nil),                                     // 73: google.iam.v1.Policy
	(*iampb.TestIamPermissionsResponse)(nil),                 // 74: google.iam.v1.TestIamPermissionsResponse
}
var file_google_cloud_securitycenter_v2_securitycenter_service_proto_depIdxs = []int32{
	8,  // 0: google.cloud.securitycenter.v2.BatchCreateResourceValueConfigsRequest.requests:type_name -> google.cloud.securitycenter.v2.CreateResourceValueConfigRequest
	53, // 1: google.cloud.securitycenter.v2.BatchCreateResourceValueConfigsResponse.resource_value_configs:type_name -> google.cloud.securitycenter.v2.ResourceValueConfig
	54, // 2: google.cloud.securitycenter.v2.CreateBigQueryExportRequest.big_query_export:type_name -> google.cloud.securitycenter.v2.BigQueryExport
	55, // 3: google.cloud.securitycenter.v2.CreateFindingRequest.finding:type_name -> google.cloud.securitycenter.v2.Finding
	56, // 4: google.cloud.securitycenter.v2.CreateMuteConfigRequest.mute_config:type_name -> google.cloud.securitycenter.v2.MuteConfig
	57, // 5: google.cloud.securitycenter.v2.CreateNotificationConfigRequest.notification_config:type_name -> google.cloud.securitycenter.v2.NotificationConfig
	53, // 6: google.cloud.securitycenter.v2.CreateResourceValueConfigRequest.resource_value_config:type_name -> google.cloud.securitycenter.v2.ResourceValueConfig
	58, // 7: google.cloud.securitycenter.v2.CreateSourceRequest.source:type_name -> google.cloud.securitycenter.v2.Source
	21, // 8: google.cloud.securitycenter.v2.GroupFindingsResponse.group_by_results:type_name -> google.cloud.securitycenter.v2.GroupResult
	50, // 9: google.cloud.securitycenter.v2.GroupResult.properties:type_name -> google.cloud.securitycenter.v2.GroupResult.PropertiesEntry
	59, // 10: google.cloud.securitycenter.v2.ListAttackPathsResponse.attack_paths:type_name -> google.cloud.securitycenter.v2.AttackPath
	54, // 11: google.cloud.securitycenter.v2.ListBigQueryExportsResponse.big_query_exports:type_name -> google.cloud.securitycenter.v2.BigQueryExport
	60, // 12: google.cloud.securitycenter.v2.ListFindingsRequest.field_mask:type_name -> google.protobuf.FieldMask
	51, // 13: google.cloud.securitycenter.v2.ListFindingsResponse.list_findings_results:type_name -> google.cloud.securitycenter.v2.ListFindingsResponse.ListFindingsResult
	56, // 14: google.cloud.securitycenter.v2.ListMuteConfigsResponse.mute_configs:type_name -> google.cloud.securitycenter.v2.MuteConfig
	57, // 15: google.cloud.securitycenter.v2.ListNotificationConfigsResponse.notification_configs:type_name -> google.cloud.securitycenter.v2.NotificationConfig
	53, // 16: google.cloud.securitycenter.v2.ListResourceValueConfigsResponse.resource_value_configs:type_name -> google.cloud.securitycenter.v2.ResourceValueConfig
	58, // 17: google.cloud.securitycenter.v2.ListSourcesResponse.sources:type_name -> google.cloud.securitycenter.v2.Source
	61, // 18: google.cloud.securitycenter.v2.ListValuedResourcesResponse.valued_resources:type_name -> google.cloud.securitycenter.v2.ValuedResource
	62, // 19: google.cloud.securitycenter.v2.SetFindingStateRequest.state:type_name -> google.cloud.securitycenter.v2.Finding.State
	63, // 20: google.cloud.securitycenter.v2.SetMuteRequest.mute:type_name -> google.cloud.securitycenter.v2.Finding.Mute
	54, // 21: google.cloud.securitycenter.v2.UpdateBigQueryExportRequest.big_query_export:type_name -> google.cloud.securitycenter.v2.BigQueryExport
	60, // 22: google.cloud.securitycenter.v2.UpdateBigQueryExportRequest.update_mask:type_name -> google.protobuf.FieldMask
	64, // 23: google.cloud.securitycenter.v2.UpdateExternalSystemRequest.external_system:type_name -> google.cloud.securitycenter.v2.ExternalSystem
	60, // 24: google.cloud.securitycenter.v2.UpdateExternalSystemRequest.update_mask:type_name -> google.protobuf.FieldMask
	55, // 25: google.cloud.securitycenter.v2.UpdateFindingRequest.finding:type_name -> google.cloud.securitycenter.v2.Finding
	60, // 26: google.cloud.securitycenter.v2.UpdateFindingRequest.update_mask:type_name -> google.protobuf.FieldMask
	56, // 27: google.cloud.securitycenter.v2.UpdateMuteConfigRequest.mute_config:type_name -> google.cloud.securitycenter.v2.MuteConfig
	60, // 28: google.cloud.securitycenter.v2.UpdateMuteConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	57, // 29: google.cloud.securitycenter.v2.UpdateNotificationConfigRequest.notification_config:type_name -> google.cloud.securitycenter.v2.NotificationConfig
	60, // 30: google.cloud.securitycenter.v2.UpdateNotificationConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	53, // 31: google.cloud.securitycenter.v2.UpdateResourceValueConfigRequest.resource_value_config:type_name -> google.cloud.securitycenter.v2.ResourceValueConfig
	60, // 32: google.cloud.securitycenter.v2.UpdateResourceValueConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	65, // 33: google.cloud.securitycenter.v2.UpdateSecurityMarksRequest.security_marks:type_name -> google.cloud.securitycenter.v2.SecurityMarks
	60, // 34: google.cloud.securitycenter.v2.UpdateSecurityMarksRequest.update_mask:type_name -> google.protobuf.FieldMask
	58, // 35: google.cloud.securitycenter.v2.UpdateSourceRequest.source:type_name -> google.cloud.securitycenter.v2.Source
	60, // 36: google.cloud.securitycenter.v2.UpdateSourceRequest.update_mask:type_name -> google.protobuf.FieldMask
	66, // 37: google.cloud.securitycenter.v2.GroupResult.PropertiesEntry.value:type_name -> google.protobuf.Value
	55, // 38: google.cloud.securitycenter.v2.ListFindingsResponse.ListFindingsResult.finding:type_name -> google.cloud.securitycenter.v2.Finding
	52, // 39: google.cloud.securitycenter.v2.ListFindingsResponse.ListFindingsResult.resource:type_name -> google.cloud.securitycenter.v2.ListFindingsResponse.ListFindingsResult.Resource
	0,  // 40: google.cloud.securitycenter.v2.SecurityCenter.BatchCreateResourceValueConfigs:input_type -> google.cloud.securitycenter.v2.BatchCreateResourceValueConfigsRequest
	2,  // 41: google.cloud.securitycenter.v2.SecurityCenter.BulkMuteFindings:input_type -> google.cloud.securitycenter.v2.BulkMuteFindingsRequest
	4,  // 42: google.cloud.securitycenter.v2.SecurityCenter.CreateBigQueryExport:input_type -> google.cloud.securitycenter.v2.CreateBigQueryExportRequest
	5,  // 43: google.cloud.securitycenter.v2.SecurityCenter.CreateFinding:input_type -> google.cloud.securitycenter.v2.CreateFindingRequest
	6,  // 44: google.cloud.securitycenter.v2.SecurityCenter.CreateMuteConfig:input_type -> google.cloud.securitycenter.v2.CreateMuteConfigRequest
	7,  // 45: google.cloud.securitycenter.v2.SecurityCenter.CreateNotificationConfig:input_type -> google.cloud.securitycenter.v2.CreateNotificationConfigRequest
	9,  // 46: google.cloud.securitycenter.v2.SecurityCenter.CreateSource:input_type -> google.cloud.securitycenter.v2.CreateSourceRequest
	10, // 47: google.cloud.securitycenter.v2.SecurityCenter.DeleteBigQueryExport:input_type -> google.cloud.securitycenter.v2.DeleteBigQueryExportRequest
	11, // 48: google.cloud.securitycenter.v2.SecurityCenter.DeleteMuteConfig:input_type -> google.cloud.securitycenter.v2.DeleteMuteConfigRequest
	12, // 49: google.cloud.securitycenter.v2.SecurityCenter.DeleteNotificationConfig:input_type -> google.cloud.securitycenter.v2.DeleteNotificationConfigRequest
	13, // 50: google.cloud.securitycenter.v2.SecurityCenter.DeleteResourceValueConfig:input_type -> google.cloud.securitycenter.v2.DeleteResourceValueConfigRequest
	14, // 51: google.cloud.securitycenter.v2.SecurityCenter.GetBigQueryExport:input_type -> google.cloud.securitycenter.v2.GetBigQueryExportRequest
	24, // 52: google.cloud.securitycenter.v2.SecurityCenter.GetSimulation:input_type -> google.cloud.securitycenter.v2.GetSimulationRequest
	25, // 53: google.cloud.securitycenter.v2.SecurityCenter.GetValuedResource:input_type -> google.cloud.securitycenter.v2.GetValuedResourceRequest
	67, // 54: google.cloud.securitycenter.v2.SecurityCenter.GetIamPolicy:input_type -> google.iam.v1.GetIamPolicyRequest
	15, // 55: google.cloud.securitycenter.v2.SecurityCenter.GetMuteConfig:input_type -> google.cloud.securitycenter.v2.GetMuteConfigRequest
	16, // 56: google.cloud.securitycenter.v2.SecurityCenter.GetNotificationConfig:input_type -> google.cloud.securitycenter.v2.GetNotificationConfigRequest
	17, // 57: google.cloud.securitycenter.v2.SecurityCenter.GetResourceValueConfig:input_type -> google.cloud.securitycenter.v2.GetResourceValueConfigRequest
	18, // 58: google.cloud.securitycenter.v2.SecurityCenter.GetSource:input_type -> google.cloud.securitycenter.v2.GetSourceRequest
	19, // 59: google.cloud.securitycenter.v2.SecurityCenter.GroupFindings:input_type -> google.cloud.securitycenter.v2.GroupFindingsRequest
	22, // 60: google.cloud.securitycenter.v2.SecurityCenter.ListAttackPaths:input_type -> google.cloud.securitycenter.v2.ListAttackPathsRequest
	26, // 61: google.cloud.securitycenter.v2.SecurityCenter.ListBigQueryExports:input_type -> google.cloud.securitycenter.v2.ListBigQueryExportsRequest
	28, // 62: google.cloud.securitycenter.v2.SecurityCenter.ListFindings:input_type -> google.cloud.securitycenter.v2.ListFindingsRequest
	30, // 63: google.cloud.securitycenter.v2.SecurityCenter.ListMuteConfigs:input_type -> google.cloud.securitycenter.v2.ListMuteConfigsRequest
	32, // 64: google.cloud.securitycenter.v2.SecurityCenter.ListNotificationConfigs:input_type -> google.cloud.securitycenter.v2.ListNotificationConfigsRequest
	34, // 65: google.cloud.securitycenter.v2.SecurityCenter.ListResourceValueConfigs:input_type -> google.cloud.securitycenter.v2.ListResourceValueConfigsRequest
	36, // 66: google.cloud.securitycenter.v2.SecurityCenter.ListSources:input_type -> google.cloud.securitycenter.v2.ListSourcesRequest
	38, // 67: google.cloud.securitycenter.v2.SecurityCenter.ListValuedResources:input_type -> google.cloud.securitycenter.v2.ListValuedResourcesRequest
	40, // 68: google.cloud.securitycenter.v2.SecurityCenter.SetFindingState:input_type -> google.cloud.securitycenter.v2.SetFindingStateRequest
	68, // 69: google.cloud.securitycenter.v2.SecurityCenter.SetIamPolicy:input_type -> google.iam.v1.SetIamPolicyRequest
	41, // 70: google.cloud.securitycenter.v2.SecurityCenter.SetMute:input_type -> google.cloud.securitycenter.v2.SetMuteRequest
	69, // 71: google.cloud.securitycenter.v2.SecurityCenter.TestIamPermissions:input_type -> google.iam.v1.TestIamPermissionsRequest
	42, // 72: google.cloud.securitycenter.v2.SecurityCenter.UpdateBigQueryExport:input_type -> google.cloud.securitycenter.v2.UpdateBigQueryExportRequest
	43, // 73: google.cloud.securitycenter.v2.SecurityCenter.UpdateExternalSystem:input_type -> google.cloud.securitycenter.v2.UpdateExternalSystemRequest
	44, // 74: google.cloud.securitycenter.v2.SecurityCenter.UpdateFinding:input_type -> google.cloud.securitycenter.v2.UpdateFindingRequest
	45, // 75: google.cloud.securitycenter.v2.SecurityCenter.UpdateMuteConfig:input_type -> google.cloud.securitycenter.v2.UpdateMuteConfigRequest
	46, // 76: google.cloud.securitycenter.v2.SecurityCenter.UpdateNotificationConfig:input_type -> google.cloud.securitycenter.v2.UpdateNotificationConfigRequest
	47, // 77: google.cloud.securitycenter.v2.SecurityCenter.UpdateResourceValueConfig:input_type -> google.cloud.securitycenter.v2.UpdateResourceValueConfigRequest
	48, // 78: google.cloud.securitycenter.v2.SecurityCenter.UpdateSecurityMarks:input_type -> google.cloud.securitycenter.v2.UpdateSecurityMarksRequest
	49, // 79: google.cloud.securitycenter.v2.SecurityCenter.UpdateSource:input_type -> google.cloud.securitycenter.v2.UpdateSourceRequest
	1,  // 80: google.cloud.securitycenter.v2.SecurityCenter.BatchCreateResourceValueConfigs:output_type -> google.cloud.securitycenter.v2.BatchCreateResourceValueConfigsResponse
	70, // 81: google.cloud.securitycenter.v2.SecurityCenter.BulkMuteFindings:output_type -> google.longrunning.Operation
	54, // 82: google.cloud.securitycenter.v2.SecurityCenter.CreateBigQueryExport:output_type -> google.cloud.securitycenter.v2.BigQueryExport
	55, // 83: google.cloud.securitycenter.v2.SecurityCenter.CreateFinding:output_type -> google.cloud.securitycenter.v2.Finding
	56, // 84: google.cloud.securitycenter.v2.SecurityCenter.CreateMuteConfig:output_type -> google.cloud.securitycenter.v2.MuteConfig
	57, // 85: google.cloud.securitycenter.v2.SecurityCenter.CreateNotificationConfig:output_type -> google.cloud.securitycenter.v2.NotificationConfig
	58, // 86: google.cloud.securitycenter.v2.SecurityCenter.CreateSource:output_type -> google.cloud.securitycenter.v2.Source
	71, // 87: google.cloud.securitycenter.v2.SecurityCenter.DeleteBigQueryExport:output_type -> google.protobuf.Empty
	71, // 88: google.cloud.securitycenter.v2.SecurityCenter.DeleteMuteConfig:output_type -> google.protobuf.Empty
	71, // 89: google.cloud.securitycenter.v2.SecurityCenter.DeleteNotificationConfig:output_type -> google.protobuf.Empty
	71, // 90: google.cloud.securitycenter.v2.SecurityCenter.DeleteResourceValueConfig:output_type -> google.protobuf.Empty
	54, // 91: google.cloud.securitycenter.v2.SecurityCenter.GetBigQueryExport:output_type -> google.cloud.securitycenter.v2.BigQueryExport
	72, // 92: google.cloud.securitycenter.v2.SecurityCenter.GetSimulation:output_type -> google.cloud.securitycenter.v2.Simulation
	61, // 93: google.cloud.securitycenter.v2.SecurityCenter.GetValuedResource:output_type -> google.cloud.securitycenter.v2.ValuedResource
	73, // 94: google.cloud.securitycenter.v2.SecurityCenter.GetIamPolicy:output_type -> google.iam.v1.Policy
	56, // 95: google.cloud.securitycenter.v2.SecurityCenter.GetMuteConfig:output_type -> google.cloud.securitycenter.v2.MuteConfig
	57, // 96: google.cloud.securitycenter.v2.SecurityCenter.GetNotificationConfig:output_type -> google.cloud.securitycenter.v2.NotificationConfig
	53, // 97: google.cloud.securitycenter.v2.SecurityCenter.GetResourceValueConfig:output_type -> google.cloud.securitycenter.v2.ResourceValueConfig
	58, // 98: google.cloud.securitycenter.v2.SecurityCenter.GetSource:output_type -> google.cloud.securitycenter.v2.Source
	20, // 99: google.cloud.securitycenter.v2.SecurityCenter.GroupFindings:output_type -> google.cloud.securitycenter.v2.GroupFindingsResponse
	23, // 100: google.cloud.securitycenter.v2.SecurityCenter.ListAttackPaths:output_type -> google.cloud.securitycenter.v2.ListAttackPathsResponse
	27, // 101: google.cloud.securitycenter.v2.SecurityCenter.ListBigQueryExports:output_type -> google.cloud.securitycenter.v2.ListBigQueryExportsResponse
	29, // 102: google.cloud.securitycenter.v2.SecurityCenter.ListFindings:output_type -> google.cloud.securitycenter.v2.ListFindingsResponse
	31, // 103: google.cloud.securitycenter.v2.SecurityCenter.ListMuteConfigs:output_type -> google.cloud.securitycenter.v2.ListMuteConfigsResponse
	33, // 104: google.cloud.securitycenter.v2.SecurityCenter.ListNotificationConfigs:output_type -> google.cloud.securitycenter.v2.ListNotificationConfigsResponse
	35, // 105: google.cloud.securitycenter.v2.SecurityCenter.ListResourceValueConfigs:output_type -> google.cloud.securitycenter.v2.ListResourceValueConfigsResponse
	37, // 106: google.cloud.securitycenter.v2.SecurityCenter.ListSources:output_type -> google.cloud.securitycenter.v2.ListSourcesResponse
	39, // 107: google.cloud.securitycenter.v2.SecurityCenter.ListValuedResources:output_type -> google.cloud.securitycenter.v2.ListValuedResourcesResponse
	55, // 108: google.cloud.securitycenter.v2.SecurityCenter.SetFindingState:output_type -> google.cloud.securitycenter.v2.Finding
	73, // 109: google.cloud.securitycenter.v2.SecurityCenter.SetIamPolicy:output_type -> google.iam.v1.Policy
	55, // 110: google.cloud.securitycenter.v2.SecurityCenter.SetMute:output_type -> google.cloud.securitycenter.v2.Finding
	74, // 111: google.cloud.securitycenter.v2.SecurityCenter.TestIamPermissions:output_type -> google.iam.v1.TestIamPermissionsResponse
	54, // 112: google.cloud.securitycenter.v2.SecurityCenter.UpdateBigQueryExport:output_type -> google.cloud.securitycenter.v2.BigQueryExport
	64, // 113: google.cloud.securitycenter.v2.SecurityCenter.UpdateExternalSystem:output_type -> google.cloud.securitycenter.v2.ExternalSystem
	55, // 114: google.cloud.securitycenter.v2.SecurityCenter.UpdateFinding:output_type -> google.cloud.securitycenter.v2.Finding
	56, // 115: google.cloud.securitycenter.v2.SecurityCenter.UpdateMuteConfig:output_type -> google.cloud.securitycenter.v2.MuteConfig
	57, // 116: google.cloud.securitycenter.v2.SecurityCenter.UpdateNotificationConfig:output_type -> google.cloud.securitycenter.v2.NotificationConfig
	53, // 117: google.cloud.securitycenter.v2.SecurityCenter.UpdateResourceValueConfig:output_type -> google.cloud.securitycenter.v2.ResourceValueConfig
	65, // 118: google.cloud.securitycenter.v2.SecurityCenter.UpdateSecurityMarks:output_type -> google.cloud.securitycenter.v2.SecurityMarks
	58, // 119: google.cloud.securitycenter.v2.SecurityCenter.UpdateSource:output_type -> google.cloud.securitycenter.v2.Source
	80, // [80:120] is the sub-list for method output_type
	40, // [40:80] is the sub-list for method input_type
	40, // [40:40] is the sub-list for extension type_name
	40, // [40:40] is the sub-list for extension extendee
	0,  // [0:40] is the sub-list for field type_name
}

func init() { file_google_cloud_securitycenter_v2_securitycenter_service_proto_init() }
func file_google_cloud_securitycenter_v2_securitycenter_service_proto_init() {
	if File_google_cloud_securitycenter_v2_securitycenter_service_proto != nil {
		return
	}
	file_google_cloud_securitycenter_v2_attack_path_proto_init()
	file_google_cloud_securitycenter_v2_bigquery_export_proto_init()
	file_google_cloud_securitycenter_v2_external_system_proto_init()
	file_google_cloud_securitycenter_v2_finding_proto_init()
	file_google_cloud_securitycenter_v2_mute_config_proto_init()
	file_google_cloud_securitycenter_v2_notification_config_proto_init()
	file_google_cloud_securitycenter_v2_resource_value_config_proto_init()
	file_google_cloud_securitycenter_v2_security_marks_proto_init()
	file_google_cloud_securitycenter_v2_simulation_proto_init()
	file_google_cloud_securitycenter_v2_source_proto_init()
	file_google_cloud_securitycenter_v2_valued_resource_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateResourceValueConfigsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateResourceValueConfigsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BulkMuteFindingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BulkMuteFindingsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateBigQueryExportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateFindingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateMuteConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateNotificationConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateResourceValueConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteBigQueryExportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteMuteConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteNotificationConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteResourceValueConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBigQueryExportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMuteConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetNotificationConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetResourceValueConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GroupFindingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GroupFindingsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GroupResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAttackPathsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAttackPathsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSimulationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetValuedResourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBigQueryExportsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBigQueryExportsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFindingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFindingsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMuteConfigsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMuteConfigsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNotificationConfigsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNotificationConfigsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListResourceValueConfigsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListResourceValueConfigsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSourcesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSourcesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListValuedResourcesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListValuedResourcesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetFindingStateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetMuteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateBigQueryExportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateExternalSystemRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateFindingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateMuteConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateNotificationConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateResourceValueConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSecurityMarksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFindingsResponse_ListFindingsResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFindingsResponse_ListFindingsResult_Resource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   53,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_securitycenter_v2_securitycenter_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_securitycenter_v2_securitycenter_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_securitycenter_v2_securitycenter_service_proto_msgTypes,
	}.Build()
	File_google_cloud_securitycenter_v2_securitycenter_service_proto = out.File
	file_google_cloud_securitycenter_v2_securitycenter_service_proto_rawDesc = nil
	file_google_cloud_securitycenter_v2_securitycenter_service_proto_goTypes = nil
	file_google_cloud_securitycenter_v2_securitycenter_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SecurityCenterClient is the client API for SecurityCenter service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SecurityCenterClient interface {
	// Creates a ResourceValueConfig for an organization. Maps user's tags to
	// difference resource values for use by the attack path simulation.
	BatchCreateResourceValueConfigs(ctx context.Context, in *BatchCreateResourceValueConfigsRequest, opts ...grpc.CallOption) (*BatchCreateResourceValueConfigsResponse, error)
	// Kicks off an LRO to bulk mute findings for a parent based on a filter. If
	// no location is specified, findings are muted in global. The parent
	// can be either an organization, folder, or project. The findings matched by
	// the filter will be muted after the LRO is done.
	BulkMuteFindings(ctx context.Context, in *BulkMuteFindingsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a BigQuery export.
	CreateBigQueryExport(ctx context.Context, in *CreateBigQueryExportRequest, opts ...grpc.CallOption) (*BigQueryExport, error)
	// Creates a finding in a location. The corresponding source must exist for
	// finding creation to succeed.
	CreateFinding(ctx context.Context, in *CreateFindingRequest, opts ...grpc.CallOption) (*Finding, error)
	// Creates a mute config.
	CreateMuteConfig(ctx context.Context, in *CreateMuteConfigRequest, opts ...grpc.CallOption) (*MuteConfig, error)
	// Creates a notification config.
	CreateNotificationConfig(ctx context.Context, in *CreateNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error)
	// Creates a source.
	CreateSource(ctx context.Context, in *CreateSourceRequest, opts ...grpc.CallOption) (*Source, error)
	// Deletes an existing BigQuery export.
	DeleteBigQueryExport(ctx context.Context, in *DeleteBigQueryExportRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deletes an existing mute config. If no location is specified, default is
	// global.
	DeleteMuteConfig(ctx context.Context, in *DeleteMuteConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deletes a notification config.
	DeleteNotificationConfig(ctx context.Context, in *DeleteNotificationConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deletes a ResourceValueConfig.
	DeleteResourceValueConfig(ctx context.Context, in *DeleteResourceValueConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets a BigQuery export.
	GetBigQueryExport(ctx context.Context, in *GetBigQueryExportRequest, opts ...grpc.CallOption) (*BigQueryExport, error)
	// Get the simulation by name or the latest simulation for the given
	// organization.
	GetSimulation(ctx context.Context, in *GetSimulationRequest, opts ...grpc.CallOption) (*Simulation, error)
	// Get the valued resource by name
	GetValuedResource(ctx context.Context, in *GetValuedResourceRequest, opts ...grpc.CallOption) (*ValuedResource, error)
	// Gets the access control policy on the specified Source.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Gets a mute config. If no location is specified, default is
	// global.
	GetMuteConfig(ctx context.Context, in *GetMuteConfigRequest, opts ...grpc.CallOption) (*MuteConfig, error)
	// Gets a notification config.
	GetNotificationConfig(ctx context.Context, in *GetNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error)
	// Gets a ResourceValueConfig.
	GetResourceValueConfig(ctx context.Context, in *GetResourceValueConfigRequest, opts ...grpc.CallOption) (*ResourceValueConfig, error)
	// Gets a source.
	GetSource(ctx context.Context, in *GetSourceRequest, opts ...grpc.CallOption) (*Source, error)
	// Filters an organization or source's findings and groups them by their
	// specified properties in a location. If no location is specified, findings
	// are assumed to be in global
	//
	// To group across all sources provide a `-` as the source id.
	// The following list shows some examples:
	//
	// + `/v2/organizations/{organization_id}/sources/-/findings`
	// +
	// `/v2/organizations/{organization_id}/sources/-/locations/{location_id}/findings`
	// + `/v2/folders/{folder_id}/sources/-/findings`
	// + `/v2/folders/{folder_id}/sources/-/locations/{location_id}/findings`
	// + `/v2/projects/{project_id}/sources/-/findings`
	// + `/v2/projects/{project_id}/sources/-/locations/{location_id}/findings`
	GroupFindings(ctx context.Context, in *GroupFindingsRequest, opts ...grpc.CallOption) (*GroupFindingsResponse, error)
	// Lists the attack paths for a set of simulation results or valued resources
	// and filter.
	ListAttackPaths(ctx context.Context, in *ListAttackPathsRequest, opts ...grpc.CallOption) (*ListAttackPathsResponse, error)
	// Lists BigQuery exports. Note that when requesting BigQuery exports at a
	// given level all exports under that level are also returned e.g. if
	// requesting BigQuery exports under a folder, then all BigQuery exports
	// immediately under the folder plus the ones created under the projects
	// within the folder are returned.
	ListBigQueryExports(ctx context.Context, in *ListBigQueryExportsRequest, opts ...grpc.CallOption) (*ListBigQueryExportsResponse, error)
	// Lists an organization or source's findings.
	//
	// To list across all sources for a given location provide a `-` as the source
	// id. If no location is specified, finding are assumed to be in global.
	// The following list shows some examples:
	//
	// + `/v2/organizations/{organization_id}/sources/-/findings`
	// +
	// `/v2/organizations/{organization_id}/sources/-/locations/{location_id}/findings`
	ListFindings(ctx context.Context, in *ListFindingsRequest, opts ...grpc.CallOption) (*ListFindingsResponse, error)
	// Lists mute configs. If no location is specified, default is
	// global.
	ListMuteConfigs(ctx context.Context, in *ListMuteConfigsRequest, opts ...grpc.CallOption) (*ListMuteConfigsResponse, error)
	// Lists notification configs.
	ListNotificationConfigs(ctx context.Context, in *ListNotificationConfigsRequest, opts ...grpc.CallOption) (*ListNotificationConfigsResponse, error)
	// Lists all ResourceValueConfigs.
	ListResourceValueConfigs(ctx context.Context, in *ListResourceValueConfigsRequest, opts ...grpc.CallOption) (*ListResourceValueConfigsResponse, error)
	// Lists all sources belonging to an organization.
	ListSources(ctx context.Context, in *ListSourcesRequest, opts ...grpc.CallOption) (*ListSourcesResponse, error)
	// Lists the valued resources for a set of simulation results and filter.
	ListValuedResources(ctx context.Context, in *ListValuedResourcesRequest, opts ...grpc.CallOption) (*ListValuedResourcesResponse, error)
	// Updates the state of a finding. If no location is specified, finding is
	// assumed to be in global
	SetFindingState(ctx context.Context, in *SetFindingStateRequest, opts ...grpc.CallOption) (*Finding, error)
	// Sets the access control policy on the specified Source.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Updates the mute state of a finding. If no location is specified, finding
	// is assumed to be in global
	SetMute(ctx context.Context, in *SetMuteRequest, opts ...grpc.CallOption) (*Finding, error)
	// Returns the permissions that a caller has on the specified source.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
	// Updates a BigQuery export.
	UpdateBigQueryExport(ctx context.Context, in *UpdateBigQueryExportRequest, opts ...grpc.CallOption) (*BigQueryExport, error)
	// Updates external system. This is for a given finding. If no location is
	// specified, finding is assumed to be in global
	UpdateExternalSystem(ctx context.Context, in *UpdateExternalSystemRequest, opts ...grpc.CallOption) (*ExternalSystem, error)
	// Creates or updates a finding. If no location is specified, finding is
	// assumed to be in global. The corresponding source must exist for a finding
	// creation to succeed.
	UpdateFinding(ctx context.Context, in *UpdateFindingRequest, opts ...grpc.CallOption) (*Finding, error)
	// Updates a mute config. If no location is specified, default is
	// global.
	UpdateMuteConfig(ctx context.Context, in *UpdateMuteConfigRequest, opts ...grpc.CallOption) (*MuteConfig, error)
	// Updates a notification config. The following update
	// fields are allowed: description, pubsub_topic, streaming_config.filter
	UpdateNotificationConfig(ctx context.Context, in *UpdateNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error)
	// Updates an existing ResourceValueConfigs with new rules.
	UpdateResourceValueConfig(ctx context.Context, in *UpdateResourceValueConfigRequest, opts ...grpc.CallOption) (*ResourceValueConfig, error)
	// Updates security marks. For Finding Security marks, if no location is
	// specified, finding is assumed to be in global. Assets Security Marks can
	// only be accessed through global endpoint.
	UpdateSecurityMarks(ctx context.Context, in *UpdateSecurityMarksRequest, opts ...grpc.CallOption) (*SecurityMarks, error)
	// Updates a source.
	UpdateSource(ctx context.Context, in *UpdateSourceRequest, opts ...grpc.CallOption) (*Source, error)
}

type securityCenterClient struct {
	cc grpc.ClientConnInterface
}

func NewSecurityCenterClient(cc grpc.ClientConnInterface) SecurityCenterClient {
	return &securityCenterClient{cc}
}

func (c *securityCenterClient) BatchCreateResourceValueConfigs(ctx context.Context, in *BatchCreateResourceValueConfigsRequest, opts ...grpc.CallOption) (*BatchCreateResourceValueConfigsResponse, error) {
	out := new(BatchCreateResourceValueConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/BatchCreateResourceValueConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) BulkMuteFindings(ctx context.Context, in *BulkMuteFindingsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/BulkMuteFindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateBigQueryExport(ctx context.Context, in *CreateBigQueryExportRequest, opts ...grpc.CallOption) (*BigQueryExport, error) {
	out := new(BigQueryExport)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/CreateBigQueryExport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateFinding(ctx context.Context, in *CreateFindingRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/CreateFinding", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateMuteConfig(ctx context.Context, in *CreateMuteConfigRequest, opts ...grpc.CallOption) (*MuteConfig, error) {
	out := new(MuteConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/CreateMuteConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateNotificationConfig(ctx context.Context, in *CreateNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error) {
	out := new(NotificationConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/CreateNotificationConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateSource(ctx context.Context, in *CreateSourceRequest, opts ...grpc.CallOption) (*Source, error) {
	out := new(Source)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/CreateSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) DeleteBigQueryExport(ctx context.Context, in *DeleteBigQueryExportRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/DeleteBigQueryExport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) DeleteMuteConfig(ctx context.Context, in *DeleteMuteConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/DeleteMuteConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) DeleteNotificationConfig(ctx context.Context, in *DeleteNotificationConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/DeleteNotificationConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) DeleteResourceValueConfig(ctx context.Context, in *DeleteResourceValueConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/DeleteResourceValueConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetBigQueryExport(ctx context.Context, in *GetBigQueryExportRequest, opts ...grpc.CallOption) (*BigQueryExport, error) {
	out := new(BigQueryExport)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/GetBigQueryExport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetSimulation(ctx context.Context, in *GetSimulationRequest, opts ...grpc.CallOption) (*Simulation, error) {
	out := new(Simulation)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/GetSimulation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetValuedResource(ctx context.Context, in *GetValuedResourceRequest, opts ...grpc.CallOption) (*ValuedResource, error) {
	out := new(ValuedResource)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/GetValuedResource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetMuteConfig(ctx context.Context, in *GetMuteConfigRequest, opts ...grpc.CallOption) (*MuteConfig, error) {
	out := new(MuteConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/GetMuteConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetNotificationConfig(ctx context.Context, in *GetNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error) {
	out := new(NotificationConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/GetNotificationConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetResourceValueConfig(ctx context.Context, in *GetResourceValueConfigRequest, opts ...grpc.CallOption) (*ResourceValueConfig, error) {
	out := new(ResourceValueConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/GetResourceValueConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetSource(ctx context.Context, in *GetSourceRequest, opts ...grpc.CallOption) (*Source, error) {
	out := new(Source)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/GetSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GroupFindings(ctx context.Context, in *GroupFindingsRequest, opts ...grpc.CallOption) (*GroupFindingsResponse, error) {
	out := new(GroupFindingsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/GroupFindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListAttackPaths(ctx context.Context, in *ListAttackPathsRequest, opts ...grpc.CallOption) (*ListAttackPathsResponse, error) {
	out := new(ListAttackPathsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/ListAttackPaths", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListBigQueryExports(ctx context.Context, in *ListBigQueryExportsRequest, opts ...grpc.CallOption) (*ListBigQueryExportsResponse, error) {
	out := new(ListBigQueryExportsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/ListBigQueryExports", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListFindings(ctx context.Context, in *ListFindingsRequest, opts ...grpc.CallOption) (*ListFindingsResponse, error) {
	out := new(ListFindingsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/ListFindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListMuteConfigs(ctx context.Context, in *ListMuteConfigsRequest, opts ...grpc.CallOption) (*ListMuteConfigsResponse, error) {
	out := new(ListMuteConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/ListMuteConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListNotificationConfigs(ctx context.Context, in *ListNotificationConfigsRequest, opts ...grpc.CallOption) (*ListNotificationConfigsResponse, error) {
	out := new(ListNotificationConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/ListNotificationConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListResourceValueConfigs(ctx context.Context, in *ListResourceValueConfigsRequest, opts ...grpc.CallOption) (*ListResourceValueConfigsResponse, error) {
	out := new(ListResourceValueConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/ListResourceValueConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListSources(ctx context.Context, in *ListSourcesRequest, opts ...grpc.CallOption) (*ListSourcesResponse, error) {
	out := new(ListSourcesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/ListSources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListValuedResources(ctx context.Context, in *ListValuedResourcesRequest, opts ...grpc.CallOption) (*ListValuedResourcesResponse, error) {
	out := new(ListValuedResourcesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/ListValuedResources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) SetFindingState(ctx context.Context, in *SetFindingStateRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/SetFindingState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) SetMute(ctx context.Context, in *SetMuteRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/SetMute", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateBigQueryExport(ctx context.Context, in *UpdateBigQueryExportRequest, opts ...grpc.CallOption) (*BigQueryExport, error) {
	out := new(BigQueryExport)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/UpdateBigQueryExport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateExternalSystem(ctx context.Context, in *UpdateExternalSystemRequest, opts ...grpc.CallOption) (*ExternalSystem, error) {
	out := new(ExternalSystem)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/UpdateExternalSystem", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateFinding(ctx context.Context, in *UpdateFindingRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/UpdateFinding", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateMuteConfig(ctx context.Context, in *UpdateMuteConfigRequest, opts ...grpc.CallOption) (*MuteConfig, error) {
	out := new(MuteConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/UpdateMuteConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateNotificationConfig(ctx context.Context, in *UpdateNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error) {
	out := new(NotificationConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/UpdateNotificationConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateResourceValueConfig(ctx context.Context, in *UpdateResourceValueConfigRequest, opts ...grpc.CallOption) (*ResourceValueConfig, error) {
	out := new(ResourceValueConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/UpdateResourceValueConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateSecurityMarks(ctx context.Context, in *UpdateSecurityMarksRequest, opts ...grpc.CallOption) (*SecurityMarks, error) {
	out := new(SecurityMarks)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/UpdateSecurityMarks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateSource(ctx context.Context, in *UpdateSourceRequest, opts ...grpc.CallOption) (*Source, error) {
	out := new(Source)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v2.SecurityCenter/UpdateSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SecurityCenterServer is the server API for SecurityCenter service.
type SecurityCenterServer interface {
	// Creates a ResourceValueConfig for an organization. Maps user's tags to
	// difference resource values for use by the attack path simulation.
	BatchCreateResourceValueConfigs(context.Context, *BatchCreateResourceValueConfigsRequest) (*BatchCreateResourceValueConfigsResponse, error)
	// Kicks off an LRO to bulk mute findings for a parent based on a filter. If
	// no location is specified, findings are muted in global. The parent
	// can be either an organization, folder, or project. The findings matched by
	// the filter will be muted after the LRO is done.
	BulkMuteFindings(context.Context, *BulkMuteFindingsRequest) (*longrunningpb.Operation, error)
	// Creates a BigQuery export.
	CreateBigQueryExport(context.Context, *CreateBigQueryExportRequest) (*BigQueryExport, error)
	// Creates a finding in a location. The corresponding source must exist for
	// finding creation to succeed.
	CreateFinding(context.Context, *CreateFindingRequest) (*Finding, error)
	// Creates a mute config.
	CreateMuteConfig(context.Context, *CreateMuteConfigRequest) (*MuteConfig, error)
	// Creates a notification config.
	CreateNotificationConfig(context.Context, *CreateNotificationConfigRequest) (*NotificationConfig, error)
	// Creates a source.
	CreateSource(context.Context, *CreateSourceRequest) (*Source, error)
	// Deletes an existing BigQuery export.
	DeleteBigQueryExport(context.Context, *DeleteBigQueryExportRequest) (*emptypb.Empty, error)
	// Deletes an existing mute config. If no location is specified, default is
	// global.
	DeleteMuteConfig(context.Context, *DeleteMuteConfigRequest) (*emptypb.Empty, error)
	// Deletes a notification config.
	DeleteNotificationConfig(context.Context, *DeleteNotificationConfigRequest) (*emptypb.Empty, error)
	// Deletes a ResourceValueConfig.
	DeleteResourceValueConfig(context.Context, *DeleteResourceValueConfigRequest) (*emptypb.Empty, error)
	// Gets a BigQuery export.
	GetBigQueryExport(context.Context, *GetBigQueryExportRequest) (*BigQueryExport, error)
	// Get the simulation by name or the latest simulation for the given
	// organization.
	GetSimulation(context.Context, *GetSimulationRequest) (*Simulation, error)
	// Get the valued resource by name
	GetValuedResource(context.Context, *GetValuedResourceRequest) (*ValuedResource, error)
	// Gets the access control policy on the specified Source.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Gets a mute config. If no location is specified, default is
	// global.
	GetMuteConfig(context.Context, *GetMuteConfigRequest) (*MuteConfig, error)
	// Gets a notification config.
	GetNotificationConfig(context.Context, *GetNotificationConfigRequest) (*NotificationConfig, error)
	// Gets a ResourceValueConfig.
	GetResourceValueConfig(context.Context, *GetResourceValueConfigRequest) (*ResourceValueConfig, error)
	// Gets a source.
	GetSource(context.Context, *GetSourceRequest) (*Source, error)
	// Filters an organization or source's findings and groups them by their
	// specified properties in a location. If no location is specified, findings
	// are assumed to be in global
	//
	// To group across all sources provide a `-` as the source id.
	// The following list shows some examples:
	//
	// + `/v2/organizations/{organization_id}/sources/-/findings`
	// +
	// `/v2/organizations/{organization_id}/sources/-/locations/{location_id}/findings`
	// + `/v2/folders/{folder_id}/sources/-/findings`
	// + `/v2/folders/{folder_id}/sources/-/locations/{location_id}/findings`
	// + `/v2/projects/{project_id}/sources/-/findings`
	// + `/v2/projects/{project_id}/sources/-/locations/{location_id}/findings`
	GroupFindings(context.Context, *GroupFindingsRequest) (*GroupFindingsResponse, error)
	// Lists the attack paths for a set of simulation results or valued resources
	// and filter.
	ListAttackPaths(context.Context, *ListAttackPathsRequest) (*ListAttackPathsResponse, error)
	// Lists BigQuery exports. Note that when requesting BigQuery exports at a
	// given level all exports under that level are also returned e.g. if
	// requesting BigQuery exports under a folder, then all BigQuery exports
	// immediately under the folder plus the ones created under the projects
	// within the folder are returned.
	ListBigQueryExports(context.Context, *ListBigQueryExportsRequest) (*ListBigQueryExportsResponse, error)
	// Lists an organization or source's findings.
	//
	// To list across all sources for a given location provide a `-` as the source
	// id. If no location is specified, finding are assumed to be in global.
	// The following list shows some examples:
	//
	// + `/v2/organizations/{organization_id}/sources/-/findings`
	// +
	// `/v2/organizations/{organization_id}/sources/-/locations/{location_id}/findings`
	ListFindings(context.Context, *ListFindingsRequest) (*ListFindingsResponse, error)
	// Lists mute configs. If no location is specified, default is
	// global.
	ListMuteConfigs(context.Context, *ListMuteConfigsRequest) (*ListMuteConfigsResponse, error)
	// Lists notification configs.
	ListNotificationConfigs(context.Context, *ListNotificationConfigsRequest) (*ListNotificationConfigsResponse, error)
	// Lists all ResourceValueConfigs.
	ListResourceValueConfigs(context.Context, *ListResourceValueConfigsRequest) (*ListResourceValueConfigsResponse, error)
	// Lists all sources belonging to an organization.
	ListSources(context.Context, *ListSourcesRequest) (*ListSourcesResponse, error)
	// Lists the valued resources for a set of simulation results and filter.
	ListValuedResources(context.Context, *ListValuedResourcesRequest) (*ListValuedResourcesResponse, error)
	// Updates the state of a finding. If no location is specified, finding is
	// assumed to be in global
	SetFindingState(context.Context, *SetFindingStateRequest) (*Finding, error)
	// Sets the access control policy on the specified Source.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Updates the mute state of a finding. If no location is specified, finding
	// is assumed to be in global
	SetMute(context.Context, *SetMuteRequest) (*Finding, error)
	// Returns the permissions that a caller has on the specified source.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
	// Updates a BigQuery export.
	UpdateBigQueryExport(context.Context, *UpdateBigQueryExportRequest) (*BigQueryExport, error)
	// Updates external system. This is for a given finding. If no location is
	// specified, finding is assumed to be in global
	UpdateExternalSystem(context.Context, *UpdateExternalSystemRequest) (*ExternalSystem, error)
	// Creates or updates a finding. If no location is specified, finding is
	// assumed to be in global. The corresponding source must exist for a finding
	// creation to succeed.
	UpdateFinding(context.Context, *UpdateFindingRequest) (*Finding, error)
	// Updates a mute config. If no location is specified, default is
	// global.
	UpdateMuteConfig(context.Context, *UpdateMuteConfigRequest) (*MuteConfig, error)
	// Updates a notification config. The following update
	// fields are allowed: description, pubsub_topic, streaming_config.filter
	UpdateNotificationConfig(context.Context, *UpdateNotificationConfigRequest) (*NotificationConfig, error)
	// Updates an existing ResourceValueConfigs with new rules.
	UpdateResourceValueConfig(context.Context, *UpdateResourceValueConfigRequest) (*ResourceValueConfig, error)
	// Updates security marks. For Finding Security marks, if no location is
	// specified, finding is assumed to be in global. Assets Security Marks can
	// only be accessed through global endpoint.
	UpdateSecurityMarks(context.Context, *UpdateSecurityMarksRequest) (*SecurityMarks, error)
	// Updates a source.
	UpdateSource(context.Context, *UpdateSourceRequest) (*Source, error)
}

// UnimplementedSecurityCenterServer can be embedded to have forward compatible implementations.
type UnimplementedSecurityCenterServer struct {
}

func (*UnimplementedSecurityCenterServer) BatchCreateResourceValueConfigs(context.Context, *BatchCreateResourceValueConfigsRequest) (*BatchCreateResourceValueConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateResourceValueConfigs not implemented")
}
func (*UnimplementedSecurityCenterServer) BulkMuteFindings(context.Context, *BulkMuteFindingsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BulkMuteFindings not implemented")
}
func (*UnimplementedSecurityCenterServer) CreateBigQueryExport(context.Context, *CreateBigQueryExportRequest) (*BigQueryExport, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBigQueryExport not implemented")
}
func (*UnimplementedSecurityCenterServer) CreateFinding(context.Context, *CreateFindingRequest) (*Finding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFinding not implemented")
}
func (*UnimplementedSecurityCenterServer) CreateMuteConfig(context.Context, *CreateMuteConfigRequest) (*MuteConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMuteConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) CreateNotificationConfig(context.Context, *CreateNotificationConfigRequest) (*NotificationConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNotificationConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) CreateSource(context.Context, *CreateSourceRequest) (*Source, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSource not implemented")
}
func (*UnimplementedSecurityCenterServer) DeleteBigQueryExport(context.Context, *DeleteBigQueryExportRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBigQueryExport not implemented")
}
func (*UnimplementedSecurityCenterServer) DeleteMuteConfig(context.Context, *DeleteMuteConfigRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMuteConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) DeleteNotificationConfig(context.Context, *DeleteNotificationConfigRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNotificationConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) DeleteResourceValueConfig(context.Context, *DeleteResourceValueConfigRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteResourceValueConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) GetBigQueryExport(context.Context, *GetBigQueryExportRequest) (*BigQueryExport, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBigQueryExport not implemented")
}
func (*UnimplementedSecurityCenterServer) GetSimulation(context.Context, *GetSimulationRequest) (*Simulation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSimulation not implemented")
}
func (*UnimplementedSecurityCenterServer) GetValuedResource(context.Context, *GetValuedResourceRequest) (*ValuedResource, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetValuedResource not implemented")
}
func (*UnimplementedSecurityCenterServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedSecurityCenterServer) GetMuteConfig(context.Context, *GetMuteConfigRequest) (*MuteConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMuteConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) GetNotificationConfig(context.Context, *GetNotificationConfigRequest) (*NotificationConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNotificationConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) GetResourceValueConfig(context.Context, *GetResourceValueConfigRequest) (*ResourceValueConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetResourceValueConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) GetSource(context.Context, *GetSourceRequest) (*Source, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSource not implemented")
}
func (*UnimplementedSecurityCenterServer) GroupFindings(context.Context, *GroupFindingsRequest) (*GroupFindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GroupFindings not implemented")
}
func (*UnimplementedSecurityCenterServer) ListAttackPaths(context.Context, *ListAttackPathsRequest) (*ListAttackPathsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAttackPaths not implemented")
}
func (*UnimplementedSecurityCenterServer) ListBigQueryExports(context.Context, *ListBigQueryExportsRequest) (*ListBigQueryExportsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBigQueryExports not implemented")
}
func (*UnimplementedSecurityCenterServer) ListFindings(context.Context, *ListFindingsRequest) (*ListFindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFindings not implemented")
}
func (*UnimplementedSecurityCenterServer) ListMuteConfigs(context.Context, *ListMuteConfigsRequest) (*ListMuteConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMuteConfigs not implemented")
}
func (*UnimplementedSecurityCenterServer) ListNotificationConfigs(context.Context, *ListNotificationConfigsRequest) (*ListNotificationConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNotificationConfigs not implemented")
}
func (*UnimplementedSecurityCenterServer) ListResourceValueConfigs(context.Context, *ListResourceValueConfigsRequest) (*ListResourceValueConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListResourceValueConfigs not implemented")
}
func (*UnimplementedSecurityCenterServer) ListSources(context.Context, *ListSourcesRequest) (*ListSourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSources not implemented")
}
func (*UnimplementedSecurityCenterServer) ListValuedResources(context.Context, *ListValuedResourcesRequest) (*ListValuedResourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListValuedResources not implemented")
}
func (*UnimplementedSecurityCenterServer) SetFindingState(context.Context, *SetFindingStateRequest) (*Finding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetFindingState not implemented")
}
func (*UnimplementedSecurityCenterServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedSecurityCenterServer) SetMute(context.Context, *SetMuteRequest) (*Finding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetMute not implemented")
}
func (*UnimplementedSecurityCenterServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateBigQueryExport(context.Context, *UpdateBigQueryExportRequest) (*BigQueryExport, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBigQueryExport not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateExternalSystem(context.Context, *UpdateExternalSystemRequest) (*ExternalSystem, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateExternalSystem not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateFinding(context.Context, *UpdateFindingRequest) (*Finding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFinding not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateMuteConfig(context.Context, *UpdateMuteConfigRequest) (*MuteConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateMuteConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateNotificationConfig(context.Context, *UpdateNotificationConfigRequest) (*NotificationConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNotificationConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateResourceValueConfig(context.Context, *UpdateResourceValueConfigRequest) (*ResourceValueConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateResourceValueConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateSecurityMarks(context.Context, *UpdateSecurityMarksRequest) (*SecurityMarks, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSecurityMarks not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateSource(context.Context, *UpdateSourceRequest) (*Source, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSource not implemented")
}

func RegisterSecurityCenterServer(s *grpc.Server, srv SecurityCenterServer) {
	s.RegisterService(&_SecurityCenter_serviceDesc, srv)
}

func _SecurityCenter_BatchCreateResourceValueConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateResourceValueConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).BatchCreateResourceValueConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/BatchCreateResourceValueConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).BatchCreateResourceValueConfigs(ctx, req.(*BatchCreateResourceValueConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_BulkMuteFindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BulkMuteFindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).BulkMuteFindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/BulkMuteFindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).BulkMuteFindings(ctx, req.(*BulkMuteFindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateBigQueryExport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBigQueryExportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateBigQueryExport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/CreateBigQueryExport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateBigQueryExport(ctx, req.(*CreateBigQueryExportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateFinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateFinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/CreateFinding",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateFinding(ctx, req.(*CreateFindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateMuteConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMuteConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateMuteConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/CreateMuteConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateMuteConfig(ctx, req.(*CreateMuteConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateNotificationConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNotificationConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateNotificationConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/CreateNotificationConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateNotificationConfig(ctx, req.(*CreateNotificationConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/CreateSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateSource(ctx, req.(*CreateSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_DeleteBigQueryExport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBigQueryExportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).DeleteBigQueryExport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/DeleteBigQueryExport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).DeleteBigQueryExport(ctx, req.(*DeleteBigQueryExportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_DeleteMuteConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMuteConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).DeleteMuteConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/DeleteMuteConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).DeleteMuteConfig(ctx, req.(*DeleteMuteConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_DeleteNotificationConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNotificationConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).DeleteNotificationConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/DeleteNotificationConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).DeleteNotificationConfig(ctx, req.(*DeleteNotificationConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_DeleteResourceValueConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteResourceValueConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).DeleteResourceValueConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/DeleteResourceValueConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).DeleteResourceValueConfig(ctx, req.(*DeleteResourceValueConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetBigQueryExport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBigQueryExportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetBigQueryExport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/GetBigQueryExport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetBigQueryExport(ctx, req.(*GetBigQueryExportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetSimulation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSimulationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetSimulation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/GetSimulation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetSimulation(ctx, req.(*GetSimulationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetValuedResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetValuedResourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetValuedResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/GetValuedResource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetValuedResource(ctx, req.(*GetValuedResourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetMuteConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMuteConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetMuteConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/GetMuteConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetMuteConfig(ctx, req.(*GetMuteConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetNotificationConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNotificationConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetNotificationConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/GetNotificationConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetNotificationConfig(ctx, req.(*GetNotificationConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetResourceValueConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetResourceValueConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetResourceValueConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/GetResourceValueConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetResourceValueConfig(ctx, req.(*GetResourceValueConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/GetSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetSource(ctx, req.(*GetSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GroupFindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GroupFindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GroupFindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/GroupFindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GroupFindings(ctx, req.(*GroupFindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListAttackPaths_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAttackPathsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListAttackPaths(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/ListAttackPaths",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListAttackPaths(ctx, req.(*ListAttackPathsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListBigQueryExports_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBigQueryExportsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListBigQueryExports(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/ListBigQueryExports",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListBigQueryExports(ctx, req.(*ListBigQueryExportsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListFindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListFindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/ListFindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListFindings(ctx, req.(*ListFindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListMuteConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMuteConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListMuteConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/ListMuteConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListMuteConfigs(ctx, req.(*ListMuteConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListNotificationConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNotificationConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListNotificationConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/ListNotificationConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListNotificationConfigs(ctx, req.(*ListNotificationConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListResourceValueConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListResourceValueConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListResourceValueConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/ListResourceValueConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListResourceValueConfigs(ctx, req.(*ListResourceValueConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListSources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListSources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/ListSources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListSources(ctx, req.(*ListSourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListValuedResources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListValuedResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListValuedResources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/ListValuedResources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListValuedResources(ctx, req.(*ListValuedResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_SetFindingState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetFindingStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).SetFindingState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/SetFindingState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).SetFindingState(ctx, req.(*SetFindingStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_SetMute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetMuteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).SetMute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/SetMute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).SetMute(ctx, req.(*SetMuteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateBigQueryExport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBigQueryExportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateBigQueryExport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/UpdateBigQueryExport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateBigQueryExport(ctx, req.(*UpdateBigQueryExportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateExternalSystem_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateExternalSystemRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateExternalSystem(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/UpdateExternalSystem",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateExternalSystem(ctx, req.(*UpdateExternalSystemRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateFinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateFinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/UpdateFinding",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateFinding(ctx, req.(*UpdateFindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateMuteConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMuteConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateMuteConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/UpdateMuteConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateMuteConfig(ctx, req.(*UpdateMuteConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateNotificationConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNotificationConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateNotificationConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/UpdateNotificationConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateNotificationConfig(ctx, req.(*UpdateNotificationConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateResourceValueConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateResourceValueConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateResourceValueConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/UpdateResourceValueConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateResourceValueConfig(ctx, req.(*UpdateResourceValueConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateSecurityMarks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSecurityMarksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateSecurityMarks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/UpdateSecurityMarks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateSecurityMarks(ctx, req.(*UpdateSecurityMarksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v2.SecurityCenter/UpdateSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateSource(ctx, req.(*UpdateSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SecurityCenter_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.securitycenter.v2.SecurityCenter",
	HandlerType: (*SecurityCenterServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "BatchCreateResourceValueConfigs",
			Handler:    _SecurityCenter_BatchCreateResourceValueConfigs_Handler,
		},
		{
			MethodName: "BulkMuteFindings",
			Handler:    _SecurityCenter_BulkMuteFindings_Handler,
		},
		{
			MethodName: "CreateBigQueryExport",
			Handler:    _SecurityCenter_CreateBigQueryExport_Handler,
		},
		{
			MethodName: "CreateFinding",
			Handler:    _SecurityCenter_CreateFinding_Handler,
		},
		{
			MethodName: "CreateMuteConfig",
			Handler:    _SecurityCenter_CreateMuteConfig_Handler,
		},
		{
			MethodName: "CreateNotificationConfig",
			Handler:    _SecurityCenter_CreateNotificationConfig_Handler,
		},
		{
			MethodName: "CreateSource",
			Handler:    _SecurityCenter_CreateSource_Handler,
		},
		{
			MethodName: "DeleteBigQueryExport",
			Handler:    _SecurityCenter_DeleteBigQueryExport_Handler,
		},
		{
			MethodName: "DeleteMuteConfig",
			Handler:    _SecurityCenter_DeleteMuteConfig_Handler,
		},
		{
			MethodName: "DeleteNotificationConfig",
			Handler:    _SecurityCenter_DeleteNotificationConfig_Handler,
		},
		{
			MethodName: "DeleteResourceValueConfig",
			Handler:    _SecurityCenter_DeleteResourceValueConfig_Handler,
		},
		{
			MethodName: "GetBigQueryExport",
			Handler:    _SecurityCenter_GetBigQueryExport_Handler,
		},
		{
			MethodName: "GetSimulation",
			Handler:    _SecurityCenter_GetSimulation_Handler,
		},
		{
			MethodName: "GetValuedResource",
			Handler:    _SecurityCenter_GetValuedResource_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _SecurityCenter_GetIamPolicy_Handler,
		},
		{
			MethodName: "GetMuteConfig",
			Handler:    _SecurityCenter_GetMuteConfig_Handler,
		},
		{
			MethodName: "GetNotificationConfig",
			Handler:    _SecurityCenter_GetNotificationConfig_Handler,
		},
		{
			MethodName: "GetResourceValueConfig",
			Handler:    _SecurityCenter_GetResourceValueConfig_Handler,
		},
		{
			MethodName: "GetSource",
			Handler:    _SecurityCenter_GetSource_Handler,
		},
		{
			MethodName: "GroupFindings",
			Handler:    _SecurityCenter_GroupFindings_Handler,
		},
		{
			MethodName: "ListAttackPaths",
			Handler:    _SecurityCenter_ListAttackPaths_Handler,
		},
		{
			MethodName: "ListBigQueryExports",
			Handler:    _SecurityCenter_ListBigQueryExports_Handler,
		},
		{
			MethodName: "ListFindings",
			Handler:    _SecurityCenter_ListFindings_Handler,
		},
		{
			MethodName: "ListMuteConfigs",
			Handler:    _SecurityCenter_ListMuteConfigs_Handler,
		},
		{
			MethodName: "ListNotificationConfigs",
			Handler:    _SecurityCenter_ListNotificationConfigs_Handler,
		},
		{
			MethodName: "ListResourceValueConfigs",
			Handler:    _SecurityCenter_ListResourceValueConfigs_Handler,
		},
		{
			MethodName: "ListSources",
			Handler:    _SecurityCenter_ListSources_Handler,
		},
		{
			MethodName: "ListValuedResources",
			Handler:    _SecurityCenter_ListValuedResources_Handler,
		},
		{
			MethodName: "SetFindingState",
			Handler:    _SecurityCenter_SetFindingState_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _SecurityCenter_SetIamPolicy_Handler,
		},
		{
			MethodName: "SetMute",
			Handler:    _SecurityCenter_SetMute_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _SecurityCenter_TestIamPermissions_Handler,
		},
		{
			MethodName: "UpdateBigQueryExport",
			Handler:    _SecurityCenter_UpdateBigQueryExport_Handler,
		},
		{
			MethodName: "UpdateExternalSystem",
			Handler:    _SecurityCenter_UpdateExternalSystem_Handler,
		},
		{
			MethodName: "UpdateFinding",
			Handler:    _SecurityCenter_UpdateFinding_Handler,
		},
		{
			MethodName: "UpdateMuteConfig",
			Handler:    _SecurityCenter_UpdateMuteConfig_Handler,
		},
		{
			MethodName: "UpdateNotificationConfig",
			Handler:    _SecurityCenter_UpdateNotificationConfig_Handler,
		},
		{
			MethodName: "UpdateResourceValueConfig",
			Handler:    _SecurityCenter_UpdateResourceValueConfig_Handler,
		},
		{
			MethodName: "UpdateSecurityMarks",
			Handler:    _SecurityCenter_UpdateSecurityMarks_Handler,
		},
		{
			MethodName: "UpdateSource",
			Handler:    _SecurityCenter_UpdateSource_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/securitycenter/v2/securitycenter_service.proto",
}
