// Code generated by smithy-go-codegen DO NOT EDIT.

package mturk

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mturk/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	The UpdateQualificationType operation modifies the attributes of an existing
//
// Qualification type, which is represented by a QualificationType data structure.
// Only the owner of a Qualification type can modify its attributes.
//
// Most attributes of a Qualification type can be changed after the type has been
// created. However, the Name and Keywords fields cannot be modified. The
// RetryDelayInSeconds parameter can be modified or added to change the delay or to
// enable retries, but RetryDelayInSeconds cannot be used to disable retries.
//
// You can use this operation to update the test for a Qualification type. The
// test is updated based on the values specified for the Test,
// TestDurationInSeconds and AnswerKey parameters. All three parameters specify the
// updated test. If you are updating the test for a type, you must specify the Test
// and TestDurationInSeconds parameters. The AnswerKey parameter is optional;
// omitting it specifies that the updated test does not have an answer key.
//
// If you omit the Test parameter, the test for the Qualification type is
// unchanged. There is no way to remove a test from a Qualification type that has
// one. If the type already has a test, you cannot update it to be AutoGranted. If
// the Qualification type does not have a test and one is provided by an update,
// the type will henceforth have a test.
//
// If you want to update the test duration or answer key for an existing test
// without changing the questions, you must specify a Test parameter with the
// original questions, along with the updated values.
//
// If you provide an updated Test but no AnswerKey, the new test will not have an
// answer key. Requests for such Qualifications must be granted manually.
//
// You can also update the AutoGranted and AutoGrantedValue attributes of the
// Qualification type.
func (c *Client) UpdateQualificationType(ctx context.Context, params *UpdateQualificationTypeInput, optFns ...func(*Options)) (*UpdateQualificationTypeOutput, error) {
	if params == nil {
		params = &UpdateQualificationTypeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateQualificationType", params, optFns, c.addOperationUpdateQualificationTypeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateQualificationTypeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateQualificationTypeInput struct {

	// The ID of the Qualification type to update.
	//
	// This member is required.
	QualificationTypeId *string

	// The answers to the Qualification test specified in the Test parameter, in the
	// form of an AnswerKey data structure.
	AnswerKey *string

	// Specifies whether requests for the Qualification type are granted immediately,
	// without prompting the Worker with a Qualification test.
	//
	// Constraints: If the Test parameter is specified, this parameter cannot be true.
	AutoGranted *bool

	// The Qualification value to use for automatically granted Qualifications. This
	// parameter is used only if the AutoGranted parameter is true.
	AutoGrantedValue *int32

	// The new description of the Qualification type.
	Description *string

	// The new status of the Qualification type - Active | Inactive
	QualificationTypeStatus types.QualificationTypeStatus

	// The amount of time, in seconds, that Workers must wait after requesting a
	// Qualification of the specified Qualification type before they can retry the
	// Qualification request. It is not possible to disable retries for a Qualification
	// type after it has been created with retries enabled. If you want to disable
	// retries, you must dispose of the existing retry-enabled Qualification type using
	// DisposeQualificationType and then create a new Qualification type with retries
	// disabled using CreateQualificationType.
	RetryDelayInSeconds *int64

	// The questions for the Qualification test a Worker must answer correctly to
	// obtain a Qualification of this type. If this parameter is specified,
	// TestDurationInSeconds must also be specified.
	//
	// Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data
	// structure. This parameter cannot be specified if AutoGranted is true.
	//
	// Constraints: None. If not specified, the Worker may request the Qualification
	// without answering any questions.
	Test *string

	// The number of seconds the Worker has to complete the Qualification test,
	// starting from the time the Worker requests the Qualification.
	TestDurationInSeconds *int64

	noSmithyDocumentSerde
}

type UpdateQualificationTypeOutput struct {

	//  Contains a QualificationType data structure.
	QualificationType *types.QualificationType

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateQualificationTypeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateQualificationType{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateQualificationType{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateQualificationType"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateQualificationTypeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateQualificationType(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateQualificationType(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateQualificationType",
	}
}
