// Code generated by smithy-go-codegen DO NOT EDIT.

package inspector2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/inspector2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists Amazon Inspector coverage statistics for your environment.
func (c *Client) ListCoverageStatistics(ctx context.Context, params *ListCoverageStatisticsInput, optFns ...func(*Options)) (*ListCoverageStatisticsOutput, error) {
	if params == nil {
		params = &ListCoverageStatisticsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCoverageStatistics", params, optFns, c.addOperationListCoverageStatisticsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCoverageStatisticsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCoverageStatisticsInput struct {

	// An object that contains details on the filters to apply to the coverage data
	// for your environment.
	FilterCriteria *types.CoverageFilterCriteria

	// The value to group the results by.
	GroupBy types.GroupKey

	// A token to use for paginating results that are returned in the response. Set
	// the value of this parameter to null for the first request to a list action. For
	// subsequent calls, use the NextToken value returned from the previous request to
	// continue listing results after the first page.
	NextToken *string

	noSmithyDocumentSerde
}

type ListCoverageStatisticsOutput struct {

	// The total number for all groups.
	//
	// This member is required.
	TotalCounts *int64

	// An array with the number for each group.
	CountsByGroup []types.Counts

	// A token to use for paginating results that are returned in the response. Set
	// the value of this parameter to null for the first request to a list action. For
	// subsequent calls, use the NextToken value returned from the previous request to
	// continue listing results after the first page.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCoverageStatisticsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListCoverageStatistics{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListCoverageStatistics{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCoverageStatistics"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListCoverageStatisticsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCoverageStatistics(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListCoverageStatisticsAPIClient is a client that implements the
// ListCoverageStatistics operation.
type ListCoverageStatisticsAPIClient interface {
	ListCoverageStatistics(context.Context, *ListCoverageStatisticsInput, ...func(*Options)) (*ListCoverageStatisticsOutput, error)
}

var _ ListCoverageStatisticsAPIClient = (*Client)(nil)

// ListCoverageStatisticsPaginatorOptions is the paginator options for
// ListCoverageStatistics
type ListCoverageStatisticsPaginatorOptions struct {
	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCoverageStatisticsPaginator is a paginator for ListCoverageStatistics
type ListCoverageStatisticsPaginator struct {
	options   ListCoverageStatisticsPaginatorOptions
	client    ListCoverageStatisticsAPIClient
	params    *ListCoverageStatisticsInput
	nextToken *string
	firstPage bool
}

// NewListCoverageStatisticsPaginator returns a new ListCoverageStatisticsPaginator
func NewListCoverageStatisticsPaginator(client ListCoverageStatisticsAPIClient, params *ListCoverageStatisticsInput, optFns ...func(*ListCoverageStatisticsPaginatorOptions)) *ListCoverageStatisticsPaginator {
	if params == nil {
		params = &ListCoverageStatisticsInput{}
	}

	options := ListCoverageStatisticsPaginatorOptions{}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCoverageStatisticsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCoverageStatisticsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCoverageStatistics page.
func (p *ListCoverageStatisticsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCoverageStatisticsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	result, err := p.client.ListCoverageStatistics(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListCoverageStatistics(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCoverageStatistics",
	}
}
