// Code generated by smithy-go-codegen DO NOT EDIT.

package glue

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/glue/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Allows a third-party analytical engine to retrieve unfiltered table metadata
// from the Data Catalog.
//
// For IAM authorization, the public IAM action associated with this API is
// glue:GetTable .
func (c *Client) GetUnfilteredTableMetadata(ctx context.Context, params *GetUnfilteredTableMetadataInput, optFns ...func(*Options)) (*GetUnfilteredTableMetadataOutput, error) {
	if params == nil {
		params = &GetUnfilteredTableMetadataInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetUnfilteredTableMetadata", params, optFns, c.addOperationGetUnfilteredTableMetadataMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetUnfilteredTableMetadataOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetUnfilteredTableMetadataInput struct {

	// The catalog ID where the table resides.
	//
	// This member is required.
	CatalogId *string

	// (Required) Specifies the name of a database that contains the table.
	//
	// This member is required.
	DatabaseName *string

	// (Required) Specifies the name of a table for which you are requesting metadata.
	//
	// This member is required.
	Name *string

	// Indicates the level of filtering a third-party analytical engine is capable of
	// enforcing when calling the GetUnfilteredTableMetadata API operation. Accepted
	// values are:
	//
	//   - COLUMN_PERMISSION - Column permissions ensure that users can access only
	//   specific columns in the table. If there are particular columns contain sensitive
	//   data, data lake administrators can define column filters that exclude access to
	//   specific columns.
	//
	//   - CELL_FILTER_PERMISSION - Cell-level filtering combines column filtering
	//   (include or exclude columns) and row filter expressions to restrict access to
	//   individual elements in the table.
	//
	//   - NESTED_PERMISSION - Nested permissions combines cell-level filtering and
	//   nested column filtering to restrict access to columns and/or nested columns in
	//   specific rows based on row filter expressions.
	//
	//   - NESTED_CELL_PERMISSION - Nested cell permissions combines nested permission
	//   with nested cell-level filtering. This allows different subsets of nested
	//   columns to be restricted based on an array of row filter expressions.
	//
	// Note: Each of these permission types follows a hierarchical order where each
	// subsequent permission type includes all permission of the previous type.
	//
	// Important: If you provide a supported permission type that doesn't match the
	// user's level of permissions on the table, then Lake Formation raises an
	// exception. For example, if the third-party engine calling the
	// GetUnfilteredTableMetadata operation can enforce only column-level filtering,
	// and the user has nested cell filtering applied on the table, Lake Formation
	// throws an exception, and will not return unfiltered table metadata and data
	// access credentials.
	//
	// This member is required.
	SupportedPermissionTypes []types.PermissionType

	// A structure containing Lake Formation audit context information.
	AuditContext *types.AuditContext

	// The resource ARN of the view.
	ParentResourceArn *string

	// The Lake Formation data permissions of the caller on the table. Used to
	// authorize the call when no view context is found.
	Permissions []types.Permission

	// A structure used as a protocol between query engines and Lake Formation or
	// Glue. Contains both a Lake Formation generated authorization identifier and
	// information from the request's authorization context.
	QuerySessionContext *types.QuerySessionContext

	// Specified only if the base tables belong to a different Amazon Web Services
	// Region.
	Region *string

	// The resource ARN of the root view in a chain of nested views.
	RootResourceArn *string

	// A structure specifying the dialect and dialect version used by the query engine.
	SupportedDialect *types.SupportedDialect

	noSmithyDocumentSerde
}

type GetUnfilteredTableMetadataOutput struct {

	// A list of column names that the user has been granted access to.
	AuthorizedColumns []string

	// A list of column row filters.
	CellFilters []types.ColumnRowFilter

	// Specifies whether the view supports the SQL dialects of one or more different
	// query engines and can therefore be read by those engines.
	IsMultiDialectView bool

	// A flag that instructs the engine not to push user-provided operations into the
	// logical plan of the view during query planning. However, if set this flag does
	// not guarantee that the engine will comply. Refer to the engine's documentation
	// to understand the guarantees provided, if any.
	IsProtected bool

	// A Boolean value that indicates whether the partition location is registered
	// with Lake Formation.
	IsRegisteredWithLakeFormation bool

	// The Lake Formation data permissions of the caller on the table. Used to
	// authorize the call when no view context is found.
	Permissions []types.Permission

	// A cryptographically generated query identifier generated by Glue or Lake
	// Formation.
	QueryAuthorizationId *string

	// The resource ARN of the parent resource extracted from the request.
	ResourceArn *string

	// The filter that applies to the table. For example when applying the filter in
	// SQL, it would go in the WHERE clause and can be evaluated by using an AND
	// operator with any other predicates applied by the user querying the table.
	RowFilter *string

	// A Table object containing the table metadata.
	Table *types.Table

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetUnfilteredTableMetadataMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetUnfilteredTableMetadata{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetUnfilteredTableMetadata{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetUnfilteredTableMetadata"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetUnfilteredTableMetadataValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetUnfilteredTableMetadata(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetUnfilteredTableMetadata(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetUnfilteredTableMetadata",
	}
}
