/*
 * Copyright (C) 2023 Chris Talbot
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <adwaita.h>

G_BEGIN_DECLS

#define GEOCLUE_STUMBLER_TYPE_STATS_PAGE (geoclue_stumbler_stats_page_get_type())
G_DECLARE_FINAL_TYPE (GeoclueStumblerStatsPage, geoclue_stumbler_stats_page, GEOCLUE_STUMBLER, STATS_PAGE, AdwBin)

void geoclue_stumbler_stats_page_new_submission (GeoclueStumblerStatsPage *self,
                                                 const char *json_contents,
                                                 gboolean    first_load);

void geoclue_stumbler_stats_reset_submissions (GeoclueStumblerStatsPage *self);

unsigned int geoclue_stumbler_stats_get_queued_submission_count (GeoclueStumblerStatsPage *self);

void geoclue_stumbler_stats_update_total_submission_label (GeoclueStumblerStatsPage *self);
void geoclue_stumbler_stats_page_new_upload (GeoclueStumblerStatsPage *self);

void geoclue_stumbler_stats_page_set_maps_page (GeoclueStumblerStatsPage *self,
                                                GtkWidget                *maps_page_bin);

G_END_DECLS
