/*
 * Copyright (c) 2024, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package jdk.internal.event;

/**
 * Event recording file reads.
 */
public final class FileReadEvent extends Event {

    // The order of these fields must be the same as the parameters in
    // commit(..., String, long, boolean)
    public String path;
    public long bytesRead;
    public boolean endOfFile;

    public static boolean enabled() {
        // Generated by JFR
        return false;
    }

    public static long timestamp() {
        // Generated by JFR
        return 0L;
    }

    public static boolean shouldThrottleCommit(long duration, long end) {
        // Generated by JFR
        return false;
    }

    /**
     * Helper method to offer the data needed to potentially commit an event.
     * The duration of the operation is computed using the current
     * timestamp and the given start time. If the duration meets
     * or exceeds the configured value and is not throttled (determined by calling the
     * generated method {@link #shouldThrottleCommit(long, long)}), an event will be
     * emitted by calling {@link #commit(long, long, String, long, boolean)}
     *
     * @param start  the start time
     * @param path  the path
     * @param bytesRead  the number of bytes that were read, or -1 if the end of the file was reached
     */
    public static void offer(long start, String path, long bytesRead) {
        long end = timestamp();
        long duration = end - start;
        if (shouldThrottleCommit(duration, end)) {
            boolean endOfFile = bytesRead < 0;
            long bytes = endOfFile ? 0 : bytesRead;
            commit(start, duration, path, bytes, endOfFile);
        }
    }

    public static void commit(long start, long duration, String path, long bytesRead, boolean endOfFile) {
        // Generated by JFR
    }
}
