/*******************************************************************************
 * Copyright (c) Erik Kunze 1995 - 1999
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Erik Kunze
 *
 * $Id: acconfig.h,v 1.15 1999/05/11 17:28:23 erik Rel $
 ******************************************************************************/

#ifndef _XZX_CONFIG_H
#define _XZX_CONFIG_H

#include <X11/keysym.h>

/********************************************************************************
 * General configuration
 *******************************************************************************/

/* Defines the package name. */
#define PACKAGE			"noname"

/* Defines the version number. */
#define VERSION			"0.0.0"

/* Defines the build date. */
#define DATE			"00/00/00"

/* Defines the host, where the program should run. */
#define HOST			"unknown"

/* Where the X11 app-defaults directory is. */
#define USRLIBDIR		"/usr/lib/X11"

/* Where the configuration files and ROM images are installed. */
#define LIBDIR			"/usr/local/lib/xzx"

/* Compile without assert() calls. */
#undef NDEBUG

/* The file z80.c contains the code for the emulation of the Z80, which itself
   is a huge switch statement.  With optimizations turned on, CC needs a huge
   amount of memory in order to compile/optimize this code.  Undefine this
   if you run out of swap space. */
#define HAVE_ENOUGH_SWAP

/********************************************************************************
 * Configuration valid for both shareware and registered version
 *******************************************************************************/

/* Define this for Spectrum +3 emulation support. */
#define XZX_PLUS3

/* Define this for Pentagon emulation support. */
#define XZX_PENTAGON

/* Define this for Scorpion emulation support. */
#undef XZX_SCORPION

/* Define this for Shadow ROM and Microdrive support. */
#undef XZX_IF1

/* How many microrives are there (1-8)? */
#define IF1_DRIVES		2

/* Define this for Multiface 128/3 support.  You need an image of the Multiface
   ROM.  The built-in debugger is a good replacement for the Multiface, so you
   should not have any reason to turn the emulation on. */
#undef XZX_MF

/* Define this for Kempston mouse support. At the moment only used from the
   Pentagon and Scorpion emulation. */
#undef XZX_KMOUSE

/* Audio support (automatically adjusted by 'configure').
   Choose the audio support type you want.  You must not combine XBELL_AUDIO
   with any other, but you can define both SPEAKER_AUDIO and AYCHIP_AUDIO. */

/* Emulate speaker via /dev/dsp or /dev/audio. */
#undef SPEAKER_AUDIO

/* Emulate AY chip via /dev/dsp or /dev/audio. */
#undef AYCHIP_AUDIO

/* Emulate ROM beeps only via X server bell (most platforms). */
#undef XBELL_AUDIO

/* Joystick support (automatically adjusted by 'configure').
   You need Linux/FreeBSD with a joystick driver. */
#undef JOY

/* Emulate ULA delay: slows down emulation. Use with care. */
#define EMULATE_ULA_DELAY

/* Warn if a 48k program accesses ports from the 128K machinery. */
#define PEDANTIC

/* Define this to connect I/O ports to stdin, stdout & stderr. */
#undef PSEUDO_IO


/********************************************************************************
 * Configuration valid for the sharware version only
 *******************************************************************************/

/* Define the key to use as ESCAPE in the OSD's.  Change this if your keyboard
   lacks the ESC key (X11/keysym.h). */
#define ESCAPE			XK_Escape

/* OffiX drag 'n' drop support (automatically adjusted by 'configure').
   See http://leb.net/OffiX */
#undef OFFIX_DND


/********************************************************************************
 * Configuration valid for the registered version only
 *******************************************************************************/

/* Define this for BetaDisk 128 (TR-DOS) emulation support. */
#define XZX_TRDOS

/* Define this for +D emulation support. */
#undef XZX_MGT

/* Printer support.
   Choose the printer support type you want. */

/* Emulate ZX printer (not supported yet) */
#undef ZX_PRINTER

/* Emulate Interface I printer (not supported yet) */
#undef IF1_PRINTER

/* Emulate +3 centronics printer */
#undef PLUS3_PRINTER

/* Emulate ACB Stereo hardware for AY chip. */
#undef STEREO_AUDIO


/********************************************************************************
 * Do not change anything below this line
 *******************************************************************************/

/* Define this if Xlib has the MITSHM extension. */
#undef HAVE_MITSHM

/* Define this if program can query MITSHM extension. */
#undef HAVE_SHMQUERY

/* Path relative to /usr/include for header file soundcard.h. */
#undef SOUNDCARD_H_PATH

/* Path relative to /usr/include for header file joystick.h. */
#undef JOYSTICK_H_PATH

/* Define this if NAS is used for the sound emulation. */
#undef NAS_AUDIO

/* Define this if OSS is used for the sound emulation. */
#undef OSS_AUDIO

/* Define this on IRIX machines if the alXXX functions are available. */
#undef HAVE_al_FUNCS

@TOP@
@BOTTOM@

#include "config2.h"

#endif /* ! _XZX_CONFIG_H */

/* EOF *************************************************************************/
