/*
Copyright (C) 2001, 2006 United States Government
as represented by the Administrator of the
National Aeronautics and Space Administration.
All Rights Reserved.
*/
package gov.nasa.worldwind.globes;

/**
 * @author Patrick Murris
 * @version $Id: Moon.java 5189 2008-04-27 04:06:56Z patrickmurris $
 */

public class Moon extends EllipsoidalGlobe
{
    // From http://en.wikipedia.org/wiki/Moon
    public static final double WGS84_EQUATORIAL_RADIUS = 1738140.0; // ellipsoid equatorial getRadius, in meters
    public static final double WGS84_POLAR_RADIUS = 1735970.0; // ellipsoid polar getRadius, in meters
    public static final double WGS84_ES = 0.00125; // eccentricity squared, semi-major axis

    public Moon()
    {
        super(WGS84_EQUATORIAL_RADIUS, WGS84_POLAR_RADIUS, WGS84_ES, new MoonElevationModel());
    }
}