/*
 * StatusBar widget
 *
 * created: apesen, 19961201
 *
 * changed: apesen, 19970206
 * changed: mpichler, 19970807
 * changed: jwolte, 19970904
 *
 * $Id: StatusBar.java,v 1.4 1997/09/19 15:43:14 mpichler Exp $
 */


package iicm.widgets;

import java.awt.*;
import java.util.*;


/**
 * StatusBar - manage multiple status lines
 */

public class StatusBar extends Panel
{
  private Vector statusbar = new Vector ();
  private CardLayout layout_;
  Progress progress;

  public StatusBar ()
  {
    setLayout (layout_ = new CardLayout ());
  }

  public void addBar (String st, Container bar)
  {
    statusbar.addElement (bar);
    add (st, bar);
  }

  public void next ()
  {
    layout_.next (this);
  }

  public void previous ()
  {
    layout_.previous (this);
  }

  public void first ()
  {
    layout_.first (this);
  }

  public void last ()
  {
    layout_.last (this);
  }

  /**
   * set label msg of in given field of given card.
   * @return flag whether text component or button was found
   */

  public boolean setLabel (int card, int field, String msg)
  {
    try
    {
      Container bar = (Container) statusbar.elementAt (card);
      Component item = bar.getComponent (field);
      if (item instanceof TextComponent)
      {
        ((TextComponent) item).setText (msg);
        // this hack makes too long lables left justified, but empties the system clipboard.
        // We apologize for the inconvenience
        ((TextComponent) item).select (0, 0);
        return true;
      }
      if (item instanceof Button)
      {
        ((Button) item).setLabel (msg);
        return true;
      }
    }
    catch (Exception e)  { }

    return false;
  } // setLabel

}; // StatusBar
