/*
 * ImageButton.java - image button
 *
 * created: mpichler, 19970925
 *
 * changed: mpichler, 19970925
 *
 * $Id: ImageCanvas.java,v 1.1 1997/09/25 13:35:15 mpichler Exp $
 */


package iicm.widgets;

import java.awt.*;
import java.awt.image.*;


/**
 * ImageCanvas - canvas showing an image
 */

public class ImageCanvas extends Canvas
{
  private Image img_;
  private int width_, height_;
  boolean ready_;
  private Dimension dim_;


  public ImageCanvas (Image img)
  {
    img_ = img;
    width_ = img.getWidth (this);
    height_ = img.getHeight (this);
    ready_ = (width_ > 0 && height_ > 0);
    dim_ = new Dimension (width_ > 0 ? width_ : 1, height_ > 0 ? height_ : 1);
  }

  public Dimension minimumSize ()
  {
    return dim_;
  }

  public Dimension preferredSize ()
  {
    return dim_;
  }

  public void update (Graphics gc)
  {
    if (ready_)
      paint (gc);
    else
      super.update (gc);
  }

  public void paint (Graphics gc)
  {
    if (!ready_)
      return;

    gc.drawImage (img_, 0, 0, this);
  }

} // ImageCanvas
