package test.contrib.bug334;

import javax.swing.table.AbstractTableModel;

public class TableModel extends AbstractTableModel {

	// for serialization
	private static final long serialVersionUID = -8419507524443534049L;

	private int rows;

	private int columns;

	public TableModel(int rows, int columns) {
		this.rows = rows;
		this.columns = columns;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.table.TableModel#getColumnCount()
	 */
	public int getColumnCount() {
		return rows;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.table.TableModel#getRowCount()
	 */
	public int getRowCount() {
		return columns;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.table.TableModel#getValueAt(int, int)
	 */
	public Object getValueAt(int rowIndex, int columnIndex) {
		return (char) ('A' + columnIndex) + String.valueOf(rowIndex);
	}

}
