package test.contrib;

import java.awt.BorderLayout;
import java.io.File;
import java.lang.reflect.Method;
import java.net.*;

import javax.swing.*;

/**
 * 
 */
public class MemLeakInLAFTest {
	public void run() {
		JFrame mainFrame = new JFrame("Memory Leak Test");
		mainFrame.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);

		JPanel content = new JPanel(new BorderLayout());
		mainFrame.setContentPane(content);

		mainFrame.setLocation(300, 200);
		mainFrame.setSize(300, 200);
		mainFrame.setVisible(true);

		int i = 1;
		while (true) {
			System.out.println(i++);

			DemoClassLoader classLoader = new DemoClassLoader(getClass()
					.getClassLoader());

			try {
				Class swingSet2Class = classLoader.loadClass("SwingSet2Applet");

				Method initMethod = swingSet2Class.getMethod("init",
						new Class[] {});
				Method startMethod = swingSet2Class.getMethod("start",
						new Class[] {});
				Method stopMethod = swingSet2Class.getMethod("stop",
						new Class[] {});
				Method destroyMethod = swingSet2Class.getMethod("destroy",
						new Class[] {});

				JApplet applet = (JApplet) swingSet2Class.newInstance();

				initMethod.invoke(applet, new Object[] {});
				startMethod.invoke(applet, new Object[] {});
				content.add(applet, BorderLayout.CENTER);
				content.revalidate();

				Thread.sleep(5000);

				content.removeAll();

				stopMethod.invoke(applet, new Object[] {});
				destroyMethod.invoke(applet, new Object[] {});
			} catch (Exception ex) {
				ex.printStackTrace();
			}
		}
	}

	public static void main(String[] args) {
		new MemLeakInLAFTest().run();
	}

	private static class DemoClassLoader extends URLClassLoader {
		DemoClassLoader(ClassLoader parent) {
			super(new URL[] {}, parent);

			try {
				addURL(new File("SwingSet2.jar").toURI().toURL());
			} catch (MalformedURLException ex) {
				ex.printStackTrace();
			}
		}
	}
}
