/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.jvnet.substance.theme.transform;

import java.awt.Color;

import org.jvnet.substance.theme.SubstanceTheme;

/**
 * Theme transformation that shifts the original theme.
 * 
 * @author Kirill Grouchnikov
 */
public class ShiftTransform implements ThemeTransform {
	/**
	 * Shift color for background colors. Should have full opacity.
	 */
	private Color backgroundShiftColor;

	/**
	 * Value in 0.0...1.0 range. Larger values shift more towards the specified
	 * color.
	 */
	private double backgroundShiftFactor;

	/**
	 * Shift color for foreground colors. Should have full opacity.
	 */
	private Color foregroundShiftColor;

	/**
	 * Value in 0.0...1.0 range. Larger values shift more towards the specified
	 * color.
	 */
	private double foregroundShiftFactor;

	/**
	 * Creates a new transformation.
	 * 
	 * @param backgroundShiftColor
	 *            Shift color for background colors. Should have full opacity.
	 * @param backgroundShiftFactor
	 *            Value in 0.0...1.0 range. Larger values shift more towards the
	 *            specified color.
	 * @param foregroundShiftColor
	 *            Shift color for foreground colors. Should have full opacity.
	 * @param foregroundShiftFactor
	 *            Value in 0.0...1.0 range. Larger values shift more towards the
	 *            specified color.
	 */
	public ShiftTransform(Color backgroundShiftColor,
			double backgroundShiftFactor, Color foregroundShiftColor,
			double foregroundShiftFactor) {
		this.backgroundShiftColor = backgroundShiftColor;
		this.backgroundShiftFactor = backgroundShiftFactor;
		this.foregroundShiftColor = foregroundShiftColor;
		this.foregroundShiftFactor = foregroundShiftFactor;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.theme.transform.ThemeTransform#transform(org.jvnet.substance.theme.SubstanceTheme)
	 */
	public SubstanceTheme transform(SubstanceTheme theme) {
		return theme.shift(this.backgroundShiftColor,
				this.backgroundShiftFactor, this.foregroundShiftColor,
				this.foregroundShiftFactor);
	}
}
