/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.jvnet.substance.text;

import java.awt.Graphics;

import javax.swing.text.*;

import org.jvnet.substance.painter.text.SubstanceTextPainter;

/**
 * Custom plain view for painting text components with
 * {@link SubstanceTextPainter}-based approach.
 * 
 * @author Kirill Grouchnikov
 */
public class SubstancePlainView extends PlainView {
	/**
	 * Creates a new view.
	 * 
	 * @param elem
	 *            Text element.
	 */
	public SubstancePlainView(Element elem) {
		super(elem);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.text.PlainView#drawSelectedText(java.awt.Graphics, int,
	 *      int, int, int)
	 */
	@Override
	protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1)
			throws BadLocationException {
		return TextUtilities.drawSelectedText(g, this, this, x, y, p0, p1);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.text.PlainView#drawUnselectedText(java.awt.Graphics,
	 *      int, int, int, int)
	 */
	@Override
	protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1)
			throws BadLocationException {
		return TextUtilities.drawUnselectedText(g, this, this, x, y, p0, p1);
	}
}
