#include <Windows.h>
#include "FL/Fl.H"
#include "FL/fl_ask.H"
#include "FL/x.H"
#include "FL/fl_draw.H"
#include "src/Fl_Font.H"


extern HDC fl_gc;
extern Fl_Font_Descriptor* fl_fontsize;

void MG_fl_draw(const char *txt, int x, int y)
/* it is reprogrammed because in FLTK 1.3 text is output one char at a time
 and this is not convenient when doing copy/paste
 */
{
	if(txt == NULL) return;
	int n = strlen(txt);
	COLORREF oldColor = SetTextColor(fl_gc, fl_RGB());
	if (fl_fontsize) SelectObject(fl_gc, fl_fontsize->fid);
	WCHAR *wout = new WCHAR[n+5];
	int newl = MultiByteToWideChar(CP_UTF8, 0, txt, n, wout, n + 5);
	TextOutW(fl_gc, x, y, wout, newl);
	delete wout;
	SetTextColor(fl_gc, oldColor);
}

void *MG_PrepareCopy(int w, int h)
/* returns NULL iff error
 */
{
	HDC oldflgc = fl_gc;
	int factor = 32; // empirically set
	RECT rect; rect.left = 0; rect.top = 0; rect.right=w*factor; rect.bottom=h*factor;
	fl_gc = CreateEnhMetaFile (NULL, NULL, &rect, NULL);
	if (fl_gc != NULL) {
		SetTextAlign(fl_gc, TA_BASELINE|TA_LEFT);
		SetBkMode(fl_gc, TRANSPARENT);
		return oldflgc;
    } 
	else {
		fl_gc = oldflgc;
		return NULL;
	}
}


void MG_CompleteCopy(void *oldflgc)
{
	HENHMETAFILE hmf = CloseEnhMetaFile (fl_gc);
	if ( hmf != NULL ) {
		if ( OpenClipboard (NULL) ){
			EmptyClipboard ();
			SetClipboardData (CF_ENHMETAFILE, hmf);
			CloseClipboard ();
		}
		DeleteEnhMetaFile(hmf);
	}
	fl_gc = (HDC)oldflgc;
}
