;;; Tail-weak tables. This is for internal use only, for real life
;;; applications we have to provide a more general interface with the
;;; 3 combinations of head and tail weakness.

(define make-weak-table make-table)

(define (weak-table-set! table number set-me)
  (table-set! table number (make-weak-pointer set-me)))

(define (weak-table-ref table number)
  (let ((ref (table-ref table number)))
    (if (weak-pointer? ref) (weak-pointer-ref ref) ref)))

(define (weak-table-walk proc table)
  (table-walk
   (lambda (number value)
     (proc number (if (weak-pointer? value) (weak-pointer-ref value) value)))
   table))

(define (strengthen-weak-table-ref table number)
  (table-set! table number (weak-table-ref table number)))

(define (weaken-weak-table-ref table number)
  (weak-table-set! table number (weak-table-ref table number)))
