.TH "figure" 2 " 04 June 1998" "Fractales Group" "Scilab Function"
.so ../sci.an
.SH NAME
figure - create a figure
.SH CALLING SEQUENCE
hn=figure(h, [prop1, value1  ...])
.SH PARAMETERS

.TP
o 
h : integer
Handle of the window to create. If not specified, the first free
handle is used
.TP
o 
prop{1, 2 ...} : character string
name of a property to set
.TP
o 
val{1, 2 ...} : scilab object
value to give to the corresponding property
.TP
o 
hn :
handle of the newly created window
.SH DESCRIPTION

This routine creates a tksci figure (toplevel window). If a handle is
given, the figure corresponding to this handle is created .
Otherwise, the window is created with the first free handle, that is
the lowest integer not already used by a window.  The property named
'position' allows to control the geometrical aspect of the control.
It is a [ 1,4] real vector x y w h where the letters stand for the x
location of the left bottom corner, the y location of the left bottom
corner, the width and the height of the uicontrol.
 
One can also set this property by giving a string where the fields are
separated by a '|', ie "x|y|w|h".
.SH EXAMPLE
.nf
h=figure(3);
// creates  figure number 1.
uicontrol( h, 'style','text', ...
 'string','This is a figure', ...
 'position',[50 70 100 100], ...
 'fontsize',15);
// put a  text in figure 3
figure();
// create figure 1
uicontrol( 'style','text', ...
 'string','Another figure', ...
 'position',[50 70 100 100], ...
 'fontsize',15);
// put a text in figure 1
close();
// close the current graphic window (ie fig. 1)
close(h);
// close figure 3
.fi
.SH SEE ALSO
close, gcf
.SH AUTHOR
Bertrand Guiheneuf
