.TH mfft 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
mfft - multi-dimensional fft
.SH CALLING SEQUENCE
.nf
[xk]=mfft(x,flag,dim)
.fi
.SH PARAMETERS
.TP
x
: \fVx(i,j,k,...)\fR input signal in the form of a row vector
whose values are arranged so that the i index runs the
quickest, followed by the j index, etc.
.TP
flag
: (-1) FFT or (1) inverse FFT
.TP
dim
: dimension vector which gives the number of
values of \fVx\fR for each of its indices
.TP
xk
: output of multidimensional fft in same format as for \fVx\fR
.SH DESCRIPTION
FFT for a multi-dimensional signal

For example for a three dimensional vector which has three points
along its first dimension, two points along its second
dimension and three points along its third dimension the row
vector is arranged as follows
.nf
     x=[x(1,1,1),x(2,1,1),x(3,1,1),
        x(1,2,1),x(2,2,1),x(3,2,1),
              x(1,1,2),x(2,1,2),x(3,1,2),
              x(1,2,2),x(2,2,2),x(3,2,2),
                    x(1,1,3),x(2,1,3),x(3,1,3),
                    x(1,2,3),x(2,2,3),x(3,2,3)]
.fi
and the \fVdim\fR vector is: \fVdim=[3,2,3]\fR
.SH AUTHOR
C. B.
