.TH if 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
if then else - conditional execution
.SH SYNTAX
.nf
if expr1 then statements
elseif expri then statements
  ....
else  statements
end
.fi
.SH DESCRIPTION
The if statement evaluates a logical expression and executes a group
of statements when the expression is true.

The  \fVexpri\fR are expressions with numeric or boolean
values. If \fVexpri\fR are matrix valued the condition is true only if
all matrix entries are true.
.LP
 The optional \fVelseif\fR and \fVelse\fR provide for the
execution of alternate groups of statements. An \fVend\fR keyword,
which matches the \fVif\fR, terminates the last group of
statements. The line structure given above is not significant, the
only constraint is that each \fVthen\fR keyword must be on the same
line line as its corresponding \fVif\fR or \fVelseif\fR keyword.

.LP
The keyword \fVthen\fR can be replaced by a carriage return or a
comma.
.LP
Warning: the number of characters used to define the body of any
conditionnal instruction (if while for or select/case) must be limited to
16k.

.SH EXAMPLE
.nf
   i=2
   for j = 1:3, 
      if i == j then
        a(i,j) = 2; 
      elseif abs(i-j) == 1 then 
        a(i,j) = -1; 
      else a(i,j) = 0;
      end,
   end
.fi
.SH SEE ALSO
while, select, boolean, end, then, else
