.TH getdate 1 "Jun 1999" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
getdate - get date and time information
.SH CALLING SEQUENCE
.nf
dt=getdate()
x=getdate('s')
dt=getdate(x)
.fi
.SH PARAMETERS
.TP
dt
: an integer vector with 8 entries (see below)
.TP
x
: an integer containing a date coded in second from 1 Jan 1970

.SH DESCRIPTION
.TP 2
dt 
=getdate() returns the current date in format given below:
.RS
.TP 5
dt(1)
: The year  as a number (with the century) between 0000 and 9999.
.TP
dt(2)
: The month of the year as a number between 01 and 12.
.TP
dt(3)
: The ISO 8601  week  number  as  a   number between 01 and 53.
.TP
dt(4)
: The Julian day of the year  as a number between 001 and 366.
.TP
dt(5)
: Specifies the weekday as a decimal number [1,7], with 1 representing
Sunday. 
.TP
dt(6)
: The day of the month as a number between 01 and 31.
.TP
dt(7)
: The hour of the day  as a number between 00 and 23.
.TP
dt(8)
: The minute  as a number between 00 and 59.
.TP
dt(9)
: The second is output as a number between 00 and 61.
.RE
.TP
x =getdate('s'), returns a scalar with the number of seconds since Jan
1, 1970, 00:00 UTC (unix time convention)
.TP
dt
=getdate(x) ,format the date given by x (number of seconds since Jan
1, 1970, 00:00 UTC) in format given above:
.SH EXAMPLES
.nf
w=getdate()
mprintf("Year:%d,Month:%d,Day:%d",w(1),w(2),w(6));

x=getdate('s')
getdate(x)

.fi
.SH SEE ALSO
date, timer

