.TH fit_dat 1 "Feb 1998" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
fit_dat - Parameter identification based on measured data
.SH CALLING SEQUENCE
.nf
[p,err]=fit_dat(G,p0,Z [,W] [,pmin,pmax] [,DG])
.fi
.SH PARAMETERS
.TP 10
G
: Scilab function (e=G(p,z), e: nex1, p: npx1, z: nzx1)
.TP
p0
: initial guess (size npx1)
.TP 10
Z
: matrix [z_1,z_2,...z_n] where z_i (nzx1) is the ith measurement
.TP
W
: weighting matrix of size nexne (optional; default 1)
.TP
pmin
: lower bound on p (optional; size npx1)
.TP
pmax
: upper bound on p (optional; size npx1)
.TP
DG
: partial of G wrt p (optional; S=DG(p,z), S: nexnp)
.SH DESCRIPTION
\fVfit_dat\fR is used for fitting data to a model.
For a given function G(p,z), this function finds the best vector 
of parameters p for approximating G(p,z_i)=0 for a set of measurement
vectors z_i. Vector p is found by minimizing
\fVG(p,z_1)'WG(p,z_1)+G(p,z_2)'WG(p,z_2)+...+G(p,z_n)'WG(p,z_n)\fR
.SH EXAMPLE
.nf
deff('y=FF(x)','y=a*(x-b)+c*x.*x')
X=[];Y=[];
a=34;b=12;c=14;for x=0:.1:3, Y=[Y,FF(x)+100*(rand()-.5)];X=[X,x];end
Z=[Y;X];
deff('e=G(p,z)','a=p(1),b=p(2),c=p(3),y=z(1),x=z(2),e=y-FF(x)')
[p,err]=fit_dat(G,[3;5;10],Z)
xset('window',0)
xbasc();
plot2d(X',Y',-1) 
plot2d(X',FF(X)',5,'002')
a=p(1),b=p(2),c=p(3);plot2d(X',FF(X)',12,'002')

a=34;b=12;c=14;
deff('s=DG(p,z)','y=z(1),x=z(2),s=-[x-p(2),-p(1),x*x]')
[p,err]=fit_dat(G,[3;5;10],Z,DG)
xset('window',1)
xbasc();
plot2d(X',Y',-1) 
plot2d(X',FF(X)',5,'002')
a=p(1),b=p(2),c=p(3);plot2d(X',FF(X)',12,'002')
.fi
.SH SEE ALSO
optim, datafit
