.TH cycle_basis 1 "September 1996" "Scilab Group" "Scilab function"
.so ../sci.an
.SH NAME
cycle_basis - basis of cycle of a simple undirected graph
.SH CALLING SEQUENCE
.nf
spc = cycle_basis(g)
.fi
.SH PARAMETERS
.TP 2
g
: graph list
.TP 4
spc
: sparse matrix
.SH DESCRIPTION
First a spanning tree is found by using \fVmin_weight_tree\fR and then used to 
find all fundamental cycles with respect to this tree. They are returned as a 
set of cycles, each cycle being represented by a set of edges.
These cycles are returned in a sparse matrix \fVspc\fR: each line of this
matrix corresponds to a cycle.

The graph \fVg\fR is supposed to be a simple undirected and connected graph
(\fVcycle_basis\fR does not check that the graph is simple, use 
\fVgraph_simp\fR before calling it if necessary).
.SH EXAMPLE
.nf
ta=[1 1 2 2 2 3 4 5 5 7 8 8 9 10 10 10 10 10 11 12 13 13 13 14 15 16 16 17 17];
he=[2 10 3 5 7 4 2 4 6 8 6 9 7 7 11 13 13 15 12 13 9 10 14 11 16 1 17 14 15];
gt=make_graph('foo',1,17,ta,he);
gt('node_x')=[283 163 63 57 164 164 273 271 339 384 504 513 439 623 631 757 642];
gt('node_y')=[59 133 223 318 227 319 221 324 432 141 209 319 428 443 187 151 301];
gt('edge_color')=modulo([1:(edge_number(gt))],15)+1;
gt('node_diam')=[1:(gt('node_number'))]+20;
show_graph(gt);
g=graph_simp(gt);
g('edge_color')=modulo([1:(edge_number(g))],15)+1;
g('node_diam')=gt('node_diam');
g('default_edge_hi_width')=12;
show_graph(g);
spc=cycle_basis(g);
for kk=1:(size(spc,1)),
  aaa=spc(kk,:);aaa=full(aaa);aaa(aaa==0)=[];
  show_arcs(aaa);
end;
.fi
.SH SEE ALSO
min_weight_tree, graph_simp
