.TH legends 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
legends - draw graph legend
.SH CALLING SEQUENCE
.nf
legends(strings,style [,opt])
legends(strings,style,xy)

.fi
.SH PARAMETERS 
.TP 13
strings
: n vector of strings, strings(i) is the legend of the ith curve
.TP
style : 
integer row vector of size n (the plot styles, third parameter
of plot2d) or an integer 2 x n matrix, style(1,k) contains the plot
style for the kth curve and style(2,k) contains the line style (if
style(1,k)>0) or mark color (if style(1,k)<0).
.TP 
opt
.RS
.TP 1
1 
= Upper right-hand corner 
2 
= Upper left-hand corner
.TP
3 
= Lower left-hand corner
.TP
4 
= Lower right-hand corner
.TP
5 
= Interactive placement with the mouse    (default)
.RE
.TP
xy 
: a vector [x,y] which gives the coordinates of the upper left corner
of the legend box.

.SH DESCRIPTION
Puts a legend on the current plot using the specified strings as
labels.
.LP
In the interactive placement (opt=5) move the legend box with the
mouse and press the left button to release it.
.LP
This function allow more flexible placement of the legends than the
leg plot2d argument.

.SH EXAMPLE
.nf
t=0:0.1:2*%pi;
plot2d(t,[cos(t'),cos(2*t'),cos(3*t')],[-1,2 3]);  
legends(['cos(t)';'cos(2*t)';'cos(3*t)'],[-1,2 3],4)
xset("line style",2);plot2d(t,cos(t),style=5);
xset("line style",4);plot2d(t,sin(t),style=3);
legends(["sin(t)";"cos(t)"],[[5;2],[3;4]])
.fi
.SH SEE ALSO
plot2d, xstring, xtitle
