.TH graypolarplot  "April 2000" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
graypolarplot - Polar 2D plot of a surface using colors
.SH CALLING SEQUENCE
.nf
graypolarplot(theta,rho,z,[strf,rect])
.fi
.SH PARAMETERS 
.TP 7
rho
: a vector with  size n1, the discretization of the radius 
.TP 
theta
: a vector with  size n2, the discretization of the the angle.
.TP 
z
: real matrix of size (n1,n2). \fVz(i,j)\fR is the value of the surface at 
the point (rho(i),theta(j)).

.TP
strf
: is a string of length 3 \fV"xy0"\fR.
.RS
.TP
The default is \fV"030"\fR.
.TP 3
x
: controls the display of captions.
.RS
.TP 5
x=0
: no captions.
.TP
x=1
: captions are displayed. They are given by the optional argument \fVleg\fR.
.RE
.TP
y
: controls the computation of the frame.
.RS
.TP 5
y=0
: the current boundaries (set by a previous call to another high level
plotting function) are used. Useful when superposing multiple plots.
.TP
y=1
: the optional argument \fVrect\fR is used to specify the boundaries of 
the plot.
.TP
y=2 
: the boundaries of the plot are computed using min and max values of \fVx\fR and \fVy\fR.
.TP
y=3
: like \fVy=1\fR but produces isoview scaling.
.TP
y=4
: like \fVy=2\fR but produces isoview scaling.
.TP
y=5
: like \fVy=1\fR but \fVplot2d\fR can change the boundaries of the plot and 
the ticks of the axes to produce pretty graduations. When the zoom button 
is activated, this mode is used.
.TP
y=6
: like \fVy=2\fR but \fVplot2d\fR can change the boundaries of the plot and 
the ticks of the axes to produce pretty graduations. When the zoom button 
is activated, this mode is used.
.TP
y=7
: like \fVy=5\fR but the scale of the new plot is merged with the 
current scale.
.TP
y=8
: like \fVy=6\fR but the scale of the new plot is merged with the 
current scale.
.RE
.RE
.TP
leg
: a string. It is used when the first character x of argument \fVstrf\fR is 1.
\fVleg\fR has the form \fV"leg1@leg2@...."\fR where \fVleg1\fR, \fVleg2\fR, 
etc. are respectively the captions of the first curve,
of the second curve, etc.

The default is \fV" "\fR.
.TP
rect
: This argument is used when the second character y of argument \fVstrf\fR is 1,
3 or 5. It is a row vector of size 4 and gives the dimension of the frame: 
\fVrect=[xmin,ymin,xmax,ymax]\fR.
.RE
.LP

.SH DESCRIPTION
Takes a 2D plot of the surface given by \fVz\fR on a polar coordinate
grid defined by \fVrho\fR and \fVtheta\fR. Each grid region if filled
with a gray or color level depending on the average value of \fVz\fR
on the corners of the grid.

.SH EXAMPLES 
.nf

  rho=1:0.1:4;theta=(0:0.02:1)*2*%pi;
  z=30+round(theta'*(1+rho^2));
  xset('colormap',hotcolormap(128))
  xset('background',xget('white'))
  xbasc();graypolarplot(theta,rho,z)
.fi
