.TH fec 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
fec - contour level of a function defined on a triangular mesh 
.SH CALLING SEQUENCE
.nf
fec(x,y,triangles,func,[strf,leg,rect,nax,zminmax,colminmax])
.fi
.SH PARAMETERS
.TP 10
x,y
: two vectors of size \fVn\fR, \fV(x(i),y(i))\fR gives the coordinates of node 
\fVi\fR
.TP
func
: a vector of size \fVn\fR : \fVfunc(i)\fR
gives the value of the function for which we want the level curves.
.TP 
triangles 
: is a \fV[Ntr,5]\fR matrix. Each line of \fVtriangles\fR specifies a triangle of the 
mesh \fVtriangle(j) = [number,node1,node2,node3,flag]\fR.
\fVnode1,node2,node3\fR are the number of the nodes which constitutes the triangle. number is the number of the triangle and flag is an integer not used in the fec function 
.TP
strf,leg,rect,nax  
: see plot2d
.TP
zminmax
: useful only for animation with fec, zminmax is a vector of 
size 2 [zmin zmax] which gives the z values associated with 
the first and the last color (of the current colormap). 
(More exactly if the colormap have nc colors and if we note
dz = (zmax-zmin)/nc, then the part of the triangulation
where  zmin + (i-1)dz <= z < zmin + i dz is filled with the
color i). By default zmin = min(func) and zmax = max(func).
If you want to do an animation with func values that varie
in time, take for zmin and zmax the global minimum and
maximum or something close. 
CAUTION : for func values greather than zmax the last color 
is used and for func values less than zmin this is the first color 
(so you don't see that the zminmax levels are crossed).
.TP
colminmax
: a vector of 2 positives integers colminmax=[colmin colmax]
with 1 <= colmin < colmax <= nc (where nc is the number of
colors of the current colormap). By default all the colors
of the colormap are used but with colminmax you may choose
a sub-part of the (current) colormap.     
.SH DESCRIPTION 
See the demo files \fVdemos/fec\fR.

\fVfec.ex1\fR is a simple demo file in which a mesh and a function 
on that mesh is completely built in Scilab syntax 

\fVfec.ex2\fR is an example for which the mesh and the function value where 
computed by an external mesh builder (amdba type mesh) and an external program.
A set of macros ( provided in file \fVmacros.sci\fR) can be used to read the 
data files in Scilab and plot the results. 
.SH SEE ALSO
Sfgrayplot, Sgrayplot
