.TH sysfact 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
sysfact- system factorization
.SH CALLING SEQUENCE
.nf
[S,Series]=sysfact(Sys,Gain,flag)
.fi
.SH PARAMETERS
.TP 10
Sys
: \fVsyslin\fR list containing the matrices \fV[A,B,C,D]\fR.
.TP
Gain  
: real matrix 
.TP
flag
: string \fV'post'\fR or \fV'pre'\fR
.TP
S
: \fVsyslin\fR list
.TP
Series
: \fVsyslin\fR list
.SH DESCRIPTION
If \fVflag\fR equals \fV'post'\fR, \fVsysfact\fR returns in \fVS\fR the linear 
system with ABCD matrices \fV(A+B*Gain, B , Gain, I)\fR, and   \fVSeries\fR, 
a minimal realization of the series system \fVSys*S\fR.
If \fVflag\fR equals \fV'pre'\fR,  \fVsysfact\fR returns  the linear system
\fV(A+Gain*C, Gain , C, I)\fR and \fVSeries\fR, a minimal realization of the 
series system \fVS*Sys\fR.
.SH AUTHOR
F.D.
.SH EXAMPLE
.nf
//Kalman filter
Sys=ssrand(3,2,4);Sys('D')=rand(3,2);
S=sysfact(Sys,lqr(Sys),'post');
ww=minss(Sys*S);
ss2tf(gtild(ww)*ww),Sys('D')'*Sys('D')
//Kernel
Sys=ssrand(2,3,4);
[X,d,F,U,k,Z]=abinv(Sys);
ss2tf(Sys*Z)
ss2tf(Sys*sysfact(Sys,F,'post')*U)
.fi
.SH SEE ALSO
lqr, lqe


