// File:	StepToGeom_MakeVectorWithMagnitude.cxx
// Created:	Mon Jul  5 11:49:43 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>
// sln 22.10.2001. CTS23496: Vector is not created if direction have not been succesfully created (StepToGeom_MakeVectorWithMagnitude(...) function)

#include <StepToGeom_MakeVectorWithMagnitude.ixx>
#include <StepGeom_Vector.hxx>
#include <StepGeom_Direction.hxx>
#include <StepToGeom_MakeDirection.hxx>
#include <Geom_Direction.hxx>
#include <gp_Dir.hxx>
#include <gp_Vec.hxx>
#include <StdFail_NotDone.hxx>
#include <UnitsMethods.hxx>

//=============================================================================
// Creation d' un VectorWithMagnitude de Geom a partir d' un Vector de Step
//=============================================================================

StepToGeom_MakeVectorWithMagnitude::StepToGeom_MakeVectorWithMagnitude
  ( const Handle(StepGeom_Vector)& V)
{
  Standard_Real M;
  Handle(StepGeom_Direction) D;
  Handle(Geom_Direction)         D1;
  gp_Dir                         D2;
  gp_Vec                         V1;

  D  = V->Orientation();
  StepToGeom_MakeDirection MkDir(D);
  // sln 22.10.2001. CTS23496: Vector is not created if direction have not been succesfully created 
  if(!MkDir.IsDone()) {
    done = Standard_False;
    return;
  }
  D1 = MkDir.Value();
  D2 = D1->Dir();
  V1 = gp_Vec(D2);
  M  = V->Magnitude() * UnitsMethods::LengthFactor();
  V1 = V1*M;
  theVectorWithMagnitude = new Geom_VectorWithMagnitude(V1);
  done = Standard_True;
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom_VectorWithMagnitude) &
      StepToGeom_MakeVectorWithMagnitude::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theVectorWithMagnitude;
}
