// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TDataStd_IntegerArray_HeaderFile
#define _TDataStd_IntegerArray_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_TDataStd_IntegerArray_HeaderFile
#include <Handle_TDataStd_IntegerArray.hxx>
#endif

#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _TDF_Attribute_HeaderFile
#include <TDF_Attribute.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_TDF_Attribute_HeaderFile
#include <Handle_TDF_Attribute.hxx>
#endif
#ifndef _Handle_TDF_RelocationTable_HeaderFile
#include <Handle_TDF_RelocationTable.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class TColStd_HArray1OfInteger;
class Standard_GUID;
class TDF_Label;
class TDF_Attribute;
class TDF_RelocationTable;


//! Contains an array of integers. <br>
class TDataStd_IntegerArray : public TDF_Attribute {

public:
 // Methods PUBLIC
 // 

//! class methods <br>
//!          ============= <br>//! Returns the GUID for arrays of integers. <br>
Standard_EXPORT static const Standard_GUID& GetID() ;

//! Finds or creates an integer array attribute with <br>
//! the lower boundary lower and the upper <br>
//! boundary upper, on the label label. <br>
Standard_EXPORT static  Handle_TDataStd_IntegerArray Set(const TDF_Label& label,const Standard_Integer lower,const Standard_Integer upper) ;

//! Initialize the inner array with bounds from <lower> to <upper> <br>
Standard_EXPORT   void Init(const Standard_Integer lower,const Standard_Integer upper) ;

//! Sets  the   <Index>th  element  of   the  array to <Value> <br>
Standard_EXPORT   void SetValue(const Standard_Integer Index,const Standard_Integer Value) ;

//! Return the value of  the  <Index>th element of the array <br>
Standard_EXPORT   Standard_Integer Value(const Standard_Integer Index) const;
  Standard_Integer operator ()(const Standard_Integer Index) const
{
  return Value(Index);
}


//!  Returns the lower boundary of this array of integers. <br>
Standard_EXPORT   Standard_Integer Lower() const;

//! Return the upper boundary of this array of integers. <br>
Standard_EXPORT   Standard_Integer Upper() const;

//! Returns the length of this array of integers in <br>
//! terms of the number of elements it contains. <br>
Standard_EXPORT   Standard_Integer Length() const;

//! Sets the inner array <myValue>  of the IntegerArray attribute to <br>
//! <newArray>. If value of <newArray> differs from <myValue>, Backup performed <br>
//! and myValue refers to new instance of HArray1OfInteger that holds <newArray> <br>
//! values <br>
Standard_EXPORT   void ChangeArray(const Handle(TColStd_HArray1OfInteger)& newArray) ;

//! Return the inner array of the IntegerArray attribute <br>
Standard_EXPORT   Handle_TColStd_HArray1OfInteger Array() const;


Standard_EXPORT TDataStd_IntegerArray();


Standard_EXPORT  const Standard_GUID& ID() const;


Standard_EXPORT   void Restore(const Handle(TDF_Attribute)& With) ;


Standard_EXPORT   Handle_TDF_Attribute NewEmpty() const;

//! Note. Uses inside ChangeArray() method <br>
Standard_EXPORT   void Paste(const Handle(TDF_Attribute)& Into,const Handle(TDF_RelocationTable)& RT) const;


Standard_EXPORT virtual  Standard_OStream& Dump(Standard_OStream& anOS) const;
//Standard_EXPORT ~TDataStd_IntegerArray();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_TColStd_HArray1OfInteger myValue;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
