// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Interface_FileReaderTool_HeaderFile
#define _Interface_FileReaderTool_HeaderFile

#ifndef _Handle_Interface_Protocol_HeaderFile
#include <Handle_Interface_Protocol.hxx>
#endif
#ifndef _Handle_Interface_FileReaderData_HeaderFile
#include <Handle_Interface_FileReaderData.hxx>
#endif
#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfTransient_HeaderFile
#include <Handle_TColStd_HArray1OfTransient.hxx>
#endif
#ifndef _Handle_Interface_Check_HeaderFile
#include <Handle_Interface_Check.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
class Interface_Protocol;
class Interface_FileReaderData;
class Interface_InterfaceModel;
class TColStd_HArray1OfTransient;
class Standard_DomainError;
class Standard_NoSuchObject;
class Interface_Check;
class Standard_Transient;
class Interface_GeneralLib;
class Interface_ReaderLib;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Defines services which are required to load an InterfaceModel <br>
//!           from a File. Typically, it may firstly transform a system <br>
//!           file into a FileReaderData object, then work on it, not longer <br>
//!           considering file contents, to load an Interface Model. <br>
//!           It may also work on a FileReaderData already loaded. <br>
//! <br>
//!           FileReaderTool provides, on one hand, some general services <br>
//!           which are common to all read operations but can be redefined, <br>
//!           plus general actions to be performed specifically for each <br>
//!           Norm, as deferred methods to define. <br>
//! <br>
//!           In particular, FileReaderTool defines the Interface's Unknown <br>
//!           and Error entities <br>
class Interface_FileReaderTool  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Sets Data to a FileReaderData. Works with a Protocol <br>
Standard_EXPORT   void SetData(const Handle(Interface_FileReaderData)& reader,const Handle(Interface_Protocol)& protocol) ;

//! Returns the Protocol given at creation time <br>
Standard_EXPORT   Handle_Interface_Protocol Protocol() const;

//! Returns the FileReaderData which is used to work <br>
Standard_EXPORT   Handle_Interface_FileReaderData Data() const;

//! Stores a Model. Used when the Model has been loaded <br>
Standard_EXPORT   void SetModel(const Handle(Interface_InterfaceModel)& amodel) ;

//! Returns the stored Model <br>
Standard_EXPORT   Handle_Interface_InterfaceModel Model() const;

//! Allows controlling how exception raisings are handled <br>
//!           If err is False, they are not (hence, dbx can take control) <br>
//!           If err is True, they are, and they are traced if trace is True <br>
//!           (by putting on "cout" Entity's Number and file record num) <br>
//!           Default given at Model's creation time if True, True <br>
Standard_EXPORT   void SetErrorHandle(const Standard_Boolean err,const Standard_Boolean trace = Standard_True) ;

//! Returns values of Error and Trace flags <br>
Standard_EXPORT   void ErrorHandle(Standard_Boolean& err,Standard_Boolean& trace) const;

//! Fills records with empty entities; once done, each entity can <br>
//!           ask the FileReaderTool for any entity referenced through an <br>
//!           identifier. Calls Recognize which is specific to each specific <br>
//!           type of FileReaderTool <br>
Standard_EXPORT   void SetEntities() ;

//! Recognizes a record, given its number. Specific to each <br>
//!           Interface; called by SetEntities. It can call the basic method <br>
//!           RecognizeByLib. <br>
//!           Returns False if recognition has failed, True else. <br>
//!           <ach> has not to be filled if simply Recognition has failed : <br>
//!           it must record true error messages : RecognizeByLib can <br>
//!           generate error messages if NewRead is called <br>
//! <br>
//!           Note that it works thru a Recognizer (method Evaluate) which <br>
//!           has to be memorized before starting <br>
Standard_EXPORT virtual  Standard_Boolean Recognize(const Standard_Integer num,Handle(Interface_Check)& ach,Handle(Standard_Transient)& ent)  = 0;

//! Recognizes a record with the help of Libraries. Can be used <br>
//!           to implement the method Recognize. <br>
//!           <rlib> is used to find Protocol and CaseNumber to apply <br>
//!           <glib> performs the creation (by service NewVoid, or NewRead <br>
//!             if NewVoid gave no result) <br>
//!           <ach> is a check, which is transmitted to NewRead if it is <br>
//!             called, gives a result but which is false <br>
//!           <ent> is the result <br>
//!           Returns False if recognition has failed, True else <br>
Standard_EXPORT   Standard_Boolean RecognizeByLib(const Standard_Integer num,Interface_GeneralLib& glib,Interface_ReaderLib& rlib,Handle(Interface_Check)& ach,Handle(Standard_Transient)& ent) const;

//! Provides an unknown entity, specific to the Interface <br>
//!           called by SetEntities when Recognize has failed (Unknown alone) <br>
//!           or by LoadModel when an Entity has caused a Fail on reading <br>
//!           (to keep at least its literal description) <br>
//!           Uses Protocol to do it <br>
Standard_EXPORT   Handle_Standard_Transient UnknownEntity() const;

//! Creates an empty Model of the norm. Uses Protocol to do it <br>
Standard_EXPORT   Handle_Interface_InterfaceModel NewModel() const;

//! Reads and fills Entities from the FileReaderData set by <br>
//!           SetData to an InterfaceModel. <br>
//!           It enchains required operations, the specific ones correspond <br>
//!           to deferred methods (below) to be defined for each Norm. <br>
//!           It manages also error recovery and trace. <br>
//!           Remark : it calls SetModel. <br>
//!           It Can raise any error which can occur during a load <br>
//!           operation, unless Error Handling is set. <br>
//!           This method can also be redefined if judged necessary. <br>
Standard_EXPORT   void LoadModel(const Handle(Interface_InterfaceModel)& amodel) ;

//! Reads, Fills and Returns one Entity read from a Record of the <br>
//!           FileReaderData. This Method manages also case of Fail or <br>
//!           Warning, by producing a ReportEntyty plus , for a Fail, a <br>
//!           literal Content (as an UnknownEntity). Performs also Trace <br>
Standard_EXPORT   Handle_Standard_Transient LoadedEntity(const Standard_Integer num) ;

//! Fills model's header; each Interface defines for its Model its <br>
//!           own file header; this method fills it from FileReaderTool.+ <br>
//!           It is called by AnalyseFile from InterfaceModel <br>
Standard_EXPORT virtual  void BeginRead(const Handle(Interface_InterfaceModel)& amodel)  = 0;

//! Fills an Entity, given record no; specific to each Interface, <br>
//!           called by AnalyseFile from InterfaceModel (which manages its <br>
//!           calling arguments) <br>
//!           To work, each Interface can define a method in its proper <br>
//!           Transient class, like this (given as an example) : <br>
//!           AnalyseRecord (me  : mutable; FR     : in out FileReaderTool; <br>
//!                          num : Integer; acheck : in out Check) <br>
//!                              returns Boolean; <br>
//!           and call it from AnalyseRecord <br>
//! <br>
//!           Returned Value : True if the entity could be loaded, False <br>
//!             else (in case of syntactic fail) <br>
Standard_EXPORT virtual  Standard_Boolean AnalyseRecord(const Standard_Integer num,const Handle(Standard_Transient)& anent,Handle(Interface_Check)& acheck)  = 0;


Standard_EXPORT virtual  void Destroy() ;
Standard_EXPORT virtual ~Interface_FileReaderTool() { Destroy(); }

//! Ends file reading after reading all the entities <br>
//!           default is doing nothing; redefinable as necessary <br>
Standard_EXPORT virtual  void EndRead(const Handle(Interface_InterfaceModel)& amodel) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Interface_Protocol theproto;
Handle_Interface_FileReaderData thereader;
Handle_Interface_InterfaceModel themodel;
Standard_Boolean theerrhand;
Standard_Boolean theertrace;
Standard_Integer thenbrep0;
Standard_Integer thenbreps;
Handle_TColStd_HArray1OfTransient thereports;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
