// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESSolid_Shell_HeaderFile
#define _IGESSolid_Shell_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESSolid_Shell_HeaderFile
#include <Handle_IGESSolid_Shell.hxx>
#endif

#ifndef _Handle_IGESSolid_HArray1OfFace_HeaderFile
#include <Handle_IGESSolid_HArray1OfFace.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_IGESSolid_Face_HeaderFile
#include <Handle_IGESSolid_Face.hxx>
#endif
class IGESSolid_HArray1OfFace;
class TColStd_HArray1OfInteger;
class Standard_DimensionMismatch;
class Standard_OutOfRange;
class IGESSolid_Face;


//! defines Shell, Type <514> Form Number <1> <br>
//!          in package IGESSolid <br>
//!          Shell entity is a connected entity of dimensionality 2 <br>
//!          which divides R3 into two arcwise connected open subsets, <br>
//!          one of which is finite. Inside of the shell is defined to <br>
//!          be the finite region. <br>
//!          From IGES-5.3, Form can be <1> for Closed or <2> for Open <br>
class IGESSolid_Shell : public IGESData_IGESEntity {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT IGESSolid_Shell();

//! This method is used to set the fields of the class Shell <br>
//!       - allFaces  : the faces comprising the shell <br>
//!       - allOrient : the orientation flags of the shell <br>
//! raises exception if length of allFaces & allOrient do not match <br>
Standard_EXPORT   void Init(const Handle(IGESSolid_HArray1OfFace)& allFaces,const Handle(TColStd_HArray1OfInteger)& allOrient) ;

//! Tells if a Shell is Closed, i.e. if its FormNumber is 1 <br>
//!           (this is the default) <br>
Standard_EXPORT   Standard_Boolean IsClosed() const;

//! Sets or Unsets the Closed status (FormNumber = 1 else 2) <br>
Standard_EXPORT   void SetClosed(const Standard_Boolean closed) ;

//! returns the number of the face entities in the shell <br>
Standard_EXPORT   Standard_Integer NbFaces() const;

//! returns the Index'th face entity of the shell <br>
//! raises exception if Index <= 0 or Index > NbFaces() <br>
Standard_EXPORT   Handle_IGESSolid_Face Face(const Standard_Integer Index) const;

//! returns the orientation of Index'th face w.r.t the direction of <br>
//! the underlying surface <br>
//! raises exception if Index <= 0 or Index > NbFaces() <br>
Standard_EXPORT   Standard_Boolean Orientation(const Standard_Integer Index) const;
//Standard_EXPORT ~IGESSolid_Shell();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_IGESSolid_HArray1OfFace theFaces;
Handle_TColStd_HArray1OfInteger theOrientation;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
