// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESGeom_CurveOnSurface_HeaderFile
#define _IGESGeom_CurveOnSurface_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESGeom_CurveOnSurface_HeaderFile
#include <Handle_IGESGeom_CurveOnSurface.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_IGESData_IGESEntity_HeaderFile
#include <Handle_IGESData_IGESEntity.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
class IGESData_IGESEntity;


//! defines IGESCurveOnSurface, Type <142> Form <0> <br>
//!          in package IGESGeom <br>
//!          A curve on a parametric surface entity associates a given <br>
//!          curve with a surface and identifies the curve as lying on <br>
//!          the surface. <br>
class IGESGeom_CurveOnSurface : public IGESData_IGESEntity {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT IGESGeom_CurveOnSurface();

//! This method is used to set the fields of the class <br>
//!           CurveOnSurface <br>
//!       - aMode       : Way the curve on the surface has been created <br>
//!       - aSurface    : Surface on which the curve lies <br>
//!       - aCurveUV    : Curve S (UV) <br>
//!       - aCurve3D    : Curve C (3D) <br>
//!       - aPreference : 0 = Unspecified <br>
//!                       1 = S o B is preferred <br>
//!                       2 = C is preferred <br>
//!                       3 = C and S o B are equally preferred <br>
Standard_EXPORT   void Init(const Standard_Integer aMode,const Handle(IGESData_IGESEntity)& aSurface,const Handle(IGESData_IGESEntity)& aCurveUV,const Handle(IGESData_IGESEntity)& aCurve3D,const Standard_Integer aPreference) ;

//! returns the mode in which the curve is created on the surface <br>
//! 0 = Unspecified <br>
//! 1 = Projection of a given curve on the surface <br>
//! 2 = Intersection of two surfaces <br>
//! 3 = Isoparametric curve, i.e:- either a `u` parametric <br>
//!     or a `v` parametric curve <br>
Standard_EXPORT   Standard_Integer CreationMode() const;

//! returns the surface on which the curve lies <br>
Standard_EXPORT   Handle_IGESData_IGESEntity Surface() const;

//! returns curve S <br>
Standard_EXPORT   Handle_IGESData_IGESEntity CurveUV() const;

//! returns curve C <br>
Standard_EXPORT   Handle_IGESData_IGESEntity Curve3D() const;

//! returns preference mode <br>
//! 0 = Unspecified <br>
//! 1 = S o B is preferred <br>
//! 2 = C is preferred <br>
//! 3 = C and S o B are equally preferred <br>
Standard_EXPORT   Standard_Integer PreferenceMode() const;
//Standard_EXPORT ~IGESGeom_CurveOnSurface();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer theCreationMode;
Handle_IGESData_IGESEntity theSurface;
Handle_IGESData_IGESEntity theCurveUV;
Handle_IGESData_IGESEntity theCurve3D;
Standard_Integer thePreferenceMode;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
