// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _DDF_Transaction_HeaderFile
#define _DDF_Transaction_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_DDF_Transaction_HeaderFile
#include <Handle_DDF_Transaction.hxx>
#endif

#ifndef _TDF_Transaction_HeaderFile
#include <TDF_Transaction.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Handle_TDF_Data_HeaderFile
#include <Handle_TDF_Data.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_TDF_Delta_HeaderFile
#include <Handle_TDF_Delta.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Standard_DomainError;
class Standard_NullObject;
class TDF_Data;
class TDF_Delta;


//! This class encapsulates TDF_Transaction. <br>
class DDF_Transaction : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Creates an empty transaction context, unable to be <br>
//!          opened. <br>
Standard_EXPORT DDF_Transaction();

//! Creates a transaction context on <aDF>, ready to <br>
//!          be opened. <br>
Standard_EXPORT DDF_Transaction(const Handle(TDF_Data)& aDF);

//! If not yet done, opens a new transaction on <br>
//!          <myDF>. Returns the index of the just opened <br>
//!          transaction. <br>
//! <br>
//!          It raises DomainError if the transaction is <br>
//!          already open, and NullObject if there is no <br>
//!          current Data framework. <br>
Standard_EXPORT   Standard_Integer Open() ;

//! Commits the transactions until AND including the <br>
//!          current opened one. <br>
Standard_EXPORT   Handle_TDF_Delta Commit(const Standard_Boolean withDelta = Standard_False) ;

//! Aborts the transactions until AND including the <br>
//!          current opened one. <br>
//! <br>
Standard_EXPORT   void Abort() ;
~DDF_Transaction()
{
  Abort();
}


//! Returns the Data from TDF. <br>
Standard_EXPORT   Handle_TDF_Data Data() const;

//! Returns the number of the transaction opened by <me>. <br>
Standard_EXPORT   Standard_Integer Transaction() const;

//! Returns true if the transaction is open. <br>
Standard_EXPORT   Standard_Boolean IsOpen() const;




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TDF_Transaction myTransaction;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
