// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepTools_ShapeSet_HeaderFile
#define _BRepTools_ShapeSet_HeaderFile

#ifndef _BRep_Builder_HeaderFile
#include <BRep_Builder.hxx>
#endif
#ifndef _GeomTools_SurfaceSet_HeaderFile
#include <GeomTools_SurfaceSet.hxx>
#endif
#ifndef _GeomTools_CurveSet_HeaderFile
#include <GeomTools_CurveSet.hxx>
#endif
#ifndef _GeomTools_Curve2dSet_HeaderFile
#include <GeomTools_Curve2dSet.hxx>
#endif
#ifndef _TColStd_IndexedMapOfTransient_HeaderFile
#include <TColStd_IndexedMapOfTransient.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopTools_ShapeSet_HeaderFile
#include <TopTools_ShapeSet.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
#ifndef _Standard_IStream_HeaderFile
#include <Standard_IStream.hxx>
#endif
#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
class BRep_Builder;
class TopoDS_Shape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Contains a Shape and all  its subshapes, locations <br>
//!          and geometries. <br>
//! <br>
//!          The topology is inherited from TopTools. <br>
class BRepTools_ShapeSet  : public TopTools_ShapeSet {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Builds an empty ShapeSet. <br>
//!          Parameter <isWithTriangles> is added for XML Persistence <br>
Standard_EXPORT BRepTools_ShapeSet(const Standard_Boolean isWithTriangles = Standard_True);

//! Builds an empty ShapeSet. <br>
//!          Parameter <isWithTriangles> is added for XML Persistence <br>
Standard_EXPORT BRepTools_ShapeSet(const BRep_Builder& B,const Standard_Boolean isWithTriangles = Standard_True);

//! Clears the content of the set. <br>
Standard_EXPORT virtual  void Clear() ;

//! Stores the goemetry of <S>. <br>
Standard_EXPORT virtual  void AddGeometry(const TopoDS_Shape& S) ;

//! Dumps the geometry of me on the stream <OS>. <br>
Standard_EXPORT virtual  void DumpGeometry(Standard_OStream& OS) const;

//! Writes the geometry of  me  on the stream <OS> in a <br>
//!          format that can be read back by Read. <br>
Standard_EXPORT virtual  void WriteGeometry(Standard_OStream& OS) const;

//! Reads the geometry of me from the  stream  <IS>. <br>
Standard_EXPORT virtual  void ReadGeometry(Standard_IStream& IS) ;

//! Dumps the geometry of <S> on the stream <OS>. <br>
Standard_EXPORT virtual  void DumpGeometry(const TopoDS_Shape& S,Standard_OStream& OS) const;

//! Writes the geometry of <S>  on the stream <OS> in a <br>
//!          format that can be read back by Read. <br>
Standard_EXPORT virtual  void WriteGeometry(const TopoDS_Shape& S,Standard_OStream& OS) const;

//! Reads the geometry of a shape of type <T> from the <br>
//!          stream <IS> and returns it in <S>. <br>
Standard_EXPORT virtual  void ReadGeometry(const TopAbs_ShapeEnum T,Standard_IStream& IS,TopoDS_Shape& S) ;

//! Inserts  the shape <S2> in  the  shape <S1>.  This <br>
//!          method must be   redefined  to  use   the  correct <br>
//!          builder. <br>
Standard_EXPORT virtual  void AddShapes(TopoDS_Shape& S1,const TopoDS_Shape& S2) ;


Standard_EXPORT virtual  void Check(const TopAbs_ShapeEnum T,TopoDS_Shape& S) ;

//! Reads the 3d polygons  of me <br>
//!          from the  stream  <IS>. <br>
Standard_EXPORT   void ReadPolygon3D(Standard_IStream& IS) ;

//! Writes the 3d polygons <br>
//!          on the stream <OS> in a format that can <br>
//!          be read back by Read. <br>
Standard_EXPORT   void WritePolygon3D(Standard_OStream& OS,const Standard_Boolean Compact = Standard_True) const;

//! Dumps the 3d polygons <br>
//!          on the stream <OS>. <br>
Standard_EXPORT   void DumpPolygon3D(Standard_OStream& OS) const;

//! Reads the triangulation of me <br>
//!          from the  stream  <IS>. <br>
Standard_EXPORT   void ReadTriangulation(Standard_IStream& IS) ;

//! Writes the triangulation <br>
//!          on the stream <OS> in a format that can <br>
//!          be read back by Read. <br>
Standard_EXPORT   void WriteTriangulation(Standard_OStream& OS,const Standard_Boolean Compact = Standard_True) const;

//! Dumps the triangulation <br>
//!          on the stream <OS>. <br>
Standard_EXPORT   void DumpTriangulation(Standard_OStream& OS) const;

//! Reads the polygons on triangulation of me <br>
//!          from the  stream  <IS>. <br>
Standard_EXPORT   void ReadPolygonOnTriangulation(Standard_IStream& IS) ;

//! Writes the polygons on triangulation <br>
//!          on the stream <OS> in a format that can <br>
//!          be read back by Read. <br>
Standard_EXPORT   void WritePolygonOnTriangulation(Standard_OStream& OS,const Standard_Boolean Compact = Standard_True) const;

//! Dumps the polygons on triangulation <br>
//!          on the stream <OS>. <br>
Standard_EXPORT   void DumpPolygonOnTriangulation(Standard_OStream& OS) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
BRep_Builder myBuilder;
GeomTools_SurfaceSet mySurfaces;
GeomTools_CurveSet myCurves;
GeomTools_Curve2dSet myCurves2d;
TColStd_IndexedMapOfTransient myPolygons2D;
TColStd_IndexedMapOfTransient myPolygons3D;
TColStd_IndexedMapOfTransient myTriangulations;
TColStd_IndexedMapOfTransient myNodes;
Standard_Boolean myWithTriangles;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
