// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepFill_MultiLine_HeaderFile
#define _BRepFill_MultiLine_HeaderFile

#ifndef _TopoDS_Face_HeaderFile
#include <TopoDS_Face.hxx>
#endif
#ifndef _Geom2dAdaptor_Curve_HeaderFile
#include <Geom2dAdaptor_Curve.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Standard_DomainError;
class TopoDS_Face;
class TopoDS_Edge;
class Geom2d_Curve;
class Geom_Curve;
class gp_Pnt;
class gp_Pnt2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Private class used to compute the 3d curve and the <br>
//!          two 2d curves resulting from the intersection of a <br>
//!          surface of linear extrusion( Bissec, Dz) and the 2 <br>
//!          faces. <br>
//!          This 3 curves will  have  the same parametrization <br>
//!          as the Bissectrice. <br>
//!          This  class  is  to  be  send  to an approximation <br>
//!          routine. <br>
class BRepFill_MultiLine  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT BRepFill_MultiLine();


Standard_EXPORT BRepFill_MultiLine(const TopoDS_Face& Face1,const TopoDS_Face& Face2,const TopoDS_Edge& Edge1,const TopoDS_Edge& Edge2,const Standard_Boolean Inv1,const Standard_Boolean Inv2,const Handle(Geom2d_Curve)& Bissec);

//! Search if the Projection of the Bissectrice on the <br>
//!          faces needs an approximation or not. <br>
//!          Returns true if the approximation is not needed. <br>
Standard_EXPORT   Standard_Boolean IsParticularCase() const;

//! Returns   the continuity  betwwen  the two  faces <br>
//!          seShape         from GeomAbsparated by myBis. <br>
Standard_EXPORT   GeomAbs_Shape Continuity() const;

//! raises if IsParticularCase is <False>. <br>
Standard_EXPORT   void Curves(Handle(Geom_Curve)& Curve,Handle(Geom2d_Curve)& PCurve1,Handle(Geom2d_Curve)& PCurve2) const;

//! returns the first parameter of the Bissectrice. <br>
Standard_EXPORT   Standard_Real FirstParameter() const;

//! returns the last parameter of the Bissectrice. <br>
Standard_EXPORT   Standard_Real LastParameter() const;

//! Returns the current point on the 3d curve <br>
Standard_EXPORT   gp_Pnt Value(const Standard_Real U) const;

//! returns the current point on the PCurve of the <br>
//!          first face <br>
Standard_EXPORT   gp_Pnt2d ValueOnF1(const Standard_Real U) const;

//! returns the current point on the PCurve of the <br>
//!          first face <br>
Standard_EXPORT   gp_Pnt2d ValueOnF2(const Standard_Real U) const;


Standard_EXPORT   void Value3dOnF1OnF2(const Standard_Real U,gp_Pnt& P3d,gp_Pnt2d& PF1,gp_Pnt2d& PF2) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopoDS_Face myFace1;
TopoDS_Face myFace2;
Geom2dAdaptor_Curve myU1;
Geom2dAdaptor_Curve myV1;
Geom2dAdaptor_Curve myU2;
Geom2dAdaptor_Curve myV2;
Standard_Boolean myIsoU1;
Standard_Boolean myIsoU2;
Geom2dAdaptor_Curve myBis;
Standard_Integer myKPart;
GeomAbs_Shape myCont;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
