/*
 *   meix0439n.h -- MEIO device dependant definitions
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#undef _MSC_VER

#define NOTMUTED 0
#define MUTED    1

#define MEIO_VIO_TASK_NAME       "VIO000"
#define MEIO_VIO_ITCB_NAME       "VIOITCB"      /* name MEIO uses to connect to VIO */
#define MEIO_VIO_ITCB_LABEL      "MEIOVIO"

#define MEIO_COMMAND_LABEL       "MEIO_CMD"     /* label of command word */
#define MEIO_DATA_LABEL          "MEIODATA"     /* label of data words */
#define MEIO_VIOGAINLABEL        "VIOGAIN"

#define WRITE_CDC        0x02     /* Update Codec data                    */

/* define default state for CODEC                               */
/* Lineout & Headphone ON, max gain on DAC & ADC, select Linein */
/* ADC->DAC monitor OFF                                         */
#define CODEC16_DEFAULT   0x00000000L

/*------------------------------------------------------------------------- 
 *
 * define local, special purpose methods
 *
 *------------------------------------------------------------------------- */
ULONG WriteMEIOData(PMEIO_DSP pMeioDsp, const USHORT cusCommand, ULONG data);
ULONG FAR TaioMethods(RF_ARGS);
ULONG SetupTAIO(PMEIO_DSP pD);            /* set up TAIO BIOS interface */
void  delay(ULONG);

/*-------------------------------------------------------------------------
 *
 * first define general purpose ACI_SWITCH subclass
 *
 *------------------------------------------------------------------------- */
#define CSAL 0                     /* Control Switch Array - Left  channel*/
#define CSAR 1                     /* Control Switch Array - Right channel*/
#define LASTACIPORT CSAR           /* Only two ACI ports for this adapter */

typedef struct { RESOURCE Resource;
                 struct
                 {
                    USHORT State;             /* keeps switch state in convenient form */
                    USHORT ScoreboardIndex;   /* index into scoreboard array */
                    USHORT BitField;          /* =1 in proper bit position */
                 } data;
} ACI_SWITCH_RESOURCE;
#define ACI_SWITCH    ANALOG_SWITCH       /* our own subclass of ANALOG_SWITCH */


/*-------------------------------------------------------------------------
 *
 * define connect function prototypes
 *
 *------------------------------------------------------------------------- */

/* First Possible connections (through Input Mux) to CDADC */

ULONG FAR MicS1_CdAdcS1        (RF_ARGS);
ULONG FAR MicL1_CdAdcL1        (RF_ARGS);
ULONG FAR MicR1_CdAdcR1        (RF_ARGS);

ULONG FAR LineOutS1_CdAdcS1    (RF_ARGS);
ULONG FAR LineOutL1_CdAdcL1    (RF_ARGS);
ULONG FAR LineOutR1_CdAdcR1    (RF_ARGS);

/* Connect CDDAC to Lineout */
ULONG FAR CdDacS1_LineOutS1    (RF_ARGS);
ULONG FAR CdDacL1_LineOutL1    (RF_ARGS);
ULONG FAR CdDacR1_LineOutR1    (RF_ARGS);

ULONG FAR HandIn1_TeleOut1     (RF_ARGS);
ULONG FAR TeleIn1_TeleAdc1     (RF_ARGS);
ULONG FAR TeleDac1_TeleOut1    (RF_ARGS);
ULONG FAR CommTx1_UartOut1     (RF_ARGS);
ULONG FAR UartIn1_CommRx1      (RF_ARGS);


/*-------------------------------------------------------------------------
 *
 * define internal node handles
 *
 *------------------------------------------------------------------------- */
enum {NOHANDLE = ANALOG_INTERNAL  /* use internal node handle values */

     ,DATAFLAG                    /* Handset deselector switch */
/* enumerate handles for connect functions */
     ,hMicS1_CdAdcS1  = ARESOURCESET   /* analog resource sets */
     ,hMicL1_CdAdcL1
     ,hMicR1_CdAdcR1
     ,hLineOutS1_CdAdcS1
     ,hLineOutL1_CdAdcL1
     ,hLineOutR1_CdAdcR1
     ,hCdDacS1_LineOutS1
     ,hCdDacL1_LineOutL1
     ,hCdDacR1_LineOutR1
     ,hHandIn1_TeleOut1
     ,hTeleIn1_TeleAdc1
     ,hTeleDac1_TeleOut1

     ,hCommTx1_UartOut1    = DRESOURCESET /* Digital resource sets */
     ,hUartIn1_CommRx1

     ,hTAIO_BIOS

     };



/*-------------------------------------------------------------------------
 *
 * begin resource definitions
 * do owner ports first
 *
 *------------------------------------------------------------------------- */
ResourceRef(MicS1    , ANALOG_OWNER_PORT);
ResourceRef(MicL1    , ANALOG_OWNER_PORT);
ResourceRef(MicR1    , ANALOG_OWNER_PORT);
ResourceRef(TeleDac1 , ANALOG_OWNER_PORT);
ResourceRef(TeleIn1  , ANALOG_OWNER_PORT);
ResourceRef(VoiceDac1,ANALOG_OWNER_PORT);
ResourceRef(HandIn1  , ANALOG_OWNER_PORT);
ResourceRef(V96Dac1,ANALOG_OWNER_PORT);
ResourceRef(UartIn1  ,DIGITAL_OWNER_PORT);
ResourceRef(CommTx1  ,DIGITAL_OWNER_PORT);

/* do user ports next */
ResourceRef(CdAdcS1  , ANALOG_USER_PORT);
ResourceRef(CdAdcL1  , ANALOG_USER_PORT);
ResourceRef(CdAdcR1  , ANALOG_USER_PORT);
ResourceRef(LineOutS1, ANALOG_USER_PORT);
ResourceRef(LineOutL1, ANALOG_USER_PORT);
ResourceRef(LineOutR1, ANALOG_USER_PORT);
ResourceRef(TeleAdc1 , ANALOG_USER_PORT);
ResourceRef(TeleOut1 , ANALOG_USER_PORT);
ResourceRef(VoiceAdc1, ANALOG_USER_PORT);
ResourceRef(HandOut1    ,ANALOG_USER_PORT);
ResourceRef(V96Adc1, ANALOG_USER_PORT);
ResourceRef(UartOut1    ,DIGITAL_USER_PORT);
ResourceRef(CommRx1     ,DIGITAL_USER_PORT);


/*-------------------------------------------------------------------------
 *
 * define internal analog switch resources
 *
 *------------------------------------------------------------------------- */
ResourceRef(DataFlag  ,ANALOG_SWITCH);

/*-------------------------------------------------------------------------
 *
 * define internal analog nodes
 *
 *------------------------------------------------------------------------- */
ResourceRef(CaptureGainL,ANALOG_INTERNAL);
ResourceRef(CaptureGainR,ANALOG_INTERNAL);
ResourceRef(TaioBios,BIOSTASK);

/*-------------------------------------------------------------------------
 *
 * define Resource Sets
 *
 *------------------------------------------------------------------------- */
ResourceSRef(MicS1_CdAdcS1      );
ResourceSRef(MicL1_CdAdcL1      );
ResourceSRef(MicR1_CdAdcR1      );
ResourceSRef(LineOutS1_CdAdcS   );
ResourceSRef(LineOutL1_CdAdcL1  );
ResourceSRef(LineOutR1_CdAdcR1  );
ResourceSRef(CdDacS1_LineOutS1  );
ResourceSRef(CdDacL1_LineOutL1  );
ResourceSRef(CdDacR1_LineOutR1  );
ResourceSRef(HandIn1_TeleOut1  );
ResourceSRef(TeleIn1_TeleAdc1  );
ResourceSRef(TeleDac1_TeleOut1 );
ResourceSRef(CommTx1_UartOut1    );
ResourceSRef(UartIn1_CommRx1     );

/*-------------------------------------------------------------------------
 *-------------------------------------------------------------------------
 *
 *   BEGIN SECTION to DEFINE RESOURCE OBJECTS
 *   THIS section is only compiled in main module
 *
 *-------------------------------------------------------------------------
 *------------------------------------------------------------------------- */

#ifdef TIGERSHARK2_DEF    
/*-------------------------------------------------------------------------
 *
 * begin resource init section
 * do owner ports first
 *
 *------------------------------------------------------------------------- */
ResourceDef(CdDacS1  ,ANALOG_OWNER_PORT)={Rparms(CDDAC_S1  ,ANALOG_OWNER_PORT,
  AnalogOwnerDefault),ANALOG0};
ResourceDef(CdDacL1  ,ANALOG_OWNER_PORT)={Rparms(CDDAC_L1  ,ANALOG_OWNER_PORT,
  AnalogOwnerDefault),ANALOG0};
ResourceDef(CdDacR1  ,ANALOG_OWNER_PORT)={Rparms(CDDAC_R1  ,ANALOG_OWNER_PORT,
  AnalogOwnerDefault),ANALOG0};

ResourceDef(MicS1    ,ANALOG_OWNER_PORT)={Rparms(MIC_S1    ,ANALOG_OWNER_PORT,
  AnalogOwnerDefault),ANALOG0};
ResourceDef(MicL1    ,ANALOG_OWNER_PORT)={Rparms(MIC_L1    ,ANALOG_OWNER_PORT,
  AnalogOwnerDefault),{260, 0}};
ResourceDef(MicR1    ,ANALOG_OWNER_PORT)={Rparms(MIC_R1    ,ANALOG_OWNER_PORT,
  AnalogOwnerDefault),{260, 0}};

ResourceDef(HandIn1  ,ANALOG_OWNER_PORT)={Rparms(HANDIN_1  ,ANALOG_OWNER_PORT,AnalogOwnerDefault),ANALOG0};
ResourceDef(TeleDac1 ,ANALOG_OWNER_PORT)={Rparms(TELEDAC_1 ,ANALOG_OWNER_PORT,
  AnalogOwnerDefault),ANALOG0};
ResourceDef(TeleIn1  ,ANALOG_OWNER_PORT)={Rparms(TELEIN_1  ,ANALOG_OWNER_PORT,
  AnalogOwnerDefault),ANALOG0};

ResourceDef(UartIn1  ,DIGITAL_OWNER_PORT)={Rparms(UARTIN_1  ,DIGITAL_OWNER_PORT,
  DigitalOwnerDefault),DIGITAL0};
ResourceDef(CommTx1  ,DIGITAL_OWNER_PORT)={Rparms(COMMTX_1  ,DIGITAL_OWNER_PORT,
  DigitalOwnerDefault),DIGITAL0};


/* do user ports next */
ResourceDef(CdAdcL1     ,ANALOG_USER_PORT)={Rparms(CDADC_L1     ,
  ANALOG_USER_PORT,AnalogUserDefault ),ANALOG0};
ResourceDef(CdAdcR1     ,ANALOG_USER_PORT)={Rparms(CDADC_R1     ,
  ANALOG_USER_PORT,AnalogUserDefault ),ANALOG0};
ResourceDef(CdAdcS1     ,ANALOG_USER_PORT)={Rparms(CDADC_S1     ,
  ANALOG_USER_PORT,AnalogUserDefault),ANALOG0};

ResourceDef(LineOutS1   ,ANALOG_USER_PORT)={Rparms(LINEOUT_S1   ,
  ANALOG_USER_PORT,AnalogUserDefault),ANALOG0};
ResourceDef(LineOutL1   ,ANALOG_USER_PORT)={Rparms(LINEOUT_L1   ,
  ANALOG_USER_PORT,AnalogUserDefault),ANALOG0};
ResourceDef(LineOutR1   ,ANALOG_USER_PORT)={Rparms(LINEOUT_R1   ,
  ANALOG_USER_PORT,AnalogUserDefault),ANALOG0};

ResourceDef(HandOut1    ,ANALOG_USER_PORT)={Rparms(HANDOUT_1    ,
  ANALOG_USER_PORT,AnalogUserDefault),ANALOG0};

ResourceDef(TeleAdc1    ,ANALOG_USER_PORT)={Rparms(TELEADC_1    ,
  ANALOG_USER_PORT,AnalogUserDefault),ANALOG0};
ResourceDef(TeleOut1    ,ANALOG_USER_PORT)={Rparms(TELEOUT_1    ,
  ANALOG_USER_PORT,AnalogUserDefault),ANALOG0};

ResourceDef(UartOut1    ,DIGITAL_USER_PORT)={Rparms(UARTOUT_1    ,
  DIGITAL_USER_PORT,DigitalUserDefault),DIGITAL0};
ResourceDef(CommRx1     ,DIGITAL_USER_PORT)={Rparms(COMMRX_1     ,
  DIGITAL_USER_PORT,DigitalUserDefault),DIGITAL0};


/*-------------------------------------------------------------------------
 *
 * define internal analog switch resources
 *
 *------------------------------------------------------------------------- */

ResourceDef(DataFlag  ,ANALOG_SWITCH)={Rparms(0,
  ANALOG_SWITCH,TaioMethods),OFF}; /* handset selector switch */

ResourceDef(TaioBios,BIOSTASK)=                   /* resource for TAIO */
        {Rparms(hTAIO_BIOS,BIOSTASK,TaioMethods), BIOSTASK0 };

/*-------------------------------------------------------------------------
 *
 * now define resource sets
 *
 *------------------------------------------------------------------------- */
ResourceSet(MicL1_CdAdcL1   )
  {&MicL1 ,&CdAdcL1 ,0};
ResourceSet(MicR1_CdAdcR1   )
  {&MicR1 ,&CdAdcR1 ,0};
ResourceSet(MicS1_CdAdcS1   )
  {&MicS1 ,&CdAdcS1 ,&rMicL1_CdAdcL1, &rMicR1_CdAdcR1,0};

ResourceSet(CdDacS1_LineOutS1)
  {&CdDacS1, &LineOutS1, &rCdDacL1_LineOutL1, &rCdDacR1_LineOutR1,0};
ResourceSet(CdDacL1_LineOutL1)
  {&CdDacL1, &LineOutL1, 0};
ResourceSet(CdDacR1_LineOutR1)
  {&CdDacR1, &LineOutR1, 0};

ResourceSet(HandIn1_TeleOut1  ) {&HandIn1  ,&TeleOut1 ,0};
ResourceSet(TeleIn1_TeleAdc1  )
  {&TeleIn1  ,&TeleAdc1 ,&TaioBios,0};
ResourceSet(TeleDac1_TeleOut1 )
  {&TeleDac1 ,&TeleOut1 ,&TaioBios,0};

ResourceSet(CommTx1_UartOut1    )
  {&CommTx1,&UartOut1,0};
ResourceSet(UartIn1_CommRx1     )
  {&UartIn1,&CommRx1,0};

/*-------------------------------------------------------------------------
 *
 * finally, define array of ALL resource sets for this adapter
 *
 *-------------------------------------------------------------------------*/
PRS AllResources[] =
{
   PRS_Entry(MicS1_CdAdcS1      ),
   PRS_Entry(MicL1_CdAdcL1      ),
   PRS_Entry(MicR1_CdAdcR1      ),
   PRS_Entry(CdDacS1_LineOutS1  ),
   PRS_Entry(CdDacL1_LineOutL1  ),
   PRS_Entry(CdDacR1_LineOutR1  ),
   PRS_Entry( HandIn1_TeleOut1     ),
   PRS_Entry(TeleIn1_TeleAdc1   ),
   PRS_Entry(TeleDac1_TeleOut1  ),

   PRS_Entry(CommTx1_UartOut1   ),
   PRS_Entry(UartIn1_CommRx1    ),

   PRS_NULL  /* marks end of list, REQUIRED!!!! */
};



/*  create an array of all ports and nodes, */
/*  this is required to easily handle the dspMeioQuery() requests. */
PVOID AllHandles[]=
{
   /* Analog Owners */
    &CdDacS1
   ,&CdDacL1
   ,&CdDacR1
   ,&MicS1
   ,&MicL1
   ,&MicR1
   ,&HandIn1
   ,&TeleDac1
   ,&TeleIn1

   /* do user ports next */
   ,&CdAdcL1
   ,&CdAdcR1
   ,&CdAdcS1
   ,&LineOutL1
   ,&LineOutR1
   ,&LineOutS1
   ,&TeleAdc1
   ,&TeleOut1

   ,&UartIn1
   ,&CommTx1

   ,&DataFlag
   /*  Digital Users */
   ,&UartOut1
   ,&CommRx1

   ,&TaioBios

   ,0               /* terminate the array, REQUIRED!! */
};

/*--------------------------------------------------------------------------
 *
 * define all the mundane junk need to support these functions, etc.
 *
 *-------------------------------------------------------------------------- */

/* first we need an array of resource owners */
/* size should be MAX_MEIO_CONNECTIONS (from MEIOGTWY.H) X average #resources */
/* per connection. This is typically 4.xxxx, 4 is probably safe since it is */
/* unlikely that anyone will use all connections available (of course there */
/* is sharing to consider..., better make it 7. */
/* this must be initialized to 0 by InitializeMeio(). */

#if !defined(MAX_MEIO_CONNECTIONS)
#include <meiogtwy.h>
#endif
#define NUM_OWNERS   MAX_MEIO_CONNECTIONS * 7

USHORT roOwnersSize = NUM_OWNERS;              /* provide size for future ref. */
struct resource_owner FAR roOwners[ NUM_OWNERS ];

/* tell MEIO what we can do */
ULONG  MEIO_Adapter_Characteristics = MACF_CDADCBIOS
                                    | MACF_CDDACBIOS
                                    | MACF_TAIO
                                    | MACF_TAIOBIOS
                                    | MACF_UART
                                    | MACF_UARTBIOS
                                    ;  /* end of options */

union          /* make complete structure a single entity for memtransfer */
{
  struct
  {
     /* The 1st 16 bits are sent by the MEIO DSP code to the codec as is.                  */
     /* The remaining bits are set by the MEIO DSP code as needed based on what it decides */
     /* (with the exception of the Mute bit, which will not be changed).                   */

     unsigned int DO2         : 1;
     unsigned int DO1         : 1;
     unsigned int OutputRight : 5;      /* right channel dac attenuation */

        /* These bits (OutputLeft) correspond to LA3..LA1 in the CS4216/8 spec. */
        /* Must be set to zero for correct operation of Marlin. */
     unsigned int OutputLeft  : 3;      /* left channel dac attenuation (always 0) */

     unsigned int InputRight  : 4;      /* right channel input gain (any gain) */
     unsigned int InputLeftP1 : 2;      /* left channel input gain (always 0) */
     unsigned int InputLeftP2 : 2;      /* left channel input gain (always 0) */

        /* (ISR = 0 ==> HANDSET)   (ISR = 1 ==> MIC) */
     unsigned int ISR         : 1;      /* right input multiplexer select */
                                        /* switches between mic & handset */
                                        /* always set to 1; DSP code will */
                                        /* set as specified by VIO if VIO */
                                        /* loaded */
        /* ISL must be set to zero for correct operation of Marlin. */
     unsigned int ISL         : 1;      /* left input multiplexer select */

     unsigned int CodecMute   : 1;      /* output mute control (never mute) */
     unsigned int Mute        : 1;      /* master output mute control */

     unsigned int reserved    : 10;     /* not used */
  } Ctl;
  ULONG Data;              /* ULONG reference for I/O */
} TelephonyCodec16 = {0L};

USHORT TelephonyCodecUpdated = 1;/* flag to signal update required */


union          /* make complete structure a single entity for memtransfer */
{
  struct
  {
     /* The 1st 16 bits are sent by the MEIO DSP code to the codec as is.                  */
     /* The remaining bits are set by the MEIO DSP code as needed based on what it decides */
     /* (with the exception of the Mute bit, which will not be changed).                   */

     unsigned int DO2         : 1;
     unsigned int DO1         : 1;
     unsigned int OutputRight : 5;      /* right channel dac attenuation */

        /* These bits (OutputLeft) correspond to LA3..LA1 in the CS4216/8 spec. */
        /* Must be set to zero for correct operation of Marlin. */
     unsigned int OutputLeft  : 3;      /* left channel dac attenuation (always 0) */

     unsigned int InputRight  : 4;      /* right channel input gain (any gain) */
     unsigned int InputLeftP1 : 2;      /* left channel input gain (always 0) */
     unsigned int InputLeftP2 : 2;      /* left channel input gain (always 0) */

        /* (ISR = 0 ==> HANDSET)   (ISR = 1 ==> MIC) */
     unsigned int ISR         : 1;      /* right input multiplexer select */
                                        /* switches between mic & handset */
                                        /* always set to 1; DSP code will */
                                        /* set as specified by VIO if VIO */
                                        /* loaded */
        /* ISL must be set to zero for correct operation of Marlin. */
     unsigned int ISL         : 1;      /* left input multiplexer select */

     unsigned int CodecMute   : 1;      /* output mute control (never mute) */
     unsigned int Mute        : 1;      /* master output mute control */
     unsigned int ModemNotInUse  : 1;   /* Modem not in use */

     unsigned int reserved    : 9 ;     /* not used */
  } Ctl;
  ULONG Data;              /* ULONG reference for I/O */
} CDCodec16 = {0L};

PMEIO_DSP pMEIODSP;
USHORT CDCodecUpdated = 1;/* flag to signal update required */

USHORT usCouplerID=0;         /* CouplerID word */

HINSTANCE hpinst;

/* End of conditionally compiled section */
#else

extern
USHORT usCouplerID;           /* CouplerID word */

#endif


/*
 * VIO ITCB members
 */
#define MEIO_HIOCTL_OFFSET       0        /* offsets within VIO's ITCB */
#define MEIO_INPUTCTL_OFFSET     2
#define MEIO_SHACTIVE_OFFSET     4


#define MEIO_HOOKCNTL_OFFSET     0        /* controls ON/OFF Hook state */
#define MEIO_DATAFLAG_OFFSET     0x000A   /* offset of dataflag entry */
#define MEIO_TAIOMODE_OFFSET     0x0014   /* offset for TAIO status */
#define MEIO_TAIO_LINESEIZE      6        /* ON Hook if below this state */
#define MEIO_TAIO_OFFLINE        4        /* PHONE is not in use. */
#define AIC1SD                   0x168    /* address of AIC1SD word */
#define HSRELAYBIT               0x8000
#define AIC1STAT                 0x16A    /* address of AIC1STAT word */


#define VIO_HS_ITCB   "VIOITCB_HS"    /* handset ITCB TAIO -> VIO */
#define TAIO_HS_ITCB  "TAIOITCB_HS"   /* handset ITCB TAIO -> VIO */

#define MEIO_4231ADDRLABEL       "CSADDRLO"
#define MEIO_TAIO_TASK_NAME      "TAIO000"
#define MEIO_TAIO_ITCB_NAME      "TAIOITCB"     /* name MEIO uses to connect to TAIO */
#define MEIO_TAIO_ITCB_LABEL     "MEIOTAIO"
#define MEIO_TAIOBLOCKSIZE       105            /* number of words in TAIO WTT */


#if !defined(LPUSHORT)
  typedef USHORT FAR    *LPUSHORT;      /* lpus*/
#endif

#define WINNT50 5
#define WINNT40 4
#define WIN9X 3
extern DWORD gdwWinPlatform;

ULONG FAR SetupCWMIXER(USHORT Device, USHORT action);
ULONG FAR CdDacConnectCountInc(LPUSHORT lpCount);
ULONG FAR CdDacConnectCountDec(LPUSHORT lpCount);
ULONG FAR MicConnectCountInc(LPUSHORT lpCount);
ULONG FAR MicConnectCountDec(LPUSHORT lpCount);

LRESULT MEIO_SendMessage(
    HWND hWnd,	/* handle of destination window */
    UINT Msg,	/* message to send */
    WPARAM wParam,	/* first message parameter */
    LPARAM lParam 	/* second message parameter */
   );	
 

/*
 * declaration for xilinx programming
 */
#if defined(XILINX)
int program_pld(unsigned int);
#endif

/* define MEIO_Module name */

/*#define MEIO_MODULE              "MEIX0437.DSP" */
#define MEIO_MODULE              ".\\MEIX0437.DSP"

extern USHORT Mixer_Connected;
extern USHORT MicCount;
