/*
 *   blwtt.h
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                         
 *   blwtt.h
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */

//  This class loads blacklist settings from the WT Table and makes them
//  available to the other blacklist objects.  Because the purpose is to
//  pass information, all variables are public.
//
//
//
//
//****************************************************************************

#if !defined(BLWTT_H)
#define BLWTT_H  1

//---- includes --------------------------------------------------------------

#include <mwblapi.h>
#include <idevice.h>
#include <unsucces.h>


//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
typedef struct _WTTsettings
{
  // This is set true if all the WT Table loading went OK.
  BOOL bWTTloaded;

  // This holds the current country number.
  ULONG ulCountryNumber;

  // This is set if there are blacklist settings in the current WT Table.
  BOOL bBlacklistingEnabled;

  // This settings says to use special code for the country since a special
  // case exists which is not covered by the standard controls.
  BOOL bUseSpecialAlgorithm;
  
  // This settings says to use Time Windowing instead of series type blacklisting.
  BOOL bUseTimeWindowing;
  
  // This setting says that a user abort is to be counted as unsuccessful.
  BOOL bUserAbortIsUnsuccessful;
  
  // This blacklists the number after the first series is complete.
  BOOL bBlacklistAfterFirstSeries;
  
  // This blacklists the number after the second series is complete.
  BOOL bBlacklistAfterSecondSeries;
  
  // This setting causes all phone numbers to be mapped into a single
  // virtual phone number.  This was originally put into the code to
  // support Austria which required if 12 unsuccessful calls were made
  // to any phone numbers, then all dialing must stop.
  BOOL bDoNotDistiguishPhoneNumbers;
  
  // This is the delay in seconds that all call attempts are required to
  // observe.  This is the required on-hook time.
  ULONG ulAllCallDelay;
  
  // This is the delay in seconds that the first retry for an unsuccessful
  // number must observe.  This value could be different from the
  // ulUnsuccessfulRetryDelay that is enforced on subsequent retries.
  ULONG ulFirstRetryDelay;
  
  // This is the delay in seconds that is forced between call attempts
  // to the same number if the previous attempt was unsuccessful.
  ULONG ulUnsuccessfulRetryDelay;
  
  // This is the maximum unsuccessful call count allowed in each series or
  // time window.
  ULONG ulMaxUnsuccessfulCount;
  
  // This is the time window in seconds.
  ULONG ulTimeWindow;
  
  // This is the delay in seconds the is forced before a series can be
  // repeated.
  ULONG ulSeriesToSeriesDelay;

} WTTsettings;

ULONG wttReset (WTTsettings *pWTT);
BOOL wttIsWTTloaded(WTTsettings *pWTT);

#endif // !defined(BLWTT_H)
