/************************************************************************/
/* File   : mquel.h				                        */
/* Purpose: mquel module header			                        */
/* By     : Keith R. Davis	      		                        */
/* Date   : 12/27/95				                        */
/* Notes  : Copyright(c) 1996-98 Mutiny Bay Software                    */
/************************************************************************/

#ifndef _MQUEL_H
#define _MQUEL_H

#define MPSQL_VERSION "2.1"

#define ERR_MSG_SIZE 5120               /* max error message size               */

XtAppContext   app;		        /* application context		        */

/* widget struct */
typedef struct _mquel_widgets{
  Widget               	shell,		/* application shell			*/
			menu,		/* application menu			*/
                        buffermenu,     /* buffer submenu                       */
                        btnbar,		/* button bar			        */
                        btn_new,        /* new SQL file button                  */
                        btn_open,       /* open file button                     */
                        btn_save,       /* save file button                     */
                        btn_print,      /* print file button                    */  
			btn_exe,	/* execute qy button			*/
                        btn_spool,      /* spool results to file button         */
                        btn_connect,    /* connect to database button           */
			pane,		/* paned workspace			*/
			mainwindow,	/* application main window		*/
			sqlwindow,	/* SQL window			        */
			resultwindow,	/* query result window		        */
                        msgframe,       /* frame for message widget             */ 
			message,	/* label widget for messages		*/
                        highlight,      /* syntax highlighting toggle           */
                        tabspace,       /* tab setting                          */
                        plain,          /* no highlighting toggle               */
                        align,          /* aligned output toggle                */
                        standard,       /* standard output toggle               */ 
                        expand,         /* expanded output toggle               */
                        text,           /* text output toggle                   */
                        html,           /* HTML output toggle                   */
                        tglspool,       /* spool toggle                         */
                        tglcol,         /* col heading toggle                   */
                        tglecho,        /* echo query toggle                    */
                        spoolfile,      /* spool file                           */
                        none,           /* column separator                     */
                        tab,            /* column separator                     */
                        space,          /* column separator                     */
                        comma,          /* column separator                     */
                        database,       /* database selection                   */
                        host,           /* connection host                      */
                        port,           /* connection port                      */
                        uname,          /* uname                                */
                        pwd,            /* pwd                                  */ 
                        printer,        /* printer                              */
                        find,           /* find text string                     */
                        replacefind,    /* replace find string                  */
                        replacewith;    /* replace with string                  */
}MQUELwidgets;

extern MQUELwidgets *AppWidgetsPtr;     /* global pointer to app widgets         */
extern tabs;                            /* editor tab setting                    */

/* creates the appliation's text editing area */
Widget MQUEL_CreateSqlTextArea(Widget parent);

/* creates the appliation's result window     */
Widget MQUEL_CreateResultTextArea(Widget parent);

/* set the application toolbar state          */
void MQUEL_SetToolbar(int state);

/* gets app options from setup file */
int MQUEL_GetOptions(void);

/* saves app options to setup file  */
int MQUEL_SaveOptions(void);

/* processes cmd line args          */
int MQUEL_GetCmdLineArg(int argc, char **argv);
	
#endif	
