/* fatal.C
 * John Viega
 *
 * Jan 28-29 2000
 */

#include <stdio.h>
#include "config.H"

void OutOfMemory()
{
  fprintf(stderr, "Out of memory, sorry." NEWLINE);
  exit(2);
}

void Perror(char *arg)
{
  char *progname = GetProgramName();
  char *buf;
  int  size = strlen(progname) + strlen(arg)+2;
  buf = new char[size];
  if(!buf)
    OutOfMemory();
#ifdef HAVE_SNPRINTF
  snprintf(buf, size, "%s:%s", progname, arg);
#else
  char *fmt_str = "%s:%s";
  // u_bound off by 4 from actual answer.
  int  u_bound  = strlen(fmt_str) + strlen(progname) + strlen(arg);
  if(u_bound >= size)
    {
      char *tmp_sncp_buf = new char[u_bound];
      if(!tmp_sncp_buf) OutOfMemory();
      sprintf(tmp_sncp_buf, fmt_str, progname, arg); // ITS4: ignore
      tmp_sncp_buf[size] = 0;
      strcpy(buf, tmp_sncp_buf);  // ITS4: ignore
      delete[] tmp_sncp_buf;
    }
  else
    {
      sprintf(buf, fmt_str, progname, arg);  // ITS4: ignore
    }
#endif
  perror(buf);
  delete[] buf;
}
