# Generated automatically from Makefile.in by configure.
#
# This file is a Makefile for Floater.  If it has the name "Makefile.in"
# then it is a template for a Makefile;  to generate the actual Makefile,
# run "./configure", which is a configuration script generated by the
# "autoconf" program (constructs like "@foo@" will get replaced in the
# actual Makefile.

#----------------------------------------------------------------
# Things you can change to personalize the Makefile for your own site
# are in the section that follows.  It is recommended that you modify
# Makefile.in rather than Makefile.  Then do "make Makefile".
#----------------------------------------------------------------

# Default top-level directories in which to install architecture-
# specific files (exec_prefix) and machine-independent files such as
# scripts (prefix).  The values specified here may be overridden at
# configure-time with the --exec-prefix and --prefix options to the
# "configure" script.  It is easiest if you set these to the same
# values you used in the Tk installation.  If you don't you likely
# will need to change TCL_INCLUDES, TK_INCLUDES, TCL_LIB, and
# TK_LIB, below.  You may need to change those 4 in any case.

exec_prefix =   /usr3/users/pike/crud/floater
prefix =        /usr3/users/pike/crud/floater

# This is a hack to help people who are confused about how to set the
# FLOATER_LIBRARY variable.  If you set that correctly it is entirely
# unnecessary.  If it causes problems, switch the comment characters
# on the two lines (so that SRC_DIR_DEFN is defined to be the empty string).
SRC_DIR_DEFN = `pwd`
#SRC_DIR_DEFN =

FLOATER_LIBRARY =	$(prefix)/tclcode

# Directory in which to install the program floater and floatert:
BIN_DIR =	$(exec_prefix)/bin

# The directory containing the Tcl header files (i.e., tcl.h) appropriate
# for this version of Floater.  If they're in a standard place, leave this
# blank.
#TCL_INCLUDES = -I/usr3/users/pike/tcl8.0/generic
TCL_INCLUDES = 

# The directory containing the Tk header files (i.e., tk.h).
#TK_INCLUDES = -I/usr3/users/pike/tk8.0/generic
TK_INCLUDES = 

#TCL_LIB = /usr/local/lib/libtcl80.a
TCL_LIB = -ltcl80
#TCL_LIB = -ltcl76
#TCL_LIB = -L../tcl7.6/unix -ltcl76
#TCL_LIB = /usr3/users/pike/tcl7.6/unix/libtcl76.a
#TCL_LIB = /usr3/users/pike/tcl8.0/unix/libtcl80.so.1.0

#TK_LIB = /usr/local/lib/libtk80.a
TK_LIB = -ltk80
#TK_LIB = -ltk42
#TK_LIB = -L../tk4.2/unix -ltk42
#TK_LIB = /usr3/users/pike/tk4.2/unix/libtk42.a
#TK_LIB = /usr3/users/pike/tk8.0/unix/libtk80.so.1.0


# If necessary, the include directory for ncurses:
#CURSES_INCLUDES = 
CURSES_INCLUDES = -I/usr/sww/include/ncurses
# -I/usr/sww/lib/gcc-include

# The curses library:
#CURSES = -lcurses
CURSES = -L/usr/sww/lib/ncurses -lncurses
#CURSES =

# The switches and their meaning:
#
#   GUI_ONLY: If true, the executable that is built will not include the
#	textual user interface to Floater and you need not link with curses.
#   TCL_IN_C: If true, instead of reading the Tcl files that are part of
#	Floater at run time, they are formatted into C and compiled.
#	Just a matter of convenience.  Remove floatcl.o from FLOBS, below,
#	if you set TCL_IN_C to 0.  (Note: floatcl.c crashes some lousy
#	compilers, such as one by Microsoft.)
#   USER_TCL: If true, users can execute Tcl commands (by doing "tcl ...").
SWITCHES = -DGUI_ONLY=0 -DTCL_IN_C=1 -DUSER_TCL=1


# Under HP/UX, reverse the comment characters on the following lines
# to enable the ANSI HP compiler, etc.  (Also, you may need to link
# with the .sl version of the Tcl and Tk libraries if you're using HP/UX.)
# HP_FLAGS = -Aa -DNO_HALFDELAY
HP_FLAGS =

# Floater requires ANSI C.  You may need to modify the definition of
# CC or CFLAGS, below.  When in doubt, try gcc.

#----------------------------------------------------------------
# Most of the rest of these options you probably won't have to touch.
#----------------------------------------------------------------

# A "-I" switch that can be used when compiling to make all of the
# X11 include files accessible (the configure script will try to
# set this value, and will cause it to be an empty string if the
# include files are accessible via /usr/include).
X11_INCLUDES =   -I/usr/openwin/include

# Linker switch(es) to use to link with the X11 library archive (the
# configure script will try to set this value automatically, but you
# can override it).
X11_LIB_SWITCHES =      -lX11

# Libraries to use when linking:  must include at least Tk, Tcl,
# Xlib, the math library, and curses or ncurses.  You may link in
# either the shared (usually .so) or non-shared (.a) version of Tcl/Tk.
# Note that Tk4.2 and Tcl7.6 are recommended; Tk4.1 and Tcl7.5 will also
# work.  No other versions will work.
LIBS = $(TK_LIB) $(TCL_LIB) \
	$(X11_LIB_SWITCHES) $(CURSES) -lm

# To change the compiler switches, change the following line:
#CFLAGS = -O4 -g
CFLAGS = -g

# Some versions of make, like SGI's, use the following variable to
# determine which shell to use for executing commands.  We also use it
# for executing config.status to remake the Makefile.
SHELL =		/bin/sh

#----------------------------------------------------------------
# The information below is modified by the configure script when
# Makefile is generated from Makefile.in.  You shouldn't normally
# modify any of this stuff by hand.
#----------------------------------------------------------------

AC_FLAGS =		 -DHAVE_STDLIB_H=1 -DUNIX_SOCKET=1 -DHAVE_ERRNO_H=1 -DHAVE_SYS_TIME_H=1 -DHAVE_MALLOC_H=1 
INSTALL =		/usr/sww/bin/ginstall -c
INSTALL_PROGRAM =	${INSTALL}
INSTALL_DATA =		${INSTALL} -m 644
RANLIB =		ranlib
SRC_DIR =		.

#----------------------------------------------------------------
# The information below should be usable as is.  The configure
# script won't modify it and you shouldn't need to modify it
# either.
#----------------------------------------------------------------


CC =		gcc -pipe
CPP =		/usr/lib/cpp -B
CPP_SWITCHES =
#CPP_SWITCHES =	-DDEBUG
CC_SWITCHES =	${CFLAGS} ${CURSES_INCLUDES} -I${SRC_DIR} \
${TCL_INCLUDES} ${TK_INCLUDES} ${AC_FLAGS} ${SWITCHES} \
-DFLOATER_LIBRARY=\"${FLOATER_LIBRARY}\" \
${HP_FLAGS} ${X11_INCLUDES} -DSRC_DIR=\"${SRC_DIR_DEFN}\"
DEPEND =	gcc -M ${CC_SWITCHES}

# If you want to have Floater read floater.tcl etc. at run time, you may
# remove floatcl.o from FLOBS. (Make sure you have also removed -DTCL_IN_C=1
# from SWITCHES.)
FLOBS = tickler.o main.o commandhash.o alloc.o floatcmd.o \
	comm.o rand.o deal.o stringlist.o br.o UI.o bits.o util.o result.o \
	score.o calendar.o help.o autohelp.o bug.o text.o floatcl.o
HEADERS = alloc.h comm.h commandhash.h deal.h debug.h floatcmd.h floater.h \
	message.h rand.h stringlist.h tickler.h br.h UI.h bits.h util.h \
	result.h score.h calendar.h help.h bug.h heartsrules.h text.h
TCL_IN_C_FILES = tclcode/floater.tcl tclcode/floatert.tcl
TEXTS = Copyright Readme Confusing Bugs


ALL_FILES = `echo $(FLOBS) | sed 's/ tkAppInit.o//' | tr . - \
		| sed s/-o/-c/g | tr - .` $(HEADERS) \
	ref autohelp?.c floatcl?.c Floaterlogo.gif \
	floatcl.c computer.c computer.h \
	bitmaps/{bitmaps.c,*._} \
	depend.inc depend2.inc Makefile.in Makefile.pike floatert \
	configure configure.in configure.info config.guess config.sub \
	install-sh \
	README CONFUSING BUGS NEWS Readme Confusing Bugs Copyright \
	copyright.message tcl2c \
	tclcode/{*.tcl,*.TCL}

.SUFFIXES: .TCL .tcl

.TCL.tcl:
	$(CPP) $(CPP_SWITCHES) $< > $@


all: floater tclcode/floater.tcl tclcode/floatert.tcl tclcode/floaterw.tcl

floatcl.c: tcl2c floatcl1.c floatcl2.c $(TCL_IN_C_FILES)
	tcl2c $(TCL_IN_C_FILES)
	@echo "Created floatcl.c"

autohelp.c: autohelp1.c autohelp2.c autohelp3.c ref
	-rm -f autohelp.c
	cp autohelp1.c autohelp.c
	sed 's/"/\\"/g' ref | sed 's/\(.*\)/\"\1\\n\"/g' >> autohelp.c
	cat autohelp2.c >> autohelp.c
	echo -n \" >> autohelp.c
	grep "	" ref | tr "\012" " " | tr -d "\011" >> autohelp.c
	echo -n \" >> autohelp.c
	cat autohelp3.c >> autohelp.c

floater: $(FLOBS)
	$(CC) $(CC_SWITCHES) $(FLOBS) $(LIBS) -o $@




Makefile: $(SRC_DIR)/Makefile.in
	$(SHELL) config.status

clean:

.c.o:
	$(CC) -c $(CC_SWITCHES) $<

depend:
	-rm -f depend.inc depend2.inc
	echo -n "tclcode/floater.tcl: " > depend2.inc
	echo tclcode/*.TCL >> depend2.inc
	echo -n "tclcode/floatert.tcl: " >> depend2.inc
	echo tclcode/*.TCL >> depend2.inc
	echo -n "tclcode/floaterw.tcl: " >> depend2.inc
	echo tclcode/*.TCL >> depend2.inc
	-csh -c "$(DEPEND) *.c > depend.inc"
	echo "main.o: floater.h" >> depend.inc

include depend.inc
include depend2.inc
