/*****************************************************************************/
/*                                                                           */
/* NAME:      Radeon_extension_tvout.h                                       */
/*                                                                           */
/* Copyright (c) 2003, ATI, ATI Research GmbH, Starnberg, Germany            */
/*                                                                           */
/*****************************************************************************/

#ifndef _TVO_EXT_H_
#define _TVO_EXT_H_


// ============================================================================
// === TV out Extension Management                                          ===
// ============================================================================

#define ATITVOUT_EXTENSION_NAME     "ATITVOUT"

#define ATITVOUT_NUMBER_EVENTS          0 
#define ATITVOUT_NUMBER_ERRORS          0

#define X_ATITVOSetOverscan             0
#define X_ATITVOSetFormat               1
#define X_ATITVOGetData                 2
#define X_ATITVOAdjustPosition          3
#define X_ATITVOAdjustVPosition         4
#define X_ATITVOAdjustColor             5

#define XREP_SZ(name)       sizeof(x##name##Reply)
#define XREQ_SZ(name)       sizeof(x##name##Req)

//////////////////////////////////////////////////////////////////////////////
// ProcATITVOSetOverscan

// requests must be multiple of 4
typedef struct _ATITVOSetOverscan {
    CARD8   reqType;             //    1
    CARD8   fireglReqType;       //    1
    CARD16  length B16;          //    2
    /* specific */
    CARD32  screen B32;         //    4
    CARD32  TVEnable B32;        //    4
} xATITVOSetOverscanReq;       // = 12

//  replies must be ...
//      - 4 byte alligned, 
//      - minimum 32 bytes (pad the structure)
typedef struct {
    BYTE    type;                //    1    (X_Reply)
    BYTE    pad1;                //    1
    CARD16  sequenceNumber B16;  //    2
    CARD32  length B32;          //    4
    /* specific */
    CARD32  screen B32;          //    4
    CARD32  error B32;           //    4
    CARD32  pad2 B32;            //    4
    CARD32  pad3 B32;            //    4
    CARD32  pad4 B32;            //    4
    CARD32  pad5 B32;            //    4
    CARD32  pad6 B32;            //    4
} xATITVOSetOverscanReply;       // = 32
// 32 bytes (reply needs)

#define sz_xATITVOSetOverscanReq      XREQ_SZ(ATITVOSetOverscan)
#define sz_xATITVOSetOverscanReply    XREP_SZ(ATITVOSetOverscan)

//////////////////////////////////////////////////////////////////////////////
// ProcATITVOSetFormat

// requests must be multiple of 4
typedef struct _ATITVOSetFormat {
    CARD8   reqType;            //    1
    CARD8   fireglReqType;      //    1
    CARD16  length B16;         //    2
    /* specific */
    CARD32  screen B32;         //    4
    CARD32  TVFormat B32;     //    4
} xATITVOSetFormatReq;        // = 12

//  replies must be ...
//      - 4 byte alligned, 
//      - minimum 32 bytes (pad the structure)
typedef struct {
    BYTE    type;                //    1    (X_Reply)
    BYTE    pad1;                //    1
    CARD16  sequenceNumber B16;  //    2
    CARD32  length B32;          //    4
    /* specific */
    CARD32  screen B32;          //    4
    CARD32  error B32;           //    4
    CARD32  pad2 B32;            //    4
    CARD32  pad3 B32;            //    4
    CARD32  pad4 B32;            //    4
    CARD32  pad5 B32;            //    4
    CARD32  pad6 B32;            //    4
} xATITVOSetFormatReply;       // = 32
// 32 bytes (reply needs)

#define sz_xATITVOSetFormatReq      XREQ_SZ(ATITVOSetFormat)
#define sz_xATITVOSetFormatReply    XREP_SZ(ATITVOSetFormat)

//////////////////////////////////////////////////////////////////////////////
// ProcATITVOGetData

// requests must be multiple of 4
typedef struct _ATITVOGetData {
    CARD8   reqType;            //    1
    CARD8   fireglReqType;      //    1
    CARD16  length B16;         //    2
    /* specific */
    CARD32  screen B32;         //    4
} xATITVOGetDataReq;            // =  8

//  replies must be ...
//      - 4 byte alligned, 
//      - minimum 32 bytes (pad the structure)
typedef struct {
    BYTE    type;                //    1    (X_Reply)
    BYTE    pad1;                //    1
    CARD16  sequenceNumber B16;  //    2
    CARD32  length B32;          //    4
    /* specific */
    CARD32  TVConnected B32;     //    4
    CARD32  TVFormat B32;           //    4
    CARD32  tvHSizeAdj B32;      //    4
    CARD32  tvVSizeAdj B32;      //    4
    CARD32  tvHPosAdj B32;       //    4
    CARD32  tvVPosAdj B32;       //    4
    CARD32  tvHStartAdj B32;     //    4
    CARD32  tvColorAdj B32;      //    4
    CARD32  tvMinX;
    CARD32  tvMaxX;
    CARD32  tvMinY;
    CARD32  tvMaxY;
    CARD32  tvOverscan;
    CARD32  error B32;           //    4
} xATITVOGetDataReply;           // = 48

#define sz_xATITVOGetDataReq      XREQ_SZ(ATITVOGetData)
#define sz_xATITVOGetDataReply    XREP_SZ(ATITVOGetData)

//////////////////////////////////////////////////////////////////////////////
// ProcATITVOAdjustVPosition

// requests must be multiple of 4
typedef struct _ATITVOAdjustVPosition {
    CARD8   reqType;            //    1
    CARD8   fireglReqType;      //    1
    CARD16  length B16;         //    2
    /* specific */
    CARD32  screen B32;         //    4
    CARD32  tvVPosAdj B32;     //    4
} xATITVOAdjustVPositionReq;         // = 12

//  replies must be ...
//      - 4 byte alligned, 
//      - minimum 32 bytes (pad the structure)
typedef struct {
    BYTE    type;               //    1    (X_Reply)
    BYTE    pad1;               //    1
    CARD16  sequenceNumber B16; //    2
    CARD32  length B32;         //    4
    /* specific */
    CARD32  error B32;           //    4
    CARD32  pad2 B32;            //    4
    CARD32  pad3 B32;            //    4
    CARD32  pad4 B32;            //    4
    CARD32  pad5 B32;            //    4
    CARD32  pad6 B32;            //    4
} xATITVOAdjustVPositionReply;        // = 32
// 32 bytes (reply needs)

#define sz_xATITVOAdjustVPositionReq      XREQ_SZ(ATITVOAdjustVPosition)
#define sz_xATITVOAdjustVPositionReply    XREP_SZ(ATITVOAdjustVPosition)

//////////////////////////////////////////////////////////////////////////////
// ProcATITVOAdjustPosition

// requests must be multiple of 4
typedef struct _ATITVOAdjustPosition {
    CARD8   reqType;            //    1
    CARD8   fireglReqType;      //    1
    CARD16  length B16;         //    2
    /* specific */
    CARD32  screen B32;         //    4
    CARD32  tvHPosAdj B32;      //    4
    CARD32  tvVPosAdj B32;
    CARD32  tvHSizeAdj B32;
    CARD32  tvVSizeAdj B32;
} xATITVOAdjustPositionReq;     // = 20

//  replies must be ...
//      - 4 byte alligned, 
//      - minimum 32 bytes (pad the structure)
typedef struct {
    BYTE    type;               //    1    (X_Reply)
    BYTE    pad1;               //    1
    CARD16  sequenceNumber B16; //    2
    CARD32  length B32;         //    4
    /* specific */
    CARD32  error B32;          //    4
    CARD32  pad2 B32;           //    4
    CARD32  pad3 B32;           //    4
    CARD32  pad4 B32;           //    4
    CARD32  pad5 B32;           //    4
    CARD32  pad6 B32;           //    4
} xATITVOAdjustPositionReply;  // = 32
// 32 bytes (reply needs)

#define sz_xATITVOAdjustPositionReq      XREQ_SZ(ATITVOAdjustPosition)
#define sz_xATITVOAdjustPositionReply    XREP_SZ(ATITVOAdjustPosition)

//////////////////////////////////////////////////////////////////////////////
// ProcATITVOAdjustColor

// requests must be multiple of 4
typedef struct _ATITVOAdjustColor {
    CARD8   reqType;            //    1
    CARD8   fireglReqType;      //    1
    CARD16  length B16;         //    2
    /* specific */
    CARD32  screen B32;         //    4
    CARD32  tvColorAdj B32;     //    4
} xATITVOAdjustColorReq;        // = 12

//  replies must be ...
//      - 4 byte alligned, 
//      - minimum 32 bytes (pad the structure)
typedef struct {
    BYTE    type;               //    1    (X_Reply)
    BYTE    pad1;               //    1
    CARD16  sequenceNumber B16; //    2
    CARD32  length B32;         //    4
    /* specific */
    CARD32  error B32;          //    4
    CARD32  pad2 B32;           //    4
    CARD32  pad3 B32;           //    4
    CARD32  pad4 B32;           //    4
    CARD32  pad5 B32;           //    4
    CARD32  pad6 B32;           //    4
} xATITVOAdjustColorReply;      // = 32
// 32 bytes (reply needs)

#define sz_xATITVOAdjustColorReq      XREQ_SZ(ATITVOAdjustColor)
#define sz_xATITVOAdjustColorReply    XREP_SZ(ATITVOAdjustColor)



#endif // _TVO_EXT_H_
