#######################
# (c) Jan Walter 2000 #
#######################

# CVS
# $Author: jan $
# $Date: 2001/02/02 10:57:45 $
# $RCSfile: objimport.py,v $
# $Revision: 1.3 $

import string
import os
import Blender

def testObjImport(filename):
    print 'testObjImport("%s")' % filename
    vcount  = 0
    vncount = 0
    fcount  = 0
    pointList    = []
    normalList   = []
    faceList     = []
    materialList = []
    file = open(filename, "r")
    lines = file.readlines()
    linenumber = 1
    for line in lines:
        words = string.split(line)
        if words and words[0] == "#":
            pass # ignore comments
        elif words and words[0] == "v":
            vcount = vcount + 1
            x = string.atof(words[1])
            y = string.atof(words[2])
            z = string.atof(words[3])
            pointList.append([x, y, z])
        elif words and words[0] == "vn":
            vncount = vncount + 1
            i = string.atof(words[1])
            j = string.atof(words[2])
            k = string.atof(words[3])
            normalList.append([i, j, k])
        elif words and words[0] == "f":
            fcount = fcount + 1
            vi = [] # vertex  indices
            ti = [] # texture indices
            ni = [] # normal  indices
            words = words[1:]
            lcount = len(words)
            for index in (xrange(lcount)):
                vtn = string.split(words[index], "/")
                vi.append(string.atoi(vtn[0]))
                if len(vtn) > 1 and vtn[1]:
                    ti.append(string.atoi(vtn[1]))
                if len(vtn) > 2 and vtn[2]:
                    ni.append(string.atoi(vtn[2]))
            faceList.append([vi, ti, ni])
        elif words and words[0] == "mtllib":
            # try to export materials
            directory, dummy = os.path.split(filename)
            filename = os.path.join(directory, words[1])
            try:
                file = open(filename, "r")
            except:
                print "no material file %s" % filename
            else:
                file = open(filename, "r")
                line = file.readline()
                while line:
                    words = string.split(line)
                    if words and words[0] == "newmtl":
                        name = words[1]
                        file.readline() # Ns .
                        file.readline() # d .
                        file.readline() # illum .
                        line = file.readline()
                        words = string.split(line)
                        Kd = [string.atof(words[1]),
                              string.atof(words[2]),
                              string.atof(words[3])]
                        line = file.readline()
                        words = string.split(line)
                        Ks = [string.atof(words[1]),
                              string.atof(words[2]),
                              string.atof(words[3])]
                        line = file.readline()
                        words = string.split(line)
                        Ka = [string.atof(words[1]),
                              string.atof(words[2]),
                              string.atof(words[3])]
                        materialList.append([name, Kd, Ks, Ka])
                    line = file.readline()
                file.close()
        elif words and words[0] == "usemtl":
            name = words[1]
            print "usemtl %s" % name
        elif words:
            ##pass
            print "%s: %s" % (linenumber, words)
        linenumber = linenumber + 1
    file.close()
    # import in Blender
    print "import into Blender ..."
    print "triangles and quads ..."
    scene  = Blender.getCurrentScene()
    mesh   = Blender.Mesh("OBJ")
    object = Blender.Object("OBJ")
    mesh.enterEditMode()
    for face in faceList:
        vi, ti, ni = face
##         if ti:
##             print ti
        if len(vi) == 3: # triangle
            indices = []
            for vertex in vi:
                x, y, z = pointList[vertex-1] # in OBJ the indices start with 1
                index = mesh.addVertex(x, y, z, 0, 0, 0)
                indices.append(index)
            mesh.addFace(indices[0], indices[1], indices[2], 0, 0, 0)
        elif len(vi) == 4: # quad
            indices = []
            for vertex in vi:
                x, y, z = pointList[vertex-1] # in OBJ the indices start with 1
                index = mesh.addVertex(x, y, z, 0, 0, 0)
                indices.append(index)
            mesh.addFace(indices[0], indices[1],
                         indices[2], indices[3], 0, 0)
##         else:
##             print vi, ti, ni
    Blender.connect(object, mesh)
    Blender.connect(scene, object)
    mesh.leaveEditMode()
    print "all other (general) polygons ..."
    for face in faceList:
        vi, ti, ni = face
        if len(vi) != 3 and len(vi) != 4:
            # export the polygon as edges
            mesh   = Blender.Mesh("OBJ")
            object = Blender.Object("OBJ")
            mesh.enterEditMode()
            for i in xrange(len(vi)-1):
                x, y, z = pointList[vi[i]-1] # in OBJ the indices start with 1
                index1 = mesh.addVertex(x, y, z, 0, 0, 0)
                x, y, z = pointList[vi[i+1]-1] # see above
                index2 = mesh.addVertex(x, y, z, 0, 0, 0)
                mesh.addFace(index1, index2, 0, 0, 0, 0)
            # add edge from last point to the first point to close the polygon
            x, y, z = pointList[vi[0]-1] # in OBJ the indices start with 1
            index1 = mesh.addVertex(x, y, z, 0, 0, 0)
            x, y, z = pointList[vi[-1]-1] # in OBJ the indices start with 1
            index2 = mesh.addVertex(x, y, z, 0, 0, 0)
            mesh.addFace(index1, index2, 0, 0, 0, 0)
            # remove doubles and triangulate
            mesh.createTrianglesFromEdges()
            # now connect ...
            Blender.connect(object, mesh)
            Blender.connect(scene, object)
            mesh.leaveEditMode()
    print "... finished"

def callback(fs):
    filename = fs.filename
    testObjImport(filename)

if __name__ == "__main__":
    try:
        import GUI
    except:
        print "This script is only working with the new GUI module ..."
    else:
        fs = GUI.FileSelector()
        fs.activate(callback, fs)
